#!/usr/bin/perl -Tw
##########################################################################
# Click Manager 2.2.2                                                    #
# Copyright (c) 2001-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################

# Load modules and whatnot.
use strict;
use CGI::Carp qw(fatalsToBrowser);
use CGI qw/:standard/;
use Fcntl qw(:DEFAULT :flock);

# Declare variables that will be used later in the script.
my %tmpl;

# Settings that you might need to change.
$tmpl{yoursite} = 'Aardvark Industries'; # The name of your site.
$tmpl{yoururl} = 'http://www.aardvarkind.com/'; # The URL to your site
my $dir = '.'; # The full path to the directory this file is in.
my $require_pw = '0'; # Require a password to view the stats?  1=yes 0=no
my $pw = 'password'; # If you require a password, what will the password be?

# Tells the script what version it is.
$tmpl{version} = '2.2.2';

# Read the form using CGI.pm.
my $q = new CGI;
my %form = $q->Vars;

# Check the password.
if ($require_pw) {
  if ($form{pw} eq $pw) { &stats; }
  elsif ($form{pw}) { &error("Invalid password!  Please go back and try again."); }
  else { &login; }
}
else { &stats; }



# Login if a password is required.
sub login {
  print "Content-type: text/html\n\n";
  print <<EndHTML;
<form action="stats.cgi" method="post">
<input name="pw" type="password" size="20" />
<input type="submit" value="Login" />
</form>
Powered By <a href="http://www.aardvarkind.com/?a=cgi&amp;b=clickmanager&amp;c=index" target="_blank">Click Manager $tmpl{version}</a>
EndHTML
}



# The stats and graphs page.
sub stats {
  sysopen(CLICKMANAGER, "$dir/clickmanager.txt", O_RDONLY) || die "$dir/clickmanager.txt\n\n$!, stopped";
  flock(CLICKMANAGER, 2);
  my @db = <CLICKMANAGER>;
  close(CLICKMANAGER);
  sysopen(TOTAL, "$dir/total.txt", O_RDONLY) || die "$dir/total.txt\n\n$!, stopped";
  flock(TOTAL, 2);
  my($hits_today, $hits_1, $hits_2, $hits_3, $hits_highest, $hits_total, $hits_days) = split(/\|/, <TOTAL>);
  close(TOTAL);
  $tmpl{hits_total} = $hits_total;
  my $g_avg = "Average|" . $hits_total / $hits_days;
  my $g_today = "Today|$hits_today";
  my $g_1 = "Yesterday|$hits_1";
  my $g_2 = "2 Days Ago|$hits_2";
  my $g_3 = "3 Days Ago|$hits_3";
  my $g_highest = "Highest Day|$hits_highest";
  $tmpl{totalgraph} = &graph($g_avg, $g_today, $g_1, $g_2, $g_3, $g_highest); 
  foreach my $line(@db) {
    chomp;
    my($id, $url, $hits) = split(/\|/, $line);
    $line = join('|', $hits, $url, $id);
  }
  @db = sort { $b <=> $a }@db;
  foreach (@db) {
    my($hits, $url, $id) = split(/\|/);
    $tmpl{individual} .= qq~<tr><td class="cell">$id</td><td class="cell">$url</td><td align="right" class="cell">$hits</font></td></tr>~;
  }
  &template;
}



# Used for some error messages.
sub error {
  print "Content-type: text/html\n\n$_[0]\n";
  exit;
}



# This is a modified version of Text::BarGraph, originally written by 
# Kirk Baucom <kbaucom@schizoid.com>.  Alot of the functionality has 
# been removed.  If you want to use it, you can download the original 
# Text::BarGraph at http://search.cpan.org/search?dist=Text-BarGraph.
sub graph {
  my($gtext, $min_data, $max_data, $dots, $dotstring);
  my $dot = "#";
  my $tag = 5;
  my $scale = 1;
  my $columns = 80;
  my @data = @_;
  foreach (@data) {
    my($key, $value) = split(/\|/);
    if ($min_data > $value) { $min_data = $value; }
    if (length($key) > $tag) { $tag = length($key); }
    if ($value > $max_data) { $max_data = $value; }
  }
  if (!defined($max_data)) { $max_data = 0; }
  my $data_length = length($max_data);
  my $barsize = $columns - ($tag + $data_length + 4);
  if ($max_data) { $scale = $barsize / ($max_data); }
  foreach (@data) {
    my($key, $value) = split(/\|/);
    $dots = int(($value) * $scale);
    $dotstring = ${dot}x$dots;
    $gtext .= "<tr><td class=\"cell\"><b>" . sprintf("%${tag}s</b></td><td class=\"cell\">%${data_length}d</td><td class=\"cell\">%s\n", $key, $value, $dotstring) . "</td></tr>";
  }
  return $gtext;
}



# Reads and parses the template.
sub template {
  open(TEMPLATE, "$dir/template.html") || die "$dir/template.html\n\n$!, stopped";
  flock(TEMPLATE, 2);
  my $template = join('', <TEMPLATE>);
  close(TEMPLATE);
  $tmpl{copyright} = "Powered By <a href=\"http://www.aardvarkind.com/?a=cgi\&amp\;b=clickmanager\&amp\;c=index\" target=\"_blank\">Click Manager $tmpl{version}</a>";
  print "Content-type: text/html\n\n";
  if ($template =~ /<\$copyright>/) {
    $template =~ s/<\$(.+?)>/$tmpl{$1}/ig;
    print $template;
  }
  else { print "Please put the copyright link back in the template.\n"; }
}