# CONFIGURACAO DO CHAT
#
#######################

$data_dir = "data"; # data directory like "data"
$unknowncmd_msg = "unknown command"; # msg when command is unknown
$unknownnick_msg = "unknown nickname"; # msg when nickname is unknown
$help_msg= << "[END]"; # msg printed on /help (DON'T REMOVE "[END]")
    <I><B>comandos:</B></I><BR>
    /msg <KBD>nickname</KBD> <KBD>message</KBD> - send private <KBD>message</KBD> to <KBD>nickname</KBD><BR>
    /help - Este arquivo de Help<BR>
    /about - Sobre este programa<BR>
    /me - action (p.e. "/me says ola" ser mostrado como "* user says ola")<BR>
    /userinfo <KBD>nick</KBD> - mostra informaes sobre o usurio<BR>
	/memo <KBD>nick message</KBD> - deixa mensagem para usurio offline<BR><BR>
    <I><B>master commands:</B></I><BR>    
    /list_nicks <KBD>masterpassword</KBD> - lista todos os usurios(online ou no)<BR>
    /clean_old_nicks <KBD>masterpassword x</KBD> - remove todos usurios que no visitaram o chat por <KBD>x</KBD> dias<BR>
    /remove_nick <KBD>masterpassword nick</KBD> - remove <KBD>nick</KBD><BR>
    /ban <KBD>masterpassword nick</KBD> - Proibe usurio de utilizar a sala<BR>
    /ban <KBD>masterpassword</KBD> ip:<KBD>x.x.x.x</KBD> - Proibe IP de utilizar a sala <BR>
    /kick <KBD>masterpassword nick</KBD> - Elimina usurio da sala<BR>
    /unban <KBD>masterpassword nick</KBD> - permite o usurio voltar  sala<BR>
    /unban <KBD>masterpassword</KBD> ip:<KBD>x.x.x.x</KBD> - permite o IP voltar  sala<BR>
[END]
$welcome_msg = << "[END]"; # msg printed when user logs in
    Benvindo ao Ralf's Chat / Traduo CGI-BRASIL !<BR>
    Tecle /help para Ajuda !
[END]
$masterpassword = "mpw"; # Masterpassword para comandos especiais
$wrongmasterpass_msg = "masterpassword incorreta"; # msg printed when wrong mpw was used at a special cmd
$updatefrequency = 5; # number of seconds the chat updates itself
$clear_old_msgs = 1; # set to 1 if you want that old msgs are deleted when the chat is empty
$nocleantime_msg = "nmero de dias no especficado"; # if no number of days in /clean_old_nicks is given
$message_limit = 20; # number of maximal (public) messages in the chat window
$new_msg_on_top = 0; # set to 1 if you want new messages printed on top, to work around the msie bug
$admin_email_addresse = "you\@yourserver.com"; # Your email address (replace @ with \@) NEW
$mailprogramme = '/usr/lib/sendmail'; # Path to the mail-transport-agent NEW
$mail_on_new_registration = 0; # set to 1 if you want to be mailed when a new user registers NEW
$logtype = 0; # The type of log you wish: 0 - no log, 1 - registrations, 2 - +logins, 3 - +messages NEW
$log_dir = "logs"; # directory for log files NEW
$script_name = "chat.cgi"; # filename of the script like "chat.cgi" NEW
$script2_name = "chat2.cgi"; # filename of the second cript like "chat2.cgi" NEW
$max_users = "-1"; # the maximal number of users in the chat at the same time, set to "-1" if unlimited NEW
$login_msg = "entrou no chat"; # MSG printed when user logs in without "user" NEW
$logout_msg = "saiu do chat"; # MSG printed when user logs out without "user" NEW
$days_to_keep_memos = 60; # Number of days to keep memos NEW
$min_update_freq = 2; # the minimum update frequency NEW

# Files - no  necessrio mudar nada aqui.

$data_msg_file = "messages";
$data_stillalive_file = "stillalive";
$data_private_file = "private"; # without .user
$data_nicks_file = "nicks"; # you should leave this one, else the user has to register on every single script
$data_userinfo_file = "userinfo"; # the user-info database NEW
$data_banned_file = "banned"; # banned user file NEW
$data_memo_file = "memo"; # memo file NEW

# HTML-Stuff

$html_bodytag = '<BODY BGColor=#000000 TEXT=#6699FF Link=#0000FF VLINK=#0000CC ALINK=#0000FF>'; # The bodytag for html files NEW
$html_title = "Ralfs Chat & CGI-BRASIL"; # The title of your chat NEW
$banner_picture = "http://www.brasilsites.com/_images/banralfc.gif"; # the banner picture, set to "" if you dont want any banner NEW
$banner_link = "http://www.ralfchat.de"; # The banner link NEW
$logout_url = "$script_name"; # the url for the logout-link NEW
$input_field_size = "30"; # the size of the msg input field NEW

# FINAL DA PARTE DE CONFIGURAO
#
########################

# HTML 
#
########################


#NONICK.HTML - when nick doesnot exists
sub nonick_html {
    print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - Nick no existe</TITLE>
</HEAD>
$html_bodytag
<CENTER>
<H1><I>Nick no existe</I></H1>
<B><A HREF="$script2_name?action=register">register</A> or<BR>
<A HREF="$script_name">tente outro nick</A></B>
</CENTER>
</BODY>
</HTML>
[END]
}

#WRONGPASS.HTML - when wrong password was input
sub wrongpass_html {
    print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - Senha incorreta</TITLE>
</HEAD>
$html_bodytag
<CENTER>
<H1><I>Senha incorreta</I></H1>
<B><A HREF="$script2_name?action=send_pwd&name=$query{'name'}">Senha incorreta</A></B><BR>
<B><A HREF="$script_name">tentar novamente</A></B>
</CENTER>
</BODY>
</HTML>
[END]
}

#KICKED.HTML - when user is kicked
sub kicked_html {
    print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - Voc foi excludo</TITLE>
</HEAD>
$html_bodytag
<CENTER>
<H1><I>Voc foi excludo</I></H1>
<B><A HREF="$script2_name?action=gotourl&url=$logout_url" TARGET="_top">logout</A></B>
</CENTER>
</BODY>
</HTML>
[END]
}

#KICKED.HTML - when user is kicked
sub banned_html {
    print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - Voc foi eliminado</TITLE>
</HEAD>
$html_bodytag
<CENTER>
<H1><I>Voc foi eliminado</I></H1>
<B><A HREF="$script2_name?action=gotourl&url=$logout_url" TARGET="_top">logout</A></B>
</CENTER>
</BODY>
</HTML>
[END]
}

# Parte principal - No mude nada aqui!
#
#######################

$version = "0.10";     # don't change
$lastmodified = "24.10.99"; # don't change
$about_msg = "created and copyright by Ralf Gueldemeister \&lt;ralfg\@bigfoot.com> on 25.12.98; last modified on $lastmodified; Version $version; traduo de Marcelo Contart &lt;mac\@brasilsites.com>"; # msg printed on /about

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$mon++; $year += 1900;
$log_file = "$year-$mon-$mday.txt";

&getquery;


sub extract_qs { # einzelne variablen aus query_string extrahieren und in hash $query uebergeben
    @split = split (/&/, $qs);
    foreach $split (@split) {
    	($query_key, $query_value) = split (/=/, $split);
    	$query_value =~ tr/+/ /;
    	$query_value =~ s/%([\dA-Fa-f][\dA-Fa-f])/ pack ("C", hex ($1))/eg;
    	$query{$query_key} = $query_value;	
    }

}

sub getquery {
    if ($ENV{'REQUEST_METHOD'} eq "GET") {
        $qs= $ENV{'QUERY_STRING'}; # Wert vom query_string wird in $qs gespeichert
    } elsif ($ENV{'REQUEST_METHOD'} eq "POST") {
        read(STDIN, $qs, $ENV{'CONTENT_LENGTH'});
    }
    &extract_qs; # einzelne variablen aus querystring auslesen
}

sub header { # Gibt standard html header aus
    print "Content-type: text/html\n\n";
}

sub error { # Irgendein Fehler ist aufgetreten
    &header;
    print "<H1>An error occured</H1>";
    print "<I>Query_String:</I> $qs<BR>";
    print "<I>Errormessage:</I> $_[0]";
    exit;
}

sub make_matrix {
    undef @matrix;
    foreach (@_) {  
        chomp;
    	push @matrix, [split(/;;/, $_)];
    }
}

sub join_matrix {
    join(';;', $matrix[$i2][0],$matrix[$i2][1],$matrix[$i2][2],$matrix[$i2][3],$matrix[$i2][4],$matrix[$i2][5],$matrix[$i2][6],$matrix[$i2][7],$matrix[$i2][8],$matrix[$i2][9],$matrix[$i2][10],$matrix[$i2][11],$matrix[$i2][12]);
}

sub repair_safile {
    $i=0;
    for (@sa) {        
        if (/[A-Za-z]/) {
            $satemp[$i]=$_;
            $i++; 
        }
    }    
    $i=0;
    for (@satemp) {
        $satemp2[$i*2] = $satemp[$i];
        $satemp2[$i*2+1] = time;
        $i++; 
    }

    @sa = @satemp2;

    $#sa % 2 == 1 ? return @sa : &error("safile corrupt");    
}

sub checkpass {
    if (-e "$data_dir/$data_nicks_file") {  # wenn nickfile existiert dann oeffnen
    	open (NICKFILE, "<$data_dir/$data_nicks_file") || &error("::open Nickfile failed::");
    } 
    else {  # else print nonick_html
	    &header;
    	&nonick_html;
    	exit;
    }
    my @nickfile = <NICKFILE>; 
    close NICKFILE; 

    @save_matrix = @matrix;
    &make_matrix(@nickfile);

    for ($cpi=0; $cpi<=$#matrix; $cpi++) {
        if ($matrix[$cpi][0] eq $query{'name'}) {
		    $nickok = 1;
            if ($matrix[$cpi][1] ne $query{'password'}) {
		        &header;
                &wrongpass_html;
        	    exit;
    	    }
            if ($matrix[$cpi][10] == 1) {
		        &header;
                &kicked_html;
        	    exit;
            }
            if ($matrix[$cpi][10] == 2) {
		        &header;
                &banned_html;
        	    exit;
            }
	    } 
	}
    
    if ($nickok != 1) {
        &header;
        &nonick_html;
        exit;
    }

    @matrix = @save_matrix;
}

sub postprivatemsg { # parameter: 0: empfaenger 1: sender 2: msg 
    &checkpass;  # Passwort checken
    
    # kill linebreaks
    $_[2] =~ s/\n/ /g;

    if (-e "$data_dir/$data_private_file.$_[0]") {
    } else {
        &postprivatemsg($query{'name'}, "MSG", "$unknownnick_msg: $_[0]");
        return;
    }

    # alte Eintraege >35 loeschen
    open (PRIVATEFILE, "<$data_dir/$data_private_file.$_[0]") || &error("opening $data_dir/$data_private_file.$_[0] failed");
    my @privatefile = <PRIVATEFILE>;
    close PRIVATEFILE;

    for ($ppm_i=0; $ppm_i <= ($#privatefile -35); $ppm_i++) {
        shift(@privatefile);
    }
    open (PRIVATEFILE, ">$data_dir/$data_private_file.$_[0]") || &error("opening privatefile failed");
    flock(PRIVATEFILE,2);

    print PRIVATEFILE @privatefile;

#    flock(PRIVATEFILE,8);
    close PRIVATEFILE;

	while (time == $last_priv_msg_id) {}
	$priv_msg_id = time;
    $last_priv_msg_id = $priv_msg_id;

    open (PRIVATEFILE, ">>$data_dir/$data_private_file.$_[0]");
    flock(PRIVATEFILE,2);

    if ($query{'color'} eq "standard") {
        print PRIVATEFILE "$priv_msg_id;;<B>[$_[1]]</B> $_[2]\n";
    } else {
        print PRIVATEFILE "$priv_msg_id;;<FONT COLOR=\"$query{'color'}\"><B>[$_[1]]</B> $_[2]</FONT>\n";
    }        
    
#    flock(PRIVATEFILE,8);
    close PRIVATEFILE;

    open (CHATFILE, ">>$data_dir/$data_msg_file");
    flock(CHATFILE,2);

    print CHATFILE "<!--PrivateMsgHere;;$_[0];;$priv_msg_id;;-->";

#    flock(CHATFILE,8);
    close CHATFILE;
}

sub create_file { # Datei erstellen (in Klammern als parameter zu uebergeben)
    $file2create = $_[0];
    open (CREATEFILE, ">$file2create") || &error("creating $file2create failed");
    close (CREATEFILE);
}

sub userinfo {
    open (UIFILE, "<$data_dir/$data_userinfo_file") || &create_file("$data_dir/$data_userinfo_file");
    my @uifile = <UIFILE>; 
    close UIFILE;

    &make_matrix(@uifile);

	$nickfound = 0;
    for ($i=0; $i<=$#matrix; $i++) {
        if ($matrix[$i][0] eq $query{'infoabout'}) {
            $userinfo{'realname'}=$matrix[$i][1];
            $userinfo{'email'}=$matrix[$i][2];
            $userinfo{'age'}=$matrix[$i][3];
            $userinfo{'city'}=$matrix[$i][4];
            $userinfo{'country'}=$matrix[$i][5];
            $userinfo{'url'}=$matrix[$i][6];
            $userinfo{'stuff'}=$matrix[$i][7];
            $userinfo{'photo_url'}=$matrix[$i][8];
            $userinfo{'icq_uin'}=$matrix[$i][9];
			$nickfound = 1;
        }
    }

    if ($userinfo_as_private_msg != 1) {
        &header;
        &userinfo_html;
    } elsif ($nickfound == 0){
        &postprivatemsg($query{'name'}, "USERINFO", "user $query{'infoabout'} not found");
	} else {
        &postprivatemsg($query{'name'}, "USERINFO", "<B>$query{'infoabout'}</B><BR>realname: $userinfo{'realname'}<BR>email: <A HREF=\"mailto:$userinfo{'email'}\">$userinfo{'email'}</A><BR>age: $userinfo{'age'}<BR>city: $userinfo{'city'}<BR>country: $userinfo{'country'}<BR>homepage: <A HREF=\"$userinfo{'url'}\">$userinfo{'url'}</A><BR>anything else: $userinfo{'stuff'}<BR>photo: <A HREF=\"$userinfo{'photo_url'}\">$userinfo{'photo_url'}</A>");
    }
}

1;
