#! /usr/local/bin/perl -w
use strict;

# ======================================================================
# Credit Card Validation Solution, Perl Edition
# Usage Example
#
# ======================================================================
# Author     Daniel Convissor <danielc@AnalysisAndSolutions.com>
# Copyright  The Analysis and Solutions Company, 2002-2003
# Version    $Name: rel-5-12 $ $Id: ccvs_example.pl,v 1.9 2003/08/05 16:59:53 danielc Exp $
# Link       http://www.ccvs.info/
# ======================================================================

use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';

print header;

use ccvs;
my $Form  = new CreditCardValidationSolution();
my $Month = '';
my $Year  = '';


print "<html>\n";
print " <head>\n";
print "  <title>Credit Card Validation Solution:&trade;";
print "  Perl Edition Test</title>\n";
print " </head>\n";
print " <body>\n";

if ( !param('Number') ) {
    $Form->{CCVSNumber} = '4002417016240182';

} else {
    #  Put the names of the card types you accept in here.
    #  To handle all card types, skip this step and put ''
    #  in the Accepted argument.
    my @Accepted = ('Visa', 'JCB');

    if ( !$Form->validateCreditCard(param('Number'), 'en', \@Accepted, 'Y',
                                    param('Month'), param('Year')) ) {
        print "  <p>PROBLEM: $Form->{CCVSError}</p>\n";
    } else {
        print "  <p>That $Form->{CCVSType} number seems good";
        print "  and expires in $Form->{CCVSExpiration}.\n";
        print "  <br />The left digits are $Form->{CCVSNumberLeft}";
        print "  and the right digits are $Form->{CCVSNumberRight}.</p>";

    }

    $Month = param('Month');
    $Year  = param('Year');
}

print "  <form method=\"post\">\n";
print "   Number: <input type=\"text\" name=\"Number\" size=\"21\"";
print         " maxlen=\"21\" value=\"$Form->{CCVSNumber}\" />\n";
print "   Month: <input type=\"text\" name=\"Month\" size=\"2\"";
print         " maxlength=\"2\" value=\"$Month\" />\n";
print "   Year: <input type=\"text\" name=\"Year\" size=\"4\"";
print         " maxlength=\"4\" value=\"$Year\" />\n";
print "   <input type=\"submit\" name=\"Submit\" value=\"Test\" />\n";
print "  </form>\n";
print " </body>\n";
print "</html>\n";
