#!/usr/local/bin/perl

require ('cgi-lib.pl');
####################################################################
#                                                                  #
#  CC_GUESTBOOK BY CGI CITY IS A VERY SIMPLE GUESTBOOK PROGRAM.    #
#  IT FEATURES EMAIL NOTIFICATION SO THE GUESTBOOK OWNER IS        #
#  INFORMED WHENEVER THERE ARE NEW ENTRIES TO HIS/HER GUESTBOOK.   #
#  THIS SCRIPT CAN ALSO BE USED AS A "POST IT" BOARD WHERE         #
#  VISITORS CAN SIMPLY POST MESSAGES.                              #
#                                                                  #
#  THIS PROGRAM MAY BE USED AND DISTRIBUTED FREELY PROVIDED        #
#  NO MODIFICATIONS ARE MADE TO THE CODE.                          #
#                                                                  #
#  Copyright (c) 1998-1999 - CGI City - All rights reserved        #
#  Author: Peter N. Go - cgicity@icthus.net                        #
#                                                                  #
####################################################################
#                                                                  #
#  DISCLAIMER:                                                     #
#  In no event will CGI City be liable to the user of this script  #
#  or any third party for any damages, including any lost profits, #
#  lost savings or other incidental, consequential or special      #
#  damages arising out of the operation of or inability to operate #
#  this script, even if user has been advised of the possibility   #
#  of such damages.                                                #
#                                                                  #
####################################################################

####################################################################
#                                                                  #
#  INSTRUCTIONS:                                                   #
#  1. Change the first line of this script to point correctly to   #
#     your host server's Perl interpreter.                         #
#  2. Under the "ASSIGN THE VARIABLES" section below, change the   #
#     variables as needed.                                         #
#  3. Upload this script to your cgi-bin directory and chmod it    #
#     to 777                                                       #
#  4. Upload the file named "guestbook_view.html" to a directory   #
#     of your choice in your web host server. That directory and   #
#     the file must both be chmod 777                              #
#                                                                  #
####################################################################

########################
## ASSIGN THE VARIABLES
########################

##  Change the following to point correctly to your server's sendmail program
$mailprog = '/usr/sbin/sendmail';

##  Change the following to point correctly to your guestbook's URL
$guestbook_url = "http://yourdomain.com/guestbook_view.html";

##  Change the following to point correctly to your guestbook's path in the server
$guestbook_file = "/web/path/to/guestbook_view.html" ;

##  Change the following to the email address where you want the notification sent
##  Don't forget the backslash "\" before the "@" sign
$my_email = "yourname\@yourdomain.com";

##  Change the following error message as you see fit. You may also leave it as it is.
$message = "The following error(s) occurred while processing your input." ;


###############################
## DO NOT EDIT PAST THIS LINE
###############################

&ReadParse(*field);
$name = $field{'name'} ;	 
$email = $field{'email'} ;	 
$homepage_title = $field{'homepage_title'} ;	 
$homepage_url = $field{'homepage_url'} ;	 
$main_message = $field{'main_message'} ;	 
$found_err = "" ;
$getdate = `date +"%D %T %Z"`; 
chop ($getdate);

#####################################################
#  IF THERE ARE MISSING ENTRIES, PRINT ERROR MESSAGE
#####################################################
$errmsg = "<LI>You forgot to enter your name.</LI>\n" ;
if ($name eq "") {
	$message = $message.$errmsg ;
	$found_err = 1 ; }
$errmsg = "<LI>Please enter a valid email address</LI>\n" ;
if ($email !~ /.+\@.+\..+/) {
	$message = $message.$errmsg ;
	$found_err = 1 ; }
$errmsg = "<LI>Please enter your homepage title.</LI>\n" ;
if ($homepage_title eq "") {
	$message = $message.$errmsg ;
	$found_err = 1 ; }
$errmsg = "<LI>Please give us your homepage URL.</LI>\n" ;
if ($homepage_url eq "") {
	$message = $message.$errmsg ;
	$found_err = 1 ; }
if ($found_err) {
	&PrintError; }

########################################
#  PRINT  ENTRIES TO THE GUESTBOOK PAGE
########################################
open (FILE,"$guestbook_file") || die "Can't Open $guestbook_file: $!\n";
@lines = <FILE>;
close(FILE);

flock(POST, 2) ;
open (POST,">$guestbook_file") || die "Can't Open $guestbook_file: $!\n";
$main_message =~ s/&/&amp;/g;
$main_message =~ s/"/&quot;/g;
$main_message =~ s/>/&gt;/g;
$main_message =~ s/</&lt;/g;
$main_message =~ s/\cM\n/<BR>/g;

foreach $line (@lines) {
	if ($line =~ /<!--begin-->/) { 
	print POST "<!--begin-->\n";
	print POST "<DIR> \n";
	print POST "<FONT COLOR=\"#FF0000\"><B>Name:</B></FONT> <A HREF=MAILTO:$email>$name</A><BR> \n";
	print POST "<FONT COLOR=\"#FF0000\"><B>Homepage:</B></FONT> <A HREF=$homepage_url>$homepage_title</A><BR> \n";
	print POST "<FONT COLOR=\"#FF0000\"><B>Date Posted:</B></FONT> $getdate<BR> \n";
	print POST "<FONT COLOR=\"#FF0000\"><B>Message:</B></FONT><BR>$main_message</DIR><HR WIDTH=90%><BR> \n";
	} else {
		print POST ("$line");
	}
}
close (POST);
flock(POST, 8) ;
&success;
&notify;

######################
#  PRINT SUCCESS PAGE
######################
sub success {
print "Content-type: text/html\n\n";
print<<"end1";
<HTML>
<BODY BGCOLOR=WHITE>
<CENTER>
<H1>Thank you for signing my guestbook</H1>
<A HREF=$guestbook_url>View Guestbook</A>
</BODY>
</HTML>
end1
}

######################
#  NOTIFY BY EMAIL
######################
sub notify  {
	open (MAIL,"|$mailprog -t");
	print MAIL "To: $my_email\n";
	print MAIL "From: Guestbook Notification System\n";
	print MAIL "Subject: NEW GUESTBOOK ENTRY\n";
	print MAIL "You have a new guestbook entry posted by $name\n";
	print MAIL "from this IP - $ENV{'REMOTE_HOST'} \n";
	print MAIL "You may view it at $guestbook_url\n";
	close (MAIL);
exit;
}

#########################
#  OUTPUT ERROR MESSAGE
#########################
sub PrintError { 
print "Content-type: text/html\n\n";
print "<HTML><TITLE>Error!</TITLE></HEAD><BODY BGCOLOR=\"#FFFFFF\">\n\n";
print "<OL><H2>\n";
print $message;
print "</OL></H2></BODY></HTML>";

exit 0 ;
return 1 ; 
}

