#!/usr/local/bin/perl

# Bibliotecas Requeridas
# --------------------------------------------------------
eval {
    ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");
    ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");

    require "/somline.hypermart.net/cgi-bin/busca/admin/links.cfg";
    require "$db_lib_path/db_utils.pl";
    require "$db_lib_path/links.def";
    require "$db_lib_path/site_html.pl";
};
if ($@) {
    print "Content-type: text/plain\n\n";
    print "Erro incluindo bibliotecas: $@\n";
    print "Tenha certeza de que elas existem, permisses esto corretas e caminhos esto definidos corretamente.";
    exit;
}

# ========================================================

eval { &main; }; 
if ($@) { &cgierr("fatal error: $@"); } 
exit;  

sub main {
# --------------------------------------------------------
    local (%in) = &parse_form;

# Ns estamos processando o formulrio. 
    if ($in{'Submit'}) {
        &process_form;
    }
# Ou ento estamos exibindo o formulrio (em site_html.pl).
    else {
        if ($in{'ID'} =~ /^\d+$/) { # Se j tiver entrado um ID
            my (%rec) = &get_record ($in{'ID'});

	    if ($rec{$db_key} eq $in{'ID'}) { # Este for vlido
                if ($rec{'Senha'} eq $in{'senha'}) {  # E a senha vlida
                    &site_html_modify_form (%rec);   # Exibe os dados atuais!
                }
                else {
                    &site_html_modify_failure ("Senha Invlida: $in{'senha'}");  # Aqui a senha est errada
                }
            }
            else { # Se nao tiver entrado um ID correto
                &site_html_modify_failure ("ID do Link Desconhecido: $in{'ID'}");
            }
        }
        else { # Se nenhum ID foi entrado
            &site_html_modify_first; # Exibe o formulrio e pede!
        }
    }
}

sub process_form {
# --------------------------------------------------------          
    my ($key, $status, @values, $found);
    local (%original);

# Tenha certeza de que h um link para modificar.
    !$in{'Current URL'} and &site_html_modify_failure ("no especificou link a modificar") and return;
    
# Checa se o link a ser atualizado est no banco de dados.
    open (DB, "<$db_file_name") or &cgierr("error in validate_records. unable to open db file: $db_file_name. Reason: $!");
    $found = 0;
    LINE: while (<DB>) {
        (/^#/)      and next LINE;
        (/^\s*$/)   and next LINE;
        chomp;      
        @data = &split_decode($_);
        if ($data[$db_url] eq $in{'Current URL'}) {
            $in{$db_key} = $data[0];
            $found = 1; 
            %original = &array_to_hash (0, @data);
            last LINE;
        }
    }
    close DB;
    !$found and &site_html_modify_failure ("link was not found in the database") and return;
    
# Since we have a valid link, let's make sure the system fields are set to their
# proper values. We will simply copy over the original field values. This is to stop
# people from trying to modify system fields like number of hits, etc.
    foreach $key (keys %add_system_fields) {
        $in{$key} = $original{$key};
    }

# Set date variable to today's date.
    $in{$db_cols[$db_modified]} = &get_date;
    
# Validate the form input.. 
    $status = &validate_record(%in);
    if ($status eq "ok") {
# First make sure the link isn't already in there.
        open (MOD, "<$db_modified_name") or &cgierr ("error opening modified database: $db_modified_name. Reason: $!");
        while (<MOD>) {
            chomp;
            @values = split /\|/;
            if ($values[0] eq $in{$db_key}) {
                close MOD;
                &site_html_modify_failure("Um pedido de modificao desse site j foi recebido. Tente de novo mais tarde.");
                return;
            }
        }
        close MOD;

# Print out the modified record to a "modified database" where it is stored until
# the admin decides to add it into the real database.
        open (MOD, ">>$db_modified_name") or &cgierr("error in modify.cgi. unable to open modification database: $db_modified_name. Reason: $!");
            flock(MOD, $LOCK_EX) unless (!$db_use_flock);       
            print MOD &join_encode(%in);    
        close MOD;      # automatically removes file lock

# Send the admin an email message notifying of new addition.
#        &send_email;
# Send the visitor to the success page.     
        &site_html_modify_success;
    }
    else {
# Let's change that error message from a comma delimted list to an html
# bulleted list.
        &site_html_modify_failure($status);
    }       
}

sub send_email {
# --------------------------------------------------------
# Sends an email to the admin, letting him know that there is
# a new link waiting to be validated.

# Check to make sure that there is an admin email address defined.
    $db_admin_email or &cgierr("Admin Email Address Not Defined in config file!");
    my $to = $db_admin_email;
    my $from = $in{$db_cols[$db_contact_email]};
    my $subject = "Modificao no Banco de Dados: $in{'Title'}";
    my $msg = qq|
O seguinte link foi modificado e est esperando ser validado:

LINK ORIGINAL:
===============================================
              Ttulo:  $original{'Title'}
                 URL:  $original{'URL'}
           Descrio:  $original{'Description'}
                Pas:  $original{'Country'}
                Tipo:  $original{'Type'}
   Nome para Contato:  $original{'Contact Name'}
  Email para Contato:  $original{'Contact Email'}
           Categoria:  $original{'Category'}
       
NOVO LINK:
===============================================
              Ttulo:  $in{'Title'}
                 URL:  $in{'URL'}
           Descrio:  $in{'Description'}
                Pas:  $in{'Country'}
                Tipo:  $in{'Type'}
   Nome para Contato:  $in{'Contact Name'}
  Email para Contato:  $in{'Contact Email'}
           Categoria:  $in{'Category'}

    Remote Host: $ENV{'REMOTE_HOST'}
        Referer: $ENV{'HTTP_REFERER'}
       
Para atualizar, por favor v em:
    $db_script_url
    
Sinceramente,

Links Manager.
    |;

# Then mail it away!    
    require "$db_lib_path/Mailer.pm";
    my $mailer = new Mailer ( { smtp => $db_smtp_server, 
                                sendmail => $db_mail_path, 
                                from => $from, 
                                subject => $subject,
                                to => $to,
                                msg => $msg,
                                log => $db_mailer_log
                            } ) or return undef;
    $mailer->send or return undef;
}