#!/usr/local/bin/perl

# Bibliotecas Requeridas
# --------------------------------------------------------

eval {
    ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");    # Pega o local do script: UNIX /
    ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");    # Pega o local do script: Windows \

    require "/somline.hypermart.net/cgi-bin/busca/admin/links.cfg";
    require "$db_lib_path/db_utils.pl";
    require "$db_lib_path/links.def";
    require "$db_lib_path/site_html.pl";
};
if ($@) {
    print "Content-type: text/plain\n\n";
    print "Erro incluindo bibliotecas: $@\n";
    print "Tenha certeza de que elas existem, permisses esto corretas e caminhos esto definidos corretamente.";
    exit;
}

# ========================================================

eval { &main; };                            # Trap any fatal errors so the program hopefully 
if ($@) { &cgierr("fatal error: $@"); }     # never produces that nasty 500 server error page.
exit;   # There are only two exit calls in the script, here and in in &cgierr. 

sub main {
# --------------------------------------------------------
    local (%in) = &parse_form;
    
    if ($in{'rate'}) {
        &rate_it;
    }
    elsif ($in{$db_key} =~ /^\d+$/) {
        my (%rec) = &get_record ($in{$db_key});
        ($rec{$db_key} eq $in{$db_key}) ?
            &site_html_rate_form    (%rec) :
            &site_html_rate_failure ("Link ID desconhecido: $in{$db_key}");
    }
    else {
        print "Location: $build_ratings_url/\n\n";
    }
}

sub rate_it {
# --------------------------------------------------------          
    my $id    = $in{$db_key};
    my $delim = quotemeta($db_delim);
    my $time  = time();
    my $rating = $in{'rate'};

# Make sure we have a valid rating. 
    unless (($rating =~ /^\d\d?/) and ($rating >= 1) and ($rating <= 10)) {
        &site_html_rate_failure ("A sua avaliao '$rating'  invalida.");
        return;
    }
    
# Let's get the link information.
    my %rec = &get_record ($id);
    ($rec{$db_key} eq $id) or (&site_html_rate_failure ("No foi possvel encontrar link com o ID '$id'.") and return);

# Increase the rating.
    
    if (open (HIT, "<$db_rates_path/$id")) {        
        my $input = <HIT>; chomp $input;
        ($votes, $old_rating) = split /\s/, $input;     
        chomp ($old_time = <HIT>);
        chomp (@IP       = <HIT>);
        (($time - $old_time) > 21600) and (@IP = ());
        foreach $ip (@IP) {         
            $ip eq $ENV{'REMOTE_ADDR'} and ($visited++ and last);
        }
        close HIT;

        if (!$visited) {
            push (@IP, $ENV{'REMOTE_ADDR'});
            $votes  = $votes + 1;
            $rating = $rating + $old_rating;
            open (HIT, ">$db_rates_path/$id")   or &cgierr ("Can't open for output counter file. Reason: $!");
            if ($db_use_flock) { flock (HIT, 2) or &cgierr ("Can't get file lock. Reason: $!"); }
            local $" = "\n";
            print HIT "$votes $rating\n$time\n@IP";
            close HIT;
            &site_html_rate_success;
        }       
        else {
            &site_html_rate_failure ("Desculpe, voc j avaliou este site recentemente.");
        }
    }
    else {
        open (HIT, ">$db_rates_path/$id") or &cgierr ("Can't increment counter file '$db_rates_path/$id'. Reason: $!");     
        print HIT "1 $rating\n$time\n$ENV{'REMOTE_ADDR'}";
        close HIT;      
        &site_html_rate_success;
    }
}