 
##########################################################
##                      Globals                         ##
##########################################################

    $font       = 'font face="verdana,arial,helvetica" size="2"';
    $font_title = 'font face="verdana,arial,helvetica" size="4"';

##########################################################
##                      Home Page                       ##
##########################################################

sub html_home {
# --------------------------------------------------------
# Prints the database frame index page.
#
    &html_print_headers();
    print  qq|
<html>
<head>
<title>Sistema de Busca: Administrao</title>

<frameset cols="155,*"> 
  <frame src="$db_script_url?display=navigation" name="nav">
  <frame src="$db_script_url?display=body" name="cgimain" scrolling="AUTO">
</frameset>

<noframes><body bgcolor="#FFFFFF">
Sorry, you need a frames capable browse to use this program.
</body></noframes>
</html>
    |;
}

sub html_navigation {
# --------------------------------------------------------
# Prints the navigation links.
#
    &html_print_headers();      
    print qq|
<html>
<head>
    <title>$html_title: Main Menu.</title>  
    <base target="cgimain">
</head> 
<body bgcolor="#DDDDDD">

<p><$font><b>Links<br></b></font>
   <$font>
        <a href="$db_script_url?db=links&view_search=1">Ver</a><br>
        <a href="$db_script_url?db=links&add_form=1">Adicionar</a><br>
        <a href="$db_script_url?db=links&delete_search=1">Apagar</a><br>
        <a href="$db_script_url?db=links&modify_search=1">Modificar</a><br>
        <a href="$db_script_url?db=links&validate_form=1">Validar</a><br>
        <a href="$db_script_url?db=links&check_duplicates=1">Checar Dup.</a>
    </font>
</P>
<p> <$font><b>Categorias<br></b></font>
    <$font>
        <a href="$db_script_url?db=category&view_search=1">Ver</a><br>
        <a href="$db_script_url?db=category&add_form=1">Adicionar</a><br>
        <a href="$db_script_url?db=category&delete_search=1">Apagar</a><br>
        <a href="$db_script_url?db=category&modify_search=1">Modificar</a><br>
        <a href="$db_script_url?db=links&check_links=1">Checar Cat.</a>
    </font>
</p>
<p><$font><b>Emails</b><br></font>
    <$font>
        <a href="$db_script_url?db=links&html_mail_update=1">Atualizaes</a><br>
        <a href="$db_script_url?db=links&html_mail_target=1">Donos de Link</a><br>
    </font>
</p>
<p><$font><b>Log das Buscas</b><br>
    <a href="$db_script_url?view_log=1">Ver Log</a><br>
</p>
<p><$font><b>Construindo</b><br></font>
    <$font>
        <a href="nph-build.cgi">Construir Tudo</a><br>
        <a href="nph-build.cgi?staggered=1">Por partes</a><br>       
        <a href="nph-build.cgi?staggered=1&auto=1">Por partes (Auto)</a><br>     
   </font>
</p>

<p><$font><b>Verificando Links</b><br></font>
    <$font>
        <a href="nph-verify.cgi">Checagem Rpida</a><br>
        <a href="nph-verify.cgi?detailed">Detalhado</a>
    </font>
</p>

</body>
</html> 
    |;
}

sub html_body {
# --------------------------------------------------------
# Prints the body of the links admin. Usually instructions.
#
    &html_print_headers();
    ($ENV{'REMOTE_USER'} or $ENV{'AUTH_USER'}) ?
        ($warning = '') :
        ($warning = '<h1><blink>ATENO: Diretrio do ADMINSTRADOR no est protegido por senha!!</blink></h1>');
        
        
    print qq~
<html>
<head>
<title>Ajuda</title>
</head>
<body bgcolor="#DDDDDD">

<p><$font><b>Bem Vindo ao Sistema de Busca</b></font></p>

$warning

<p><$font>

    Do seu painel de administrao, voc tem total controle sobre o seu banco de dados. 
    
    Aqui est uma descrio rpida do que voc pode fazer!
</font></p>

<p align="center"><$font><big><big><big><a href="$banner_admin_cgi">Banner Admin</a></big></big></big></p>

<p align=center><hr size=1 width=80% noshade><br><center><$font><a href="#menu">Menu de Opes</a> | <a href="#common">Perguntas Comuns</a></font></center></p>

<a name="menu"> </a>
<p><$font><b>Menu Links</b>
<blockquote>
<dl>
    <dt>Ver<dd>Procura por todo o banco de dados usando qualquer campo!
    <dt>Adicionar<dd>Adiciona um novo link para o banco de dados.
    <dt>Apagar<dd>Apaga um ou mais links do banco de dados. Simplesmente busque pelo link que quer remover
                         e aperte apagar.
    <dt>Modificar<dd>Modificar um ou mais links de uma vez. De novo, somente busque pelo link que voc quer atualizar
                         (selecione Modificar Mltiplos de uma vez para editar vrios links por vez) e faa as alteraes.
    <dt>Validar<dd>Qualquer link que foi cadastrado pelo pblico ir aguardar uma aprovao sua.
     				Clique em Validar para adicion-los ao banco de dados, ou rejeite eles
                           (e envia uma notificao de rejeio!)
    <dt>Checar Dupl.<dd>Tenha certeza de que voc no tem links duplos. Essa funo ir tambm mostrar-lhe
                            os links duplicados, permitindo a voc apagar ambos!
</dl>
</blockquote>
</font></p>

<p><$font><b>Menu Categoria</b>
<blockquote>
<dl>
    <dt>Ver, Adicionar, Apagar, Modificar<dd>Voc tem o mesmo controle sobre a lista de categoria assim como voc tem com os links!
    <dt>Checar Cat.<dd>Tenha certeza de que todos os links tem uma categoria definida. Voc poder colocar o link sem categoria
                       em uma categoria apropriada.
</dl>
</blockquote>
</font></p>

<p><$font><b>Menu Emails</b>
<blockquote>
<dl>
    <dt>Atualizaes<dd>Envie email de atualizaes para os usurios! Essa funo ir enviar um emaila todos que se cadastraram
                                  para essas atualizaes com uma lista de todos os seus novos links!
    <dt>Donos de Links<dd>Envia um email para algumas pessoas, ou para todas que tem um link. Todos os emails
                              so customizados para cada dono usando simples tags.
</dl>
</blockquote>
</font></p>

<p><$font><b>Menu Constuindo</b>
<blockquote>
<dl>
    <dt>Constuir Tudo<dd>O mtodo prefetido para a atualizao do seu banco de dados. Simplesmente clique aqui e todos os seus arquivos HTML
                            sero construidos.
    <dt>Por partes<dd>Se o banco de dados  muito grande e a opo acima no est funcionando? Use esta opo para construir
                            suas pginas aos poucos. Demora um pouco mais, mas utiliza menos memria do servidor.
    <dt>Por partes (Auto)<dd>O mesmo que o acima, exceto por uma tag meta refresh que ir fazer tudo sozinho.
</dl>
</blockquote>
</font>
</p>

<p><$font><b>Menu Verificando Links</b>
<blockquote>
<dl>
    <dt>Checagem Rpida</dt><dd>Somente checa o cdigo de resposta do link, alguns servidores desabilitam isso ento voc deve ter
                            menos resultados do que a quantidade de links..
    <dt>Checagem Detalhada</dt><dd>Checa cada link pegando a pgina inteira. Corrija erros 404, outros erros podem ser menos srios.
</dl>
</blockquote>
</p>

<p align=center><hr size=1 width=80% noshade><br><center><$font><a href="#menu">Menu de Opes</a> | <a href="#common">Perguntas Comuns</a></font></center></p>

<a name="common"> </a>
<p><$font><b>Perguntas Comuns</b><br>
Essas so algumas perguntas comuns sobre o script.

<blockquote>
<dl>
            <dt>Como eu crio subdiretrios?
                <dd>Crie uma categoria normalmente, por exemplo 'Computadores', para ter uma subcategoria
                 chamada 'Hardware', clique em Adicionar Categoria, e nomeie a categoria como 'Computadores/Hardware'.<br>
                 Voc pode ter quantos nveis voc quiser assim como 'Computadores/Hardware/Placas_de_Video/Diamond', mas 
                 tenha certeza de que voc tenha criado as categorias apropriadas antes. Ex, voc tem que ter a categoria
                 'Computadores', 'Computadores/Hardware' and 'Computadores/Hardware/Placas_de_Video'
                 primeiro.
                 
            <dt>Como eu uso espaos no nome da categoria?
                <dd>Use o caracter '_'. O script ir repor isso com um espao quando exibindo a categoria.
            
            <dt>Porque nenhum link  exibido no Top 10? (ou outro definido)
                <dd>Um link precisa ter pelo menos 10 votos antes de ele ser colocado no Top.
                        
</dl>
</blockquote>
</font></p>
                                                             
</body>
</html>
    
    ~;
}

sub html_footer {
# --------------------------------------------------------
# Print the menu and the footer and logo. It would be nice if you left
# the logo in. ;)
#
# We only print options that the user have permissions for.
#

    my $font       = 'Font face="Verdana, Arial, Helvetica" Size=2';
    print qq!<P align=center><$font><b>$html_object: </b> 
              <A HREF="$db_script_url?db=$in{'db'}&add_form=1">Adicionar</A>
              <A HREF="$db_script_url?db=$in{'db'}&view_search=1">Ver</A>
              <A HREF="$db_script_url?db=$in{'db'}&delete_search=1">Apagar</A> 
              <A HREF="$db_script_url?db=$in{'db'}&modify_search=1">Modificar</A> 
              <A HREF="$db_script_url?db=$in{'db'}&view_records=1&$db_key=*">Lista Todos</A>
              </font></p>
    !;
}   

sub html_search_options {
# --------------------------------------------------------
#
    print qq~
    <P>
    <STRONG>Opes de Busca:</STRONG> <br>
    <INPUT TYPE="CHECKBOX" NAME="ma"> Encontra qualquer
    <INPUT TYPE="CHECKBOX" NAME="cs"> Encontra por acaso
    <INPUT TYPE="CHECKBOX" NAME="ww"> Palavras inteiras
    <INPUT TYPE="CHECKBOX" NAME="re"> Expresso Regular<BR>
    <INPUT TYPE="TEXT" NAME="keyword" SIZE=15 MAXLENGTH=255> Palavra de Busca <FONT SIZE=-1> (ir encontrar em qualquer campo)</FONT><BR>
    <INPUT TYPE="TEXT" NAME="mh" VALUE="$db_max_hits" SIZE=3 MAXLENGTH=3> N mx de Hits retornados<BR>
    Classificar por:
    <SELECT NAME="sb">
        <OPTION>---
    ~; for (my $i =0; $i <= $#db_cols; $i++) { print qq~<OPTION VALUE="$i">$db_cols[$i]</OPTION>\n~ if ($db_form_len{$db_cols[$i]} >= 0); } print qq~
    </SELECT>
    Ordem de Classificao:
    <SELECT NAME="so">
        <OPTION VALUE="ascend">Ascendente
        <OPTION VALUE="descend">Descendente
    </SELECT>
    ~;
}

##########################################################
##                      Adding                          ##
##########################################################

sub html_add_form {
# --------------------------------------------------------

    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Adicionando novo $html_object.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="POST">
        <input type=hidden name="db" value="$in{'db'}"> 
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Adicionar novo $html_object</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Add a New $html_object
                    </b></font></center><br>
                    <$font>
                        |; &html_record_form (&get_defaults); print qq|
                    </font></p>
                    <p><center> <INPUT TYPE="SUBMIT" NAME="add_record" VALUE="Adicionar $html_object"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html> 
|;
}

sub html_add_success {
# --------------------------------------------------------
# The page that is returned upon a successful addition to
# the database. You should use &get_record and &html_record
# to verify that the record was inserted properly and to make
# updating easier.

    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: $html_object Adicionado.</title>
</head>

<body bgcolor="#DDDDDD">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: $html_object Adicionado</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        $html_object Adicionado
                    </b></font></center><br>
                    <$font>
                        <P><Font face="Verdana, Arial, Helvetica" Size=2>O seguinte registro foi adicionado com sucesso ao banco de dados:</FONT>
                        |; &html_record(&get_record($in{$db_key})); print qq|   
                    </font></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
</body>
</html>     
|;
}

sub html_add_failure {
# --------------------------------------------------------
# The page that is returned if the addition failed. An error message 
# is passed in explaining what happened in $message and the form is
# reprinted out saving the input (by passing in %in to html_record_form).

    my $message = shift;
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Erro! Impossvel Adicionar $html_object.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="POST">
        <input type=hidden name="db" value="$in{'db'}">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Erro: Impossvel Adicionar $html_object</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Erro: <font color=red>Impossvel Adicionar $html_object</font>
                    </b></font></center><br>
                    <$font>
                        Houve problemas com os seguintes campos: <FONT COLOR="red"><B>$message</B></FONT>
                        <P>Por favor, corrija qualquer erro e envie o registro de novo.</p></font>
                        |; &html_record_form (%in); print qq|
                    </font></p>
                    <p><center> <INPUT TYPE="SUBMIT" NAME="add_record" VALUE="Adicionar $html_object"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html> 
|;
}

##########################################################
##                      Viewing                         ##
##########################################################

sub html_view_search {
# --------------------------------------------------------
# This page is displayed when a user requests to search the 
# database for viewing. 
# Note: all searches must use GET method.
#
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Procura no Banco de Dados.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="GET">
        <input type=hidden name="db" value="$in{'db'}">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Procura no Banco de Dados</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Procura no Banco de Dados
                    </b></font></center><br>
                    <$font>
                        |;  &html_record_form(); print qq|
                        |; &html_search_options; print qq|
                    </font></p>
                    <p><center> <INPUT TYPE="SUBMIT" NAME="view_records" VALUE="Ver $html_object"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html> 
|;
}

sub html_view_success {
# --------------------------------------------------------
   
    
    my @hits = @_;
    my ($numhits) = ($#hits+1) / ($#db_cols+1);
    my ($maxhits); $in{'mh'} ? ($maxhits = $in{'mh'}) : ($maxhits = $db_max_hits);  
    
    &html_print_headers();  
    print qq|
<html>
<head>
    <title>$html_title: Resultado da Busca.</title>
</head>

<body bgcolor="#DDDDDD">
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td colspan=2 bgcolor="navy"><FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                   <b>$html_title: Resultados da Busca</b>
        </font></td></tr>
    </table>
    
    <blockquote>
    <p><$font>
        A sua busca retornou <b>$db_total_hits</b> intens.</font>
|;
    if ($db_next_hits) {
        print "<br><$font>Pages: $db_next_hits</font>";
    }
    
# Go through each hit and convert the array to hash and send to 
# html_record for printing.
    for (0 .. $numhits - 1) {
        print "<P>";
        &html_record (&array_to_hash($_, @hits));
    }
    if ($db_next_hits) {
        print "<br><$font>Pginas: $db_next_hits</font>";
    }
    
    print qq|
        <p>
        <table border=0 bgcolor="#DDDDDD" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td>|; &html_footer; print qq|</td></tr>
        </table>
    </blockquote>
</body>
</html>
|;
}

sub html_view_failure {
# --------------------------------------------------------
# The search for viewing failed. The reason is stored in $message
# and a new search form is printed out.

    my ($message) = $_[0];
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Busca Falhou.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="GET">
        <input type=hidden name="db" value="$in{'db'}">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Busca Falhou</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Busca Falhou
                    </b></font></center><br>
                    <$font>
                        <P>houve problemas com a busca. Motivo: <FONT COLOR="red"><B>$message</B></FONT>
                        <BR>Por favor, corrija o erro e envio o registro de novo.</p>
                        |;  &html_record_form(%in); print qq|
                        |; &html_search_options; print qq|</p>
                    </font></p>
                    <p><center> <INPUT TYPE="SUBMIT" NAME="view_records" VALUE="Ver $html_objects"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html>
|;
}

##########################################################
##                      Deleting                        ##
##########################################################

sub html_delete_search {
# --------------------------------------------------------

    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Procura no Banco de Dados para Apagar.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="GET">
        <input type=hidden name="db" value="$in{'db'}">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Procura no Banco de Dados para Apagar</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Procura no Banco de Dados para Apagar
                    </b></font></center><br>
                    <$font>
                        <P>Procura no Banco de Dados pelos registros que voc quer apagar ou
                           <A HREF="$db_script_link_url&delete_form=1&$db_key=*">lista todos</a>:</p>
                        |;  &html_record_form(); print qq|
                        |; &html_search_options; print qq|</p>
                    </font></p>
                    <p><center> <INPUT TYPE="SUBMIT" NAME="delete_form" VALUE="Search"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html> 
|;
}

sub html_delete_form {
# --------------------------------------------------------


    my ($status, @hits) = &query(); 
    my ($numhits) = ($#hits+1) / ($#db_cols+1);
    my ($maxhits); $in{'mh'} ? ($maxhits = $in{'mh'}) : ($maxhits = $db_max_hits);
    my (%tmp);
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Apagar $html_object(s).</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" METHOD="POST">
        <input type=hidden name="db" value="$in{'db'}">
        
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td colspan=2 bgcolor="navy">
                <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                   <b>$html_title: Apagar $html_object(s)</b>
        </td></tr>
    </table>
    
    <blockquote><p><$font>
        Cheque os registros que voc quer apagar e ento pressione "Apagar $html_objects":<br>
        A sua busca retornou <b>$db_total_hits</b> itens.</font>
|;
    if ($db_next_hits) {
        print "<br><$font>Pginas: $db_next_hits</font>";
    }
# Go through each hit and convert the array to hash and send to 
# html_record for printing. Also add a checkbox with name=key and value=delete.

    if ($status ne "ok") {  # There was an error searching!
        print qq|<P><FONT COLOR="RED" SIZE=4>Erro: $status</FONT></P>|;
    }
    else {
        print "<P>";
        for (0 .. $numhits - 1) {
            %tmp = &array_to_hash($_, @hits);
            print qq|<TABLE BORDER=0><TR><TD><INPUT TYPE=CHECKBOX NAME="$tmp{$db_key}" VALUE="delete"></TD><TD>|;
            &html_record (%tmp);
            print qq|</TD></TR></TABLE>\n|;         
        }
        if ($db_next_hits) {
            print "<br><$font>Pginas: $db_next_hits</font>";
        }
    }
    print qq|
        <p>
    </blockquote>
    <table border=0 bgcolor="#DDDDDD" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td>
            <p><center><INPUT TYPE="SUBMIT" name="delete_records" VALUE="Apagar $html_object(s) marcado(s)"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
            |; &html_footer; print qq|
        </td></tr>
    </table>    
</body>
</html>
|;
}

##########################################################
##                      Modifying                       ##
##########################################################
sub html_modify_search {
# --------------------------------------------------------
# The page is displayed when a user wants to modify a record. First
# the user has to search the database to pick which record to modify.
# That's handled by this form.

    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Procura no Banco de Dados para Modificao.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="GET">
        <input type=hidden name="db" value="$in{'db'}"> 
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Procura no Banco de Dados para Modificao</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Procura no Banco de Dados para Modificao
                    </b></font></center><br>
                    <$font>
                        <P>Procure no Banco de Dados pelo registro que voc quer modificar ou 
                           <A HREF="$db_script_link_url&modify_form=1&$db_key=*">Lista Todos</a>:</p>
                        |;  &html_record_form(); print qq|
                        <P><b>Modify Multiple $html_objects at Once: <input type=checkbox name="modify_mult_form" value="1"></b>
                        |; &html_search_options; print qq|</p>
                    </font></p>
                    <p><center> <INPUT TYPE="SUBMIT" NAME="modify_form" VALUE="Busca"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html>     
|;
}

sub html_modify_mult_form {
# --------------------------------------------------------
#
    my ($status, @hits) = &query("mod");
    my ($numhits) = ($#hits+1) / ($#db_cols+1);
    if (($numhits == 1) and !$in{'nh'}) { $in{'modify'} = $hits[$db_key_pos]; &html_modify_form_record(); return; }
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Modificar Mltiplos $html_objects.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" METHOD="POST">
        <input type=hidden name="db" value="$in{'db'}">
    <blockquote>
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td colspan=2 bgcolor="navy">
                <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                   <b>$html_title: Modificar Mltiplos $html_objects</b>
        </td></tr>
    </table>
    <p><$font>
        Faa qualquer alterao e cheque os resultados que voc quer salvar.<br>
        A sua busca retornou <b>$db_total_hits</b> itens.</font>  
|;
    if ($db_next_hits) {
        print "<br><$font>Pginas: $db_next_hits</font>";
    }

    if ($status ne "ok") {  # Error searching database!
        print qq|<P><FONT COLOR="RED" SIZE=4>Erro: $status</FONT>|;
    }
    else {
        print "<P>";
        for (0 .. $numhits - 1) {
            %tmp = &array_to_hash($_, @hits);
            print qq|<TABLE BORDER=0><TR><TD><INPUT TYPE=CHECKBOX NAME="$tmp{$db_key}" VALUE="modify"></TD><TD>|;
            &html_record_form_mult (%tmp);
            print qq|</TD></TR></TABLE>\n|;         
        }
        if ($db_next_hits) {
            print "<br><$font>Pginas: $db_next_hits</font>";
        }
    }
    print qq|
        <p>
        <table border=0 bgcolor="#DDDDDD" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td>
                <P><center><input type="SUBMIT" name="modify_mult_record" value="Modificar $html_objects"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                |; &html_footer; print qq|
            </td></tr>
        </table>
    </blockquote>
</body>
</html>
    |;
}

sub html_modify_form {
# --------------------------------------------------------

    my (%tmp);
    my ($status, @hits) = &query(); 
    my ($numhits) = ($#hits+1) / ($#db_cols+1);
    if (($numhits == 1) and !$in{'nh'}) { $in{'modify'} = $hits[$db_key_pos]; &html_modify_form_record(); return; }
    my ($maxhits); $in{'mh'} ? ($maxhits = $in{'mh'}) : ($maxhits = $db_max_hits);

    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Modificar $html_object.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" METHOD="POST">
        <input type=hidden name="db" value="$in{'db'}"> 
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td colspan=2 bgcolor="navy">
                <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                   <b>$html_title: Modificar $html_object</b>
        </td></tr>
    </table>
    <blockquote><p><$font>
        Cheque quais registros voc quer modificar e ento pressione "Modificar $html_objects":<br>
        A sua busca retornou <b>$db_total_hits</b> itens.</font>
|;
    if ($db_next_hits) {
        print "<br><$font>Pginas: $db_next_hits</font>";
    }

# Go through each hit and convert the array to hash and send to 
# html_record for printing. Also add a radio button with name=modify
# and value=key.
    if ($status ne "ok") {  # Error searching database!
        print qq|<P><FONT COLOR="RED" SIZE=4>Erro: $status</FONT>|;
    }
    else {
        print "<P>";
        for (0 .. $numhits - 1) {
            %tmp = &array_to_hash($_, @hits);
            print qq|<TABLE BORDER=0><TR><TD><INPUT TYPE=RADIO NAME="modify" VALUE="$tmp{$db_key}"></TD><TD>|;
            &html_record (%tmp);
            print qq|</TD></TR></TABLE>\n|;         
        }
        if ($db_next_hits) {
            print "<br><$font>Pginas: $db_next_hits</font>";
        }
    }
    print qq|
        <p>
    </blockquote>
    <table border=0 bgcolor="#DDDDDD" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td>
            <P><center><input type="SUBMIT" name="modify_form_record" value="Modificar $html_object"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
            |; &html_footer; print qq|
        </td></tr>
    </table>
</body>
</html>
|;
}

sub html_modify_mult_results {
# --------------------------------------------------------


    my ($success, $error) = @_;

    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: $html_object(s) Modificado(s).</title>
</head>

<body bgcolor="#DDDDDD">
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 align=center valign=top>
        <tr><td colspan=2 bgcolor="navy">
                <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                <b>$html_title: $html_object(s) Modificado(s).</b>
        </td></tr>
        <tr><td>
                <p><center><$font_title><b>
                    $html_object(s) Modificado(s)
                </b></font></center><br>
                <$font>
                |; print "Os seguintes registros foram modificados com sucesso: $success" if ($success); print qq|
                |; print "Os seguintes registros <b>no</b> foram modificados com suceso: $error" if ($error); print qq|
                </font></p>
                |; &html_footer; print qq|
        </td></tr>
    </table>
</body>
</html> 
|;
}

sub html_modify_form_record {
# --------------------------------------------------------

    my (%rec) = &get_record($in{'modify'});
    if (!%rec) { &html_modify_failure("unable to find record/no record specified: $in{'modify'}"); return; }

    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Modificar $html_object.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="POST">
        <input type=hidden name="db" value="$in{'db'}">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Modificar $html_object</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Modificar $html_object
                    </b></font></center><br>
                    <$font>
                        |; &html_record_form (%rec); print qq|
                    </font></p>
                    <p><center> <INPUT TYPE="SUBMIT" NAME="modify_record" VALUE="Modificar $html_object"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html> 
|;
}

sub html_modify_success {
# --------------------------------------------------------

    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: $html_object Modificado.</title>
</head>

<body bgcolor="#DDDDDD">
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td colspan=2 bgcolor="navy">
                <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                <b>$html_title: $html_object Modificado.</b>
        </td></tr>
        <tr><td>
                <p><center><$font_title><b>
                    $html_object Modificado
                </b></font></center><br>
                <$font>
                    O seguinte registro foi modificado com sucesso:
                </font></p>
                |; &html_record(&get_record($in{$db_key})); print qq|
                |; &html_footer; print qq|
        </td></tr>
    </table>
</body>
</html> 
|;
}

sub html_modify_failure {
# --------------------------------------------------------

    my ($message) = $_[0];
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Erro! Impossvel Modificar $html_object.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="POST">
        <input type=hidden name="db" value="$in{'db'}">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Erro! Impossvel Modificar $html_object.</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Erro: <font color=red>Impossvel Modificar $html_object</font>
                    </b></font></center><br>
                    <$font>
                        Houve problemas modificando o registro: <FONT COLOR="red"><B>$message</B></FONT>
                        <BR>Por favor corrija qualquer erro e envie o registro de novo.
                    </font></p>                 
                    |; &html_record_form (%in); print qq|
                    <p><center> <INPUT TYPE="SUBMIT" NAME="modify_record" VALUE="Modificar $html_object"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html>
|;
}

##########################################################
##                    Validation                        ##
##########################################################
sub html_validate_form {
# --------------------------------------------------------
# This page produces a list of records waiting to be validated, 
# from which the admin can either delete, or validate the records.

# First let's just get a list of all the records to validate/modify.
    my (@lines, @valhits, @modhits, $numhits, $counter);
    
    open (VALIDATE, "<$db_valid_name") or &cgierr("Impossvel abrir arquivo de validao: $db_valid_name. Motivo: $!");    
    LINE: while (<VALIDATE>) {
        (/^#/)    and next LINE;
        (/^\s*$/) and next LINE;
        chomp;
        push (@valhits, &split_decode($_));
    }
    close VAL;
    open (MODIFY, "<$db_modified_name") or &cgierr("Impossvel abrir arquivo de validao: $db_valid_name. Motivo: $!");    
    LINE: while (<MODIFY>) {
        (/^#/)    and next LINE;
        (/^\s*$/) and next LINE;
        chomp;
        push (@modhits, &split_decode($_));
    }   
    $numhits = (($#valhits+1) + ($#modhits+1)) / ($#db_cols+1);

# Now let's print out the page:     
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Validar Links.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" METHOD="POST">
        <input type=hidden name="db" value="$in{'db'}"> 
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy"><FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                       <b>$html_title: Validar Links</b>
            </font></td></tr>
        </table>
    |;
    if ($numhits > 0) {
        print qq|
            <blockquote>
                <p><$font>Cheque quais registros ($numhits) voc quer validar e pressione "Validar $html_objects". <br>
                  Somente 10 registros so exibidos por vez.<br>
                  Clique no link validar para abrir uma nova janela para prever o site.
            <p>
        |;
# Counter, we only want to display 10 at a time.
        my $counter = 0;
        
# Go through each validated hit and convert the array to hash and send to 
# html_record for printing. Also add a checkbox with name=key and value=delete.
        for ($i = 0; $i < ($#valhits+1) / ($#db_cols+1); $i++) {
            last if (++$counter > 10);
            %tmp = &array_to_hash ($i, @valhits);
            print qq|
        <table border=1><TR><TD colspan=2>|;
            &html_record_form_mult (%tmp);
            my $reason = &load_template ('email-del.txt', \%tmp);
            print qq|
                </TD></TR>
                <TR><TD VALIGN=TOP><INPUT TYPE="RADIO" NAME="$tmp{$db_key}" VALUE="validate"> <$font><a href="$tmp{'URL'}" target="_blank">Validar</a></font>                      
                    </TD>
                    <TD VALIGN=TOP ROWSPAN=2><INPUT TYPE="RADIO" NAME="$tmp{$db_key}" VALUE="delete"> <$font>Apagar. Motivo por Email:</font><br> <textarea name="reason-$tmp{$db_key}" rows=4 cols=40>$reason</textarea></TD>
                </TR>
                <TR><TD VALIGN=TOP><$font><a href="$db_script_url?view_records=1&$db_cols[$db_url]=$tmp{$db_cols[$db_url]}" target="_blank">Checar se  Duplicado</a></font></TD></TR>
                </TABLE>
            <hr width=550 bgcolor="black" size=4 align=left>
            |;
        }

# Go through each modified hit and convert the array to hash and send to 
# html_record for printing. Also add a checkbox with name=key and value=delete.
        for ($i = 0; $i < ($#modhits+1) / ($#db_cols+1); $i++) {
            last if (++$counter > 10);
            %tmp = &array_to_hash ($i, @modhits);
            print qq|
        <table border=1><TR><TD colspan=2>|;
            &html_record_form_mult (%tmp);
            print qq|
                </TD></TR>
                <TR><TD VALIGN=TOP><INPUT TYPE="RADIO" NAME="$tmp{$db_key}" VALUE="modify"> <$font><a href="$tmp{'URL'}" target="_blank">Modificar</a></font></TD>
                    <TD VALIGN=TOP><INPUT TYPE="RADIO" NAME="$tmp{$db_key}" VALUE="delete"> <$font>Apagar. Motivo por Email:</font><br> <textarea name="reason-$tmp{$db_key}" rows=4 cols=40>$db_email_reject</textarea></TD>
                </TR></TABLE>
            <hr width=550 bgcolor="black" size=4 align=left>
            |;
        }
        print qq|
    <p>
    </blockquote>
    <table border=0 bgcolor="#DDDDDD" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td>
            <p><center><INPUT TYPE="SUBMIT" name="validate_records" VALUE="Validar/Apagar $html_object(s) Selecionado(s)"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
            |; &html_footer; print qq|
        </td></tr>
    </table>    
        |;
    }
    else {
        print "<p><$font><b>Nenhum registro para validar!</b></font></p>";
    }
    print qq|
</body>
</html>
    |;
}

sub html_validate_success {
# --------------------------------------------------------

    my ($valsuc, $modsuc, $delsuc) = @_;
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_object(s) Validado/Apagado.</title>
</head>

<body bgcolor="#DDDDDD">
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td colspan=2 bgcolor="navy">
                <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                <b>$html_object(s) Validado/Apagado.</b>
        </td></tr>
        <tr><td>
                <p><center><$font_title><b>
                    $html_object(s) Validado/Apagado.
                </b></font></center><br>
                <$font>|;
print "O seguinte registro foi validado com sucesso: $valsuc<br>" if ($valsuc);
print "O seguinte registro foi modificado com sucesso: $modsuc<br>" if ($modsuc);
print "O seguinte registro foi apagado com sucesso: $delsuc<br>" if ($delsuc);
                &html_footer; print qq|
        </td></tr>
    </table>
</body>
</html> 
    |;

}

##########################################################
##                    Mass Mailing                      ##
##########################################################

sub html_mail_target {
# --------------------------------------------------------
#
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Email com Alvo.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="GET">
        <input type=hidden name="db" value="$in{'db'}">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Email com Alvo</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Email com Alvo
                    </b></font></center><br>                    
                    <$font>
                    Procura no Banco de Dados pelo dono do link que voc quer enviar um email ou <a href="$db_script_url?db=links&html_mail_form=1&all=1"><b>envie um email para todos os donos de link</b></a>.<br>
                        |;  &html_record_form(); print qq|
                        |; &html_search_options; print qq|
                    </font></p>
                    <p><center> <INPUT TYPE="SUBMIT" NAME="html_mail_form" VALUE="Busca"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                    |; &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html> 
    |;
}

sub html_mail_form {
# --------------------------------------------------------
#
    my $audience;
    if ($in{'all'}) {
        $audience = 'Todo o banco de dados receber um email. <input type=hidden name=all value=1>';
    }
    else {
        my (%tmp, %seen);
        my ($status, @hits) = &query(); 
        my ($numhits) = ($#hits+1) / ($#db_cols+1);
        for (0 .. $numhits - 1) {
            %tmp = &array_to_hash($_, @hits);
            ($seen{$tmp{$db_cols[$db_contact_email]}}++) ?
                ($audience .= qq!Dono do Link ($tmp{$db_key}) j recebeu o seu email.<br>!) :
                ($audience .= qq!<input type=checkbox name="$tmp{$db_key}" value="mail" checked> $tmp{$db_cols[$db_contact_name]} - $tmp{$db_cols[$db_contact_email]}<br>!);
        }
        $audience ? 
            ($audience = "<p>Os seguintes usurios recebero um email. Voc pode desmarcar usurio que voc no quer que receba um email.</p><blockquote>$audience</blockquote>") :
            ($audience = "Nenhum usurio encontrado!");
    }
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Email.</title>
</head>
    
    <body bgcolor="#DDDDDD">
        <form action="$db_mail_url" METHOD="POST">
            <input type=hidden name="db" value="links">
        <blockquote>
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                       <b>$html_title: Mail</b>
            </td></tr>
        </table>
        <p><$font>$audience</font></p>
        <p><$font>Em sua mensagem voc pode por tags &lt;%nome_do_campo%&gt; que sero trocadas pela informao
                  no banco de dados. Por exemplo, voc pode colocar:<br>
                  <em>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Parabns, o seu link tem agora &lt;%Hits%&gt;!</em>
        <p>e hits seria trocado pelo nmero de hits do link do usurio. Faa uma mensagem para voc mesmo primeiro 
                  para saber se o sistema est funcionando!
        <p><$font>Assunto: <input name="subject"></font>
        <p><$font>Mensagem:<br>
        <textarea name=message rows=40 cols=50></textarea>
        <p><center> <INPUT TYPE="SUBMIT" NAME="mass_mail" VALUE="Enviar Emails"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
        |; &html_footer; print qq| </center>       
    </form>
</body>
</html>     
    |;      
}

sub html_mail_update {
#
    my $new_links   = &build_new_links;
    my $subscribers = &build_email_list;
    my $subject     = "Novos Sites em " . &get_date;
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Atualizaes por Email.</title>
</head>
    
    <body bgcolor="#DDDDDD">
        <form action="$db_mail_url" METHOD="POST">
            <input type=hidden name="db" value="email">
        <blockquote>
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                       <b>$html_title: Atualizaes por Email</b>
            </td></tr>
        </table>
        <p><$font>Enviar para:<br>$subscribers</font></p>       
        <p><$font>Assunto: <input name="subject" value="$subject"></font>
        <p><$font>Mensagem:<br>
        <textarea name=message rows=40 cols=50>$new_links
--------------------------------------------------------------------
Para ser retirado dessa mailing list, apenas visite:
   $build_email_url?action=unsubscribe&email=&lt;%Contact Email%&gt;</textarea>
        <p><$font><b>Note:</b> &lt;%Contact Email%&gt; ser trocado pelo email do usurio.</font></p>
        <p><center> <INPUT TYPE="SUBMIT" NAME="mass_mail" VALUE="Enviar Mensagens"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
        |; &html_footer; print qq| </center>       
    </form>
</body>
</html>     
    |;      
}
##########################################################
##                    Email Messages                    ##
##########################################################

sub html_validate_email {
# --------------------------------------------------------
# All the link information is stored in %link.
    my (%link) = @_;

# Set the to, from, subject and message to send.
    my $to      = $link{'Contact Email'};
    my $from    = $db_admin_email;
    my $subject = "O seu Link foi adicionado!";
    my $msg     = &load_template ('email-add.txt', \%link);
    
# Then mail it away!
    require "$db_lib_path/Mailer.pm";
    my $mailer = new Mailer ( { smtp => $db_smtp_server, 
                                sendmail => $db_mail_path, 
                                from => $from, 
                                subject => $subject,
                                to => $to,
                                msg => $msg,
                                log => $db_mailer_log 
                            } ) or 
        &cgierr("No foi possvel iniciar o mailer. Motivo: $Mailer::error");
    $mailer->send or &cgierr ("Impossvel enviar mensagem de adiao. Motivo: $Mailer::error");   
}

sub html_modify_email {
# --------------------------------------------------------
# All the link information is stored in %link.
    my (%link) = @_;

# Set the to, from, subject and message to send.
    my $to      = $link{'Contact Email'};
    my $from    = $db_admin_email;
    my $subject = "O seu Link foi adicionado!";  
    my $msg     = &load_template ('email-mod.txt', \%link);
    
# Then mail it away!    
    require "$db_lib_path/Mailer.pm";
    my $mailer = new Mailer ( { smtp => $db_smtp_server, 
                                sendmail => $db_mail_path, 
                                from => $from, 
                                subject => $subject,
                                to => $to,
                                msg => $msg,
                                log => $db_mailer_log 
                            } ) or 
        &cgierr("No foi possvel iniciar o mailer! Motivo: $Mailer::error");
    $mailer->send or &cgierr ("Impossvel enviar mensagem de modificao. Motivo: $Mailer::error");   
}

sub html_reject_email {
# --------------------------------------------------------
# All the link information is stored in %link.
    my (%link) = @_;

# The message subject is defined in the form.
    my $to      = $link{'Contact Email'};
    my $from    = $db_admin_email;
    my $subject = "O seu Link foi rejeitado.";
    my $msg     = $in{"reason-$link{$db_key}"}; 

# Mail it away!
    require "$db_lib_path/Mailer.pm";
    my $mailer = new Mailer ( { smtp => $db_smtp_server, 
                                sendmail => $db_mail_path, 
                                from => $from, 
                                subject => $subject,
                                to => $to,
                                msg => $msg,
                                log => $db_mailer_log 
                            } ) or 
        &cgierr("No foi possvel iniciar o mailer! Motivo: $Mailer::error");
    $mailer->send or &cgierr ("Impossvel enviar mensagem de rejeio. Motivo: $Mailer::error");
}

##########################################################
##                    Misc                              ##
##########################################################

sub html_check_links {
# --------------------------------------------------------
#

    my $bad_category = shift;
    my $message      = shift;
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Checa Categorias.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" method="POST">
        <input type=hidden name="db" value="$in{'db'}">
        <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
            <tr><td colspan=2 bgcolor="navy">
                    <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>$html_title: Checa Categorias</b>
            </td></tr>
            <tr><td>
                    <p><center><$font_title><b>
                        Checa Categorias
                    </b></font></center><br>
                    <$font>|;
    if ($message) {
        print qq|<P><b>$message</b></p>|;
    }
    elsif (!$bad_category) {
        print qq|<P>No houve problemas encontrados!|;
    }
    else {
        print qq|<P align=center><font color=red><b>Ateno</b></font></p>
                 <p>Voc tem alguns links em seu banco de dados que no esto associados a uma categoria inexistente.!
                    voc pode <b>ou</b>:
                        <ol>
                            <li><b>Adicionar</b> essa categoria ao banco de dados.
                            <li><b>Apagar</b> todos os links com essa categoria no existente.
                            <li><b>Mover</b> todos os links para uma categoria existente.
                        </ol>
                 <P>Note: um mximo de 10 links so exibidos por vez.</strong></p>
                 
                 $bad_category
                 
                </font></p>
                <p><center> <INPUT TYPE="SUBMIT" NAME="fix_links" VALUE="Atualizar Categorias"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>            |;
        }
        &html_footer; print qq|
            </td></tr>
        </table>
    </form>
</body>
</html> 
    |;
}

sub html_check_duplicates {
# --------------------------------------------------------
#
    my %duplicates = @_;
    
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: Checa Links Duplicados.</title>
</head>

<body bgcolor="#DDDDDD">
    <form action="$db_script_url" METHOD="POST">
        <input type=hidden name="db" value="$in{'db'}">
        
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td colspan=2 bgcolor="navy">
                <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                   <b>$html_title: Checa Links Duplicados</b>
        </td></tr>
    </table>
    
    <blockquote><p><$font>
    |;
    if (!%duplicates) {
        print "Nenhum link duplicado encontrado.";
    }
    else {
        print qq~
                <p>Para apagar os links ofensivos, clique no checkbox e clique apagar:</p>
                <TABLE BORDER=1>
        ~;
        foreach (keys %duplicates) {
            print qq~<tr><td colspan=2><$font><b>$_</b></font></td></tr>
                     <tr><td>&nbsp; &nbsp;</td>
                         <td>
            ~;
            for ($i = 0; $i <= $#{$duplicates{$_}}; $i = $i + 3) {
                my $id    = ${$duplicates{$_}}[$i];
                my $title = ${$duplicates{$_}}[$i + 1];
                my $cat   = ${$duplicates{$_}}[$i + 2];
                print qq~<input type=checkbox name="$id" value="delete"> <$font>(<a href="$db_script_url?db=links&view_records=1&$db_key=$id&ww=1" target="_blank">$id</a>) $title em <em>$cat</em><br>~;
            }
            print qq~</td></tr>~;
        }
        print qq~
            </table>
            <p>
            </blockquote>
            <table border=0 bgcolor="#DDDDDD" cellpadding=5 cellspacing=3 width=500 valign=top>
                <tr><td>
                <p><center><INPUT TYPE="SUBMIT" name="delete_records" VALUE="Apagar $html_object(s) Selecionado(s)"> <INPUT TYPE="RESET" VALUE="Resetar"></center></p>
                ~; &html_footer; print qq~
            </td></tr>
        </table>    
        ~;
    }
    print qq|
</body>
</html>
    |;
}

sub html_generic  {
# --------------------------------------------------------

    my ($title, $message) = @_;
    &html_print_headers();
    print qq|
<html>
<head>
    <title>$html_title: $title.</title>
</head>

<body bgcolor="#DDDDDD">
    <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width=500 valign=top>
        <tr><td colspan=2 bgcolor="navy">
                <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                <b>$html_title: $title.</b>
        </td></tr>
        <tr><td>
                <p><center><$font_title><b>
                    $title
                </b></font></center><br>
                <$font>
                    $message
                </font>
                </p>
                |; &html_footer; print qq|
        </td></tr>
    </table>
</body>
</html>
    |;
}

##########################################################
##                      $html_object Layout             ##
##########################################################

sub html_record_form {
# --------------------------------------------------------
# These are now auto generated, but can be overridden by printing
# out your form/record here.
#
    my (%rec) = @_;
    print &build_html_record_form(%rec);
}

sub html_record_form_mult {
# --------------------------------------------------------
# These are now auto generated, but can be overridden by printing
# out your form/record here.
#
    my (%rec) = @_;
    print &build_html_record_form ('multiple', %rec);
}
    
sub html_record {
# --------------------------------------------------------
# These are now auto generated, but can be overridden by printing
# out your form/record here.
#
    my (%rec) = @_;     # Load any defaults to put in the VALUE field.
    print &build_html_record(%rec);
}

sub view_log {
# ---------------------------------------------------------
# Criado por Thiago Moretti <tmoretti@netabc.com.br>
#

open(DATA,"<$keyword_file") or die "No foi possvel abrir $keyword_file. Motivo: $!";
while (<DATA> ) {
chomp;
($name, $score) = split /\|/;
$scores{$name} = $score;
}
close(DATA);

$total = "0";

    &html_print_headers();

print qq|
	
<html>
<title>Keyword Log</title>
<body bgcolor="#DDDDDD">
<center><font face=Arial size=2>
   <table border=1 bgcolor="#FFFFFF" cellpadding=5 cellspacing=3 width="400">
     <tr><td colspan=2 bgcolor="navy">
       <FONT FACE="MS Sans Serif, arial,helvetica" size=1 COLOR="#FFFFFF">
                    <b>Keyword Log</b>
     </td></tr>
     <tr><td align=center width="380"><small><b><u>Palavra</b></u></small></td>
     <td align=center width="120"><small><b><u>Calls</b></u> </small></td>
|;

foreach $word (sort { $scores{$b} <=> $scores{$a} } keys %scores) 
  	  {
  	print qq|<tr><td align=center width="380"><small>$word</small></td>
	<td align=center width="120"><small>$scores{$word}</small></td>|; 
       $total = $total+$scores{$word};
  	  }

print qq|
</table>
<p>Para um total de <b>$total</b> buscas feitas at agora.</p>
</font></center>
</body>
</html>
|;
}
1;
