#!/usr/local/bin/perl

# Required Librariers
# --------------------------------------------------------
eval {
    ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");    # Pega o local do script: UNIX /
    ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");    # Pega o local do script: Windows \
    
    require 5.001;                          # Tenha certeza se temos pelo menos o perl 5.001.    
    require "/somline.hypermart.net/cgi-bin/busca/admin/links.cfg";
    require "$db_lib_path/db.pl";    
    require "$db_lib_path/db_utils.pl";
    require "$db_lib_path/admin_html.pl"; 
};

if ($@) {
    print "Content-type: text/plain\n\n";
    print "Erro incluindo bibliotecas: $@\n";
    print "Tenha certeza de que elas existem, permisses esto corretas e caminhos esto definidos corretamente.";
    exit;
}

# ========================================================
eval { &main; };                            # Se no houve erros fatais ento, rode o programa
if ($@) { &cgierr("fatal error: $@"); }     # nunca produz aquele erro 500 do servidor.
exit;
# ========================================================

sub main {
# --------------------------------------------------------
    $| = 1;                                  # Flush Output Right Away

    # Main Menu. Check to see what the user requested, then if he has permission for that
    # request, do it. Otherwise send the user off to an unauthorized request page.
    %in = &parse_form;                      # Get form input so we know which database to load.

    # Load the database definition file and set the link url.
    $in{'db'} ?
        require "$db_lib_path/$in{'db'}.def" :
        require "$db_lib_path/links.def";
        
    $db_script_link_url = "$db_script_url?db=$in{'db'}";

    # The functions beginning with &html_ can be found in admin_html.pl, while the other
    # functions can be found in db.pl
    
    if    ($in{'add_form'})             { &html_add_form; }             # Display the Add Record Form.
    elsif ($in{'add_record'})           { &add_record; }                # Add the Actual Record.
    elsif ($in{'add_record_mult'})      { &add_record_mult; }           # Add Multiple Records at once (beta).
    elsif ($in{'view_search'})          { &html_view_search; }          # Display form to search database.
    elsif ($in{'view_records'})         { &view_records; }              # Search database and print results.
    elsif ($in{'delete_search'})        { &html_delete_search; }        # Display the form to search for records to delete.
    elsif ($in{'delete_form'})          { &html_delete_form; }          # Display the form to pick records to delete.
    elsif ($in{'delete_records'})       { &delete_records; }            # Delete records.
    elsif ($in{'modify_search'})        { &html_modify_search; }        # Display the form to search for records to modify.
    elsif ($in{'modify_mult_form'})     { &html_modify_mult_form; }     # Display multiple records to modify at one time.
    elsif ($in{'modify_form'})          { &html_modify_form; }          # Display the form to pick record to modify.
    elsif ($in{'modify_form_record'})   { &html_modify_form_record; }   # Display the form to modify a record.
    elsif ($in{'modify_record'})        { &modify_record;  }            # Modify the record.
    elsif ($in{'modify_mult_record'})   { &modify_mult_record; }        # Modify multiple records at once.
    elsif ($in{'validate_form'})        { &html_validate_form; }        # Display the Validation Form.
    elsif ($in{'validate_records'})     { &validate_records; }          # Validate records.
    elsif ($in{'check_links'})          { &check_links; }               # Display/Check to make sure links have matching catgories.
    elsif ($in{'fix_links'})            { &fix_links; }                 # Fixes up any errors found in check links.
    elsif ($in{'check_duplicates'})     { &check_duplicates; }          # Display/Check for duplicate links.
    elsif ($in{'html_mail_target'})     { &html_mail_target; }          # Form to do targeted mass mailing.
    elsif ($in{'html_mail_form'})       { &html_mail_form; }            # Form to do mass mailing.
    elsif ($in{'html_mail_update'})     { &html_mail_update; }          # Form to do email updates.
    elsif ($in{'html_edit_template'})   { &html_edit_template; }        # Edit Templates
    elsif ($in{'save_template'})        { &save_template; }             # Save templates.
    elsif ($in{'html_template_help'})   { &html_template_help; }        # Template Help.
    elsif ($in{'display'} eq 'navigation') { &html_navigation; }        # Display HTML Header
    elsif ($in{'display'} eq 'body')    { &html_body; }                 # Display HTML Body
    elsif ($in{'view_log'})             { &view_log; }                  # View Search Log
    else                                { &html_home; }                 # Display Frame Index page.

}
