#!/usr/local/bin/perl

# Required Librariers
# --------------------------------------------------------
eval {
    ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");    # Pega o local do script: UNIX /
    ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");    # Pega o local do script: Windows \

    require "/somline.hypermart.net/cgi-bin/busca/admin/links.cfg";
    require "$db_lib_path/db_utils.pl";
    require "$db_lib_path/links.def";   
    require "$db_lib_path/site_html.pl";
};
if ($@) {
    print "Content-type: text/plain\n\n";
    print "Erro incluindo bibliotecas: $@\n";
    print "Tenha certeza de que elas existem, permisses esto corretas e caminhos esto definidos corretamente.";
    exit;
}

# ========================================================

eval { &main; }; 
if ($@) { &cgierr("fatal error: $@"); } 
exit;

sub main {
# --------------------------------------------------------
    local (%in) = &parse_form;

# We are processing the form. 
    if (keys %in != 0) {
        &process_form;
    }
# Otherwise we are displaying the form (in site_html.pl).
    else {
        if ($db_single_category) {
            my %is_valid = map { $_ => 1 } &category_list;
            $ENV{'HTTP_REFERER'} =~ s,/[^/]+\.[^/]+$,,; 
            $ENV{'HTTP_REFERER'} =~ m,$build_root_url/(.+?)/?$,;
            $is_valid{$1} ? &site_html_add_form ($1) : &site_html_add_form ();
        }
        else {
            &site_html_add_form ();
        }
    }
}

sub process_form {
# --------------------------------------------------------          
    my ($key, $status, $line, $output);

# Check the referer.
    if (@db_referers and $ENV{'HTTP_REFERER'}) {
        $found = 0;
        foreach (@db_referers) {
            $ENV{'HTTP_REFERER'} =~ /$_/i and $found++ and last;
        }
        if (!$found) {
            &site_html_add_failure ("Auto Envio no est permitido nesse diretrio. Por favor v at o site e adicione a sua entrada.");
            return;
        }
    }

    foreach $key (keys %add_system_fields) {
        $in{$key} = $add_system_fields{$key};
    }

    $in{$db_cols[$db_modified]} = &get_date;
    
    open (ID, "<$db_links_id_file_name") or &cgierr("error in process_form. unable to open id file: $db_links_id_file_name. Reason: $!");
        $in{$db_key} = <ID> + 1; 
    close ID;

    $status = &validate_record(%in);
    if ($status eq "ok") {

# Update the counter.
        open (ID, ">$db_links_id_file_name") or &cgierr("error in get_defaults. unable to open id file: $db_links_id_file_name. Reason: $!");
            flock(ID, 2) unless (!$db_use_flock);
            print ID $in{$db_key};     # update counter.
        close ID;       # automatically removes file lock

# Print out the validate input to a "validation database" where it is stored until
# the admin decides to add it into the real database.
        open (VAL, ">>$db_valid_name") or &cgierr("error in add_record. unable to open validate file: $db_valid_name. Reason: $!");
            flock(VAL, 2) unless (!$db_use_flock);       
            print VAL &join_encode(%in);    
        close VAL;      # automatically removes file lock

# Send the admin an email message notifying of new addition.
        &send_email;
# Send the visitor to the success page.     
        &site_html_add_success;
    }
    else {
        &site_html_add_failure($status);
    }       
}

sub send_email {
# --------------------------------------------------------
# Envia um email para o administrador, notificando ele que h um
# novo link esperando ser validado. Nenhuma checagem de erro j que
# no queremos que o usurio veja a sada de informao do &cgierr. 

# Checa se h um email de administrador definido.
    $db_admin_email or &cgierr("Endereo de Email do Administrador no foi definido no arquivo de config!");

    my $to      = $db_admin_email;
    my $from    = $in{$db_cols[$db_contact_email]};
    my $subject = "Adio ao Banco de Dados: $in{'Title'}\n";
    my $msg     = qq|
O seguinte link est esperando ser validado:

              Ttulo:  $in{'Title'}
                 URL:  $in{'URL'}
           Categoria:  $in{'Category'}           
           Descrio:  $in{'Description'}
   Nome para Contato:  $in{'Contact Name'}
  Email para Contato:  $in{'Contact Email'}
   
         Remote Host:  $ENV{'REMOTE_HOST'}
             Referer:  $ENV{'HTTP_REFERER'}
       
Para validar, por favor v em:
    $db_script_url
    
Sinceramente,

Links Manager.
    |;

# Then mail it away!    
    require "$db_lib_path/Mailer.pm";
    my $mailer = new Mailer ( { smtp => $db_smtp_server, 
                                sendmail => $db_mail_path, 
                                from => $from, 
                                subject => $subject,
                                to => $to,
                                msg => $msg,
                                log => $db_mailer_log
                            } ) or return;
    $mailer->send or return;
}