###########
# web library
#
# you can get a script to demonstrate how this library works at:
# http://www.conservatives.net/atheist/scripts/index.html?Download&new
#
# this library is for my scripts. I wrote it to contain some of my more
# frequently used subroutines so I don't have to take up so much space
# inside the scripts themselves to use them. If you want to call this library
# from your script, you must use the following syntax somewhere before you
# begin calling subroutines from this library:
#
# require 'web-lib.pl';
#
# this, as all my scripts, is copyrighted by me in 2000. You can modify it
# all you want, but you must note your modifications and leave this header
# intact. You MAY NOT sell this or any of my scripts.
# no warranties are implied or expressed. If you got this from somewhere other
# than my site, you can get great scripts by me by pointing your browser here:
# http://www.conservatives.net/atheist/scripts/
# or by e-mailing me at scripts@conservatives.net.
#
# this library functions as is. You really don't have to change anything in it.
# set its permissions and leave it alone. Then you can use it with all my scripts.
#
##########
#this is a list of words you consider cuss words for use
#in my cuss-checker subroutines. You can add to or subtract from
#the list according to your needs. You must follow Perl list protocol,
#which means each item should be surrounded by quotations, and the end
#quotation of each item should be followed by a comma -- NOT INSIDE
#THE QUOTATION MARKS! 

@badwords = ("shit","fuck","cunt","cock","cum","jism",
			"prick","pussy","asshole","ass hole",
			"suck","fag","my dick","nigger","kike",
			"dickhead","dick head","clit","spunk",
			"dago","wop","god dam","goddam",
			"snatch","twat","queer",
			"bitch","tits","titty");

###################### HEADER ######################
#
#designed to print html headers for you. To call the subroutine,
#you can use several protocols, described in my "new.cgi" script,
#which you can view at http://www.conservatives.net/atheist/scripts/new.cgi.txt
#
# You can set up a hash in your script with hed values:
# %Hed = (T         => "Page Title",
#		  Bg        => "Background color",
#		  Bk        => "Background image",
#		  FontFace  => "Font Face",
#		  FontColor => "Font Color",
#		  FontSize  => "Font Size");
#
# or you can simply set the values you want in the following manner:
#	$Hed{Bg} = "white";
#   will print a white background
#	$Hed{FontFace} = "Verdana,Arial,Helvetica";
#	will print those font faces in the header
#   you get the idea.

sub Header
{
	$HedTitle = join(//,@_) if @_;
	if ($HedTitle eq 'plain')
	{
		#tells script to print html
		print "Content-type: text/html\n\n ";
	}
	#if the %Hed hash exists, perform the following actions
	elsif (%Hed)
	{
		print "Content-type: text/html\n\n ";
		print "<html><head><title>$Hed{T}</title></head>\n";
		if ($Hed{Bk}){print "<body background=\"$Hed{Bk}\">\n";}
		elsif ($Hed{Bg}){print "<body bgcolor=\"$Hed{Bg}\">\n";}
		else{print "<body bgcolor=white>\n";}
		if ($Hed{FontFace}){print "<font face=\"$Hed{FontFace}\">\n";}
		if ($Hed{FontSize}){print "<font size=\"$Hed{FontSize}\">\n";}
		if ($Hed{FontColor}){print "<font color=\"$Hed{FontColor}\">\n";}
		if ($Hed{Other}){print "$Hed{Other}\n";}
	}
	else
	{
		#tells script to print html
		print "Content-type: text/html\n\n ";
	}
}


################# PARSE ##################################
#this parse routine reads input from POST and GET methods.
#it also can receive input from html pages that call the script
#as a virtual include. For instance, say you called a search script
#as a virtual include on a page called "search.html" If your form input
#name for the search string was "SearchString", then you would call the page
#like this: search.html?SearchString=Words+you+want+to+look+up
#Those words appear in a seldom-used environmental variable called
#"QUERY_STRING_UNESCAPED". This parse routine looks for that variable if it can't
#find any of the more traditional ones.
#I don't however, recommend that you use it, because it's fraught with
#unpredictable escape characters. You've been warned.
#
#Also, this parse reads information that was called via GET without any
#name/value pairs. For instance, say you called the above example search
#program from the location bar, but didn't want to type in "SearchString" all the time.
#This parse would read the following and understand it:
#search.html?Words+you+want+to+look+up
#or for that matter:
#search.cgi?Words+you+want+to+look+up
#
#I tried to make it as flexible as possible to make it the only parse routine
#I'll ever need.
#
#this outputs a hash called %in. To call values in the hash, you would use
#the following: $in{'SearchString'} would call the Search String we fantasized about above.
#
#if you called the script without the name/value pairs, the first item on your
#input string would become $in{'0'}, the second would be $in{'1'} and so on - it's imperative
#in those cases that you know the order in which the items will appear in the GET request.
#
#If you're not certain which way your script will be called (i.e., you use both methods
#depending on the implementation), you can use the variable $NVPairsExist to tell the 
#script how to behave. If $NVPairsExist has a value of 1, then the script has the 
#name/value pairs separated by = signs. If the $NVPairsExist has a value of 0, the script
#was called without name/value pairs.

sub Parse
{
	if ($ENV{'CONTENT_LENGTH'})
	{
		read(STDIN, $input, $ENV{'CONTENT_LENGTH'});
	}
	$input = $ENV{'QUERY_STRING'} if $ENV{'QUERY_STRING'};
	if (($ENV{'QUERY_STRING_UNESCAPED'}) && ($input eq ''))
	{
		$input = $ENV{'QUERY_STRING_UNESCAPED'};
		$input =~ s/\\&/\&/g;
		$Unesc = 1;
	}
	if ($input =~ /=/g)
	{
	    @pairs = split(/&/, $input);
		foreach $pair (@pairs) 
		{
			($name, $value) = split(/=/, $pair);
			$value =~ tr/+/ /;
			$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
			$in{$name} = $value;
			$NVPairsExist = 1;
		}
	}
	else
	{
		$count = 0;
		(@InputString) = split(/&/, $input);
		foreach $InputString (@InputString)
		{
			$InputString =~ tr/+/ /;
			$InputString =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
			$in{$count} = $InputString;
			$count++;
		}
		$NVPairsExist = 0;
	}
}


################## CHECK FOR CUSSING ############
#
#checks for cuss words in whatever scalars you want to
#send it. It's not perfect, but it works pretty well.
#
#for instance, say you want to check two values:
#	$in{name} and $in{comments}
#for cusswords. You would call the subroutine like this:
#
#	&CheckForCussing($in{name},$in{comments});
#
#the subroutine would then check the contents of those two scalars for cusswords.
#if it found cusswords, it would do two things:
#
#	* the scalar $BadFound would have a value of 1
#	* the list @BadWordFound would contain a list of cusswords it found
#
#you could then do all kinds of stuff, like simply returning a page
#saying "no cussing" if the $BadFound had a value of 1, or you could
#dig into the @BadWordFound list and show the user exactly what offensive
#words he or she had used.

sub CheckForCussing
{
	foreach $CheckString (@_)
	{
		foreach $badword (@badwords) 
		{
    		if ($CheckString =~ /$badword/gi)
    		{
    			push (@BadWordFound, $badword);
    		}
    	}
		
		#adds characters between letters of the words to check
		#and see if clever users entered words like "s h i t" or
		# "s!h!i!t" to get around the cussword checking.
		
		&BadListCheck(' ');
		&BadListCheck('\s+');
		&BadListCheck('-');
		&BadListCheck(',');
		&BadListCheck('.');
		&BadListCheck('\!');
	}
	if (@BadWordFound)
	{
		$BadFound = 1;
	}
	else
	{
		$BadFound = 0;
	}
}

#bad list check is a part of my cussing subroutine.
sub BadListCheck
{
	$InsertString = join(//, @_);
	foreach (@badwords) 
	{
		@NewBad = split(//, $_);
		$TheNewBad = join("$InsertString", @NewBad);
	    if ($CheckString =~ /$TheNewBad/gi)
    	{
    		push (@BadWordFound, $_);
    	}
	}
}


######################## ERROR ####################
#
#Error is an all-around error reporting subroutine. I use it instead of the
#die operator, because it gives me the error message right on screen, where
#I want it, instead of in the error log, where I have to hunt for it on my
#slow internet connection.
#
#calling the subroutine can be as simple as using Perl's own error message:
#	&Error("!$");
#	as in open(FILE, "$FileName") || &Error("$!");
#	that would try to open the file in the $FileName scalar. If it couldn't open
#	the file, it would call the error subroutine and feed Perl's error
#	message into the subroutine. Believe me, it is EXTREMELY helpful in diagnosing
#	trouble.
#
#you could also get more complex in calling the error subroutine:
#	open(FILE, "$FileName") || &Error("Can\'t open $FileName. Perl's reason: $!");
#	that would return the message you typed in (to help yourself diagnose problems), and
#	it would also return Perl's error message.

sub Error
{	
	$Hed{Bg} = "red";
	$Hed{T} = "Can\'t complete requested action.";
	$Hed{FontFace} = "Verdana,Arial,Helvetica,Geneva";
	$Hed{FontColor} = "white";
	&Header;
	$ErrorCode = join(//,@_);
	print "<h1>An error has occurred</h1>\n";
	print "The error: <b>$ErrorCode</b>\n";
	exit;
}

########################## STRIP HTML ################
#
#strips html from scalars. Call it like this: &StripHtml($Scalar_name,$Another_name);

sub StripHtml
{
	foreach (@_)
	{
		$_ =~ s/</&lt\;/g;
		$_ =~ s/>/&gt\;/g;
	}
}

1; #never remove this line or modify it.
