#!/usr/bin/perl

#####################
#
# BLOG 3.5
# ©2003, 2004 Leif M. Wright Communications. All rights reserved
# Blog is offered as a free educational script without any warranties
# expressed or implied. It is for educational purposes only. You alone are 
# responsible for any and all consequences of using this script. If you
# cannot agree to those terms, you are forbidden from using this script.
#
# Get the latest version at http://leifwright.com/scripts/
#
# Version 3.5 adds self-configuration. The script now requires the user only to
# configure one thing inside this script itself. The script does the rest. The blog
# itself also creates the data files it needs instead of requiring the user to 
# create them him/herself.
#
# Version 3.2 adds comments tracking. Hits to comment were tracked before,
# but now they're explicitly tracked as comments. 
#
# Version 3.1 moves administration functions to a cookie-based solution. What
# ended up happening under the other version is owners who clicked links from
# viewing the log risked sending the log's URL to access logs from other sites. That
# url contained the masked password string. Cookie-based administration also
# corrects problems involved with continuing in administration mode. The vestiges
# of the old system are still commented out throughout the script, but they're
# useless at this point.
# 3.1 also changes some display strings in the log that would cause long lines to
# push the display over the edge of the screen.
#
# Version 3.0 rewrites the script to use ONE TEMPLATE FILE instead of a header
# and a footer file with confusing construction. It also consolidates some of the
# logging functions and allows those viewing the log to view a page at a time instead
# of being stuck to the first page of results only. This is a major overhaul of the
# script.
#
# Version 2.5.1 changes logging exclusion to a cookie-based system.
#
# Version 2.5 adds logging to the script, which is why the one-day version jump
#
# HISTORY: I had a friend who wanted a blog, so I wrote the script for her. She
# doesn't really blog anymore, but she got me into blogging, so I gradually improved
# the script as I saw need. I offer the script here for you
# to use and learn from, as long as you understand it's just educational.
#
# INSTRUCTIONS: Modify the variables below according to their instructions
# Upload this script and its requisite files. Chmod this script and the web-lib.pl
# file to 0755. Chmod all directories (including
# the directory that contains this script) to 0777. Then just call this script
# with a web browser, and it will do the rest.
#
# To add an entry or administer the script, type in the url to the script, then
# follow "blog.cgi" with a question mark and the phrase "submit=admin". Your URL
# should look something like this:
#		http://leifwright.com/scripts/whatever/blog.cgi?submit=admin
# When you hit the enter key, the script will ask you for the password you set
# below. Enter that password and a link will appear to add an entry. In administration
# mode, you can also edit entries, delete them, edit or delete comments and add, edit
# or delete links from the links page. To exit administration mode, simply call the script
# by typing in its url.
#
# To upload images or movies, type [picture] or [movie] (brackets included) inside the
# text entry field when creating an entry. When you hit the submit button, the script
# will ask you to find a movie or image file on your hard drive. You cannot upload movies and
# images at the same time. This is because movies were an afterthought, and I'm not motivated
# to fix it. Pictures must be .jpgs Movies must be .mpg
#
# TEMPLATE INSTRUCTIONS:
# This script is designed to work with an html template file. The template file is now REQUIRED.
# To make a template, simply make an html file with the following tags (ALL BUT "BLOG CONTENT"
# are optional). Tags are CaSe sEnSiTive. NOTE, they also are space sensitive. Copy and paste
# if necessary to get it right:
#	<!--BLOG LINKS-->		(prints links for link page and main page, also administration login)
#	<!--BLOG RANKED-->		(prints list of top-ranked files on your blog)
#	<!--BLOG ARCHIVE-->		(prints links to archived months of your blog)
#	<!--BLOG EMAIL-->		(prints area for users to add themselves to e-mail update list)
#	%%title%%				(goes between <title> and </title> tags. Prints title of the page)
#	<!--BLOG SEARCH-->		(prints form for blog search)
#	<!--BLOG CONTENT-->		(prints the actual blog content)
# That's it. Once you have a template file with those tags, the rest of the html is up to you.
# the blog will print the appropriate content wherever you put the tags in your template.
#
#
# The blog supports bbcode-like coding. In reality, it supports using brackets ([]) instead of
# html tags (<>) But it still comes in handy if you're used to doing BBCode. 
#
# Last: this script is free. That means no support. If you e-mail, I may answer. I may not.
######################


####### INCLUDES
use CGI qw( :standard );
require 'web-lib.pl';
use POSIX;

####### USER CONFIGURATION
# this is the name of the script. Only change it if you change the name of the script.
$scriptName		=	"blog.cgi";

#this is the location of the config file. In the best-case scenario, you'd put this somewhere
#not accessible by web browsers. If you leave it like this, the script will put the config
#file in the same directory as the script. There's nothing wrong with that, but it's not the
#most secure thing in the world.
$configuration 	=	"blogconfig.txt";





####### PREPARE FOR EXECUTION
&SetCookieEncodeChars;
&SetConstantVariables;
#Find out what time it is right now.
&GetTimeNow;
#shorten input parameter
$Submit = param("submit");
#check to see if this is an administration session
if ($Submit ne "Configure the blog") {
	&GetConfigurationInfo;
}
&CheckAdmin;

#find out what the user wants to do
&ParseIncomingCommands;



#################################################
#DISPLAY ROUTINES
#################################################

####### CHECK MONTH
sub CheckMonth {	
	my ($string);
	$string = "";
	#This subroutine gets all the files for whatever month is passed to it by the
	#calling subroutine. For instance, if I want to view March 2003 files, this sub
	#actually finds all the available files in March of 2003. Nifty, huh?
	#TECHNICALLY, this subroutine does WAY too much. Object-oriented design would demand 
	#instead that I have this simply check the passed month and return an array 
	#with that month's files in it.
	#Any further parsing after that should be done with other subroutines so I don't
	#have to duplicate any coding at all. It's a lesson learned, I guess, which is
	#why I'm putting this note here to remind myself next time.
		
	#incoming variables are stored in the special array @_. I access specific members
	#of that array with $_[n]. Thus, the 0th item is the first, and item 1 is the second.
	my($thyDir) = $_[0];
	my($myMonth) = $_[1];
	my($searchYear)	=	$_[2];
	#Lesson learned: If you don't blank out the array, bad things happen.
	@CurrentFiles=();
	
	#open the directory and get its contents.
	#If the directory doesn't exist, that's not really a problem, so I don't want
	#to go to error on that. If the program choked on every empty directory,
	#it would never run. This is so I remember why there's no "or" statement here.
	opendir(THIS,"$thyDir");
	@CurrentFiles=readdir(THIS);
	closedir(THIS);


	#only print anything if there actually is a file.
	#the directory markers from Unix take up the first two
	#places in the array. Therefore, if array item 3 exists,
	#this directory has a file. Not perfect logic, but hey, we gotta
	#work with what we've got.
	if ($CurrentFiles[2] ne "") {

		
		#relocalize the variable
		$thisMo = $myMonth;
		
		#Print the month name, and open the listing table
		$string .=  "<h2>$thisMo $oldYear</h2>\n";
		$string .=  "<table border=0 cellpadding=2 cellspacing=0>\n";
		#blank out the count scalar so bad things don't happen.
		$count=0;
		
		#Since Unix is a bit freaky about how it stores files and the hashing routine in 
		#Perl is a pain, I have to sort the filenames, but this is not absolutely perfect.
		#I'm too lazy to fix it. It's "good enough." Specifically, files are not 
		#always in perfect chronological order. The dates, however, stay in order. The only
		#time the files don't stay in order is when there's more than one entry per day. In 
		#such cases, it's possible that a file made in the morning may appear before a file made
		#in the evening. I could fix the problem, but it seemed like a lot of programming
		#to solve a tiny cosmetic problem. You're welcome to tackle it yourself.
		if ($reverseFiles == 1) {
			@SortedFiles = sort {$b <=> $a} @CurrentFiles;
		} else {
			@SortedFiles = sort {$a <=> $b} @CurrentFiles;
		}
		
		#This is where it gets a BIT complicated. There are more than just text files
		#in the directory, so I have to make sure I'm only displaying the right stuff.
		#Specifically, there could be JPEG or MPG files in the directory. I don't


		#want to read those.		
		foreach (@SortedFiles) {
			#the file must end in "txt" and not begin with "comment"
			if (($_ =~ /.txt\b/) && ($_ !~ /^comment/)) {
				$thisMonthHasFiles++;
				#Start building the link that I'll display.
				$linker = "submit=ViewEntry\&month=$thisMo";
				$linker .= "\&year=$searchYear\&file=$_";
				#The current file is the directory plus this filename
				$currentFile = $thyDir . $_;
				
				#open the file and read it. The first line is the title, by the way.
				open (FILEY,"$currentFile") || &MyError("Can't open $currentFile, which is CurrentFile\[$count\]. $!");
				@FCont=<FILEY>;
				close(FILEY);
				
				#Display the link
				$string .=  "<tr><Td valign=top";
				
				#if the variable is 1, colorize this table cell. This routine will then
				#reset the variable to 0 so the next table cell isn't colorized.
				if ($ony == 1) {
					$string .=  " bgcolor=$alternatingColor";
				}
				$string .=  "><font size=$tableFontSize>";

				($theDay,$theTime) = split(/-/,$_);
				($theHour,$theMin,$theSec) = split(/\./,$theTime);
				

				#This logic doesn't always work, especially around midnight. This is another of
				#those "cosmetic and you can fix it if you want" problems.
				if ($theHour > 12) {
					$Mer = "p.m.";
				} else {
					$Mer = "a.m.";

				}
				$theThingy = $FCont[0];
				$firstGraf = $FCont[1];
				chomp($theThingy);
				
				#print the link as a headline in the list of entries
				$string .=  "<font size=$headlineFontSize><b>$thisMo $theDay</b></font> \@ $CivilianTime[$theHour]\:$theMin\:$theSec $Mer<Br>";
				
				#swap brackets for html tags in the first paragraph.
				$firstGraf =~ s/\[/\</g;
				$firstGraf =~ s/\]/\>/g;
				#$maskedLink=&MaskString($linker);
				#if ($adminOn) {
				#	$linker .=  "\&admin=" .  $adminMasked;
				#}
				$string .=  "</font><font size=$headlineFontSize><b><a href=$newform\?" . $linker;
				$string .=  ">$theThingy</a></b></font><br><font size=$tableFontSize>$firstGraf ... ";
				$string .=  " <a href=$newform\?" . $linker;
				$string .=  ">[MORE]</a></td><td valign=top";
				
				#if the variable is 1, colorize this table cell.

				if ($ony == 1) {
					$string .=  " bgcolor=$alternatingColor";
				}
				$string .=  ">";
				
				#Here I check to see what comments exist (if any) on this file.
				$commentFile = $PageBase . $searchYear . "/" . $thisMo . "/comment_" . $_;
				
				#no error checking here, because it's entirely possible I won't be able
				#to open a file because it doesn't exist, which is a legitimate possible
				#outcome.
				open (COMS,"$commentFile");
				@Comments=<COMS>;
				close(COMS);
				

				#reset commentCount variable
				$commentCount=0;
				
				#if the array contains items, there are comments. Parse them
				#to determine whether any of the comments are approved.
				foreach (@Comments) {

					
					#reset approved variable. Default is 0, which means NO.
					#each iteration will check this variable to see if the comment
					#being parsed has been approved for display. Since the split
					#comment sets the approved scalar to some value, I must reset
					#it on each iteration to make sure the result I get is pure.
					$approved = 0;
					
					#split up this line at the pipe character
					($approved,$namer,$commr,$cUrl,$cEmail) = split(/\|/,$_);
					
					#if the first field is a 1, this comment has been approved.
					if ($approved == 1) {
						
						#Since I want to report who made the LAST comment, set
						#this variable every time a valid comment is found. When
						#the last approved comment is found, this variable will
						#stay filled with the name that is recorded with it.
						$lastName = $namer;
						
						#increment the comment count.
						$commentCount++;
					}
				}
				
				#if commentCount is greater than 0, there's at least one approved
				#comment for this entry.
				if ($commentCount > 0) {
					
					#print the number of comments
					$string .=  "<font size=$tableFontSize><b>$commentCount</b> ";
					
					#if there's only one comment, use correct grammar. Pet peeve: I hate
					#it when programs say stuff like, "There are 1 comments." That's just 
					#laziness (not the good kind) on the part of the programmer. If there
					#is one comment, say, "There is 1 comment."
					if ($commentCount == 1) {
						$string .=  "comment.";
					} else {
						$string .=  "comments.";
					}
					
					#print the name of the person who made the last comment.
					$string .=  "<br>Last comment by <i>$lastName</i></font>";
				}
				$string .=  "</td></tr>\n";
				
				#reset the variable that tells me whether to colorize this table row. 
				#On the next iteration, this variable will tell the script whether to 
				#colorize this table row. In future incarnations of the script, I'll make
				#alternating row colorization an option. For now, the only option is to 
				#make the colorized row the same color as the regular background, which
				#will give the blog a monochrome effect. But why? Why? I don't know,
				if ($ony == 0) {
					$ony = 1;
				} else {
					$ony = 0;
				}
			} #end if
			$count++;
		}# end foreach 
		$string .=  "</table>\n";
	}#end if
	return $string;
}

####### LIST LATEST FILES
sub ListLatestFiles {
	my ($string);
	#List the files from the last two months.		
	$theDir = $PageBase . $Year . "/" . $thisMonth . "/";
	
	#this logic takes care of January
	if ($lastYear) {
		$oldDir = $PageBase . $lastYear . "/" . $lastMonth . "/";
		$grYear = $lastYear;
	} else {
		$oldDir = $PageBase . $Year . "/" . $lastMonth . "/";
		$grYear = $Year;
	}
	
	#start with this variable being false.
	$thisMonthHasFiles=0;	
	&Header;
	$title = "index";
	&GetHeaderTemplate;

	foreach $string (@theTemplate) {
		if ($string =~ /\<!--BLOG CONTENT--\>/) {
			$string = "";
			if ($adminOn) {
				$string .=  "<center><a href=$newform?submit=ViewLog>View Log File</a></center><p>\n";
				$string .=  "<center><a href=$newform?submit=ViewCommentsLog>View Comments Log File</a></center><p>\n";
				$string .= "<center><a href=$newform?submit=Configure>Configure this blog</a></center><p>\n";
			}
			$string .=  "<h3>Current month's writings:</h3>\n";
			$reverseFiles = 1;
			$string .= &CheckMonth($theDir,$thisMonth,$grYear);	
			if ($thisMonthHasFiles<=15) {
				$string .=  "<h3>Previous month's writings:</h3>\n";
				$string .= &CheckMonth($oldDir,$lastMonth,$grYear);
			}

		}
	}
	&GetFooterTemplate;
	exit;
}#end sub

####### SHOW MONTH
sub ShowMonth {
	my($string) = "";
	#List the files from the last two months.	
	$gYear=param("year");
	$gMonth=param("Month");	
	$theDir = $PageBase . $gYear . "/" . $gMonth . "/";
	&Header;
	$title = "Archive for $gMonth $gYear";
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /\<!--BLOG CONTENT--\>/) {
			$string = "<h3>Archive for $gMonth $gYear:</h3>\n";
			$reverseFiles = 0;
			$string .= &CheckMonth($theDir,$gMonth,$gYear);
		}
	}
	&GetFooterTemplate;
	exit;
}#end sub

####### LIST ALL FILES
sub ListAllFiles {
	my($string) = "";
	#List the files from the last two months.
	&Header;
	$title = "archive";
	&GetHeaderTemplate;
	$reverseFiles = 0;
	foreach $string (@theTemplate) {
		if ($string =~ /\<!--BLOG CONTENT--\>/) {
			$string .= "<h1>Archive of all writings on site</h1>\n";
			foreach $oldYear (@YearsList) {
				foreach $oldMonth (@MonthList) {
					$theDir = $PageBase . $oldYear . "/" . $oldMonth . "/";
					$string .= &CheckMonth($theDir,$oldMonth,$oldYear);
				}
			}
		}
	}
	&GetFooterTemplate;
	exit;
}#end sub

####### VIEW FILE
sub ViewEntry {
	my($string)="";
	$dYear	=	param("year");
	$dMonth	=	param("month");
	$dFile	=	param("file");

	
	#trim unwanted characters from passed parameters. This was a security hole that ended up
	#getting the script listed in ALL KINDS of security web sites. The hole existed for a total of 
	#something like TWO SECONDS, but now it's everywhere. Sigh.
	$dFile =~ s/\///gi;
	$dFile =~ s/\|//gi;
	$dYear =~ s/\///gi;
	$dYear =~ s/\|//gi;
	$dMonth =~ s/\///gi;
	$dMonth =~ s/\|//gi;	
	$Convert{":"} = "%3A";
	$Convert{"/"} = "%2F";
	$Convert{"?"} = "%3F";
	$Convert{"="} = "%3D";
	$Convert{"&"} = "%26";
	
	if ((! $dYear) || (! $dMonth) || (! $dFile)) {
		&MyError("I can't open a file because a crucial parameter is missing, so I can't tell what file you're trying to open.");
	}
	$filename = $PageBase . $dYear . "/" . $dMonth . "/" . $dFile;
	$commentFile = $PageBase . $dYear . "/" . $dMonth . "/comment_" . $dFile;
	open(DIARY,"$filename") || &MyError("Can't open $filename. Reason: $!");
	@Diary=<DIARY>;
	close(DIARY);
	
	#don't error check here, because there may not be any comments.
	open (COMS,"$commentFile");
	@Comments=<COMS>;
	close(COMS);
	$title = $Diary[0];
	$count=0;
	foreach (@Diary) {
		if ($count > 0) {
			#make sure each newline has an html newline character and an indent
			$line = "&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;" . $_ . "<br>\n";
			
			#change brackets to html tags
			$line =~ s/\[/\</gi;
			$line =~ s/\]/\>/gi;
			
			#Here we turn links into links that refer to this script so I can log where
			#visitors are going when they leave the blog.
			# so first, I check to see if this line has a link:
			if ($line =~ /\<a href=.*\>/) {
				#if it has a link and the link isn't to my own domain, I want to record it,
				#because the visitor is about to go offsite.
				if ($line !~ /$mydomain/i) {
					#to standardize the links, I have to assume a lot about you and how you'll
					#enter links, so I try to trap all possibilities here. This may expand with experience.

					$line =~ s/\"http/http/gi;
					$line =~ s/\" / /gi;
					$line =~ s/\"\>/\>/gi;
					$line =~ s/target=\"_blank\"//gi;
					$line =~ s/target=_blank//gi;
					$line =~ s/target=_new//gi;
					$line =~ s/target=_\"new\"//gi;
					
					# the ? operator after .* below means I want to do stingy searching. i want to stop after the first > character.
					$match = "";
					$MaskedLink = "";
					@matchList = ($line =~ /<a href=(.*?)\>.*?\<\/a\>/gi);
					foreach $match (@matchList) {
						$MaskedLink = &MaskString($match);
						$line =~ s/$match/$newform?submit=Offsite&u=$MaskedLink onMouseOver=\"window.status=\'$match\'\;return true\" onMouseOut=\"window.status=\'\'\;return true\"/gi;
					}
				} else {
					#HISTORY: These lines are vestiges of when I had my own blog and didn't want anyone
					#finding it. If someone found it, I'd move it. Thus I wanted to be able to keep all links
					#intact when I moved it, so I had the script encode all links as in the "blog" directory
					#and then when displaying, I have the script change the links to the current directory.
					$line =~ s/$mydomain\/blog\//$mydomain\/$blogDir\//gi;
				}
			}
			
			$line =~ s/$mydomain\/blog\//$mydomain\/$blogDir\//gi;
			
			#if this is a search-based display, I want to turn the search string red in the text			
			if ($search eq "true") {
				$line =~ s/$searchedString/<u><b><font color=red>$searchedString<\/font><\/b><\/u>/gi;
			}
			push(@PrintArray,$line);
		}
		$count++;
	}
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /\<!--BLOG CONTENT--\>/) {
			$string .= "<h3>$title</h3>\n";
			($dayie,$timey) = split(/-/,$dFile);
			($houry,$miny,$secy) = split(/\./,$timey);
			if ($houry > 12) {
				$meridi = " p.m.";
			} else {
				$meridi = " a.m.";
			}
			$newHour = $CivilianTime[$houry];
			$string .= "<i>$dMonth $dayie, $dYear at $newHour\:$miny\:$secy" . "$meridi</i><p>\n";
			foreach (@PrintArray) {
				$string .= "$_";
			}
	
			#process comments
			$commentsProcessed=0;
			foreach (@Comments) {
				$approved = 0;
				$cUrl = "";
				$cEmail = "";

				($approved,$namer,$commr,$cUrl,$cEmail) = split(/\|/,$_);
				if ($approved == 1) {
					$string .= "<p><table cellpadding=3  style=\"background-color: $commentBackground; border: 1 solid $commentBorder\">\n";
					$string .= "<tr><td bgcolor=$alternatingColor><font face=$tableFontFace size=$headlineFontSize><center>";
			
					#if the option is enabled, display the user's name as a link to
					#his or her web site.
					if ($displayCommentWebPages eq "yes") {
						if (($cUrl ne "http://") && ($cUrl ne "")) {
							$mcUrl = &MaskString($cUrl);		
							$string .= "<a href=$newform?submit=Offsite&u=$mcUrl target=_new onMouseOver=\"window.status=\'$cUrl\'\;return true\" onMouseOut=\"window.status=\'\'\;return true\">";
						}
					}
					$string .= "<b>$namer" . "'s";
					if ($displayCommentWebPages eq "yes") {
						if (($cUrl ne "http://") && ($cUrl ne "")) {
							$string .= "</a>";
						}
					}
					$string .= " comments:</b></font></td></tr>\n";
					$commr =~ s/<br>/<br>\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;/gi;
					if ($search eq "true") {
						$commr =~ s/$searchedString/<u><b><font color=red>$searchedString<\/font><\/b><\/u>/gi;
					}
			
					#if the commenter enters a web page address, turn it into a link, since we don't allow html
					#in comments.
					$commr =~ s/http:\/\/(.*?)\s/<a href=http:\/\/$1>http:\/\/$1<\/a>/gi;
					$string .= "<tr><td><font size=$tableFontSize face=$tableFontFace>\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;$commr\n";
					chomp($cEmail);
			
					# if the option is set, display the commenter's e-mail address as a link
					if ($displayCommentEmailAddy eq "yes") {
						if ($cEmail ne "") {
							$string .= "<br><center>(<a href=mailto:$cEmail>Email $namer</a>)";
						}
					}
					if ($adminOn) {
						$string .= "<br><center><a href=$newform?submit=EditComment&comment=$commentsProcessed&file=$commentFile>Edit Comment</a> \| ";
						$string .= "<a href=$newform?submit=DeleteComment&comment=$commentsProcessed&file=$commentFile>Delete Comment</a>\n";
					}
					$string .= "</td></tr></table>\n";


				}
				$commentsProcessed++;
			}	
			$string .= "<center><hr noshade size=1>";
			$string .= &Comment;
		$string .= "<center><hr noshade size=1>";
		$string .= &RankMe;
		$string .= "<center><hr noshade size=1>";	
		if ($adminOn) {
			$string .= "<br><a href=\"$newform\?submit=Edit\&year=$dYear\&month=$dMonth\&file=$dFile\">Edit this file</a>\n";
			$string .= "<br><a href=\"$newform\?submit=Delete\&year=$dYear\&month=$dMonth\&file=$dFile\">Delete this file</a>\n";
		}
		$myUrl = &MaskString("http://leifwright.com/scripts");
		$string .= "<p><font size=$tableFontSize color=gray><center>Like this blog program? I wrote it.  You can get a variant of it <a href=$newform\?submit=Offsite&u=$myUrl target=_new>here</a>.\n";
		$string .= "</center>";
		}
	}
	&GetFooterTemplate;
	exit;
}



#################################################
#HEADER, FOOTER ROUTINES
#################################################

sub GetHeaderTemplate {
	#one sub reads in template file
	# replace each array item that contains the appropriate tag
	#with the appropriate data. Replace the BLOG CONTENT tag with
	#the stuff here.
	#
	#Here's how it works. I open up your template file and read in all its contents.
	#Each line in your template takes up one place in the array. As I iterate through


	#each place in the array, I check for HTML comment tags.
	#When the script finds the HTML comment tags denoting the places where
	#you want blog content to go, it replaces that tag with the appropriate comment.
	#By the time the script is ready to print, all the HTML comment tags should have
	#been replaced with content and when it prints, it should print the content, not the
	#html comment tags.
	open (TEMP,"$blogTemplate") || &Error("Can't open $blogTemplate. $!");
	@theTemplate = <TEMP>;
	close(TEMP);
	$blogLinks = &BlogLinks;
	$blogRanked = &BlogRanked;
	$blogArchive = &BlogArchive;
	$blogEmail = &BlogEmail;
	$blogSearch = "<form action=$newform method=GET><font size=$tableFontSize>Search the blog: <input type=hidden name=submit value=Search>\n<input type=text name=SearchString><input type=submit value=\"Search\"><\/form><br>\n<center><hr noshade size=1><\/center>";
	foreach (@theTemplate) {
		$_ =~ s/\%\%title\%\%/$blogTitle $title/gi;
		$_ =~ s/\<!--BLOG LINKS--\>/$blogLinks/g;
		$_ =~ s/\<!--BLOG RANKED--\>/$blogRanked/g;
		$_ =~ s/\<!--BLOG ARCHIVE--\>/$blogArchive/g;
		$_ =~ s/\<!--BLOG EMAIL--\>/$blogEmail/g;
		$_ =~ s/\<!--BLOG SEARCH--\>/$blogSearch/g;
	}
}


####### BLOG LINKS
sub BlogLinks {

	#subroutine creates list of links to print in the blog. This is NOT the links page. Instead
	#it is the list of links like "Home," and "log in."
	my ($string);
	$string = "<Br>";
	$string .= "<font face=$tableFontFace size=$tableFontSize>";
	$string .=  "<h3>Blog links</h3>\n";
	$string .=  "<ul>";
	$string .=  "<li><a href=$newform\?submit=Links";
	#if ($adminOn) {
	#	$string .=  "&admin=$adminMasked";
	#}
	$string .=  ">My links</a>";
	$string .=  "<li><a href=$newform";
	#if ($adminOn) {
	#	$string .=  "?admin=$adminMasked";
	#}
	$string .=  ">Main page</a>";
	if ($adminOn) {
		$string .=  "<li><a href=$newform?submit=Write\>Add an entry</a></ul></b>";
	} else {
		$string .=  "<li><a href=$newform?submit=admin>Log in</a></ul></b>\n";
	}
	return $string;
}

####### BLOG RANKED
sub BlogRanked {
	#gets ranked entries and displays them. Actually, it just puts them in the array to be displayed.
	#Actually, it just returns them to the subroutine that called them.
	my($string);
	 $string = "<h3>$numberOfTopEntries top-ranked:</h3>\n";
	$string .=  "<ol>";
	$string .= &GetTopNRankings($numberOfTopEntries);

	$string .=  "</ol>";

	$string .=  "<center>(<a href=$newform\?submit=DisplayAllRankedFiles";
	#if ($adminOn) {
	#	$string .=  "&admin=$adminMasked";
	#}
	$string .=  ">Show all ranked files</a>)</center>\n";
	return $string;
}

####### BLOG ARCHIVE
sub BlogArchive {
	#I'm fairly certain this is a completely unnecessary subroutine, but I'm too lazy to
	#get rid of it.
	my($string);
	$string = &ListArchivedMonths;
	return $string;
}

#######BLOG EMAIL
sub BlogEmail {
	#returns HTML code to print form allowing users to sign up to be notified when
	#the blog is updated. My experience is that very few people will sign up for e-mail
	#updates. Your mileage may vary.
	my($string);
	$string = "<form action=$newform method=POST>\n";
	$string .=  "<h3>Email updates</h3>\n";
	$string .=  "Get e-mail when blog updated.<Br>";
	$string .=  "<input type=hidden name=submit value=\"Email me when blog's updated\">\n";
	$string .=  "Your name:<Br><input type=text name=name width=30><br>";
	$string .=  "Your email:<br><input type=text name=email width=30><br>\n";
	$string .=  "<input type=submit></form>\n";
	return $string;
}

####### LIST ARCHIVED MONTHS
sub ListArchivedMonths {
	#returns a string containing HTML links to every entry EVER recorded
	#in your blog. For the curious and masochistic.
	my($string);
	$string = "<h3>Archives:</h3>\n";
	$string .=  "<ul>";
	foreach $oldYear (@YearsList) {
		foreach $oldMonth (@MonthList) {
			$checkDir = $PageBase . $oldYear . "/" . $oldMonth . "/";
			
			#Lesson learned: If you don't blank out the array, bad things happen.
			@GaaFiles=();
	
			#open the directory and get its contents.
			opendir(THAT,"$checkDir");
			#strangely, my syntax highlighter doesn't recognize "readdir".

			@GaaFiles=readdir(THAT);
			closedir(THAT);
			if ($GaaFiles[2] ne "") {
				$string .=  "<li><a href=";
				$string .=  "$newform\?submit=ShowMonth\&Month=$oldMonth";
				$string .=  "\&year=$oldYear";
				#if ($adminOn) {
				#	$string .=  "&admin=$adminMasked";
				#}
				$string .=  ">$oldMonth $oldYear</a>\n";
			}
		}
	}
	$string .=  "</ul>";
	return $string;
}

####### GET FOOTER TEMPLATE
sub GetFooterTemplate {
	#This misnamed subroutine actually prints the blog. It is called after all the blog content
	#has been assembled into @theTemplate. The funky naming of the subroutine is a 
	#vestigal reminder of a time when the blog used separate header and footer files and
	#generated all the content only in between those two files. That severely restricted
	#the layout of the HTML pages, because it required certain content to be on the left side
	#of the page. Well NO MORE, Bucko!
	foreach (@theTemplate) {
		print $_;
	}
	exit;
}











#################################################
#LOGGING ROUTINES
#################################################

####### SET COOKIE ENCODE CHARS
sub SetCookieEncodeChars {
	# These are from Matt Wright's cookie lib. I modified two of his subroutines
	# below for the cookie-based logging exclusion. They were included here so
	# you wouldn't have to include another library. 
	@Cookie_Encode_Chars = ('\%', '\+', '\;', '\,', '\=', '\&', '\:\:', '\s');
	
	%Cookie_Encode_Chars = ('\%',   '%25',
	                        '\+',   '%2B',
	                        '\;',   '%3B',
	                        '\,',   '%2C',
	                        '\=',   '%3D',
	                        '\&',   '%26',
	                        '\:\:', '%3A%3A',
	                        '\s',   '+');
	
	@Cookie_Decode_Chars = ('\+', '\%3A\%3A', '\%26', '\%3D', '\%2C', '\%3B', '\%2B', '\%25');
	
	%Cookie_Decode_Chars = ('\+',       ' ',
	                        '\%3A\%3A', '::',
	                        '\%26',     '&',
	                        '\%3D',     '=',
	                        '\%2C',     ',',

	                        '\%3B',     ';',
	                        '\%2B',     '+',
	                        '\%25',     '%');
}

####### LOG COMMENT
sub LogComment {
	my($remoteAddress) = $ENV{'REMOTE_ADDR'};
	my($referer) = $ENV{'HTTP_REFERER'};
	my($browser) = $ENV{'HTTP_USER_AGENT'};
	my($thisPage) = $ENV{'REQUEST_URI'};
	#try to resolve host name for IP address. 
	if ( $remoteAddress =~ m!(\d+)\.(\d+)\.(\d+)\.(\d+)!) {
		$hostname = (gethostbyaddr(pack('C4', $1, $2, $3, $4), 2))[0];
		$hostname = $hostname || '';
	} else {
		$hostname = "query string does not pattern match to dd.dd.dd.dd";
		$hostname = '';
	}
	if (! &FetchCookies('blogExclude')) {
		open (CLOG,">>$commentsLog") || &MyError("Can't open $commentsLog. $!");
		print CLOG "\n$name\|$hostname\|$remoteAddress\|$referer\|$browser\|$thisMonth\|$DayOfMonth\|$Year\|$Hours\|$FormattedMinutes\|$FormattedSeconds";
		close(CLOG);
	}
}

####### LOG IT
sub LogIt {
	# logs user's IP, browser, referer and page visited
	#get data from environmental variables
	$remoteAddress = $ENV{'REMOTE_ADDR'};
	$referer = $ENV{'HTTP_REFERER'};
	$browser = $ENV{'HTTP_USER_AGENT'};
	$thisPage = $ENV{'REQUEST_URI'};
	
	#try to resolve host name for IP address. 
	if ( $remoteAddress =~ m!(\d+)\.(\d+)\.(\d+)\.(\d+)!) {
		$hostname = (gethostbyaddr(pack('C4', $1, $2, $3, $4), 2))[0];
		$hostname = $hostname || '';
	} else {
		$hostname = "query string does not pattern match to dd.dd.dd.dd";
		$hostname = '';
	}
	#exclude owner if necessary. Technically, since owner exclusion is cookie-based, I don't
	#have to have this if statement, but I left it there for debugging. Once you've got the 
	#"exclude me" cookie in your browser, it's easy to test logging by turning off logging
	#exclusion in the user variables above, instead of jacking around with a buncha cookies.
	if ($excludeOwnerFromLogging eq "yes") {
		#check to see if this is the owner; if so, don't log. I don't care what the cookie says,
		#I simply want to see if it exists.
		if (! &FetchCookies('blogExclude')) {
			open (LOG,">>$logfile") || &MyError("Can't open $logfile. $!");
			print LOG "\n$hostname\|$remoteAddress\|$referer\|$browser\|$sitehome$thisPage\|$thisMonth\|$DayOfMonth\|$Year\|$Hours\|$FormattedMinutes\|$FormattedSeconds";
			close(LOG);
		}
	} else {
		#the owner doesn't care if he or she is logged, so don't check.
		open (LOG,">>$logfile") || &MyError("Can't open $logfile. $!");
		print LOG "\n$hostname\|$remoteAddress\|$referer\|$browser\|$sitehome$thisPage\|$thisMonth\|$DayOfMonth\|$Year\|$Hours\|$FormattedMinutes\|$FormattedSeconds";

		close(LOG);
	}
}

####### OFFSITE

sub Offsite {
	my($goingAway);
	$remoteAddress = $ENV{'REMOTE_ADDR'};
	$referer = $ENV{'HTTP_REFERER'};
	$browser = $ENV{'HTTP_USER_AGENT'};
	$thisPage = $ENV{'REQUEST_URI'};
	$goingAwayMasked = param("u");
	#&Header;
	#print "$goingAwayMasked";
	#exit;
	$goingAway = &UnmaskString($goingAwayMasked);
	
	#records when visitors leave your site for a link from your site.
	if (! $adminOn) {
		#record all the environmental data
		
		#resolve IP address if possible.
		if ( $remoteAddress =~ m!(\d+)\.(\d+)\.(\d+)\.(\d+)!) {

			$hostname = (gethostbyaddr(pack('C4', $1, $2, $3, $4), 2))[0];
			$hostname = $hostname || '';
		} else {
			$hostname = "query string does not pattern match to dd.dd.dd.dd";
			$hostname = '';
		}
		if ($excludeOwnerFromLogging eq "yes") {
			#check to see if this is the owner; if so, don't log
			if (! &FetchCookies('blogExclude')) {
				open (LOG,">>$logfile") || &MyError("Can't open $logfile. $!");
				print LOG "\n$hostname\|$remoteAddress\|$referer\|$browser\|\|$thisMonth\|$DayOfMonth\|$Year\|$Hours\|$FormattedMinutes\|$FormattedSeconds\|$goingAway";
				close(LOG);
			}
		} else {
			open (LOG,">>$logfile") || &MyError("Can't open $logfile. $!");
			print LOG "\n$hostname\|$remoteAddress\|$referer\|$browser\|\|$thisMonth\|$DayOfMonth\|$Year\|$Hours\|$FormattedMinutes\|$FormattedSeconds\|$goingAway";
			close(LOG);
		}
	}
		#send the user where they're wanting to go.
		print ("Location: $goingAway\n");  

 		print ("Content-type: text/html\n\n");
		exit;
}


####### VIEW COMMENTS LOG

sub ViewCommentsLog {
	my($string) = "";
	#format log for viewing, display entries.
	if (! $adminOn) {
		&Error("You aren't in administration mode");
	}
	$page = param("page");
	if (! $page) {
		$page = 1;
	}
	$title = "Blog Comments Log";
	&Header;
	&GetHeaderTemplate;
	
	
	open (CLOG,"$commentsLog") || &Error("Can't open $commentsLog. $!");
	@theLog = <CLOG>;
	close(CLOG);
	
	#reverse the log so the latest entries are first
	@upsideDownLog = reverse @theLog;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Comments Log for $blogTitle</h3>\n";
	
			$count = 1;
	
			$hitCount = 1;
	
			#tell me how many hits are in the log
			foreach (@upsideDownLog) {
				#clear newlines
				chomp($_);
				#only count lines with data
				if ($_ ne "") {
					$hitCount++;
				}
			}
			#this logic lets me count how many pages of hits are for
			#display and then display links to get to them.
			$pageMinus = $page -1;
			$pagePlus = $page + 1;
			$bottomLimit = $hitsPerLogPage*$pageMinus;
			$topLimit = $hitsPerLogPage*$page;
			$daPages = $hitCount/$hitsPerLogPage;
			#/
			#the comment above is because my syntax highlighter
			#thinks I'm starting a regular expression with the division
			#operator above, so I put the slash there to close it. Dumb, I know.
	
			#ceil rounds up. Can't use it for anything were accuracy is of primary
			#importance, but for my purposes, I'm just trying to get to the nearest
			#whole number, so it's OK. ceil is in the POSIX module. if you don't have the 
			#posix module installed, comment out this line and deal with having inaccurate
			#log readings.
			$totalPages = ceil($daPages);
			$string .= "<center>";
			$string .= "<b>$hitCount total hits</b><br>";
			#lists start at 0. Have to compensate.
			$thisBottom = $bottomLimit +1;
			$string .= "Hits $thisBottom - ";

	
			#this just lets me be accurate when I'm saying how many hits
			#are on this page. Not necessary, but nice.

			if ($topLimit > $hitCount) {
				$string .= "$hitCount";
			} else {
				$string .= "$topLimit";
			}
			$string .= "<br>";
	
			#if this page is not page one, print a link to the previous page.
			if ($page > 1) {
				$prevPage = $page - 1;
				$string .= "<a href=$newform?submit=ViewCommentsLog&page=$prevPage>\&lt\;-</a> ";
			}
			#print this page number and number of total pages

			$string .= "<b>Page $page of $totalPages</b> ";
	
			#if this is not the last page, print a link to the next page.
			if ($page < $totalPages) {
				$nextPage = $page + 1;
				$string .= "<a href=$newform?submit=ViewCommentsLog&page=$nextPage>-\&gt\;</a>";
			}
			$string .= "<br>";
			$string .= "</center><br>";
	
			#Start printing hits
			$string .= "<table border=0 width=400>\n";
			foreach(@upsideDownLog) {
				#reset jumpoff variable
				$jumpOff = "";	
		
				#only do this stuff if I'm within the correct page range of hits
				if (($count > $bottomLimit) && ($count < $topLimit+1)) {
					#kill newline characters
					chomp($_);
					#skip blank lines

					if ($_ ne "") {
						$thisLine = $_;
						#split line up into its requisite parts
						#\n$name\|$hostname\|$remoteAddress\|$referer\|$browser\|$thisMonth\|$DayOfMonth\|$Year\|$Hours\|$FormattedMinutes\|$FormattedSeconds";
						($username,$hostname,$remoteAddress,$referer,$browser,$lMonth,$lDay,$lYear,$lHours,$lMinutes,$lSeconds) = split(/\|/,$thisLine);
						#build table for log display
						$string .= "<tr><td bgcolor=$alternatingColor align=right><font face=$tableFontFace size=$tableFontSize>$count Visitor: </td>";
				
						#print unresolved host names in gray. This is for my own purposes.
						if ($hostname ne "no reverse DNS for this IP") {

							$string .= "<td bgcolor=$alternatingColor><font face=$tableFontFace size=$tableFontSize><b>\"$username\" from $hostname</b>";
						} else {
							$string .= "<td bgcolor=$alternatingColor><font face=$tableFontFace size=$tableFontSize><font color=gray><b>\"$username\" from $hostname</b></font>";
						}
				
						#print IP addresses as a link to a script that will try to resolve them with whois
						$string .= " (<a href=\"http://www.xav.com/scripts/axs/whois.pl?a=$remoteAddress\" target=_new><font color=black><u>$remoteAddress</u></font></a>)</td></tr>\n";
						$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>Commented on: </td><td><font face=$tableFontFace size=$tableFontSize>";
						if ($referer ne "") {
							$displayName = $referer;
							$displayName =~ s/$sitehome\/$blogDir\/$newform\?//i;
							$displayName =~ s/=/= /gi;
							$displayName =~ s/\%3/= /gi;
							$displayName =~ s/\%20/ /gi;
							#use offsite function of this script so people can't look at their
							#referer logs and see this script's url, which contains the admin code.
							$maskedReferer = &MaskString($referer);
							$string .= "<a href=\"$newform?submit=Offsite&u=$maskedReferer\" target=_new>";
							if ($referer =~ /leifwright.com/) {
								$string .= "<font color=gray>";
							} else {
								$string .= "<font color=black>";
							}
							$string .= "$displayName</font></a>";
						} else {
							$string .= "no referer";
						}
						$string .= "</td></tr>";
						$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>Browser: </td><td><font face=$tableFontFace size=$tableFontSize>";
						$string .= "$browser</td></tr>";
						if ($lHours < 13) {
							if ($lHours == 0) {
								$lHours = 12;
							}
							$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>On:</td><td><font face=$tableFontFace size=$tableFontSize> $lMonth $lDay, $lYear at <b>$lHours" . ":" . "$lMinutes" . ":" . "$lSeconds a.m.</b><p>";
						} else {
							$lHours = $lHours - 12;
					
							$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>On:</td><td><font face=$tableFontFace size=$tableFontSize> $lMonth $lDay, $lYear at <b>$lHours" . ":" . "$lMinutes" . ":" . "$lSeconds p.m.</b><p>";
						}
						$string .= "</td></tr>";
				
					}
				}
				$count++;
			}

			#repeat printing of links for each page.
			$string .= "<tr><td colspan=2 align=center><font face=$tableFontFace size=$tableFontSize>";
			if ($page > 1) {
				$prevPage = $page - 1;
				$string .= "<a href=$newform?submit=ViewCommentsLog&page=$prevPage>\&lt\;-</a> ";
			}
			$string .= "<b>Page $page of $totalPages</b> ";
			if ($page < $totalPages) {
				$nextPage = $page + 1;
				$string .= "<a href=$newform?submit=ViewCommentsLog&page=$nextPage>-\&gt\;</a>";
			}
			$string .= "</td></tr>\n";
	
			$string .= "<tr><td colspan=2 align=center><b><font size=$tableFontSize face=$tableFontFace>Total comments since logging began: $count</td></tr>\n";
			$string .= "</table>";
		}
	}
	&GetFooterTemplate;
}

####### VIEW LOG
#\n$name\|$hostname\|$remoteAddress\|$referer\|$browser\|$thisMonth\|$DayOfMonth\|$Year\|$Hours\|$FormattedMinutes\|$FormattedSeconds";
sub ViewLog {
	my($string) = "";
	#format log for viewing, display entries.
	if (! $adminOn) {
		&Error("You aren't in administration mode");
	}
	$page = param("page");
	if (! $page) {
		$page = 1;
	}
	$title = "Blog Log";
	&Header;
	&GetHeaderTemplate;
	open (LOG,"$logfile") || &Error("Can't open $logfile. $!");
	@theLog = <LOG>;
	close(LOG);
	
	#reverse the log so the latest entries are first
	@upsideDownLog = reverse @theLog;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Log for $blogTitle</h3>\n";
	
			$count = 1;
	
			$hitCount = 1;
	
			#tell me how many hits are in the log
			foreach (@upsideDownLog) {
				#clear newlines
				chomp($_);
				#only count lines with data
				if ($_ ne "") {
					$hitCount++;
				}
			}
			#this logic lets me count how many pages of hits are for
			#display and then display links to get to them.
			$pageMinus = $page -1;
			$pagePlus = $page + 1;
			$bottomLimit = $hitsPerLogPage*$pageMinus;
			$topLimit = $hitsPerLogPage*$page;
			$daPages = $hitCount/$hitsPerLogPage;
			#/
			#the comment above is because my syntax highlighter
			#thinks I'm starting a regular expression with the division
			#operator above, so I put the slash there to close it. Dumb, I know.
	
			#ceil rounds up. Can't use it for anything were accuracy is of primary
			#importance, but for my purposes, I'm just trying to get to the nearest
			#whole number, so it's OK. ceil is in the POSIX module. if you don't have the 
			#posix module installed, comment out this line and deal with having inaccurate
			#log readings.
			$totalPages = ceil($daPages);
			$string .= "<center>";
			$string .= "<b>$hitCount total hits</b><br>";
			#lists start at 0. Have to compensate.
			$thisBottom = $bottomLimit +1;
			$string .= "Hits $thisBottom - ";

	
			#this just lets me be accurate when I'm saying how many hits
			#are on this page. Not necessary, but nice.

			if ($topLimit > $hitCount) {
				$string .= "$hitCount";
			} else {
				$string .= "$topLimit";
			}
			$string .= "<br>";
	
			#if this page is not page one, print a link to the previous page.
			if ($page > 1) {
				$prevPage = $page - 1;
				$string .= "<a href=$newform?submit=ViewLog&page=$prevPage>\&lt\;-</a> ";
			}
			#print this page number and number of total pages

			$string .= "<b>Page $page of $totalPages</b> ";
	
			#if this is not the last page, print a link to the next page.
			if ($page < $totalPages) {
				$nextPage = $page + 1;
				$string .= "<a href=$newform?submit=ViewLog&page=$nextPage>-\&gt\;</a>";
			}
			$string .= "<br>";
			$string .= "</center><br>";
	
			#Start printing hits
			$string .= "<table border=0 width=400>\n";
			foreach(@upsideDownLog) {
				#reset jumpoff variable
				$jumpOff = "";	
		
				#only do this stuff if I'm within the correct page range of hits
				if (($count > $bottomLimit) && ($count < $topLimit+1)) {
					#kill newline characters
					chomp($_);
					#skip blank lines

					if ($_ ne "") {
						$thisLine = $_;
						#split line up into its requisite parts
						($hostname,$remoteAddress,$referer,$browser,$thisPage,$lMonth,$lDay,$lYear,$lHours,$lMinutes,$lSeconds,$jumpOff) = split(/\|/,$thisLine);
						#build table for log display
						$string .= "<tr><td bgcolor=$alternatingColor align=right><font face=$tableFontFace size=$tableFontSize>$count Visitor: </td>";
				
						#print unresolved host names in gray. This is for my own purposes.
						if ($hostname ne "no reverse DNS for this IP") {
							$string .= "<td bgcolor=$alternatingColor><font face=$tableFontFace size=$tableFontSize><b>$hostname</b>";
						} else {
							$string .= "<td bgcolor=$alternatingColor><font face=$tableFontFace size=$tableFontSize><font color=gray><b>$hostname</b></font>";
						}
				

						#print IP addresses as a link to a script that will try to resolve them with whois
						$string .= " (<a href=\"http://www.xav.com/scripts/axs/whois.pl?a=$remoteAddress\" target=_new><font color=black><u>$remoteAddress</u></font></a>)</td></tr>\n";
						$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>From: </td><td><font face=$tableFontFace size=$tableFontSize>";
						if ($referer ne "") {
							$displayName = $referer;
							$displayName =~ s/$sitehome\/$blogDir\/$newform\?//i;
							$displayName =~ s/=/= /gi;
							$displayName =~ s/\%3/= /gi;
							$displayName =~ s/\%20/ /gi;
							#use offsite function of this script so people can't look at their
							#referer logs and see this script's url, which contains the admin code.
							$maskedReferer = &MaskString($referer);
							$string .= "<a href=\"$newform?submit=Offsite&u=$maskedReferer\" target=_new>";
							if ($referer =~ /leifwright.com/) {
								$string .= "<font color=gray>";
							} else {
								$string .= "<font color=black>";
							}
							$string .= "$displayName</font></a>";
						} else {
							$string .= "no referer";
						}
						$string .= "</td></tr><tr><td align=right><font face=$tableFontFace size=$tableFontSize>";
						if ($jumpOff eq "") {
							$string .= "Visited: </td><td><font face=$tableFontFace size=$tableFontSize>";
							$displayName = $thisPage;



							$linkPage = $thisPage;
							#$linkPage .= "\&admin=$adminMasked";
							$displayName =~ s/$sitehome\/$blogDir\/$newform\?//i;
							
							$string .= "<a href=$linkPage target=_new>$displayName</a></td></tr>\n";
						} else {
							$string .= " and <b><i>Left:</i> </td><td><font face=$tableFontFace size=$tableFontSize>";
							$maskedJumpoff = &MaskString($jumpOff);
							$displayJumpoff = $jumpOff;
							$displayJumpoff =~ s/\%20/ /g;
							$displayJumpoff =~ s/=/= /g;
							$string .= "<u><a href=$newform?submit=Offsite&u=$maskedJumpoff target=_new><font color=red>$displayJumpoff</a></font></u></b><br>\n";
							$string .= "</td></tr>";
						}
						$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>Browser: </td><td><font face=$tableFontFace size=$tableFontSize>";
						$string .= "$browser</td></tr>";
						if ($lHours < 13) {
							if ($lHours == 0) {
								$lHours = 12;
							}
							$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>On:</td><td><font face=$tableFontFace size=$tableFontSize> $lMonth $lDay, $lYear at <b>$lHours" . ":" . "$lMinutes" . ":" . "$lSeconds a.m.</b><p>";
						} else {
							$lHours = $lHours - 12;
					
							$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>On:</td><td><font face=$tableFontFace size=$tableFontSize> $lMonth $lDay, $lYear at <b>$lHours" . ":" . "$lMinutes" . ":" . "$lSeconds p.m.</b><p>";
						}
						$string .= "</td></tr>";
				
					}
				}
				$count++;
			}

			#repeat printing of links for each page.
			$string .= "<tr><td colspan=2 align=center><font face=$tableFontFace size=$tableFontSize>";
			if ($page > 1) {
				$prevPage = $page - 1;
				$string .= "<a href=$newform?submit=ViewLog&page=$prevPage>\&lt\;-</a> ";
			}
			$string .= "<b>Page $page of $totalPages</b> ";
			if ($page < $totalPages) {
				$nextPage = $page + 1;
				$string .= "<a href=$newform?submit=ViewLog&page=$nextPage>-\&gt\;</a>";
			}
			$string .= "</td></tr>\n";
	
			$string .= "<tr><td colspan=2 align=center><b><font size=$tableFontSize face=$tableFontFace>Total hits since logging began: $count</td></tr>\n";
			$string .= "</table>";
		}
	}
	&GetFooterTemplate;
}








#################################################

#CREATION ROUTINES
#################################################


####### WRITE ENTRY
sub WriteEntry {
	#This misnamed subroutine actually just prompts the user to create an entry.
	my($string) = "";
	if (! $adminOn) {
		&Error("You are not in administration mode. $adminOn $admin");
	}
	&Header;
	$title = "Create an entry";
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<head><title>Create an entry</title></head>\n";
			$string .= "<h3>Create an entry</h3>\n";
			$string .= "<form action=\"$newform\" method=POST>\n";
			$string .= "<input type=hidden name=admin value=$adminMasked>\n";

			$string .= "<table border=0 cellpadding=3>\n";
			$string .= "<tr><td align=right><font face=$tableFontFace size=$tableFontSize>Title:</td>\n";
			$string .= "<td><input type=text name=title size=30></td></tr>\n";
			$string .= "<tr><td valign=top align=right><font face=$tableFontFace size=$tableFontSize>Entry:</td>\n";
			$string .= "<td><textarea name=content rows=15 cols=40></textarea></td></tr>\n";
			$string .= "<tr><td colspan=2 align=center>\n";
			$string .= "<input type=submit name=submit value=\"Add this entry\"></form></td></tr></table>\n";
		}
	}
	&GetFooterTemplate;
	exit;
}


####### ADD THIS ENTRY
sub AddThisEntry {
	# This subroutine actually adds an entry to the site. It writes a new file containing
	# whatever text has been typed in, replacing unwanted characters.
	if (! $adminOn) {
		&Error("You are not in administration mode!");
	}
	#set instance variables
	$title		=	param("title");
	
	#since this sub can be called from within the script itself, I check to see if 
	#the title I'm looking for is different than the incoming httpd header
	if ($theTitle) {
		$title = $theTitle;
	}
	$content	=	param("content");
	
	#same here; I want to find out where this sub was called from
	if ($theContent) {


		$content = $theContent;
	}
	$filename	= $_[0] if $_[0];

	#I can't continue without both inputs. Smack user on the wrist.
	if ((! $title) || (! $content)) {
		&MyError("Dude! What the heck are you thinking? You must provide both a title and content to create an entry. Doofus.");
	}	
	#tell me what directory to write this file to
	$newfile = $PageBase . $Year . "/" . $thisMonth . "/";
		
	#adjust for Central time. This, by the way, pisses me off. The server should adjust when
	#I tell it to. This makes for all kinds of convoluted math, and I freaking HATE math!

	$theHours = $Hours;
	$theDay = $DayOfMonth;
	
	#create the file name
	$newfile .= $theDay . "-" . $theHours . "." . $FormattedMinutes . "." . $FormattedSeconds . ".txt";
	
	#if I got a filename, this sub was called internally.
	if ($filename) {
		$newform = $filename;
	}
	
	#this is a raw file that needs images processed if the content contains picture widgets
	if ($content =~ /\[picture\]/gi) {	
		&ProcessImages;
		
	#otherwise, I need to write the data; either no images, or they've been uploaded already

	} elsif ($content =~ /\[movie\]/gi) {	
		&ProcessMovies;
	} else {
		#create the new file.
		open(NEWFILE,">$newfile") || &MyError("Can't open $newfile. $!");
		
		#put the contents of entry into the new file
		print NEWFILE "$title\n";
		print NEWFILE "$content";
		close(NEWFILE);
		&SendUpdateEmails;

		&Header;
		$title = "Entry created.";
		&GetHeaderTemplate;
		$thingy = "<h3>Success</h3>\nI have recorded your entry.<br>\n<a href=$newform>Click here to continue</a>\n";
		foreach (@theTemplate) {
			$_ =~ s/<!--BLOG CONTENT-->/$thingy/;
		}
		&GetFooterTemplate;
		exit;
	}
}	








#################################################
#FILE MANIPULATION ROUTINES
#################################################

####### DELETE FILE
sub DeleteFile {
	if (! $adminOn) {
		&Error("You are not in administration mode");
	}
	my($string) = "";
	#actually just prints an html page asking if the user REALLY wants to delete this file.
	$year		=	param("year");
	$month		=	param("month");
	$file		=	param("file");
	&Header;
	&GetHeaderTemplate;
	$newfile =~ s/\///gi;
	$file =~ s/\///gi;
	$newfile = $PageBase . $year . "/" . $month . "/";
	$newfile .= $file;	
	$newfile =~ s/\|//gi;
	
	open(DOOMED,"$newfile") || &MyError("Can't open $newfile. Reason: $!");
	@doom=<DOOMED>;
	close(DOOMED);
	$title = $doom[0];
	chomp($title);
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string .= "<h3>Really? Delete \"$title\"?</h3>\n";
			$string .= "<form action=$newform method=POST>\n";
			$string .= "<input type=hidden name=year value=\"$Year\">\n";

			$string .= "<input type=hidden name=month value=\"$month\">\n";
			$string .= "<input type=hidden name=file value=\"$file\">\n";
			$string .= "<input type=hidden name=admin value=$adminMasked>\n";
			$string .= "Clicking the button below will delete \"$title\" forever. If you don't want";
			$string .= " to do that, click the back button on your browser.<br>";
			$string .= "<input type=submit name=submit value=\"Delete this file\"></form>\n";
		}
	}
	&GetFooterTemplate;
	exit;
}

####### DELETE THIS FILE
sub DeleteThisFile {
	if (! $adminOn) {
		&Error("You are not in administration mode");
	}
	$year		=	param("year");
	$month		=	param("month");
	$file		=	param("file");
	$newfile = $PageBase . $year . "/" . $month . "/";
	$newfile .= $file;
	
	#believe it or not, deleting a file is JUST THIS SIMPLE! If the file

	#goes away, $deleted will contain "1". Otherwise, it'll be "0"
	$deleted = unlink $newfile;

	if (! $deleted) {
		&MyError("Couldn't delete $newfile. Reason: $!");
	}
	&Header;

	&GetHeaderTemplate;
	$thingy = "<h3>File deleted</h3>\nYou <b>jerk</b>! You killed a perfectly innocent file!<p>\nJust kidding. The file is dead, but your head's probably not made of poo.<br>\n<a href=$newform>Go to your main page</a>\n";
	foreach (@theTemplate) {
		$_ =~ s/<!--BLOG CONTENT-->/$thingy/;
	}
	&GetFooterTemplate;
	exit;
}

####### EDIT THIS FILE
sub EditThisFile {
	if (! $adminOn) {
		&Error("You are not in administraton mode.");
	}
	#set instance variables
	$title		=	param("title");
	$content	=	param("content");
	$year		=	param("year");
	$month		=	param("month");
	$file		=	param("file");
	
	#I can't continue without both inputs. Smack user on the wrist.
	if ((! $title) || (! $content)) {
		&MyError("You must provide both a title and content to create an entry. Doofus.");
	}
	#tell me what directory to write this file to
	$newfile = $PageBase . $year . "/" . $month . "/";
	$newfile .= $file;
	
	#create the new file.
	open(NEWFILE,">$newfile") || &MyError("Can't open $newfile. $!");
	
	#put the contents of the entry into the new file
	print NEWFILE "$title";
	print NEWFILE "\n$content";
	close(NEWFILE);	
	&Header;
	&GetHeaderTemplate;
	$thingy = "<h3>Success</h3>\nI have edited your entry.<br>\n<a href=$newform>Click here to continue</a><br>\n<a href=\"$newform\?submit=ViewEntry\&year=$year\&month=$month\&file=$file\">Or go back to the entry</a>\n";
	foreach (@theTemplate) {
		$_ =~ s/<!--BLOG CONTENT-->/$thingy/;
	}

	&GetFooterTemplate;
	exit;
}

####### EDIT FILE
sub EditFile {
	if (! $adminOn) {
		&Error("You are not in administraton mode");
	}
	my($string) = "";
	$dYear	=	param("year");
	$dMonth	=	param("month");
	$dFile	=	param("file");
	if ((! $dYear) || (! $dMonth) || (! $dFile)) {
		&MyError("I can't open a file because a crucial parameter is missing, so I can't tell what file you're trying to open.");
	}


	$filename = $PageBase . $dYear . "/" . $dMonth . "/" . $dFile;
	open(DIARY,"$filename") || &MyError("Can't open $filename. $!");
	@Diary=<DIARY>;
	close(DIARY);
	&Header;
	&GetHeaderTemplate;
	$title = $Diary[0];
	$count=0;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Edit file $dYear $dMonth $dFile</h3>\n";
			$string .= "<form action=$newform method=POST>\n";
			$string .= "<input type=hidden name=year value=\"$dYear\">\n";
			$string .= "<input type=hidden name=month value=\"$dMonth\">\n";
			$string .= "<input type=hidden name=file value=\"$dFile\">\n";
			$string .= "<input type=hidden name=admin value=$adminMasked>\n";
			$string .= "Title: <input type=text name=title value=\"$title\"><br>\n";
			$string .= "<textarea name=content rows=15 cols=40>\n";
			foreach (@Diary) {
				if ($count > 0) {
					$string .= "$_";
				}
				$count++;
			}
			$string .= "</textarea>\n";
			$string .= "<br><input type=submit name=submit value=\"Edit this file\"></form>\n";
		}
	}
	&GetFooterTemplate;
	exit;
}













#################################################
#COMMENTS ROUTINES
#################################################

####### DISPLAY ALL RANKED FILES
# Simply prints a list of all the files that have been rated by users.
sub DisplayAllRankedFiles {
	my ($string) = "";
	
	&Header;

	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/){
			$string .= "<h3>All ranked files</h3>\n";

			$string .= "Below is a list, in order of popularity, of all the files from this blog that have been rated by readers.<p>";
			$string .= "<ol>";
			#supply the argument "n" here to tell the subroutine to display all the entries that have votes.
			$string .=&GetTopNRankings("n");
		}
	}
	&GetFooterTemplate;
	exit;
}



####### RANK THIS ENTRY
#records the user's ranking of the entry passed to the script.
#this DOES NOT check to see if this person has voted for this
#entry before, and I DO NOT plan on adding that feature. You're
#welcome to do it, but I don't need it on my personal blog, so
#I feel no overriding urge to add that feature.
sub RankThisEntry {

	my ($string) = "";
	$dYear	=	param("year");
	$dMonth	=	param("month");
	$dFile	=	param("file");
	$rank	=	param("ranking");
	$title	=	param("title");
	&GetExistingRankings;
	
	#if this entry has not already been ranked, add it to the list
	if ($match == 0) {
		chomp($title);
		$newLine = $thisFile . "\|" . $title . "\|" . $Ranks{"$rank"};
		push(@rankingArray,$newLine);
	}
	
	#write the list of ranked files to the file
	&SetExistingRankings;
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string .= "<h3>Your rating accepted</h3>\n";
			$string .= "Thank you for rating my entry.<p>\n";
			$string .= "<a href=$newform>Go to the main page</a>\n";
			$string .= "<p><a href=\"$newform\?submit=ViewEntry\&year=$dYear\&month=$dMonth\&file=$dFile\">Go back to the entry</a>\n";
		}
	}
	&GetFooterTemplate;
	exit;
}

####### SET EXISTING RANKINGS
#simply takes an array and writes it to a file. This is really poor
#object-oriented design. I should have to pass the array to this sub
#instead of depending on a constant one existing, but I was in a hurry
#and didn't feel like being proper at the time. Now I'm too lazy to 
#fix it. Deal with it.
sub SetExistingRankings {
	open (RANKS,">$greatestHitsFile"); #no error message; it's possible the file doesn't exist.
	foreach(@rankingArray) {
		if ($_ ne "") {
			print RANKS $_ . "\n";
		}
	}
	close(RANKS);
}

####### GET EXISTING RANKINGS
sub GetExistingRankings {
	#assign numerical values to the various rankings
	$Ranks{"Bad"} = 0;
	$Ranks{"OK"} = 1;
	$Ranks{"Great"} = 2;
	$thisFile	=	$dYear . "\~" . $dMonth . "\~" . $dFile;
	$match=0;
	$itemCount = 0;
	open (RANKS,"$greatestHitsFile");
	while (<RANKS>) {
		#clear newline characters
		chomp($_);
		#add to the item count if this isn't a blank line. I use itemCount
		#when I display all the ranked entries, because I don't want blank
		#numbers with no links beside them.
		if ($_ ne "") {
			$itemCount++;
		}
		#split up this item into its requisite parts
		($filename,$theTitle,$score) = split(/\|/,$_);
		
		#if this is the file being ranked, increase its score by however
		#much the user has requested it be increased.
		if ($filename eq $thisFile) {
			$score = $score + $Ranks{$rank};
			$match = 1;
		}
		
		#set hash values for this item; I'll need them later. There are three hashes
		#here, each of which is keyed to the filename. It's my own little database, but
		#it exists only in memory. But it allows me to access all the values I need with
		#relatively little trouble. Plus, the Grateful Dead is playing "Not Fade Away"
		#right now, so everything is all right right now.
		$Ranking{"$filename"} = $score;
		$Titles{"$filename"}  = $theTitle;
		$Links{"$filename"}	  = $filename;
		if ($filename ne "") {
			$newLine = $filename . "\|" . $theTitle . "\|" . $score;

			push(@rankingArray,$newLine);
		}
	}
	close(RANKS); #I like the way that sounds. "Close Ranks."
}
####### GET TOP N RANKINGS
#gets the top n ranked files. If a number is passed to this sub,
#that's how many it gets. Otherwise, it gets all of the ranked files

sub GetTopNRankings {
	my($string) = "";
	my($requestedNumber) = $_[0];	
	&GetExistingRankings;
	if ($requestedNumber eq "n") {
		$numberToDisplay = $itemCount;
	} else {
		$numberToDisplay = $requestedNumber;
	}
	
	#create array based on values of the ranking hash, which contains
	#how many points each entry has.
	@keys = sort { $Ranking{$b} <=> $Ranking{$a} } keys %Ranking;
	

	#parse the new array, listing each member that fits within the 
	#requested number of entries to display.
	for ($i=0;$i<$numberToDisplay;$i++) {
		$fileBig = $Links{"$keys[$i]"};#$topRankedFilenames[$i];
		($fYear,$fMonth,$fFile) = split(/\~/,$fileBig);
		$string .= "<li><a href=\"$newform\?submit=ViewEntry\&month=$fMonth\&year=$fYear\&file=$fFile";
		#if ($adminOn) {
		#	$string .= "&admin=$adminMasked";
		#}
		$string .= "\" target=_blank>";
		$string .= "$Titles{$keys[$i]}</a>";
		if ($requestedNumber eq "n") {
			$string .= " Score: " . $Ranking{"$keys[$i]"};
		}
		$string .= "\n";
	}
	return $string;
}


####### RANK ME
#simply prompts the user to rank the entry they've just read.
#this sub cannot be called until &Header has been called.
sub RankMe {
	my ($string) = "";
	$string .= "<center><h3>Rate this entry</h3>";
	$string .= "<form action=$newform method=POST>";
	$string .= "<input type=hidden name=year value=\"$dYear\">\n";
	$string .= "<input type=hidden name=month value=\"$dMonth\">\n";
	$string .= "<input type=hidden name=file value=\"$dFile\">\n";
	$string .= "<input type=hidden name=title value=\"$title\">\n";
	$string .= "<table border=0><tr>\n";
	$string .= "<tr><td><center><font face=$tableFontFace size=$tableFontSize><b>Bad</b><br><input type=radio name=ranking value=Bad></td>\n";
	$string .= "<td><center><font face=$tableFontFace size=$tableFontSize><b>OK</b><br><input type=radio name=ranking value=OK></td>\n";
	$string .= "<td><center><font face=$tableFontFace size=$tableFontSize><b>Great!</b><br><input type=radio name=ranking value=Great></td></tr>\n";
	$string .= "<tr><td colspan=3><center><input type=submit name=submit value=\"Rank this entry\"></form></td></tr></table>\n";
	return $string;
}

####### EDIT COMMENT
sub EditComment {
	my ($string) = "";
	#displays the comment that's passed to it so that the owner can edit the comment.
	#I think editing comments is pretty unethical, but I can also see where you'd want to
	#be able to do that, so I enabled it here.
	if (! $adminOn) {

		&Error("You are not in administration mode.");
	}
	$commentNumber = param("comment");
	$file = param("file");
	$title="Edit a comment";
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Edit Comment</h3>\n";
			$string .= "(Editing comment $commentNumber in file $file)<br>\n";
			$filename = $file;
			open (FILE,"$filename") || &MyError("Can't open $filename. $!");
			@theFiles = <FILE>;
			close(FILE);
			$victim = $theFiles[$commentNumber];
			($approved,$name,$comment,$url,$email) = split(/\|/,$victim);
			$string .= "<form action=$newform method=POST>\n";
			$string .= "<input type=hidden name=submit value=EditTheComment>\n";
			$string .= "<input type=hidden name=admin value=$adminMasked>\n";

			$string .= "<input type=hidden name=file value=$file>\n";
			$string .= "<input type=hidden name=commentNumber value=$commentNumber>\n";
			$string .= "<table border=1>\n";
			$string .= "<tr><Td>Name:</td><td><input type=text name=name value=\"$name\"></td></tr>\n";
			$string .= "<tr><td>Url: </td><td><input type=text name=url value=\"$url\"></td></tr>\n";
			$string .= "<tr><Td>Email: </td><td><input type=text name=email value=\"$email\"></td></tr>\n";
			$string .= "<tr><td valign=top>Comment:</td><td><textarea name=comment rows=7 cols=40>$comment</textarea></td></tr>\n";
			$string .= "<Tr><td colspan=2><input type=submit value=\"Edit this comment\"></td></tr></table>\n";
		}
	}
	&GetFooterTemplate;
	exit;	
}


####### DELETE COMMENT

sub DeleteComment {
	#I don't prompt the user here, since he/she will be in administration mode.
	#this simply turns the comment off, which is another reason I don't prompt.

	#turning the comment back on is as simple as changing a 0 to a 1 in the 
	#comment file.
	my($string) = "";
	if (! $adminOn) {
		&Error("You are not in administration mode.");
	}
	$file = param("file");
	$commentNumber = param("comment");
	open(FILE,"$file") || &Error("Can't open $file. $!");
	@theFile=<FILE>;
	close(FILE);
	$victim = $theFile[$commentNumber];
	chomp($victim);
	($approved,$name,$comment,$url,$email) = split(/\|/,$victim);
	$killed = "0\|$name\|$comment\|$url\|$email\n";
	$theFile[$commentNumber]=$killed;
	open(TOWRITE,">$file") || &Error("Can't overwrite $file. $!");
	foreach (@theFile) {
		print TOWRITE $_;
	}
	close(TOWRITE);
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Comment Deleted</h3>\n";
			$string .= "I deleted comment $commentNumber. To turn it back on, all you have to do is edit the comment file and turn the 0 into a 1 at the front of this comment.";
			$string .= "<br>The script doesn't do it for you, because you really shouldn't be deleting comments if you want them.";
		}
	}
	&GetFooterTemplate;

	exit;
}

####### EDIT THE COMMENT
#actually edits the comment
sub EditTheComment {
	my ($string) = "";
	if (! $adminOn) {
		&Error("You are not in administration mode.");
	}
	$file = param("file");
	$commentNumber = param("commentNumber");
	$name = param("name");
	$url = param("url");
	$email = param("email");
	$comment = param("comment");

	if ((! $name) || (! $comment)) {
		&Error("You must enter a name and comment.");
	}
	$toWrite = "1\|$name\|$comment\|$url\|$email\n";
	open(FILE,"$file") || &Error("Can't open $file for reading. $!");
	@theFiles = <FILE>;
	close(FILE);
	$theFiles[$commentNumber]=$toWrite;
	open(TOWRITE,">$file") || &Error("Can't overwrite $file. $!");
	foreach(@theFiles) {
		print TOWRITE $_;
	}
	close(TOWRITE);
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Comment edited</h3>\n";
		}
	}
	&GetFooterTemplate;

	exit;
}

####### APPROVE COMMENT
sub ApproveComment {
	#turns comment into approved comment after the owner has ok'd it
	$dYear		=	param("year");
	$dMonth		=	param("month");
	$dFile		=	param("file");
	$dUrl		=	param("url");
	$dEmail		=	param("email");
	$comment	=	param("comment");
	if ((! $dYear) || (! $dMonth) || (! $dFile)) {
		&MyError("I can't open a file because a crucial parameter is missing, so I can't tell what file you're trying to open.");
	}
	$filename = $PageBase . $dYear . "/" . $dMonth . "/" . "comment_" . $dFile;
	$count = 0;
	open(FILES,"$filename") || &MyError("Can't open $filename. $!");
	@theFiles = <FILES>;
	close(FILES);
	
	#since the determining factor for approving comments is the 
	#first number, all I have to change is that number.
	($approved,$name,$content,$url,$email) = split(/\|/,$theFiles[$comment]);
	$approved = 1;
	$theFiles[$comment] = $approved . "\|" . $name . "\|" . $content . "\|" .  $url . "\|" .  $email;
	open(TOWRITE,">$filename") || &MyError("Can't overwrite $filename. $!");
	foreach (@theFiles) {
		print TOWRITE "$_";
	}
	close(TOWRITE);
	&Header;
	&GetHeaderTemplate;
	foreach (@theTemplate) {
		$this =  "<h3>Approved</h3>The comment has been approved.\n";
		$_ =~ s/<!--BLOG CONTENT-->/$this/;
	}
	&GetFooterTemplate;
	exit;
}

####### COMMENT
sub Comment {
	#allows user to comment on specific articles. this sub just
	#presents the interface to the user for comments
	my ($string) = "";
	$string .= "<table border=0 cellpadding=3 cellspacing=0 style=\"border: 1 solid \#000000\">\n";	
	$string .= "<Tr><Td colspan=2><font face=$tableFontFace size=$tableFontSize>\n";
	$string .= "<center><h3>Comment on this entry</h3>\n";
	$string .= "$commentRequestString<br>(HTML is NOT permitted)<p>";
	$string .= "<form action=$newform method=POST>\n";
	$string .= "<input type=hidden name=file value=\"$dFile\">\n";
	$string .= "<input type=hidden name=year value=\"$dYear\">\n";
	$string .= "<input type=hidden name=month value=\"$dMonth\"></td></tr>\n";
	$string .= "<tr><Td bgcolor=$alternatingColor><font face=$tableFontFace size=$tableFontSize>Your name <b>(required)<\/b>:</td><td bgcolor=$alternatingColor><input type=text name=name size=40></td></tr>\n";
	$string .= "<tr><Td><font face=$tableFontFace size=$tableFontSize>Your web page:</td><td><input type=text name=url value=\"http://\" size=40></td></tr>\n";
	$string .= "<tr><Td bgcolor=$alternatingColor><font face=$tableFontFace size=$tableFontSize>Your email:</td><td bgcolor=$alternatingColor><input type=text name=email size=40></td></tr>\n";
	$string .= "<tr><Td valign=top><font face=$tableFontFace size=$tableFontSize>Your comment <b>(required)<\/b>:<br> <a href=$newform?submit=ExplainSmileys target=_new>Click here for smileys</a></td><td><textarea name=comment rows=7 cols=40></textarea>\n";
	$string .= "</td></tr><Tr><Td colspan=2 align=center><input type=submit name=submit value=\"Enter my comment\"></form></td></tr></table>\n";
	return $string;
}

####### ENTER COMMENT
sub EnterComment {
	$dYear		=	param("year");

	$dMonth		=	param("month");
	$dFile		=	param("file");
	$comment	=	param("comment");
	$name		=	param("name");
	$url			=	param("url");
	$email		=	param("email");
	if ((! $dYear) || (! $dMonth) || (! $dFile) || ($comment eq "") || (! $name)) {
		&MyError("I can't open a file because a crucial parameter is missing, so I can't tell what file you're trying to open.");
	}
	$filename = $PageBase . $dYear . "/" . $dMonth . "/" . "comment_" . $dFile;
	$count=0;
	
	# find out how many comments there already are.
	if (open (TOREAD,"$filename")) {
		while(<TOREAD>) {
			if (($_ ne "") && ($_ ne "\n")) {
				$count++;
			}
		}
		close(TOREAD);
	}
	
	#item 1 is actually 0, so incrementing the count first
	#gets me on the correct array item.
	$thisEntry = $count;
	
	#strip unwanted metacharacters because I don't want them, and they'll royally 
	#screw up my datafile, which'll make my day go poorly
	$comment =~ s/<|>//gi;
	$comment =~ s/\|/--/gi;
	$comment =~ s/\n|\r/\<br\>/gi;
	$comment =~ s/\<br\>\<br\>/\<br\>/gi;
	$comment =~ s/\<br\>\<br\>/\<br\>/gi;
	

	#turn smiley code into links to smiley images.
	$comment =~ s/:D/<img src=smileys\/icon_lol.gif>/gi;
	$comment =~ s/:\)/<img src=smileys\/icon_smile.gif>/gi;
	$comment =~ s/:\(/<img src=smileys\/icon_sad.gif>/gi;
	$comment =~ s/:o|:0/<img src=smileys\/icon_eek.gif>/gi;
	$comment =~ s/:P/<img src=smileys\/icon_razz.gif>/gi;
	$comment =~ s/\;\)/<img src=smileys\/icon_wink.gif>/gi;
	$comment =~ s/8\)/<img src=smileys\/icon_cool.gif>/gi;
	$comment =~ s/\;\?/<img src=smileys\/icon_confused.gif>/gi;
	$comment =~ s/\(_{1,3}Y_{1,3}\)/<img src=smileys\/moon.gif>/gi;
	$comment =~ s/\:thefinger\:/<img src=smileys\/thefinger.gif>/gi;
	
	$name =~ s/<|>//gi;
	$name =~ s/\|/--/gi;
	$email =~ s/<|>//gi;
	$email =~ s/\|/--/gi;
	$url =~ s/<|>//gi;
	$url =~ s/\|/--/gi;
	$name =~ s/\n|\r/<br>/gi;
	
	if ($logComments) {
		&LogComment;
	}
	
	#I want to append this entry to the file at the bottom.
	open (TOWRITE,">>$filename") || &MyError("Can't append to $filename. $!");
	if ($requireMyApprovalOnComments ne "no") {
		print TOWRITE "0\|$name\|$comment\|$url\|$email\n";
	} else {
		print TOWRITE "1\|$name\|$comment\|$url\|$email\n";
	}
	close(TOWRITE);
	&Header;
	
	#mail the site's owner if that option is enabled
	if ($notifyMeOnComment eq "yes") {
		open (MAIL, "|$mailprog $toMail") || &MyError("Can't open $mailprog in Entercomment sub. Reason: $!");
		print MAIL "To: $toMail\n";

		print MAIL "Reply-to: $toMail\n";
		print MAIL "From: $toMail\n";

		print MAIL "Subject: Comment entered\n\n";
		print MAIL "Hey, someone entered a comment to one of your entries.\n";
		print MAIL "Here's the comment:\n";
		print MAIL "From: $name\n";
		print MAIL "Comment: $comment\n\n";
		if ($requireMyApprovalOnComments ne "no") {
			print MAIL "Click the link here to approve this comment. To deny it, do nothing. It won't appear on the site.\n";
			$theLink = "$newform\?submit=ApproveComment\&file=$dFile\&month=$dMonth\&year=$dYear\&comment=$thisEntry";

			print MAIL "$theLink\n";
		}
		print MAIL "You can view the entry here: $newform\?submit=ViewEntry\&year=$dYear\&month=$dMonth\&file=$dFile\n";
		close(MAIL);
	}
	&GetHeaderTemplate;
	my ($string) = "";
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Comment entered</h3>\n";
			$string .= "Your comment has been entered. The blog owner will review your comment.<br><a href=$newform>Rock on, Garth</a>!<Br> Party on, Wayne!";
			$string .= "<p><a href=\"$newform\?submit=ViewEntry\&year=$dYear\&month=$dMonth\&file=$dFile\">Or go back to the entry</a>\n";
		}
	}
	&GetFooterTemplate;
	exit;
}

####### EXPLAIN SMILEYS
sub ExplainSmileys {
	&Header;
	&GetHeaderTemplate;
	my ($string) = "";
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Smileys</h3>\n";
			$string .= ":D = <img src=$sitebase\/smileys\/icon_lol.gif><br>\n";
			$string .= ":\) = <img src=$sitebase\/smileys\/icon_smile.gif><br>\n";
			$string .= ":\( = <img src=$sitebase\/smileys\/icon_sad.gif><br>\n";
			$string .= ":O = <img src=$sitebase\/smileys\/icon_eek.gif><br>\n";
			$string .= ":P = <img src=$sitebase\/smileys\/icon_razz.gif><br>\n";
			$string .= "\;\) = <img src=$sitebase\/smileys\/icon_wink.gif><br>\n";
			$string .= "8\) = <img src=$sitebase\/smileys\/icon_cool.gif><br>\n";
			$string .= "\;\? = <img src=$sitebase\/smileys\/icon_confused.gif><br>\n";
			$string .= "\(__Y__\) = <img src=$sitebase\/smileys\/moon.gif><br>\n";
			$string .= "\:thefinger\: = <img src=$sitebase\/smileys\/thefinger.gif><br>\n";
		}
	}
	&GetFooterTemplate;
}





#################################################
#LINK ROUTINES
#################################################

####### DELETE THIS LINK
sub DeleteThisLink {
	if (! $adminOn) {

		&Error("You are not in administration mode.");
	}
	$link			=	param("link");	
	open (LINKFILE,"$linkFile") || &MyError("Can't open $linkFile. $!");
	@MyLinks=<LINKFILE>;

	close(LINKFILE);
	
	#set count to nothing. I use it later to determine which link to skip
	#when rewriting the links file.
	$count=0;
	
	#for each line in the links file array
	foreach (@MyLinks) {
		
		#if this line matches the number passed to this sub, don't write it
		if ($count == $link) {
			$count++;
			next;
					
		#otherwise, write it and move on. Incrementation operator is outside
		#the loop because I use the "next" operator above.
		} else {
			push (@NewLinks,$_);
		}
		$count++;
	}
	
	#Open the links file and overwrite it, sans the skipped link.
	open (NEWFILE,">$linkFile") || &MyError("Can't overwrite $linkFile. $!");
	foreach (@NewLinks) {
		print NEWFILE "$_";
	}
	close(NEWFILE);
	$title="Link murdered!";
	&Header;
	&GetHeaderTemplate;
	$thingy = "<h3>Link murdered!</h3>\nHow could you? I'm aghast at the coldness of your heart!<br><a href=$newform?submit=Links>Click here to continue.</a>\n";
	foreach (@theTemplate) {
		$_ =~ s/<!--BLOG CONTENT-->/$thingy/;
	}
	&GetFooterTemplate;
	exit;
}

####### EDIT THIS LINK
sub EditThisLink {
	if (! $adminOn) {
		&Error("You aren't in administration mode");
	}
	$category		=	param("category");
	$description	=	param("description");
	$link			=	param("link");

	$url			= 	param("url");
	if ((! $description) || (! $url)) {
		&MyError("You have to enter a link and description. What are you thinking?");
	}
	
	
	#make sure no unacceptable metacharacters are here
	$description =~ s/\n|\r|\|//gi;
	$url =~ s/\n|\r|\|//gi;
	
	#read the existing link file.
	open (LINKFILE,"$linkFile") || &MyError("Can't open $linkFile. $!");
	@MyLinks=<LINKFILE>;

	close(LINKFILE);
	
	#assemble the new link from input parameters.
	$newLink = $category . "\|" . $description . "\|" . $url . "\n";
	
	#replace the relevant line in the array with the new link
	$MyLinks[$link] = $newLink;
	
	#overwrite the links file with the modified array
	open (NEWFILE,">$linkFile") || &MyError("Can't overwrite $linkFile. $!");
	foreach (@MyLinks) {
		print NEWFILE "$_";

	}
	close(NEWFILE);
	
	$title="Link changed!";
	&Header;
	&GetHeaderTemplate;

	$thingy = "<h3>Link changed!</h3>\nSuccess! I changed the link as you requested. Good job, bloke!<br><a href=$newform?submit=Links>Click here to continue.</a>\n";
	foreach (@theTemplate) {
		$_ =~ s/<!--BLOG CONTENT-->/$thingy/;
	}
	&GetFooterTemplate;
	exit;
}

####### DELETE LINK
sub DeleteLink {
	my ($string) = "";
	if (! $adminOn) {
		&Error("You aren't in administration mode");
	}
	#make sure the user really wants to delete this link.
	$link	=	param("link");
	open (LINKFILE,"$linkFile") || &MyError("Can't open $linkFile. $!");
	@MyLinks=<LINKFILE>;
	close(LINKFILE);

	$victim = $MyLinks[$link];
	if (! $victim) {
		&MyError("The item you requested, $link, doesn't exist in the database.");
	}
	chomp($victim);
	($category,$description,$url) = split(/\|/,$victim);
	$title="Delete link";
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Delete link</h3>\n";
			$string .= "<form action=$newform method=POST>\n";
			$string .= "<input type=hidden name=link value=\"$link\">\n";
			$string .= "<input type=hidden name=admin value=$adminMasked>\n";
			$string .= "Are you sure? By pressing the button below, you'll be deleting \"$description\".<br>\n";
			$string .= "<input type=submit name=submit value=\"Delete this link\">\n";
		}
	}
	&GetFooterTemplate;
	exit;
}

####### EDIT LINK
sub EditLink {
	my($string) = "";
	if (! $adminOn) {
		&Error("You aren't in administration mode");
	}
	$link	=	param("link");
	
	#we'll need this to display all available categories
	&GetCategories;
	
	#read in the links
	open (LINKFILE,"$linkFile") || &MyError("Can't open $linkFile. $!");
	@MyLinks=<LINKFILE>;
	close(LINKFILE);
	
	#the correct link to edit is at $link position in the array.
	$victim = $MyLinks[$link];
	
	#if we didn't find the link, something's wrong.
	if (! $victim) {
		&MyError("The item you requested, $link, doesn't exist in the database.");
	}
	chomp($victim);
	
	#split up the link into its requisite parts
	($category,$description,$url) = split(/\|/,$victim);
	
	#display the page with the info we've gleaned
	$title="Edit link";
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Edit link</h3>\n";
			$string .= "<form action=$newform method=POST>\n";
			$string .= "<input type=hidden name=link value=\"$link\">\n";
			$string .= "<input type=hidden name=admin value=$adminMasked>\n";
			$string .= "Category: <select name=category>";
	
	#select the current category in case the user doesn't want to change it
			foreach (@Categories) {
				$string .= "<option name=\"$_\"";
				if ($_ eq $category) {
					$string .= " SELECTED";
				}
				$string .= ">$_</option>";
			}
			$string .= "</select><br>\n";
			$string .= "Description: <input type=text name=description value=\"$description\" size=40><br>\n";
			$string .= "URL: <input type=text name=url value=\"$url\" size=40><br>\n";
			$string .= "<input type=submit name=submit value=\"Edit this link\">\n";
		}
	}
	&GetFooterTemplate;
	exit;
}

####### ADD LINK
sub AddLink {
	if (! $adminOn) {
		&Error("You aren't in administration mode");
	}
	$description	=	param("description");
	$link			=	param("link");
	$category		=	param("category");
	if ((! $description) || (! $link)) {
		&MyError("Dude! You have to enter a link and description.");
	}

	
	#clear out metacharacters
	$description =~ s/\n|\r|\|//gi;
	$link =~ s/\n|\r|\|//gi;
	
	#Create a new array with its first item as the new link
	$LinkArray[0] = $category . "\|" . $description . "\|" . $link;

	#be sure count is 1, not 0
	$count = 1;
	
	#read in the old link file, putting each line in the new array
	open (LINKFILE,"$linkFile") || &MyError("Can't open $linkFile. $!");
	while (<LINKFILE>) {

		chomp($_);
		if ($_ ne "") {
			$LinkArray[$count] = $_;
			$count++;
		}
	}
	close(LINKFILE);
	
	#reopen link file, this time to overwrite it with the new array.
	open(LINKER,">$linkFile") || &MyError("Can't overwrite $linkFile. $!");
	foreach (@LinkArray) {
		print LINKER $_ . "\n";
	}
	close(LINKER);
	
	#display success to user.
	$title="Link added";
	&Header;
	&GetHeaderTemplate;
	$thingy = "<h3>Link added</h3>\nI have added the link to the list. I know you want to see the whole list of links now, don't you? You KNOW you do!<br>\n<a href=\"$newform\?submit=Links\">Click here to display ALL the links.</a>\n";
	foreach (@theTemplate) {
		$_ =~ s/<!--BLOG LINKS-->/$thingy/;
	}
	&GetFooterTemplate;
	exit;
}

####### GET CATEGORIES
sub GetCategories {
	#categories are in a separate file from the links file so
	#it will be less complicated to parse. This subroutine creates
	#an array with the categories in it. That's all it does.

	open(CATS,"$catFile") || &MyError("Can't open $catFile. $!");
	while(<CATS>) {
		if ($_ ne "") {
			chomp($_);

			push (@Categories,$_);
		}
	}
	close(CATS);
}

####### ENTER LINK
sub EnterLink {
	my ($string) = "";
	if (! $adminOn) {
		&Error("You aren't in administration mode");
	}
	$title="Enter a link";
	&GetCategories;
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>Enter a link for the site</h3>\n";
			$string .= "<form action=$newform method=POST>\n";
			$string .= "<input type=hidden name=admin value=$adminMasked>\n";
			$string .= "Category: <select name=category>\n";
			foreach (@Categories) {

				$string .= "<option name=\"$_\">$_</option>";

			}

			$string .= "</select><br>\n";

			$string .= "Link description: <input type=text name=description><br>\n";
			$string .= "Link URL: <input type=text name=link value=\"http://\"><br>\n";

			$string .= "<input type=submit name=submit value=\"Add link\">\n";

			$string .= "</form>";

		}
	}
	&GetFooterTemplate;

	exit;
}

####### DISPLAY ALL LINKS
sub DisplayAllLinks {
	my($string) = "";
	&GetCategories;
	$title="Links";
	&Header;
	&GetHeaderTemplate;
	#set scalar that determines whether table row is colorized or not
	$ony =1;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h1>Links</h1>\n";
			$string .= "All links open in new windows, regardless of the setting above<Br>\n";
			if ($adminOn) {
				$string .= "<center><b><a href=\"$newform?submit=Enter link\">Enter a link</a></b>\n";
				$string .= "</center>\n";
			}
			#read in the links file
			open (THEFILE,"$linkFile") || &MyError("Can't open $linkFile. $!");
			$count=0;
			$string .= "<table border=0 cellpadding=2 cellspacing=0>\n";
	
			#while the file is open
			while (<THEFILE>) {
				chomp($_);

				#if this line has text, it has a link
				if ($_ ne "") {
			
					#parse through each category to see which this link goes in
					foreach $cat (@Categories) {

						#split up the link to get its category
						($coot,$shite,$sheite)=split(/\|/,$_);
						if ($coot eq $cat) {
					
							#Add count to the end, because when I display this link, I need
							#to know which position it occupied in the file in case I want to 
							#edit it or delete it.
							$Cats{$cat} .= "\^" . $_ . "\|" . $count;
						}
					}
				$count++;
				}

			}
			close(THEFILE);

			#Now the links are in a hash separated by category; parse each one
			foreach $key (@Categories) {

				#split this hash item into its requisite parts. Put them in an array.
				@TheCat=split(/\^/,$Cats{$key});
				$string .= "<tr><td colspan=2><center><h3>$key</h3></td></tr>\n";
		
				#now parse the array for each link
				foreach (@TheCat) {

			
					#if this item has text, it has a link
					if ($_ ne "") {
						$string .= "<tr><td valign=top";
				
						#see whether this row should be colorized
						if ($ony == 1) {
							$string .= " bgcolor=$alternatingColor";
						}
						$string .= "><font size=$tableFontSize>";

				
						#split the link line up into its requisite parts and display them
						($ccat,$description,$link,$position) = split(/\|/,$_);

						$string .= "$description</td>";
						$string .= "<td";
						if ($ony == 1) {
							$string .= " bgcolor=$alternatingColor";
						}
						$string .= ">";
						$maskedLink = &MaskString($link);
						$string .= "<font size=$tableFontSize><B><a href=\"$newform?submit=Offsite&u=$maskedLink\" target=\"_blank\" onMouseOver=\"window.status=\'$link\'\;return true\" onMouseOut=\"window.status=\'\'\;return true\">CLICK HERE</a></b><br><font size=$tableFontSize>";
						if ($adminOn) {
							$string .= "(<a href=\"$newform?submit=Edit link\&link=$position\">EDIT</a>)&nbsp;";
							$string .= "(<a href=\"$newform?submit=Delete link\&link=$position\">DELETE</a>)";
						}
						$string .= "</font></td></tr>\n";

						#reset row-shading scalar to whatever it currently isn't.
						if ($ony == 1) {

							$ony = 0;
						} else {
							$ony = 1;

						}
					}
				}
			}	
			$string .= "</table>\n";
			$string .= "\n";
		}
	}
	&GetFooterTemplate;

	exit;
}










#################################################
#PARSING ROUTINES
#################################################

####### SET CONSTANT VARIABLES
sub SetConstantVariables {
	#later called by date routines to delineate which month is which
	@MonthList=('January','February','March','April','May','June','July','August',
                'September','October','November','December');
	#same, but for days
	@DayList=('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
	@YearsList = ("2003","2004","2005","2006","2007","2008","2009","2010");

	#system clock runs on 24-hour time, so I have to translate. 
	@CivilianTime=('12','1','2','3','4','5','6','7',
                   '8','9','10','11','12','1','2','3',
                   '4','5','6','7','8','9','10','11');

	$ony = 1;
}

####### CHECK ADMIN
sub CheckAdmin {
	#$admin = param("admin");
	#$cleanAdmin = &UnmaskString($admin);
	#if ($cleanAdmin eq $password) {
	if (&FetchCookies('blogAdmin')) {
		$adminOn = 1;
	}
	#$adminString = $cleanAdmin;
	#$adminMasked = $admin;
}

####### CHECK PASS
sub CheckPass {
	my ($string) = "";
	if (param("password") ne $password) {
		&MyError("Silly rabbit! You can't administrate the blog because Trix are for kids and you got the password wrong.");
	}
	#$passPass = param("password");
	#$printPass = &MaskString($passPass);
	#&Header;
	&BakeCookies("blogAdmin","true");
	print "\n";
	&GetHeaderTemplate;
	#warning! This is in NO WAY secure. It only puts your string into hexadecimal
	#Its purpose is to prevent people from stealing your password by looking over
	#your shoulder, but it's NOT secure, so don't think you're getting encryption
	#here; you're not.
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<a href=$newform>Click here to administrate this blog</a>\n";
			if (! &FetchCookies('blogExclude')) {
				$string .= "<p><a href=$newform?submit=Exclude>Click here to exclude this browser from logging</a>\n";
			} else {
				$string .= "<p>You are excluded from logging in this blog.";
			}
		}
	}
	&GetFooterTemplate;
	exit;
}

####### EXCLUDE
sub Exclude {
	print "Content-type:text/html\n";
	&Error("$!") unless &SetCookieExpDate('Mon, 09-Feb-2009 00:00:00 GMT');

	&BakeCookies("blogExclude","true");
	print "\n";
	&GetHeaderTemplate;
	foreach (@theTemplate) {
		$thingy = "You are now excluded from logging. <a href=$newform>Click here to continue</a>\n";
		$_ =~ s/<!--BLOG CONTENT-->/$thingy/;
	}

	&GetFooterTemplate;
	exit;
}
####### FETCH COOKIES
# this is modified from Matt Wright's cookie.lib I put it here so

# you wouldn't have to require the library
sub FetchCookies 
{
	local(@ReturnCookies) = @_;
    local($cookie_flag) = 0;
    local($cookie,$value);
    if ($ENV{'HTTP_COOKIE'}) 
    {
        if ($ReturnCookies[0] ne '') 
        {
            foreach (split(/; /,$ENV{'HTTP_COOKIE'})) 
            {
                ($cookie,$value) = split(/=/);

                foreach $char (@Cookie_Decode_Chars) 
                {

                    $cookie =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                    $value =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                }

                foreach $ReturnCookie (@ReturnCookies) 
                {

                    if ($ReturnCookie eq $cookie) 
                    {
                        $Cookies{$cookie} = $value;
                        $cookie_flag = "1";
                    }
                }
            }

        }
        else
        {
			foreach (split(/; /,$ENV{'HTTP_COOKIE'})) 
            {
                ($cookie,$value) = split(/=/);

                foreach $char (@Cookie_Decode_Chars) 
                {
                    $cookie =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                    $value =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                }

                $Cookies{$cookie} = $value;
            }
            $cookie_flag = 1;
        }
    }

    return $cookie_flag;
}


######## BAKE COOKIES
# this is modified from Matt Wright's cookie.lib I put it here so
# you wouldn't have to require the library. 

sub BakeCookies 

{
    local(@cookies) = @_;
    local($cookie,$value,$char);


    while( ($cookie,$value) = @cookies ) 
    {
        foreach $char (@Cookie_Encode_Chars) 
        {
            $cookie =~ s/$char/$Cookie_Encode_Chars{$char}/g;

            $value =~ s/$char/$Cookie_Encode_Chars{$char}/g;
        }

        print 'Set-Cookie: ' . $cookie . '=' . $value . ';';
        
        if ($Cookie_Exp_Date) {
            print ' expires=' . $Cookie_Exp_Date . ';';
        }

        print "\n";

        shift(@cookies); shift(@cookies);
    }
}

####### SET COOKIE EXP DATE
sub SetCookieExpDate {
	# this is modified from Matt Wright's cookie.lib I put it here so
	# you wouldn't have to require the library. 
    if ($_[0] =~ /^\w{3}\,\s\d{2}\-\w{3}-\d{4}\s\d{2}\:\d{2}\:\d{2}\sGMT$/ ||
        $_[0] eq '') {
        $Cookie_Exp_Date = $_[0];
        return 1;
    }
    else {
        return 0;
    }
}


####### MASK STRING
sub MaskString
{
	#Requires caller to pass unhexed string as argument

	#


	#WARNING!! This is in NO WAY secure. It simply makes it 
	#harder to read. It is EASY to crack if someone knows hexadecimal.
	my($MaskedString) = "";
	my($P)=$_[0];
	@Numberized = unpack("C*",$P);#convert to ascii equivalents
	foreach $num (@Numberized)
	{
		$MaskedString .= sprintf("%02x",$num);#convert to hexadecimal
		            									#Also, make sure hex numbers
		            									#have two characters. This is
		            									#because I count on them
		            									#having two characters when
		            									#I unscramble them below.
	}
	return $MaskedString;
}



####### GET ADMIN PASS
sub GetAdminPass {
	my($string) = "";
	&Header;
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {

		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<form action=$newform method=POST>\n";
			$string .= "<input type=hidden name=submit value=CheckPass>\n";
			$string .= "Password: <input type=password name=password><br>\n";
			$string .= "<input type=submit value=\"Verify me\"></form>\n";
		}
	}
	&GetFooterTemplate;
	exit;
}

####### PARSE INCOMING COMMANDS
#incoming commands are headers passed via the http requests.
#I use them to tell the script what to do. This list of 
#if/else statements simply looks to see what the user wants to do.
sub ParseIncomingCommands {
	
	
	if ($Submit eq "Configure the blog") {
		&WriteConfiguration; 
	}
	
	
	
	if (! $Submit) {
		if (! $adminOn) {
			&LogIt;
		}
		&ListLatestFiles;
	} elsif ($Submit eq "Configure") {
		if (! $adminOn) {
			&Error("You must be in administration mode to configure the blog.");
		}
		&ConfigurationScreen;
	} elsif ($Submit eq "Offsite") {
		&Offsite;
	} elsif ($Submit =~ /admin/gi) {
		&GetAdminPass;
	} elsif ($Submit eq "CheckPass"){
		&CheckPass;
	} elsif ($Submit eq "ListAll") {
		if (! $adminOn) {
			&LogIt;
		}
		&ListAllFiles;
	} elsif ($Submit eq "ShowMonth") {
		if (! $adminOn) {
			&LogIt;
		}
		&ShowMonth;
	} elsif ($Submit eq "Edit") {
		&EditFile;
	} elsif ($Submit eq "EditComment") {
		&EditComment;
	} elsif ($Submit eq "DeleteComment") {
		&DeleteComment;
	} elsif ($Submit eq "EditTheComment") {
		&EditTheComment;
	} elsif ($Submit eq "Comment") {
		&Comment;
	} elsif ($Submit eq "Enter my comment") {
		&EnterComment;
	} elsif ($Submit eq "Delete") {
		&DeleteFile;
	} elsif ($Submit eq "Delete this file") {
		&DeleteThisFile;
	} elsif ($Submit eq "Write") {
		&WriteEntry;
	} elsif ($Submit eq "Add this entry") {
		&AddThisEntry;
	} elsif ($Submit eq "ApproveComment") {
		&ApproveComment;
	} elsif ($Submit eq "ViewEntry") {
		if (! $adminOn) {
			&LogIt;
		}
		&ViewEntry;
	} elsif ($Submit eq "ViewSearch") {
		$search = "true";
		$searchedString = param("String");
		if (! $adminOn) {
			&LogIt;
		}
		&ViewEntry;
	} elsif ($Submit eq "ViewLog") {
		&ViewLog;
	}  elsif ($Submit eq "ViewCommentsLog") {
		&ViewCommentsLog;
	} elsif ($Submit eq "Edit this file") {
		&EditThisFile;
	} elsif ($Submit eq "ProcessImages") {
		$titl = param("title");
		$totl = param("totalIterations");
		$cont = param("content");
		$iter = param("iteration");
		&ProcessImages($iter,$totl,$titl,$cont);
	} elsif ($Submit eq "Upload images") {
		&UploadImage;
	} elsif ($Submit eq "ProcessMovies") {
		$titl = param("title");
		$totl = param("totalIterations");
		$cont = param("content");
		$iter = param("iteration");
		&ProcessMovies($iter,$totl,$titl,$cont);
	} elsif ($Submit eq "Upload movies") {
		&UploadMovie;
	} elsif ($Submit eq "Search") {

		if (! $adminOn) {
			&LogIt;
		}
		&Search;
	} elsif ($Submit eq "Links") {
		if (! $adminOn) {
			&LogIt;
		}
		&DisplayAllLinks;
	} elsif ($Submit eq "Enter link") {
		&EnterLink;
	} elsif ($Submit eq "Edit link") {
		&EditLink;
	} elsif ($Submit eq "Edit this link") {
		&EditThisLink;
	} elsif ($Submit eq "Delete this link") {
		&DeleteThisLink;

	} elsif ($Submit eq "Delete link") {
		&DeleteLink;

	} elsif ($Submit eq "Email me when blog's updated") {
		&AddUpdateName;
	} elsif ($Submit eq "Add link") {
		&AddLink;
	} elsif ($Submit eq "Exclude") {
		&Exclude;
	} elsif ($Submit eq "Rank this entry") {
		&RankThisEntry;
	} elsif ($Submit eq "DisplayAllRankedFiles") {
		if (! $adminOn) {
			&LogIt;
		}
		&DisplayAllRankedFiles;
	} elsif ($Submit eq "ExplainSmileys") {
		&ExplainSmileys;
	} else {
		&MyError("I don't understand what you want to do.");
	}
}

####### GET RIGHT NOW
#sets filename based on this very second.
sub GetRightNow {
	$newFile = "/Pages/";
	$newFile .= $Year . "/" . $MonthList[$Month] . "/" . $DayOfMonth . "-" . $Hours;
	$newFile .= "." . $Minutes . "." . $Seconds;	
	print "New=$newFile<br>\n";
}

####### GET TIME NOW
#gets time and sets variables based on it.
sub GetTimeNow
{
	@time=localtime(time);
	$Seconds=$time[0];
	$Minutes=$time[1];
	$Hours=$time[2];
	$DayOfMonth=$time[3];
	$Month=$time[4];
	$Year=$time[5] + 1900;
	$WeekDay=$time[6];
	$DayOfYear=$time[7];
	$IsDaylightSaving=$time[8];
	$FormattedMinutes = sprintf("%02d", $Minutes);
	$FormattedSeconds = sprintf("%02d", $Seconds);

	#Need to know which month this is so I can figure out
	#which are the most recent postings.
	$thisMonth = $MonthList[$Month];
	$lastMonth = $MonthList[$Month-1];

	#If this is January, last month was last year.
	if ($Month < 1) {
		$lastMonth="December";
		$lastYear=$Year-1;
	}
}







#################################################
#IMAGE, MOVIE ROUTINEs
#################################################

####### UPLOAD Movie
sub UploadMovie {	
	#same almost as upload Image routine.
	$| = 1;
	$theTitle = param("title");
	$theContent = param("content");
	$thedir = param("filename");
	$totalIterations = param("totalIterations");
	for ($i=1; $i<=$totalIterations; $i++) {
		$Filename = "_" . $i . ".mpg";
		$fileKey = "movie_" . $i;
		$FileHandle = param($fileKey);

		$theNewFile = $thedir . $Filename;
		if (!open(OUTFILE,">$theNewFile")) {
			&MyError("Can't create $theNewFile. $!");
		}
		undef $BytesRead;
		undef $Buffer;
		while ($Bytes = read($FileHandle,$Buffer,1024)) {
			$BytesRead += $Bytes;
			print OUTFILE $Buffer;
		}
		push(@FilesWritten,"$Filename");
		$TotalBytes += $BytesRead;
		$Confirmation{$FileHandle} = $BytesRead;
		close($FileHandle);
		close(OUTFILE);
		chmod(0666,"$theNewFile");
	}
	$FilesUploaded = scalar(keys(%Confirmation));

	&Header;
	print "$FilesUploaded images uploaded.";
	print "<a href=$newform>Go back to the main page</a>\n";
	exit;
}


####### UPLOAD IMAGE
sub UploadImage {
	#This subroutine actually uploads a file from the user's hard drive onto the Internet.
	#clear buffer
	$| = 1;
	#this is the title of the article, not the page
	$theTitle = param("title");

	#contains the content of the article
	$theContent = param("content");
	
	#this is the name of the file.
	$thedir = param("filename");
	
	#this is how many images there are. "iterations" is left over from a previous
	#idea on parsing images one at a time. This is an example of "Lazy-as-a-virtue."
	#Or at least that's what I tell myself. I talk to myself a lot.
	$totalIterations = param("totalIterations");

	#need to upload each image specified when this script was called
	for ($i=1; $i<=$totalIterations; $i++) {
		
		#begin building this image's filename.
		$Filename = "_" . $i . ".jpg";
		
		#I need to look in the content of the article for this image number
		#build that key right here
		$fileKey = "picture_" . $i;

		
		#get the value (local filename) for the key provided.
		$FileHandle = param($fileKey);
		
		#set the remote filename to the name I've created for this image
		$theNewFile = $thedir . $Filename;
		
		#try to create the new image. Choke if it won't open.
		if (!open(OUTFILE,">$theNewFile")) {
			&MyError("Can't create $theNewFile. $!");
		}
		
		#clear out reporting variables
		undef $BytesRead;
		undef $Buffer;
		
		#read the local file byte by byte, printing it to the remote file I just created
		while ($Bytes = read($FileHandle,$Buffer,1024)) {
			$BytesRead += $Bytes;
			print OUTFILE $Buffer;
		}
		
		#put this filename in my written array in case I want to know later.
		push(@FilesWritten,"$Filename");
		
		#This only comes into play if I want to limit uploaded bytes
		$TotalBytes += $BytesRead;
		
		#Tells how many bytes this image is for later reference.
		#I don't actually USE this, but I COULD IN THE FUTURE -- you never know.
		#I'm unpredictable like that.
		$Confirmation{$FileHandle} = $BytesRead;

		#close the local file
		close($FileHandle);
		
		#close the remote file
		close(OUTFILE);
		
		#set permissions for new remote file
		chmod(0666,"$theNewFile");
	}	
	$FilesUploaded = scalar(keys(%Confirmation));
	
	#add the text of the article finally
	&Header;
	print "$FilesUploaded images uploaded.";
	print "<a href=$newform>Go back to the main page</a>\n";
	exit;

}

####### PROCESS MOVIES

sub ProcessMovies {
	#largely the same subroutine as ProcessImages. See comments there for more information.
	#probably should have used the same subroutine with an input variable for whether it was
	#a movie or a picture. Dammit.
	$theTitle = $title;
	$theContent = $content;
	@Matches = ($theContent =~ /\[movie\]/ig);
	$count = 0;
	foreach (@Matches) {
		$count++;
	}
	$totalIterations = $count;
	@Everything = split(/\[movie\]/,$theContent);
	for ($i=1;$i<=$totalIterations+1; $i++) {
		if ($i <= $count) {
			$replacer = "<a href=\"" . $sitebase . "/" . $newfile . "_" . $i . ".mpg\">MOVIE</a>";
			$interimScalar = $Everything[$i-1] . $replacer . "\n";
		} else {


			$interimScalar = $Everything[$i-1];
		}
		if ($i == 1) {
			$toRecord = $interimScalar;
		} else {
			$toRecord .= $interimScalar;
		}
	}
	
	#I also need to display a form field so you can upload the image. 
	for ($i=1;$i<=$totalIterations;$i++) {
		$replacer = "<br><b>(choose a movie file to go here)</b>:<Br><input type=\"FILE\" name=\"movie_" . $i . "\">\n";
		$NewScalar = $Everything[$i-1] . $replacer;
		if ($i == 1) {
			$toDisplay = $NewScalar;
		} else {
			$toDisplay .= $NewScalar;
		}
	}

	
	#use a regex to replace newline characters with html tags, since newlines will mess up my datafile.


	$toDisplay =~ s/\n/\<br\>\n/gi;
	
	#######
	#write this file (the text content)
	open(NEWFILE,">$newfile") || &MyError("Can't open $newfile. $!");
	print NEWFILE "$title\n";
	print NEWFILE "$toRecord";
	close(NEWFILE);
	
	#display image choices to the user
	&Header;
	print "<h1>Upload movie</h1>\n";
	print "<h4>Below, you'll be asked to upload movies</h4>\n";
	print "<form action=$newform method=POST ENCTYPE=\"multipart/form-data\">\n";	

	print $toDisplay;
	print "$firstLine";
	print "<input type=hidden name=totalIterations value=$totalIterations>\n";

	print "<input type=hidden name=filename value=\"$newfile\">\n";
	print "<input type=submit name=submit value=\"Upload movies\">\n";	
	exit;
}

####### PROCESS IMAGES
sub ProcessImages {
	#If you're wanting to upload an image, this subroutine handles the request
	#and gets everything ready to go.
	$theTitle = $title;
	$theContent = $content;
	
	#the RegEx statement returns the matches found. I dump them into
	#an array, which I later count to determine how many images to upload.
	@Matches = ($theContent =~ /\[picture\]/ig);
	$count = 0;
	foreach (@Matches) {
		$count++;
	}
	$totalIterations = $count;
	
	#Make an array out of the entry, splitting it into items based on the 
	#[picture] thingy.
	@Everything = split(/\[picture\]/,$theContent);

	#create the content to write to disk. What I'm actually doing is making an html
	#tag to represent each image. No matter what the image is named on your hard drive,
	#I rename it to the name of the text file that contains the journal entry, plus a
	#number representing which image this is in the sequence of images. For instance,
	#if the journal entry's title is "1.2.03.txt", then the first image would become
	#1.2.03_1.jpg", the next image would become 1.2.03_2.jpg
	for ($i=1;$i<=$totalIterations+1; $i++) {
		if ($i <= $count) {
			$replacer = "<img src=\"" . $sitebase . "/" . $newfile . "_" . $i . ".jpg\">";
			$interimScalar = $Everything[$i-1] . $replacer . "\n";
		} else {
			$interimScalar = $Everything[$i-1];
		}
		if ($i == 1) {
			$toRecord = $interimScalar;
		} else {
			$toRecord .= $interimScalar;
		}
	}
	

	#I also need to display a form field so you can upload the image. 
	for ($i=1;$i<=$totalIterations;$i++) {

		$replacer = "<br><b>(choose an image to go here)</b>:<Br><input type=\"FILE\" name=\"picture_" . $i . "\">\n";
		$NewScalar = $Everything[$i-1] . $replacer;
		if ($i == 1) {
			$toDisplay = $NewScalar;
		} else {
			$toDisplay .= $NewScalar;
		}
	}
	
	#use a regex to replace newline characters with html tags, since newlines will mess up my datafile.
	$toDisplay =~ s/\n/\<br\>\n/gi;
	
	#######
	#write this file (the text content)
	open(NEWFILE,">$newfile") || &MyError("Can't open $newfile. $!");
	print NEWFILE "$title\n";
	print NEWFILE "$toRecord";
	close(NEWFILE);
	
	#display image choices to the user
	&Header;
	print "<h1>Upload picture</h1>\n";
	print "<h4>Below, you'll be asked to upload images</h4>\n";
	print "<form action=$newform method=POST ENCTYPE=\"multipart/form-data\">\n";	
	print $toDisplay;
	print "$firstLine";
	print "<input type=hidden name=totalIterations value=$totalIterations>\n";
	print "<input type=hidden name=filename value=\"$newfile\">\n";
	print "<input type=submit name=submit value=\"Upload images\">\n";	
	exit;
}







#################################################
#SEARCH ROUTINE
#################################################

####### SEARCH
sub Search {
	$searchString = param("SearchString");
	
	#obviously, you can't search for nothing. Stop them from doing that.
	if (! $searchString) {
		&MyError("You can't search without a search string, silly.");
	}

	#blank out the variable counting how many files I've searched.
	$filesopened=0;
	
	#blank out the matches variable, too.
	$match=0;
	
	#blank out the titles array (it will contain the titles of matched entries).
	@titles=();
	
	#for each directory representing a year
	foreach $FileYear (@YearsList) {
		
		#foreach subdirectory representing a month
		foreach $FileMonth (@MonthList) {
			
			#set this directory's name as the directory to open
			$theDir = $PageBase . $FileYear . "/" . $FileMonth . "/";
			
			#blank out the list of files in the directory
			@CurrentFiles=();
			
			#open the directory (commented out error messages, because I may search
			#some directories that don't exist (as in months that happened before the
			#script was installed))
			opendir(THIS,"$theDir");# || &MyError("Can't open $theDir in Search sub. Reason: $!");
			@CurrentFiles=readdir(THIS);
			closedir(THIS);
			
			#if the third item in the array exists, that means there's at least one file in the 
			#directory. Unix's directory markers (.. and .) take up the first two places.
			if ($CurrentFiles[2]) {
				
				#parse each item in the array
				foreach $cur (@CurrentFiles) {
					
					#if the file ends in ".txt" and does NOT begin with "comment"
					#then it's a file containing an entry 
					#######
					# HERE'S WHERE I NEED TO PUT THE LOGIC TO SEARCH ONLY 
					# COMMENTS OR ONLY ENTRIES BASED ON WHICH BOX IS CHECKED
					#######
					
					if ($cur =~ /.txt\b/){# && ($cur !~ /^comment/)) {

						
						#increment the filesopened count. Don't remember why.
						$filesopened++;
						
						#set this file's location so I can open it later.
						$theFile = $theDir . $cur;
						
						#push the file's location onto the end of the filelist
						#directory.
						push (@fileList,$theFile);
						
						#open the file
						open (FILEY,"$theFile") || &MyError("Can't open $theFile. $!");
						@FCont=<FILEY>;
						close(FILEY);


						
						#look at each line of the file
						foreach $cunt (@FCont) {
							
							#if the line contains the searchstring
							if ($cunt =~ /$searchString/i) {
								
								#if the file's title hasn't already been flagged as
								#a file that has a match in it (prevents duplicate
								#matches because one is sufficient)
								if (! $titles{$FCont[0]}) {
									
									#add this title to the titles hash
									$titles{$FCont[0]} = 1;
									
									#Add this file's information to the second dimension
									#of the hash that contains all the matches.
									#%holder is the base hash.
									#%holder{0} is the first match's second-dimension
									#%holder{1} is the second match's second-dimension
									if ($cur =~ /comment_/) {
										$commie=1;
									} else {
										$commie=0;
									}
									$cur =~ s/comment_//gi;
									$holder{$match}{"Month"}=$FileMonth;
									$holder{$match}{"Year"}=$FileYear;
									$holder{$match}{"File"}=$cur;
									if ($commie == 1) {
										$holder{$match}{"Title"} = "From a comment for $FileMonth $FileYear $cur";
										$holder{$match}{"Title"} =~ s/.txt//gi;
										($on,$namey,$parag)=split(/\|/,$cunt);
										$holder{$match}{"Graf"}="Comment by $namey: $parag";
									} else {
										$holder{$match}{"Title"}=$FCont[0];
										$holder{$match}{"Graf"}=$cunt;
									}

									push(@Matches,1);
									#increment match so i don't overwrite earlier matches
									$match++;
								}
							}
						}

					}
				}
			}
		}
	}
	&Header;

	$title="Search results";
	my ($string) = "";
	&GetHeaderTemplate;
	foreach $string (@theTemplate) {
		if ($string =~ /<!--BLOG CONTENT-->/) {
			$string = "<h3>SearchResults</h3>\n";	
			$string .= "Files searched: $filesopened<br>\n";
			$string .= "<table border=0 cellpadding=2 cellspacing=0>\n";
	
			#if the first dimension of the holder hash has a value, at least one match
			#has been found.
			if ($holder{0}) {
		
				#tell the user how many matches I found.
				$string .= "<tr><td colspan=2><font size=$tableFontSize face=$tableFontFace>Found " . $match . " documents containing \"$searchString\":</td></tr>\n";
		
				#set boolean to true
				$bool=1;
		
				#for each match
				$i=0;
				#for($i=0;$i<=$match;$i++) {
					foreach (@Matches) {
					#make sure this item contains a filename before I print it
					if ($holder{$i}{"File"} ne "") {
				
						#set the link to reflect the actual file that had the match
						$theLink = "submit=ViewSearch\&month=" . $holder{$i}{"Month"};
						$theLink .= "\&year=" . $holder{$i}{"Year"};
						$theLink .= "\&file=" . $holder{$i}{"File"};
				
						#add the searchstring to the link so it'll be highlighted in the
						#page that results from clicking on the link.
						$theLink .= "\&String=" . $searchString;
				
						#split up the time and day for the file

						($theDay,$theTime) = split(/-/,$holder{$i}{"File"});

						#open a new row
						$string .= "<tr><td";
				
						#if the boolean is true, color this row
						if ($bool == 1) {
							$string .= " bgcolor=$alternatingColor";

						}
				
						#print the link
						$string .= " valign=top><font size=$tableFontSize face=$tableFontFace><a href=\"$newform\?" . $theLink . "\" target=_new>";
				
						#print the name of the article
						$string .= $holder{$i}{"Title"} . "</a><br>" . $holder{$i}{"Month"};
				
						#close the row, open a new one

						$string .= " " . $theDay . ", " . $holder{$i}{"Year"} . "</td><td";
				
						#if the boolean is true, colorize

						if ($bool == 1) {
							$string .= " bgcolor=$alternatingColor";
						}
						$string .= " valign=top><font size=$tableFontSize face=$tableFontFace>";
				
						#print the paragraph containing the matched string
						$theText = $holder{$i}{"Graf"};
				
						#bold the matched string in the paragraph.
						$theText =~ s/$searchString/<b>$searchString<\/b>/gi;
						$string .= "\"$theText\"</td></tr>\n";
				
						#set the boolean to whatever is appropriate for the next iteration
						if ($bool == 1) {
							$bool=0;
						} else {
							$bool=1;
						}
						$i++;
					}
				}
		
			#there were no matches found. Abandon ship.
			} else {
				$string .= "<tr><td>No matches found for $searchString.</td></tr>";
			}
	
			#close the table and wrap things up.
			$string .= "</table>\n";
		}
	}
	&GetFooterTemplate;
	exit;	
}






#################################################
# CONFIGURATION ROUTINES
#################################################
####### GET CONFIGURATION INFO
sub GetConfigurationInfo {
	#reads the configuration file if it exists. If it doesn't, it asks the user to create one.
	open(CONFIG,"$configuration") || &ConfigurationScreen("First Run");
	@Config=<CONFIG>;
	close(CONFIG);
	&GetConfigData;
}

####### GET CONFIG DATA
sub GetConfigData {
	#actually gets the configuration data and puts it into a hash.
	foreach (@Config) {
		chomp ($_);
		if ($_ ne "") {
			$unmaskedConfig = $_;
			@CPairs = split(/\|/,$unmaskedConfig);
			foreach $Cpair (@CPairs) {
				($CKey,$CValue) = split(/=/,$Cpair);
				$config{$CKey}=$CValue;
			}
		}
	}
	
	#set the global variables based on configuration data.
	$alternatingColor					=	$config{alternatingColor};
	$borderColor						=	$config{borderColor};
	$commentBackground				=	$config{commentBackground};
	$commentBorder					=	$config{commentBorder};
	$tableFontFace					=	$config{tableFontFace};
	$tableFontSize					=	$config{tableFontSize};
	$headlineFontSize					=	$config{headlineFontSize};
	$sitehome						=	$config{serverName};
	$mydomain						=	$sitehome;
	$myName						=	$config{thisScript};
	$myName						=~	s/$scriptName//;					
	$sitebase						=	$sitehome . $myName;
	$PageBase						=	$config{PageBase};
	$newform						=	$sitebase . $scriptName;
	$password						=	$config{password};
	$blogTitle						=	$config{blogTitle};
	$mailprog						=	$config{sendmail};
	$toMail							=	$config{toMail};
	$mailfile							=	$config{mailfile};
	$greatestHitsFile					=	$config{greatestHitsFile};
	$linkFile							=	$config{linkFile};
	$catFile							=	$config{catFile};
	$notifyMeOnComment				=	$config{notifyMeOnComment};
	$requireMyApprovalOnComments	=	$config{requireMyApprovalOnComments};
	$numberOfTopEntries				=	$config{numberOfTopEntries};
	$blogTemplate					=	$config{blogTemplate};
	$displayCommentWebPages			=	$config{displayCommentWebPages};
	$displayCommentEmailAddy			=	$config{displayCommentEmailAddy};
	$commentRequestString			=	$config{commentRequestString};
	$logfile							=	$config{logfile};
	$excludeOwnerFromLogging			=	$config{excludeOwnerFromLogging};
	$hitsPerLogPage					=	$config{hitsPerLogPage};
	$logComments					=	$config{logComments};
	$commentsLog					=	$config{commentsLog};
}

####### WRITE CONFIGURATION
sub WriteConfiguration {
	#called when the user has entered his or her configuration information.
	
	#need these variables to call this script again if the user has entered bad information
	$myScript		=	$ENV{'SCRIPT_NAME'};
	$serverName		=	$ENV{'SERVER_NAME'};
	$clickMe			=	"<a href=$myScript>Click here.</a>\n";
	
	#make sure both passwords user entered match each other.
	if (param(password) ne param(password2)) {
		&MyError("Your passwords do not match. You must have a single password you can remember, or you won't be able to administer your blog. $clickMe");
	}
	
	#make sure these fields are present, or there's going to be problems.
	@NeededList=("sendmail","serverName","password","toMail");
	foreach (@NeededList) {
		if (! param($_)) {
			&MyError("This program will not run unless $_ is specified. $clickMe");
		}
	}
	
	#user's e-mail address must be an actual e-mail addres or sendmail will freak
	if (param(toMail) !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$/) {
		&MyError("Your e-mail address does not appear to be valid. You entered: param(toMail) $clickMe");
	}
	my($str)	;
	#assemble string to write to config file
	$str		=	param("sendmail");
	$str		=~ s/\||(\.\.\/)//gi;
	$str		=~ s/\n|\r/<br>/gi;
	$configString = "sendmail=" . $str . "\|";
	
	$str		=	param("serverName");
	$str		=~ s/\||(\.\.\/)//gi;
	$str		=~ s/\n|\r/<br>/gi;
	$configString .= "serverName=" . $str . "\|";
	
	$str		=	param("thisScript");
	$str		=~ s/\||(\.\.\/)//gi;
	$str		=~ s/\n|\r/<br>/gi;
	$configString .= "thisScript=" . $str . "\|";
	
	$str		=	param("commentRequestString");
	$str		=~ s/\||(\.\.\/)//gi;
	$str		=~ s/\n|\r/<br>/gi;
	$configString .= "commentRequestString=" . $str . "\|";
	$configString .= "hitsPerLogPage=" . param("hitsPerLogPage") . "\|";
	$configString .= "commentBorder=" . param("commentBorder") . "\|";
	$configString .= "borderColor=" . param("borderColor") . "\|";
	$configString .= "commentBackground=" . param("commentBackground") . "\|";
	$configString .= "tableFontFace=" . param("tableFontFace") . "\|";
	$configString .= "alternatingColor=" . param("alternatingColor") . "\|";
	
	$str		=	param("password");
	$str		=~ s/\||(\.\.\/)//gi;
	$str		=~ s/\n|\r/<br>/gi;
	$configString .= "password=" . $str . "\|";
	$configString .= "blogTitle=" . param("blogTitle") . "\|";
	$configString .= "excludeOwnerFromLogging=" . param("excludeOwnerFromLogging") . "\|";
	$configString .= "numberOfTopEntries=" . param("numberOfTopEntries") . "\|";
	$configString .= "displayCommentWebPages=" . param("displayCommentWebPages") . "\|";
	$configString .= "toMail=" . param("toMail") . "\|";
	$configString .= "tableFontSize=" . param("tableFontSize") . "\|";
	$configString .= "logComments=" . param("logComments") . "\|";
	$configString .= "notifyMeOnComment=" . param("notifyMeOnComment") . "\|";
	$configString .= "displayCommentEmailAddy=" . param("displayCommentEmailAddy") . "\|";
	$configString .= "requireMyApprovalOnComments=" . param("requireMyApprovalOnComments") . "\|";
	$configString .= "mailfile=updatelist.txt\|";
	$configString .= "PageBase=Pages/\|";
	$configString .= "blogTemplate=blogTemplate.html\|";
	$configString .= "commentsLog=commentLog.txt\|";
	$configString .= "catFile=linkCategories.txt\|";
	$configString .= "logfile=blogLog.txt\|";
	$configString .= "greatestHitsFile=GreatestHits.txt\|";
	$configString .= "linkFile=links.txt\|";
	$configString .= "headlineFontSize=" . param("headlineFontSize");
	
	$maskedConfig = $configString;
	
	#I want to overwrite the file, since this will always be the latest information
	open (CONFIG,">$configuration") || &MyError("Can't write configuration file at '$configuration'. $!");
	print CONFIG $maskedConfig;
	close(CONFIG);

	
	#if the text files for the script don't exist, write them
	@FilesToCreate = ("updatelist.txt","commentLog.txt","linkCategories.txt","blogLog.txt","GreatestHits.txt","links.txt");
	
	#UNCOMMENT BEFORE RELEASE
	foreach (@FilesToCreate) {
		open (FILEY,"$_") || open (FILEY,">$_") || &MyError("Can't open or create $_. $!");
		close(FILEY);
	}
	
	#create link categories file
	$cats = "Blogs\nFunny stuff\nComputer stuff\nOther stuff";
	open (CATS,">linkCategories.txt");
	print CATS $cats;
	close (CATS);
	
	#this is where the script would display success to the user.
	&Header;
	print "<body bgcolor=white><font face=Verdana><h1>Configuration complete</h1>\n";
	print "Your configuration file has been written. <br>$clickMe to start using your blog.";
	exit;
	
}


####### SET DEFAULT VALUES
sub SetDefaultValues {
	#this sets up the blog with default values. Should only be called if a configuration file doesn't exist.
	$thisScript		=	$ENV{'SCRIPT_NAME'};
	$serverName		=	$ENV{'SERVER_NAME'};
	$scriptFileName	=	$ENV{'SCRIPT_FILENAME'};
	$documentRoot	=	$ENV{'DOCUMENT_ROOT'};

	@SendMail = split(/\s+/, qx/whereis sendmail/);
	$sendmail = $SendMail[1];
	$commentRequestString 			=	"I live for the comments! I <b>MUST KNOW</b> what you think!";
	$hitsPerLogPage					=	50;
	$commentBorder					=	"\#6666CC";
	$borderColor						=	"\#999900";
	$commentBackground				=	"\#A7B8DC";
	$tableFontFace					=	"Verdana";
	$alternatingColor					=	"\#85A0D9";
	$password						=	"";
	$blogTitle						=	"Blog Title";
	$numberOfTopEntries				=	15;
	$excludeOwnerFromLogging			=	"yes";
	$toMail							=	"your\@email.com";
	$tableFontSize					=	1;
	$logComments					=	"yes";
	$notifyMeOnComment				=	"yes";
	$displayCommentEmailAddy			=	"no";
	$requireMyApprovalOnComments	=	"no";
	$headlineFontSize					=	2;
}

####### CONFIGURATION SCREEN
sub ConfigurationScreen {
	#prompts the user to enter configuration data. First run, it
	#displays default data.
	my($arg) = $_[0];
	if ($arg) {
		&SetDefaultValues; #this is only for when the script is called virgin.
	} else {
		$sendmail = $mailprog;
		$thisScript =  $config{thisScript};
		$serverName = $config{serverName};
	}
	$fontString = "<font face=Verdana size=1>";
	&Header;
	$colorlink = "<a href=http://www.pagetutor.com/pagetutor/makapage/picker/ target=_new>this page</a>";
	print "$fontString<center><h1>Configure the blog</h1>\n";
	print "Below, you'll be asked to set quite a few values. Don't be nervous. Most of them can be left alone if you so choose. In fact, the only values you HAVE to set are the <b>password</b> and <b>e-mail</b> values. So read the instructions, and don't worry if you can't figure something out. Leave it as it is and go on to blogging.<p>";
	print "<form action=";
	if ($arg) {
		print "http://";
	}
	print "$serverName" . "$thisScript method=POST>\n";
	print "$fontString NOTE: When you need to pick colors, $colorlink can help.<p>\n";
	print "<table border=0 cellpadding=0 cellspacing=0 width=600>";
	print "<tr><Td bgcolor=\#A7B8DC align=right>$fontString Sendmail:</td><td bgcolor=\#A7B8DC> <input type=text name=sendmail value=\"$sendmail\" size=40></td></tr>\n";
	print "<tr><td colspan=2>$fontString <b>Sendmail</b> is the program on web servers that sends e-mail. This script tries to figure out where it is, and a value should be in the field above. If there's no value there, or if the value is wrong, ask your server administrator where sendmail is and put that value in the space above.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Server name:</td><td bgcolor=\#A7B8DC><input type=text size=40 name=serverName value=\"";
	if ($arg) {
		print "http://";
	}
	print "$serverName\"></td></tr>\n";
	print "<tr><td colspan=2><b>$fontString Server name</b> is the ROOT url to your server (i.e., \"http://www.yourdomain.com\"). It should be above, and you shouldn't have to change it. The exception might be if you want to display the domain differently. For instance, if you called this script from <b>http://yourdomain.com/blog.cgi</b> and you really want to add the <b>www</b> part, just add <b>www</b> before <b>yourdomain.com</b> above.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString This script:</td><td bgcolor=\#A7B8DC><input type=text size=40 name=thisScript value=\"$thisScript\"></td></tr>\n";
	print "<tr><td colspan=2>$fontString <b>This script</b> name and directory of this script. For instance, if your website is http://$serverName, but your script is in the directory \"blog\", this value would be \"/blog/\" and then the script name itself.<br>You should be able to leave this value as it is.<p></td></tr>\n";
	$commentRequestString =~ s/</\&lt\;/g;
	$commentRequestString =~ s/</\&gt\;/g;
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Comment request string:</td><td bgcolor=\#A7B8DC><textarea name=commentRequestString rows=5 cols=40>$commentRequestString</textarea></td></tr>\n";
	print "<tr><td colspan=2>$fontString <b>Comment request string</b> is the text that appears at the bottom of your entries asking your users to comment. You can change this as you like, and even include html code. Newlines (hitting return) in this field will be changed to the \&lt\;br\&gt\; tag, so keep that in mind.<p></td></tr>\n";	
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Hits per log page:</td><td bgcolor=\#A7B8DC><select name=hitsPerLogPage>";
	for ($i=10;$i<=100;$i++) {
		print "<option value=\"$i\"";
		if ($i == $hitsPerLogPage) {
			print " SELECTED";
		}

		print ">$i</option>";
	}

	print "</select></td></tr>\n";
	print "<tr><td colspan=2>$fontString <b>Hits per log page</b> tells the script how many entries to display per page when you're viewing the log. 50 is default.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Comment border:</td><td bgcolor=\#A7B8DC><input type=text name=commentBorder value=\"$commentBorder\"></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Comment border</b> is the hexadecimal color value for the border that surrounds comments. If you need help picking a color, try $colorlink.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Border color:</td><td bgcolor=\#A7B8DC><input type=text name=borderColor value=\"$borderColor\"></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Border color</b> is the hexadecimal color value for the color behind the headline above comments. If you need help picking a color, try $colorlink.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Comment background:</td><td bgcolor=\#A7B8DC><input type=text name=commentBackground value=\"$commentBackground\"></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Comment background</b> is the hexadecimal color value  for the color behind the comments themselves. If you need help picking a color, try $colorlink.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Table Font Face:</td><td bgcolor=\#A7B8DC><input type=text name=tableFontFace value=\"$tableFontFace\"></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Table Font Face</b> is the font face that is used inside the tables the blog displays. Some browsers require that table cells have font tags. The font you specify here will be used for most of your blog. You can use a comma-delimited list here (eg: Verdana,Helvetica,Arial,Courier).<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Alternating color:</td><td bgcolor=\#A7B8DC><input type=text name=alternatingColor value=\"$alternatingColor\"></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Alternating color</b> is the hexadecimal color value  for the color that appears in alternating rows on the blog. It's the shade above in this configuration screen. If you need help picking a color, try $colorlink.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Password:</td><td bgcolor=\#A7B8DC><input type=password name=password value=\"$password\"></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Retype the password:</td><td bgcolor=\#A7B8DC><input type=password name=password2 value=\"$password\"></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Password</b> is the word or phrase that allows you to administrate your blog. This is cAsE sEnSiTiVe. Also, be careful to choose something NON TRIVIAL. <b>WARNING!!!!</b> If you forget your password, the ONLY way to recover it is to <a href=http://leifwright.com/contact.cgi target=_new>e-mail me</a> (and I will charge you to retrieve it) or to completely trash your configuration and start over. It's NOT trivial. DO NOT forget your password.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Blog title:</td><td bgcolor=\#A7B8DC><input type=text name=blogTitle value=\"$blogTitle\"></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Blog title</b> is the title of your blog.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Number of top entries:</td><td bgcolor=\#A7B8DC><select name=numberOfTopEntries>";
	for ($i=0;$i<=20;$i++) {
		print "<option value=\"$i\"";
		if ($i == $numberOfTopEntries) {
			print " SELECTED";
		}
		print ">$i</option>";
	}
	print "</select></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Number of top entries</b> the number of user-ranked entries to display on your page. 10 is default. Use 0 to display no top entries.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Display commenters' web pages as links:</td><td bgcolor=\#A7B8DC><select name=displayCommentWebPages>";
	print "<option value=yes";
	if ($displayCommentWebPages eq "yes") {
		print " SELECTED";
	}
	print ">Yes</option><option value=no";
	if ($displayCommentWebPages eq "no") {
		print " SELECTED";
	}
	print ">No</option></select></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Display commenters' web pages as links</b>. \"Yes\" means when readers comment and enter a url for their web page, the script will display that URL as a link to their web page.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Exclude owner from logging:</td><td bgcolor=\#A7B8DC><select name=excludeOwnerFromLogging>";
	print "<option value=yes";
	if ($excludeOwnerFromLogging eq "yes") {
		print " SELECTED";
	}
	print ">Yes</option><option value=no";
	if ($excludeOwnerFromLogging eq "no") {
		print " SELECTED";
	}
	print ">No</option></select></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Exclude owner from logging</b> tells the script to present the blog's owner with the opportunity to exclude him or herself from logging. This keeps your log from having a ton of hits by you, thus only showing you true hits.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Your e-mail address:</td><td bgcolor=\#A7B8DC><input type=text name=toMail value=\"$toMail\" size=40></td></tr>\n"; 
	print "<tr><td colspan=2>$fontString <b>Your e-mail address</b> is the e-mail address to which communications from this blog script will be sent. Enter YOUR e-mail address. It MUST be a valid e-mail address, or the script may not function properly.<p></td></tr>\n";	
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Font size:</td><td bgcolor=\#A7B8DC><select name=tableFontSize>";
	for ($i=1;$i<=5;$i++) {
		print "<option value=\"$i\"";
		if ($i == $tableFontSize) {
			print " SELECTED";
		}
		print ">$i</option>";
	}
	print "</select></td></tr>\n";
	print "<tr><td colspan=2>$fontString <b>Font size</b> is the size of the font to be displayed in your blog. The default value is 1, which may be too small for some readers.<p></td></tr>\n";	
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Log comments:</td><td bgcolor=\#A7B8DC><select name=logComments>";
	print "<option value=yes";
	if ($logComments eq "yes") {
		print " SELECTED";
	}
	print ">Yes</option><option value=no";
	if ($logComments eq "no") {
		print " SELECTED";
	}
	print ">No</option></select></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Log comments</b>. The script can log comments separately from regular hits. This allows the owner (you) the opportunity to see who is commenting and match them with their hit patterns. Yes is default.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Notify me on comments:</td><td bgcolor=\#A7B8DC><select name=notifyMeOnComment>";
	print "<option value=yes";
	if ($notifyMeOnComment eq "yes") {
		print " SELECTED";
	}
	print ">Yes</option><option value=no";
	if ($notifyMeOnComment eq "no") {
		print " SELECTED";
	}
	print ">No</option></select></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Notify me on comments</b> tells the script to send you an e-mail when people comment on a blog entry.<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Display commenters' e-mail addresses:</td><td bgcolor=\#A7B8DC><select name=displayCommentEmailAddy>";
	print "<option value=yes";
	if ($displayCommentEmailAddy eq "yes") {
		print " SELECTED";
	}
	print ">Yes</option><option value=no";
	if ($displayCommentEmailAddy eq "no") {
		print " SELECTED";
	}
	print ">No</option></select></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Display commenters' e-mail addresses</b> tells the script to display commenters' e-mail addresses as links at the bottom of their comments. Some people like this, I find it annoying, so the default is \"no\".<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Require my approval on comments:</td><td bgcolor=\#A7B8DC><select name=requireMyApprovalOnComments>";
	print "<option value=yes";
	if ($requireMyApprovalOnComments eq "yes") {
		print " SELECTED";
	}
	print ">Yes</option><option value=no";
	if ($requireMyApprovalOnComments eq "no") {
		print " SELECTED";
	}
	print ">No</option></select></td></tr>\n";
	print "<tr><Td colspan=2>$fontString <b>Require my approval on comments</b>. Some people want to read viewers' comments before they're displayed on the site. This gives you that option. The default is \"no\".<p></td></tr>\n";
	print "<tr><td bgcolor=\#A7B8DC align=right>$fontString Headline font size:</td><td bgcolor=\#A7B8DC><select name=headlineFontSize>";
	for ($i=1;$i<=5;$i++) {
		print "<option value=\"$i\"";
		if ($i == $headlineFontSize) {
			print " SELECTED";
		}
		print ">$i</option>";
	}
	print "</select></td></tr>\n";
	print "<tr><td colspan=2>$fontString <b>Headline font size</b> is the size of the font to be displayed in your headlines. Default is 2. The bigger the number, the smaller the headline. (I.e., 1 is the biggest)<p></td></tr>\n";	
	print "<tr><td colspan=2 align=center><hr>$fontString When you hit \"Configure the blog\" below, the changes you have made above will be written into the blog's configuration. You can always change it by coming back to this screen.<br><input type=submit value=\"Configure the blog\" name=submit></form></td></tr></table>\n";
	exit;
}








#################################################
#UPDATE ROUTINES
#################################################

####### SEND UPDATE EMAILS 
sub SendUpdateEmails {
	open (MAILFILE, "$mailfile") || &MyError("$mailfile problem. $!");
	@MailList=<MAILFILE>;
	close(MAILFILE);
	foreach (@MailList) {
		chomp($_);
		if ($_ ne "") {
			($TheName,$TheAddress) = split(/\|/,$_);
			open (MAIL, "|$mailprog $TheAddress") || &MyError("Can't open $mailprog in SendUpdateEmails sub. Reason: $!");
			print MAIL "To: $TheName \<$TheAddress\>\n";
			print MAIL "Reply-to: $toMail\n";

			print MAIL "From: $toMail\n";
			print MAIL "Subject: $blogTitle updated\n\n";
			print MAIL "$blogTitle has been updated. You can read it at the link below.\n";
			print MAIL "Please understand, the entry may still undergo editing, so you may wait a while.\n";
			print MAIL "$newform\n";
			close(MAIL);
		}
	}
}



####### ADD UPDATE NAME
sub AddUpdateName {
	$name = param("name");
	$email = param("email");
	if ($email  !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$/) {
		&MyError("You need to enter an e-mail address that's real.");
	}
	open (ADDS,">>$mailfile") || &MyError("$mailfile problem. $!");
	print ADDS "$name\|$email";
	close(ADDS);
	&Header;
	print "<h3>Success</h3>\n";
	print "I have recorded your address. You will be e-mailed when the blog is updated.<br>\n";

	print "<a href=$newform>Click here to continue</a>\n";
	exit;
}

####### MyError
sub MyError
{	
	&Header;
	$title="ERROR!";
	&GetHeaderTemplate;
	$ErrorCode = join(//,@_);
	

	$thingy = "<h1>Whoops! Something went wrong!</h1>\nThe error: <b>$ErrorCode</b>\n";
	foreach (@theTemplate) {
		$_ =~ s/<!--BLOG CONTENT-->/$thingy/;
	}
			
	&GetFooterTemplate;

	exit;
}

####### UNMASK String

sub UnmaskString
{
	my ($UnmaskedString) = "";
	my ($Scrambled,$StLn,$Start,$u,$UnHex) = "";
	#Requires caller to pass hexed password as argument
	$Scrambled = $_[0];
	$StLn = length($Scrambled);
	$StLn = $StLn/2;#this will tell me how many pairs of two to grab from string
	#/
	for ($i=0;$i<$StLn;$i++)
	{
		$Start = $i * 2;#jump up two characters each time, since I'm pulling two at a time.
		$u = substr($Scrambled,$Start,2);#grab two characters from left.
		$UnHex = hex($u);#turn them into real numbers from hexadecimal
		push(@UnHexed,$UnHex);#add them to my array
	}
	$UnmaskedString=pack("C*",@UnHexed);#convert real numbers to ascii letters
	$_[0] = "";
	return $UnmaskedString;
}

sub UnmaskConfigString
{
	my ($UnmaskedString) = "";
	my ($Scrambled,$StLn,$Start,$u,$UnHex) = "";
	#Requires caller to pass hexed password as argument
	$Scrambled = $_[0];
	$StLn = length($Scrambled);
	$StLn = $StLn/2;#this will tell me how many pairs of two to grab from string
	#/
	for ($i=0;$i<$StLn;$i++)
	{
		$Start = $i * 2;#jump up two characters each time, since I'm pulling two at a time.
		$u = substr($Scrambled,$Start,2);#grab two characters from left.
		$UnHex = hex($u);#turn them into real numbers from hexadecimal
		push(@UnHexed,$UnHex);#add them to my array
	}
	$UnmaskedString=pack("C*",@UnHexed);#convert real numbers to ascii letters
	return $UnmaskedString;
}






































