##########################################################################
#
#	TITLE: common.pm
#	
#	FUNCTION: Include file housing subroutines common to many
#	aspects of My Classifieds SQL, many of which function as
#	asthetic/format-specific blocks of code.
#	
#	DATE: last edited 12.07.2003
#	
#	AUTHOR: Erin Spice
#	
#	PACKAGE: My Weblog
#
#	DETAILS: This include file contains dienice, 
#	mydate, and $fuzzymonkey.
#
#########################################################################

use lib "./lib";
use sitevariables;
use lang;

package cmn;


our $version = "My Blog 1.31";

### DIENICE ##############################################################
#
#	TITLE: dienice
#
#	INPUT: $msg - error message to be printed.
#	
#	FUNCTION: Formats $msg, prints to browser, and dies.
#	
#	OUTPUT: HTML for the page.
#	
#	FUNCTIONS CALLED: 	none
#
#	CALLED BY:		too many to name
#
##########################################################################
sub dienice {
	my $content .= "Content-type:text/html\n\n
<html>
<body>
<center>
<table width=98% bgcolor=$svb::darkcolor cellspacing=1 cellspacing=0>
	<tr>
		<td>
			<table width=100% bgcolor=$svb::lightcolor cellspacing=0>
				<tr>
					<td align=center>
					$svb::fontheader<b>$lang::oops!</b></font>
					</td>
				</tr>
				<tr>
					<td>$svb::fontsmall<center>$_[0]</center></font>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</center>
</body>
</html>";
	print $content;
	exit(3);
}




########################################################################################
##  Sends an email using  variables $subject, $to, $from, $body in @_                 ##
########################################################################################
sub email ($$$$)
{
    my ($subject, $to, $from, $body) = @_;
                                                                                                                             
    open (MAIL, "| $svb::sendmail" ) || cmn::dienice("could not open mail");
    print MAIL <<MAIL_MESSAGE;
Subject:$subject
To:$to
Reply-to:$from
From:$from

$body
MAIL_MESSAGE
     close MAIL;
}





sub leftmenu{
	my $return;
        $return .= "<table width=200 bgcolor=$svb::darkcolor cellspacing=0 cellpadding=0 border=0>
        <tr>
                <td>
                        <table width=100% cellpadding=2>
                                <tr bgcolor=$svb::headercellcolor>
                                        <td>
$svb::fontsmall <b>$svb::title</b><br></font>
                                        </td>
                                </tr>
                                <tr bgcolor=$svb::lightcolor>
                                        <td>
$svb::fontsmall<a href=index.cgi>$lang::view_blogs</a><br>
<a href=index.cgi?mode=search>$lang::search_blogs</a><br></font>
                                        </td>
                                </tr>
                        </table>
                </td>
        </tr>
</table>
<br>";
	return $return;
}






### MYDATE ###############################################################
#
#	TITLE: mydate
#
#	INPUT: output of time() or previously saved time() data.
#	
#	FUNCTION: Prints the date formatted nicely.
#	
#	OUTPUT: One line of text including date.
#	
#	FUNCTIONS CALLED: 		none
#
#	CALLED BY:			deletead
#					dodelete
#					edit
#					viewcategory
#					viewsinglead
#					searchresults
#
##########################################################################
sub mydate{
	my $datenum = $_[0] + (60*60*2);
	my ($sec,$min,$hour,$day,$mon,$year,$weekday,$yearday,$dst) = localtime($datenum);
	my $ampm = "am";
	$year = 1900 + $year;
	if ($hour > 12){
		$hour = $hour - 12;
		$ampm = "pm";
	}
	$min = sprintf("%02d",$min);
	$hour = sprintf("%02d",$hour);
	$sec = sprintf("%02d",$sec);
	return "$day $lang::months[$mon], $year, $hour\:$min $ampm";
}


# this is the fuzzymonkey signature at the bottom of every page ##########
our $fuzzymonkey = "\n\n\n
<br>
<table align=center width=98% bgcolor=$svb::tableborder cellpadding=2 cellspacing=0>
	<tr>
		<td>
			<table width=100% bgcolor=$svb::tablebg cellpadding=3 cellspacing=0>
				<tr>
					<td align=center>
					<font face=$svb::fontface color=$svb::darkcolor size=2>$lang::powered_by $version. $lang::copyright.<br>
$lang::wizard</font>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>";



sub printpage {
        my ($file,$content) = @_;
        $content .= $fuzzymonkey;
	my $baby;
	if(-e "baby.pl"){
		$baby = `./baby.pl`;
	}
	my $calendar;
	if(-e "calendar.pl"){
		$calendar = `./calendar.pl`;
	}
	my $photo;
	if(-e "photo.pl"){
		$photo = `./photo.pl`;
	}
        my $page;
        open (TEMPLATE, "./$file")
                        || dienice("$lang::read_file_error ./$svb::templatefile\: $!");
        while (<TEMPLATE>){
                $page .= $_;
        }
        close TEMPLATE;
        $page =~ s/<!-- ?content ?-->/$content/ig;
        $page =~ s/<!-- ?baby ?-->/$baby/ig;
        $page =~ s/<!-- ?calendar ?-->/$calendar/ig;
        $page =~ s/<!-- ?photo ?-->/$photo/ig;
        return $page;
}




return 1;
