#!/usr/bin/perl

use CGI qw(param);
use DBI;
use bbconfig;
use layout;
use bbfunc;
use session;

###########################################################################
#  BEGIN VARIABLE DECLARATION

# Parameters
$action = param("action");
$board = param("board");
$branch = param("branch");
$view = param("view");
$user = param("user");
$guest = param("guest");
if ($guest ne "yes") {$id = &_login; $gueststring = ""; $guestinput = "";} else {$id = 1; $gueststring = "&guest=yes"; $guestinput = "<input type=\"hidden\" name=\"guest\" value=\"yes\">";}




###########################################################################
#  BEGIN MAIN SCRIPT

if ($action eq "boarddetail") {&boarddetail;}
elsif ($action eq "branchdetail") {&branchdetail;}
elsif ($action eq "userdetail") {&userdetail;}
else {&display;}

#
#########################################################################



###########################################################################
#  BEGIN DISPLAY

sub display
{

if (($view =~ /branch/)||($view =~ /board/)) {
    # Board and Branch Activity
    %branchposts = {};
    %boardposts = {};
    %branchhits = {};
    %boardhits = {};
    %branchnames = {};
    %boardnames = {};
    %boardids = {};

    $sth = $dbh->prepare('SELECT BBranchesID, Name FROM BBranches') or &_error($sth->errstr);
    $sth->execute() or &_error($sth->errstr);
    while (@tempbranches = $sth->fetchrow_array()) {
        $sth2 = $dbh->prepare('SELECT BBoardsID, Name FROM BBoards WHERE BBranchesID = ?') or &_error($sth2->errstr);
        $sth2->execute($tempbranches[0]) or &_error($sth2->errstr);
        while (@tempboards = $sth2->fetchrow_array()) {
            $sth3 = $dbh->prepare('SELECT BPostsID FROM BPosts WHERE BBoardsID = ?') or &_error($sth3->errstr);
            $sth3->execute($tempboards[0]) or &_error($sth3->errstr);
            while (@tempposts = $sth3->fetchrow_array()) {
                $sth4 = $dbh->prepare('SELECT Count(*) FROM BReplies WHERE BPostsID = ?') or &_error($sth4->errstr);
                $sth4->execute($tempposts[0]) or &_error($sth4->errstr);
                @tempreplies = $sth4->fetchrow_array();
                $branchposts{$tempbranches[0]} += $tempreplies[0] + 1;
                $boardposts{$tempboards[0]} += $tempreplies[0] + 1;
            }
            $sth3 = $dbh->prepare('SELECT Hits FROM BBoardHits WHERE BBoardsID = ?') or &_error($sth3->errstr);
            $sth3->execute($tempboards[0]) or &_error($sth3->errstr);
            while (@temphits = $sth3->fetchrow_array()) {
                $branchhits{$tempbranches[0]} += $temphits[0];
                $boardhits{$tempboards[0]} += $temphits[0];
            }
            $boardnames{$tempboards[0]} = $tempboards[1];
            $branchnames{$tempboards[0]} = $tempbranches[1];
            if ($boardhits{$tempboards[0]} eq "") {$boardhits{$tempboards[0]} = 0;}
        }
        $branchnames2{$tempbranches[0]} = $tempbranches[1];
        if ($branchhits{$tempbranches[0]} eq "") {$branchhits{$tempbranches[0]} = 0;}
    }
} elsif ($view =~ /user/) {
    # User Activity
    %userposts = {};
    %userhits = {};
    %usernames = {};
    $sth = $dbh->prepare('SELECT BUsersID, Username FROM BUsers') or &_error($sth->errstr);
    $sth->execute() or &_error($sth->errstr);
    while (@tempusers = $sth->fetchrow_array()) {
        $sth2 = $dbh->prepare('SELECT Count(*) FROM BPosts WHERE BUsersID = ?') or &_error($sth2->errstr);
        $sth2->execute($tempusers[0]) or &_error($sth2->errstr);
        @tempboards = $sth2->fetchrow_array();
        $sth2 = $dbh->prepare('SELECT Count(*) FROM BReplies WHERE BUsersID = ?') or &_error($sth2->errstr);
        $sth2->execute($tempusers[0]) or &_error($sth2->errstr);
        @tempreplies = $sth2->fetchrow_array();
        $sth2 = $dbh->prepare('SELECT Hits FROM BBoardHits WHERE BUsersID = ?') or &_error($sth2->errstr);
        $sth2->execute($tempusers[0]) or &_error($sth2->errstr);
        while (@temphits = $sth2->fetchrow_array()) {
            $userhits{$tempusers[0]} += $temphits[0];
        }
        if ($userhits{$tempusers[0]} eq "") {$userhits{$tempusers[0]} = 0;}
        $userposts{$tempusers[0]} = $tempboards[0] + $tempreplies[0];
        $usernames{$tempusers[0]} = $tempusers[1];
    }
}


my $headnav = "";
my $pagetitle = "";
my $coldefine = "";
my $colposts = "";
my $colhits = "";
my $entries = "";

if ($view eq "branchposts") {

    $headnav = qq{Branch Activity $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "Branch Activity";
    $coldefine = "Branch";
    $colposts = "Posts";
    $colhits = "<a href=\"stats.pl?view=branchhits$gueststring\">Hits</a>";

    # Branch Activity
    foreach $key (sort {$branchposts{$b} <=> $branchposts{$a}} keys %branchposts) {
        unless (($branchposts{$key} == 0)&&($branchhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=branchdetail&branch=$key&view=posts$gueststring\">$branchnames2{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$branchposts{$key}<font></td><td><font face=\"$_font\" size=\"$_fontregular\">$branchhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries
    );

} elsif ($view eq "branchhits") {

    $headnav = qq{Branch Activity $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "Branch Activity";
    $coldefine = "Branch";
    $colposts = "<a href=\"stats.pl?view=branchposts$gueststring\">Posts</a>";
    $colhits = "Hits";

    # Branch Activity
    foreach $key (sort {$branchhits{$b} <=> $branchhits{$a}} keys %branchhits) {
        unless (($branchposts{$key} == 0)&&($branchhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=branchdetail&branch=$key&view=posts$gueststring\">$branchnames2{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$branchposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$branchhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries
    );

} elsif ($view eq "userposts") {

    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator User Activity};
    $pagetitle = "User Activity";
    $coldefine = "Username";
    $colposts = "Posts";
    $colhits = "<a href=\"stats.pl?view=userhits$gueststring\">Hits</a>";

    # User Activity
    foreach $key (sort {$userposts{$b} <=> $userposts{$a}} keys %userposts) {
        unless (($userposts{$key} == 0)&&($userhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=userdetail&user=$key&view=posts$gueststring\" target=\"main\">$usernames{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries
    );

} elsif ($view eq "userhits") {

    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator User Activity};
    $pagetitle = "User Activity";
    $coldefine = "Username";
    $colposts = "<a href=\"stats.pl?view=userposts$gueststring\">Posts</a>";
    $colhits = "Hits";

    # User Activity
    foreach $key (sort {$userhits{$b} <=> $userhits{$a}} keys %userhits) {
        unless (($userposts{$key} == 0)&&($userhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=userdetail&user=$key&view=posts$gueststring\" target=\"main\">$usernames{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries
    );

} elsif ($view eq "boardposts") {

    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator Board Activity $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "Board Activity";
    $coldefine = "Board";
    $colposts = "Posts";
    $colhits = "<a href=\"stats.pl?view=boardhits$gueststring\">Hits</a>";

    # Board Activity
    foreach $key (sort {$boardposts{$b} <=> $boardposts{$a}} keys %boardposts) {
        unless (($boardposts{$key} == 0)&&($boardhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\">$branchnames{$key}: <a href=\"stats.pl?action=boarddetail&board=$key&view=posts$gueststring\">$boardnames{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries
    );

} elsif ($view eq "boardhits") {

    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator Board Activity $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "Board Activity";
    $coldefine = "Board";
    $colposts = "<a href=\"stats.pl?view=boardposts$gueststring\">Posts</a>";
    $colhits = "Hits";

    # Board Activity
    foreach $key (sort {$boardhits{$b} <=> $boardhits{$a}} keys %boardhits) {
        unless (($boardposts{$key} == 0)&&($boardhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\">$branchnames{$key}: <a href=\"stats.pl?action=boarddetail&board=$key&view=posts$gueststring\">$boardnames{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries
    );

} else {

    &_layoutStats(
        "stats.pl?view=branchposts$gueststring",
        "stats.pl?view=branchhits$gueststring",
        "stats.pl?view=boardposts$gueststring",
        "stats.pl?view=boardhits$gueststring",
        "stats.pl?view=userposts$gueststring",
        "stats.pl?view=userhits$gueststring"
    );

}

}




###########################################################################
#  BEGIN BOARDDETAIL

sub boarddetail {

%userposts = {};
%userhits = {};

$sth = $dbh->prepare('SELECT Name FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
$sth->execute($board) or &_error($sth->errstr);
@boardinfo = $sth->fetchrow_array();

$sth = $dbh->prepare('SELECT BUsersID, Username FROM BUsers') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@tempuser = $sth->fetchrow_array()) {
    $sth2 = $dbh->prepare('SELECT Count(*) FROM BPosts WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth2->errstr);
    $sth2->execute($board, $tempuser[0]) or &_error($sth2->errstr);
    @tempposts = $sth2->fetchrow_array();
    $sth2 = $dbh->prepare('SELECT Count(*) FROM BReplies, BPosts WHERE BPosts.BPostsID = BReplies.BPostsID AND BPosts.BBoardsID = ? AND BReplies.BUsersID = ?') or &_error($sth2->errstr);
    $sth2->execute($board, $tempuser[0]) or &_error($sth2->errstr);
    @tempreplies = $sth2->fetchrow_array();
    $sth2 = $dbh->prepare('SELECT Hits FROM BBoardHits WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth2->errstr);
    $sth2->execute($board, $tempuser[0]) or &_error($sth2->errstr);
    @temphits = $sth2->fetchrow_array();

    $userposts{$tempuser[0]} = $tempposts[0] + $tempreplies[0];
    $userhits{$tempuser[0]} = $temphits[0];
    if ($userhits{$tempuser[0]} eq "") {$userhits{$tempuser[0]} = 0;}
    $username{$tempuser[0]} = $tempuser[1];
}

my $headnav = "";
my $pagetitle = "";
my $coldefine = "";
my $colposts = "";
my $colhits = "";
my $entries = "";

if ($view ne "hits") {
    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "$boardinfo[0] Details";
    $coldefine = "Username";
    $colposts = "Posts";
    $colhits = "<a href=\"stats.pl?action=boarddetail&board=$board&view=hits$gueststring\">Hits</a>";

    foreach $key (sort {$userposts{$b} <=> $userposts{$a}} keys %userposts) {
        unless (($userposts{$key} == 0)&&($userhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=userdetail&user=$key&view=posts$gueststring\">$username{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries
    );
} else {
    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "$boardinfo[0] Details";
    $coldefine = "Username";
    $colposts = "<a href=\"stats.pl?action=boarddetail&board=$board&view=posts$gueststring\">Posts</a>";
    $colhits = "Hits";

    foreach $key (sort {$userhits{$b} <=> $userhits{$a}} keys %userhits) {
        unless (($userposts{$key} == 0)&&($userhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=userdetail&user=$key&view=posts$gueststring\">$username{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries
    );
}

}


###########################################################################
#  BEGIN USERDETAIL

sub userdetail {

%branchposts = {};
%branchhits = {};
%boardposts = {};
%boardhits = {};
%boardnames = {};
%branchnames = {};

$sth = $dbh->prepare('SELECT BBranchesID, Name FROM BBranches') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@tempbranches = $sth->fetchrow_array()) {
    $sth2 = $dbh->prepare('SELECT BBoardsID, Name FROM BBoards WHERE BBranchesID = ?') or &_error($sth2->errstr);
    $sth2->execute($tempbranches[0]) or &_error($sth2->errstr);
    while (@tempboards = $sth2->fetchrow_array()) {
        $sth3 = $dbh->prepare('SELECT Count(*) FROM BPosts WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth3->errstr);
        $sth3->execute($tempboards[0], $user) or &_error($sth3->errstr);
        @tempposts = $sth3->fetchrow_array();
        $sth3 = $dbh->prepare('SELECT Count(*) FROM BReplies, BPosts WHERE BReplies.BPostsID = BPosts.BPostsID AND BPosts.BBoardsID = ? AND BReplies.BUsersID = ?') or &_error($sth3->errstr);
        $sth3->execute($tempboards[0], $user) or &_error($sth3->errstr);
        @tempreplies = $sth3->fetchrow_array();
        $sth3 = $dbh->prepare('SELECT Hits FROM BBoardHits WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth3->errstr);
        $sth3->execute($tempboards[0], $user) or &_error($sth3->errstr);
        @temphits = $sth3->fetchrow_array();
        $branchposts{$tempbranches[0]} += $tempreplies[0] + $tempposts[0];
        $branchhits{$tempbranches[0]} += $temphits[0];
        $boardposts{$tempboards[0]} = $tempreplies[0] + $tempposts[0];
        $boardhits{$tempboards[0]} = $temphits[0];
        if ($boardhits{$tempboards[0]} eq "") {$boardhits{$tempboards[0]} = 0;}
        $boardnames{$tempboards[0]} = $tempboards[1];
        $branchnames{$tempboards[0]} = $tempbranches[1];
    }
    $branchnames2{$tempbranches[0]} = $tempbranches[1];
    if ($branchhits{$tempbranches[0]} eq "") {$branchhits{$tempbranches[0]} = 0;}
}

$sth = $dbh->prepare('SELECT Username FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($user) or &_error($sth->errstr);
@userinfo = $sth->fetchrow_array();

my $headnav = "";
my $pagetitle = "";
my $coldefine = "";
my $colposts = "";
my $colhits = "";
my $entries = "";
my $coldefine2 = "";
my $colposts2 = "";
my $colhits2 = "";
my $entries2 = "";

if ($view ne "hits") {
    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "$userinfo[0] Details";
    $coldefine = "Branch";
    $colposts = "Posts";
    $colhits = "<a href=\"stats.pl?action=userdetail&user=$user&view=hits$gueststring\">Hits</a>";
    $coldefine2 = "Board";
    $colposts2 = "Posts";
    $colhits2 = "<a href=\"stats.pl?action=userdetail&user=$user&view=hits$gueststring\">Hits</a>";

    foreach $key (sort {$branchposts{$b} <=> $branchposts{$a}} keys %branchposts) {
        unless (($branchposts{$key} == 0)&&($branchhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=branchdetail&branch=$key&view=posts$gueststring\">$branchnames2{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$branchposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$branchhits{$key}</font></td></tr>";
        }
    }

    foreach $key (sort {$boardposts{$b} <=> $boardposts{$a}} keys %boardposts) {
        unless (($boardposts{$key} == 0)&&($boardhits{$key} == 0)) {
            $entries2 .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\">$branchnames{$key}: <a href=\"stats.pl?action=boarddetail&board=$key&view=posts$gueststring\">$boardnames{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries,
        $coldefine2,
        $colposts2,
        $colhits2,
        $entries2
    );
} else {
    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "$userinfo[0] Details";
    $coldefine = "Branch";
    $colposts = "<a href=\"stats.pl?action=userdetail&user=$user&view=posts$gueststring\">Posts</a>";
    $colhits = "Hits";
    $coldefine2 = "Board";
    $colposts2 = "<a href=\"stats.pl?action=userdetail&user=$user&view=posts$gueststring\">Posts</a>";
    $colhits2 = "Hits";

    foreach $key (sort {$branchhits{$b} <=> $branchhits{$a}} keys %branchhits) {
        unless (($branchposts{$key} == 0)&&($branchhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=branchdetail&branch=$key&view=posts$gueststring\">$branchnames2{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$branchposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$branchhits{$key}</font></td></tr>";
        }
    }

    foreach $key (sort {$boardhits{$b} <=> $boardhits{$a}} keys %boardhits) {
        unless (($boardposts{$key} == 0)&&($boardhits{$key} == 0)) {
            $entries2 .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\">$branchnames{$key}: <a href=\"stats.pl?action=boarddetail&board=$key&view=posts$gueststring\">$boardnames{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries,
        $coldefine2,
        $colposts2,
        $colhits2,
        $entries2
    );

}

}


###########################################################################
#  BEGIN BRANCHDETAIL

sub branchdetail {

%boardposts = {};
%boardhits = {};
%userposts = {};
%userhits = {};

$sth = $dbh->prepare('SELECT Name FROM BBranches WHERE BBranchesID = ?') or &_error($sth->errstr);
$sth->execute($branch) or &_error($sth->errstr);
@branchinfo = $sth->fetchrow_array();

$sth2 = $dbh->prepare('SELECT BBoardsID, Name FROM BBoards WHERE BBranchesID = ?') or &_error($sth2->errstr);
$sth2->execute($branch) or &_error($sth2->errstr);
while (@tempboards = $sth2->fetchrow_array()) {
    $sth3 = $dbh->prepare('SELECT BPostsID FROM BPosts WHERE BBoardsID = ?') or &_error($sth3->errstr);
    $sth3->execute($tempboards[0]) or &_error($sth3->errstr);
    while (@tempposts = $sth3->fetchrow_array()) {
        $sth4 = $dbh->prepare('SELECT Count(*) FROM BReplies WHERE BPostsID = ?') or &_error($sth4->errstr);
        $sth4->execute($tempposts[0]) or &_error($sth4->errstr);
        @tempreplies = $sth4->fetchrow_array();
        $boardposts{$tempboards[0]} += $tempreplies[0] + 1;
    }
    $sth3 = $dbh->prepare('SELECT Hits FROM BBoardHits WHERE BBoardsID = ?') or &_error($sth3->errstr);
    $sth3->execute($tempboards[0]) or &_error($sth3->errstr);
    while (@temphits = $sth3->fetchrow_array()) {
        $boardhits{$tempboards[0]} += $temphits[0];
    }
    if ($boardhits{$tempboards[0]} eq "") {$boardhits{$tempboards[0]} = 0;}
    $boardnames{$tempboards[0]} = $tempboards[1];
}

$sth = $dbh->prepare('SELECT BUsersID, Username FROM BUsers') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@tempuser = $sth->fetchrow_array()) {
    $sth2 = $dbh->prepare('SELECT Count(*) FROM BPosts, BBoards, BBranches WHERE BPosts.BBoardsID = BBoards.BBoardsID AND BBoards.BBranchesID = BBranches.BBranchesID AND BBranches.BBranchesID = ? AND BPosts.BUsersID = ?') or &_error($sth2->errstr);
    $sth2->execute($branch, $tempuser[0]) or &_error($sth2->errstr);
    @tempposts = $sth2->fetchrow_array();
    $sth2 = $dbh->prepare('SELECT Count(*) FROM BReplies, BPosts, BBoards, BBranches WHERE BPosts.BPostsID = BReplies.BPostsID AND BBoards.BBoardsID = BPosts.BBoardsID AND BBranches.BBranchesID = BBoards.BBranchesID AND BBranches.BBranchesID = ? AND BReplies.BUsersID = ?') or &_error($sth2->errstr);
    $sth2->execute($branch, $tempuser[0]) or &_error($sth2->errstr);
    @tempreplies = $sth2->fetchrow_array();
    $sth2 = $dbh->prepare('SELECT Hits FROM BBoardHits, BBoards, BBranches WHERE BBoardHits.BBoardsID = BBoards.BBoardsID AND BBoards.BBranchesID = BBranches.BBranchesID AND BBranches.BBranchesID = ? AND BBoardHits.BUsersID = ?') or &_error($sth2->errstr);
    $sth2->execute($branch, $tempuser[0]) or &_error($sth2->errstr);
    while (@temphits = $sth2->fetchrow_array()) {
        $userhits{$tempuser[0]} += $temphits[0];
    }
    if ($userhits{$tempuser[0]} eq "") {$userhits{$tempuser[0]} = 0;}
    $userposts{$tempuser[0]} = $tempposts[0] + $tempreplies[0];
    $username{$tempuser[0]} = $tempuser[1];
}

my $headnav = "";
my $pagetitle = "";
my $coldefine = "";
my $colposts = "";
my $colhits = "";
my $entries = "";
my $coldefine2 = "";
my $colposts2 = "";
my $colhits2 = "";
my $entries2 = "";

if ($view ne "hits") {
    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "$branchinfo[0] Details";
    $coldefine = "Board";
    $colposts = "Posts";
    $colhits = "<a href=\"stats.pl?action=branchdetail&branch=$branch&view=hits$gueststring\">Hits</a>";
    $coldefine2 = "Username";
    $colposts2 = "Posts";
    $colhits2 = "<a href=\"stats.pl?action=branchdetail&branch=$branch&view=hits$gueststring\">Hits</a>";

    foreach $key (sort {$boardposts{$b} <=> $boardposts{$a}} keys %boardposts) {
        unless (($boardposts{$key} == 0)&&($boardhits{$key} == 0)) {
            $entries .="<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=boarddetail&board=$key&view=posts$gueststring\">$boardnames{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardhits{$key}</font></td></tr>";
        }
    }

    foreach $key (sort {$userposts{$b} <=> $userposts{$a}} keys %userposts) {
        unless (($userposts{$key} == 0)&&($userhits{$key} == 0)) {
            $entries2 .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=userdetail&user=$key&view=posts$gueststring\">$username{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries,
        $coldefine2,
        $colposts2,
        $colhits2,
        $entries2
    );
} else {
    $headnav = qq{<a href="stats.pl?view=branchposts$gueststring">Branch Activity</a> $_linkbarseparator <a href="stats.pl?view=boardposts$gueststring">Board Activity</a> $_linkbarseparator <a href="stats.pl?view=userposts$gueststring">User Activity</a>};
    $pagetitle = "$branchinfo[0] Details";
    $coldefine = "Board";
    $colposts = "<a href=\"stats.pl?action=branchdetail&branch=$branch&view=posts$gueststring\">Posts</a>";
    $colhits = "Hits";
    $coldefine2 = "Username";
    $colposts2 = "<a href=\"stats.pl?action=branchdetail&branch=$branch&view=posts$gueststring\">Posts</a>";
    $colhits2 = "Hits";

    foreach $key (sort {$boardhits{$b} <=> $boardhits{$a}} keys %boardhits) {
        unless (($boardposts{$key} == 0)&&($boardhits{$key} == 0)) {
            $entries .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=boarddetail&board=$key&view=posts$gueststring\">$boardnames{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$boardhits{$key}</font></td></tr>";
        }
    }

    foreach $key (sort {$userhits{$b} <=> $userhits{$a}} keys %userhits) {
        unless (($userposts{$key} == 0)&&($userhits{$key} == 0)) {
            $entries2 .= "<tr><td><font face=\"$_font\" size=\"$_fontregular\"><a href=\"stats.pl?action=userdetail&user=$key&view=posts$gueststring\">$username{$key}</a></font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userposts{$key}</font></td><td><font face=\"$_font\" size=\"$_fontregular\">$userhits{$key}</font></td></tr>";
        }
    }

    &_layoutStatsDetail(
        $headnav,
        $pagetitle,
        $coldefine,
        $colposts,
        $colhits,
        $entries,
        $coldefine2,
        $colposts2,
        $colhits2,
        $entries2
    );
}

}
