#!/usr/bin/perl

use CGI qw(param);
use DBI;
use bbconfig;
use layout;
use bbfunc;
use session;

###########################################################################
#  BEGIN VARIABLE DECLARATION

# Parameters
$action = param("action");
$guest = param("guest");
$board = param("board");
$keywords = param("keywords");
$startat = int(param("startat"));
$numrecs = int(param("numrecs"));
if ($guest ne "yes") {$id = &_login; $gueststring = ""; $guestinput = "";} else {$id = 1; $gueststring = "&guest=yes"; $guestinput = "<input type=\"hidden\" name=\"guest\" value=\"yes\">";}









###########################################################################
#  BEGIN MAIN SCRIPT

if ($action eq "lookup") {&lookup;}
else {&display;}


#
#########################################################################



###########################################################################
#  BEGIN DISPLAY

sub display
{

%bbAccessList = ();
$sth = $dbh->prepare('SELECT BBoardsID FROM BBoardAccess WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
while ($temp = $sth->fetchrow_hashref()) {
    $bbAccessList{$temp->{BBoardsID}} = 1;
}

%bbProtectedList = ();
$sth = $dbh->prepare('SELECT BBoardsID FROM BBoardAccess') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while ($temp = $sth->fetchrow_hashref()) {
    $bbProtectedList{$temp->{BBoardsID}} = 1;
}

my $boardlist = "";
if ($_searchallboards != 0) {
    $boardlist = "<option value=\"all\">All Boards</option>";
} else {
    $boardlist = "";
}
$sth = $dbh->prepare('SELECT BBoards.BBoardsID, BBranches.Name, BBoards.Name FROM BBoards, BBranches WHERE BBoards.BBranchesID = BBranches.BBranchesID ORDER BY BBranches.Name, BBoards.Name') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@temp = $sth->fetchrow_array()) {
    if ( (! exists $bbProtectedList{$temp[0]}) || (exists $bbAccessList{$temp[0]}) ) {
        my $tmpselect = "";
        if ($temp[0] == $board) {$tmpselect = "selected";}
        $boardlist .= "<option value=\"$temp[0]\" $tmpselect>[$temp[1]] $temp[2]</option>";
    }
}

$formdata = qq{
    $guestinput
    <input type="hidden" name="action" value="lookup">
};

&_layoutSearch(
    $formdata,
    $boardlist
);

}



###########################################################################
#  BEGIN LOOKUP

sub lookup
{

if ($numrecs <= 0) {
    $numrecs = 10;
} elsif ($numrecs > $_maxsearch) {
    $numrecs = $_maxsearch;
}

%bbAccessList = {};
$sth = $dbh->prepare('SELECT BBoardsID FROM BBoardAccess WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
while ($temp = $sth->fetchrow_hashref()) {
    $bbAccessList{$temp->{BBoardsID}} = 1;
}

%bbProtectedList = {};
$sth = $dbh->prepare('SELECT BBoardsID FROM BBoardAccess') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while ($temp = $sth->fetchrow_hashref()) {
    $bbProtectedList{$temp->{BBoardsID}} = 1;
}

my @results = ();
my $resultcount = 0;
if (($board ne "all")||($_searchallboards == 0)) {
    $sth = $dbh->prepare('
        SELECT Subject, Message, Time, BPostsID, Writer, BUsers.Username AS Username, BBoardsID, BUsers.BUsersID,
        MATCH (Message,Subject) AGAINST (?) AS Score
        FROM BPosts
        LEFT JOIN BUsers ON BUsers.BUsersID = BPosts.BUsersID
        WHERE MATCH (Message,Subject) AGAINST (?)
        AND BBoardsID = ?
    ') or &_error($sth->errstr);
    $sth->execute($keywords,$keywords,$board) or &_error($sth->errstr);
    while ($temp = $sth->fetchrow_hashref()) {
        $temp->{Time} = &_timedate($temp->{Time});
        if ( (! exists $bbProtectedList{$temp->{BBoardsID}}) || (exists $bbAccessList{$temp->{BBoardsID}}) ) {
            push @results, $temp;
        }
    }
    $sth = $dbh->prepare('
        SELECT BReplies.Message AS Message, BReplies.Time AS Time, BRepliesID, BReplies.BPostsID AS BPostsID, BReplies.Writer AS Writer, BUsers.Username AS Username, BPosts.Subject AS Subject, BBoardsID, BReplies.PostCount AS PostCount, BUsers.BUsersID,
        MATCH (BReplies.Message) AGAINST (?) AS Score
        FROM BReplies
        LEFT JOIN BUsers ON BUsers.BUsersID = BReplies.BUsersID
        LEFT JOIN BPosts ON BPosts.BPostsID = BReplies.BPostsID
        WHERE MATCH (BReplies.Message) AGAINST (?)
        AND BPosts.BBoardsID = ?
    ') or &_error($sth->errstr);
    $sth->execute($keywords,$keywords,$board) or &_error($sth->errstr);
    while ($temp = $sth->fetchrow_hashref()) {
        $temp->{Time} = &_timedate($temp->{Time});
        if ( (! exists $bbProtectedList{$temp->{BBoardsID}}) || (exists $bbAccessList{$temp->{BBoardsID}}) ) {
            push @results, $temp;
        }
    }
} else {
    $sth = $dbh->prepare('
        SELECT Subject, Message, Time, BPostsID, Writer, BUsers.Username AS Username, BBoardsID, BUsers.BUsersID,
        MATCH (Message,Subject) AGAINST (?) AS Score
        FROM BPosts LEFT JOIN BUsers ON BUsers.BUsersID = BPosts.BUsersID
        WHERE MATCH (Message,Subject) AGAINST (?)
    ') or &_error($sth->errstr);
    $sth->execute($keywords,$keywords) or &_error($sth->errstr);
    while ($temp = $sth->fetchrow_hashref()) {
        $temp->{Time} = &_timedate($temp->{Time});
        if ( (! exists $bbProtectedList{$temp->{BBoardsID}}) || (exists $bbAccessList{$temp->{BBoardsID}}) ) {
            push @results, $temp;
        }
    }
    $sth = $dbh->prepare('
        SELECT BReplies.Message AS Message, BReplies.Time AS Time, BRepliesID, BReplies.BPostsID AS BPostsID, BReplies.Writer AS Writer, BUsers.Username AS Username, BPosts.Subject AS Subject, BBoardsID, BReplies.PostCount AS PostCount, BUsers.BUsersID,
        MATCH (BReplies.Message) AGAINST (?) AS Score
        FROM BReplies
        LEFT JOIN BUsers ON BUsers.BUsersID = BReplies.BUsersID
        LEFT JOIN BPosts ON BPosts.BPostsID = BReplies.BPostsID
        WHERE MATCH (BReplies.Message) AGAINST (?)
    ') or &_error($sth->errstr);
    $sth->execute($keywords,$keywords) or &_error($sth->errstr);
    while ($temp = $sth->fetchrow_hashref()) {
        $temp->{Time} = &_timedate($temp->{Time});
        if ( (! exists $bbProtectedList{$temp->{BBoardsID}}) || (exists $bbAccessList{$temp->{BBoardsID}}) ) {
            push @results, $temp;
        }
    }
}

# Sort by Score
@results = sort { $a->{Score} <=> $b->{Score} } @results;

$newsearchformdata = qq{
    $guestinput
    <input type="hidden" name="action" value="lookup">
};

my $endatrec = $startat + $numrecs;
$nextformdata = qq{
    $guestinput
    <input type="hidden" name="action" value="lookup">
    <input type="hidden" name="keywords" value="$keywords">
    <input type="hidden" name="startat" value="$endatrec">
    <input type="hidden" name="numrecs" value="$numrecs">
    <input type="hidden" name="board" value="$board">
};

my $boardlist = "";
if ($_searchallboards != 0) {
    $boardlist = "<option value=\"all\">All Boards</option>";
} else {
    $boardlist = "";
}
$sth = $dbh->prepare('SELECT BBoards.BBoardsID, BBranches.Name, BBoards.Name FROM BBoards, BBranches WHERE BBoards.BBranchesID = BBranches.BBranchesID ORDER BY BBranches.Name, BBoards.Name') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@temp = $sth->fetchrow_array()) {
    my $tmpselect = "";
    if ($temp[0] == $board) {$tmpselect = "selected";}
    $boardlist .= "<option value=\"$temp[0]\" $tmpselect>[$temp[1]] $temp[2]</option>";
}

&_layoutSearchResults(
    \@results,
    $#results+1,
    $startat,
    $numrecs,
    $newsearchformdata,
    $nextformdata,
    $keywords,
    $boardlist
);

}

