#!/usr/bin/perl


use CGI qw(param);
use DBI;
use bbconfig;
use layout;
use bbfunc;
use session;

###########################################################################
#  BEGIN VARIABLE DECLARATION

# Parameters
$guest = param("guest");
if ($guest ne "yes") {$id = &_login; $gueststring = ""; $guestinput = "";} else {$id = 1; $gueststring = "&guest=yes"; $guestinput = "<input type=\"hidden\" name=\"guest\" value=\"yes\">";}
$action = param("action");
$board = param("board");
$article = param("article");
$inreplyto = param("inreplyto");
$writer = param("writer");
$message = param("message");
$emoticons = param("emoticons");
$links = param("links");







###########################################################################
#  BEGIN MAIN SCRIPT

&_access($board, $id, "block_readonly");
if ($action eq "post") {&post;}
elsif ($action eq "confirmation") {&confirmation;}
else {&display;}

#
#########################################################################



###########################################################################
#  BEGIN POST

sub post
{

if (($guest eq "yes")&&($_guestpost == 0)) {
    &_descerror("Error",$_str_errors{'guest_no_post'});
}

if ((length($writer) < $_writerminlen)||(length($writer) > $_writermaxlen)) {
    &_descerror("Error",$_str_errors{'writer_length'});
}

$message = &_encode_string($message,undef,$links,$emoticons);

if ($ENV{"REMOTE_HOST"} eq "") {
    if ($ENV{"REMOTE_ADDR"} eq "") {
        $remotename = "Unresolved";
    } else {
        $remotename = $ENV{"REMOTE_ADDR"};
    }
} else {
    $remotename = $ENV{"REMOTE_HOST"};
}

$sth = $dbh->prepare('SELECT PostCount FROM BPosts WHERE BPostsID = ?') or &_error($sth->errstr);
$sth->execute($article) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();
$sth = $dbh->prepare('UPDATE BPosts SET PostCount = ? WHERE BPostsID = ?') or &_error($sth->errstr);
$sth->execute($temp[0]+1, $article) or &_error($sth->errstr);
$sth = $dbh->prepare('DELETE FROM BBoardBold WHERE BBoardsID = ?') or &_error($sth->errstr);
$sth->execute($board) or &_error($sth->errstr);

$sth = $dbh->prepare('INSERT INTO BReplies (Writer, BUsersID, Time, Message, PostCount, BPostsID, InReplyTo, Remote_Name) VALUES (?,?,?,?,?,?,?,?)') or &_error($sth->errstr);
$sth->execute($writer, $id, $currenttime, $message, $temp[0]+1, $article, $inreplyto, $remotename) or &_error($sth->errstr);
$sth = $dbh->prepare('DELETE FROM BHistory WHERE BPostsID = ?') or &_error($sth->errstr);
$sth->execute($article) or &_error($sth->errstr);

print "Location: reply.pl?action=confirmation&board=$board$gueststring\n\n";

}


###########################################################################
#  BEGIN DISPLAY

sub display
{

if (($guest eq "yes")&&($_guestpost == 0)) {
    &_descerror("Error",$_str_errors{'guest_no_post'});
}

$sth = $dbh->prepare('SELECT Subject FROM BPosts WHERE BPostsID = ?') or &_error($sth->errstr);
$sth->execute($article) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();

#if ($inreplyto == 0) {$irttext = "Base Post";} else {$irttext = "Post $inreplyto";}
$irttext = $temp[0];

my $formdata = qq{
    <input type="hidden" name="board" value="$board">
    <input type="hidden" name="article" value="$article">
    <input type="hidden" name="inreplyto" value="$inreplyto">
};
$backtotoc = qq{<a href="main.pl?action=viewboard&board=$board$gueststring">$_str_text{'backtoclink'}</a>};
$backtothread = qq{<a href="article.pl?action=viewarticle&board=$board&article=$article$gueststring">$_str_text{'backthreadlink'}</a>};

my $options;

if ($_linkify) {
    $options = qq{
        <input type="checkbox" name="links" value="1" checked>$_str_text{'link_option'}
    };
}

if ($_emoticons) {
    $options .= qq{
        <input type="checkbox" name="emoticons" value="1" checked>$_str_text{'emoticon_option'}
    };
}


unless ($options eq "") {$options .= "<br><br>"}



$sth = $dbh->prepare('SELECT First_Name, Last_Name FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
@userinfo = $sth->fetchrow_array();

if ($_fromname != 0) {
    $fullname = "$userinfo[0] $userinfo[1]";
} else {
    $fullname = "";
}

&_layoutReply(
    $irttext,
    $formdata,
    $options,
    $backtotoc,
    $backtothread,
    $fullname
);

}



###########################################################################
#  BEGIN CONFIRMATION

sub confirmation { print "Location: toc.pl?board=$board$gueststring\n\n"; }