#!/usr/bin/perl

use CGI qw(param);
use DBI;
use CGI::Cookie;
use bbconfig;
use layout;
use bbfunc;
use session;

###########################################################################
#  BEGIN VARIABLE DECLARATION

# Parameters
$action = param("action");
$guest = param("guest");
$msg = param("msg");
if ($guest ne "yes") {$id = &_login; $gueststring = ""; $guestinput = "";} else {$id = 1; $gueststring = "&guest=yes"; $guestinput = "<input type=\"hidden\" name=\"guest\" value=\"yes\">";}









###########################################################################
#  BEGIN MAIN SCRIPT

if ($guest eq "yes") {
    &_descerror("Notice","Guests do not have any preferences to modify.");
}

if ($action eq "changeprefs") {&changeprefs;}
elsif ($action eq "addfavbb") {&addfavbb;}
elsif ($action eq "delfavbb") {&delfavbb;}
elsif ($action eq "changepass") {&changepass;}
else {&display;}

#
#########################################################################



###########################################################################
#  BEGIN DISPLAY

sub display
{

$sth = $dbh->prepare('SELECT Username, Location, Header, Sidebar, AllBoards FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
@userinfo = $sth->fetchrow_array();

$sth = $dbh->prepare('SELECT BUsersID, First_Name, Last_Name, Email FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
@personinfo = $sth->fetchrow_array();

my $showheader = "";
if ($userinfo[2] eq "yes") {
    $showheader .= "<select name=\"header\"><option selected>yes</option>";
    $showheader .= "<option>no</option></select>";
} else {
    $showheader .= "<select name=\"header\"><option selected>no</option>";
    $showheader .= "<option>yes</option></select>";
}

my $showsidebar = "";
if ($userinfo[3] eq "yes") {
    $showsidebar .= "<select name=\"sidebar\"><option selected>yes</option>";
    $showsidebar .= "<option>no</option></select>";
} else {
    $showsidebar .= "<select name=\"sidebar\"><option selected>no</option>";
    $showsidebar .= "<option>yes</option></select>";
}

my $showallboards = "";
if ($userinfo[4] ne "no") {
    $showallboards .= "<select name=\"allboards\"><option selected>yes</option>";
    $showallboards .= "<option>no</option></select>";
} else {
    $showallboards .= "<select name=\"allboards\"><option selected>no</option>";
    $showallboards .= "<option>yes</option></select>";
}

@BBIDS = ();
$DelOptionList = "";
$sth = $dbh->prepare('SELECT BFavBoards.BBoardsID, BBoards.Name, BBranches.Name FROM BFavBoards, BBoards, BBranches WHERE BFavBoards.BUsersID = ? AND BFavBoards.BBoardsID = BBoards.BBoardsID AND BBoards.BBranchesID = BBranches.BBranchesID ORDER BY BBranches.BBranchesID, BBoards.Name') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
while (@temp = $sth->fetchrow_array()) {
    push @BBIDS, $temp[0];
    $DelOptionList .= "<option value=\"$temp[0]\">[$temp[2]] $temp[1]</option>";
}

$AddOptionList = "";
$sth = $dbh->prepare('SELECT BBoards.BBoardsID, BBoards.Name, BBranches.Name FROM BBoards, BBranches WHERE BBoards.BBranchesID = BBranches.BBranchesID ORDER BY BBranches.BBranchesID, BBoards.Name') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@temp = $sth->fetchrow_array()) {
    $inlist = "false";
    foreach $tmpbb (@BBIDS) {if ($temp[0] == $tmpbb) {$inlist = "true";}}
    if ($inlist eq "false") {$AddOptionList .= "<option value=\"$temp[0]\">[$temp[2]] $temp[1]</option>";}
}

&_layoutPrefs(
    $userinfo[0],
    $personinfo[1],
    $personinfo[2],
    $userinfo[1],
    $personinfo[3],
    $showheader,
    $showsidebar,
    $showallboards,
    $DelOptionList,
    $AddOptionList,
    $msg
);

}


###########################################################################
#  BEGIN CHANGEPREFS

sub changeprefs
{

$header = param("header");
$sidebar = param("sidebar");
$location = param("location");
$email = param("email");
$allboards = param("allboards");
$first_name = param("first_name");
$last_name = param("last_name");

$sth = $dbh->prepare('UPDATE BUsers SET Header = ?, Sidebar = ?, Location = ?, Email = ?, AllBoards = ?, First_Name = ?, Last_Name = ? WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($header, $sidebar, $location, $email, $allboards, $first_name, $last_name, $id) or &_error($sth->errstr);

print "Location: prefs.pl?msg=$_str_text{'prefs_updated'}\n\n";

}



###########################################################################
#  BEGIN CHANGEPASS

sub changepass
{

$oldpass = param("oldpass");
$newpass = param("newpass");
$confpass = param("confpass");

if ($_requireoldpw != 0) {
    $sth = $dbh->prepare('SELECT Password, PASSWORD(?) FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute($oldpass, $id) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();
    if ($temp[1] ne $temp[0]) {&_descerror("Error", "Your old password was incorrect.");}
}

if ($newpass ne $confpass) {
    &_descerror("Error", "Your new password and confirmation password did not match.");
} elsif (length($newpass) < $_passwordminlen) {
    &_descerror("Error", $_str_errors{'pass_too_short'});
} elsif (length($newpass) > $_passwordmaxlen) {
    &_descerror("Error", $_str_errors{'pass_too_long'});
}

$sth = $dbh->prepare('UPDATE BUsers SET Password = PASSWORD(?) WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($newpass, $id) or &_error($sth->errstr);

$sth = $dbh->prepare('SELECT Password FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();

$cookievalue = "$id,$temp[0]";
$c = new CGI::Cookie(-name => "$_cookie", -value => $cookievalue, -path =>  $_cookiepath);

print "Set-Cookie: $c\n";
print "Location: prefs.pl?msg=$_str_text{'password_changed'}\n\n";

}


###########################################################################
#  BEGIN ADDFAVBB

sub addfavbb
{

if ($guest ne "yes") {
    $bbid = param("bb");
    $sth = $dbh->prepare('INSERT INTO BFavBoards (BUsersID, BBoardsID) VALUES (?,?)') or &_error($sth->errstr);
    $sth->execute($id, $bbid) or &_error($sth->errstr);
}

print "Location: prefs.pl?msg=$_str_text{'bb_add_fav'}\n\n";

}


###########################################################################
#  BEGIN DELFAVBB

sub delfavbb
{

if ($guest ne "yes") {
    $bbid = param("bb");
    $sth = $dbh->prepare('DELETE FROM BFavBoards WHERE BUsersID = ? AND BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($id, $bbid) or &_error($sth->errstr);
}

print "Location: prefs.pl?msg=$_str_text{'bb_del_fav'}\n\n";

}