#!/usr/bin/perl


use CGI qw(param);
use DBI;
use bbconfig;
use layout;
use bbfunc;
use session;

###########################################################################
#  BEGIN VARIABLE DECLARATION

# Parameters
$guest = param("guest");
if ($guest ne "yes") {$id = &_login; $gueststring = ""; $guestinput = "";} else {$id = 1; $gueststring = "&guest=yes"; $guestinput = "<input type=\"hidden\" name=\"guest\" value=\"yes\">";}
$action = param("action");
$board = param("board");
$subject = param("subject");
$writer = param("writer");
$message = param("message");
$emoticons = param("emoticons");
$links = param("links");







###########################################################################
#  BEGIN MAIN SCRIPT

&_access($board, $id, "block_readonly");
if ($action eq "post") {&post;}
elsif ($action eq "confirmation") {&confirmation;}
else {&display;}

#
#########################################################################



###########################################################################
#  BEGIN POST

sub post
{

if (($guest eq "yes")&&($_guestpost == 0)) {
    &_descerror("Error",$_str_errors{'guest_no_post'});
}

if ((length($subject) < $_subjectminlen)||(length($subject) > $_subjectmaxlen)) {
    &_descerror("Error",$_str_errors{'subject_length'});
}

if ((length($writer) < $_writerminlen)||(length($writer) > $_writermaxlen)) {
    &_descerror("Error",$_str_errors{'writer_length'});
}

$message = &_encode_string($message,undef,$links,$emoticons);
$subject = &_encode_string($subject);
$writer = &_encode_string($writer,"nohtml");

if ($ENV{"REMOTE_HOST"} eq "") {
    if ($ENV{"REMOTE_ADDR"} eq "") {
        $remotename = "Unresolved";
    } else {
        $remotename = $ENV{"REMOTE_ADDR"};
    }
} else {
    $remotename = $ENV{"REMOTE_HOST"};
}

$sth = $dbh->prepare('SELECT PostCount FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
$sth->execute($board) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();
$sth = $dbh->prepare('UPDATE BBoards SET PostCount = ? WHERE BBoardsID = ?') or &_error($sth->errstr);
$sth->execute($temp[0]+1, $board) or &_error($sth->errstr);
$sth = $dbh->prepare('DELETE FROM BBoardBold WHERE BBoardsID = ?') or &_error($sth->errstr);
$sth->execute($board) or &_error($sth->errstr);

$sth = $dbh->prepare('INSERT INTO BPosts (Subject, Writer, BUsersID, Time, Message, PostCount, BBoardsID, Remote_Name) VALUES (?,?,?,?,?,?,?,?)') or &_error($sth->errstr);
$sth->execute($subject, $writer, $id, $currenttime, $message, 0, $board, $remotename) or &_error($sth->errstr);

print "Location: post.pl?action=confirmation&board=$board$gueststring\n\n";

}


###########################################################################
#  BEGIN DISPLAY

sub display
{

if (($guest eq "yes")&&($_guestpost == 0)) {
    &_descerror("Error",$_str_errors{'guest_no_post'});
}

$sth = $dbh->prepare('SELECT Name FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
$sth->execute($board) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();

$sth = $dbh->prepare('SELECT First_Name, Last_Name FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
@userinfo = $sth->fetchrow_array();

my $formdata = "<input type=\"hidden\" name=\"board\" value=\"$board\">";

$backtotoc = qq{<a href="main.pl?action=viewboard&board=$board$gueststring">$_str_text{'backtoclink'}</a>};

my $options;

if ($_linkify) {
    $options = qq{
        <input type="checkbox" name="links" value="1" checked>$_str_text{'link_option'}
    };
}

if ($_emoticons) {
    $options .= qq{
        <input type="checkbox" name="emoticons" value="1" checked>$_str_text{'emoticon_option'}
    };
}

unless ($options eq "") {$options .= "<br><br>"}

if ($_fromname != 0) {
    $fullname = "$userinfo[0] $userinfo[1]";
} else {
    $fullname = "";
}

&_layoutPost(
    $temp[0],
    $formdata,
    $options,
    $backtotoc,
    $fullname
);

}



###########################################################################
#  BEGIN CONFIRMATION

sub confirmation { print "Location: toc.pl?board=$board$gueststring\n\n"; }