use bbconfig;
use layout;


$_version = "0.2.1";
$_release = "Beta";

if ($_usetime != 0) {
    use Time::HiRes qw(gettimeofday);
    $_initial_time = gettimeofday;
}

#  Icon
######################################################################

sub _icon {
    if (($ENV{'HTTP_USER_AGENT'} =~ /Mozilla/) && ($ENV{'HTTP_USER_AGENT'} !~ /Gecko/) && ($ENV{'HTTP_USER_AGENT'} !~ /MSIE/)) {$alignmethod = "baseline"}
    else {$alignmethod = "absmiddle"}
    return qq{<img src="$_imgpath/$_[0].gif" border="0" align="$alignmethod">};

}


#  Table
######################################################################

sub _table {

    return qq{
    <table border="0" cellpadding="0" cellspacing="2" width="$_[0]" bgcolor="$_tableborder">
        <tr>
            <td>
                <table border="0" cellpadding="3" cellspacing="2" width="100%">
                    <tr>
                        <td bgcolor="$_tablebg">$_[1]</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    };

}



###########################################################################
#  BEGIN COMMAIFY
#
# Turns 1234567 into 1,234,567

sub _commaify {
    my $number = reverse $_[0];
    $number =~ s/(\d\d\d)(?=\d)(?!\d*\.)/$1,/g;
    return scalar reverse $number;
}


###########################################################################
#  BEGIN FORMAT

sub _format {
    my $text = shift;
    my $linkswitch = shift;
    my $emoticonswitch = shift;

    if ($_linkify && $linkswitch) {

        $text =~ s/\b((http:\/\/|ftp:\/\/|gopher:\/\/|www\.)                               # Valid Protocols, followed by two backslashes
                   \w[\w|\.+|\%|\?|\-|\&|\~|\+|\=|\#|\/]*          # Any of these characters
                   ([\w|\/]))                                    # End with either a slash or a valid word character      
                  /\<\!\-\-L\-\-\>\<a href=\"$1\" target=\"_new\"\>$1\<\/a\>/xg;
        $text =~ s/(mailto:|)                                    # mailto: at the beginning or not
                   ([\w|\.]+                                     # Any word character or period
                   \@                                            # "@" sign       
                   \w[\w|\.|\%|\?|\-|\+|\=]+\.\w+)              # Followed by any number of characters
                  /\<\!\-\-L\-\-\>\<a href=\"mailto:$2\"\>$2\<\/a\>/xg;
    }

    if ($_emoticons && $emoticonswitch) {
        foreach my $icon (keys %_emoticons) {
            my $url = qq{<img src="$_emoticonspath/$_emoticons{$icon}" border="0" height="$_emoticonheight" width="$_emoticonwidth" align="top" alt="$icon">};
            $text =~ s/\Q$icon/$url/g;
        }
    }

    return $text;
}



###########################################################################
#  BEGIN ENCODE_STRING

sub _encode_string {
    my $string = shift;
    my $option = shift;
    my $links = shift;
    my $emoticons = shift;

    $string =~ s/</&lt;/g;
    $string =~ s/>/&gt;/g;

    if (($_convertnewline != 0)&&($option ne "nohtml")) {
        $string =~ s/\n/<br>/g;
    } elsif ($option ne "nohtml") {
        $string =~ s/\n\n/<p>/g;
    }

    if ($_multiplespaces) {
        $string =~ s/ \s/ &nbsp;/g;
    }

    foreach $word (@_censored_words) {
        my $replace = $_censor x length($word);
        $string =~ s/\b$word\b/$replace/ig;
    }

    foreach $word (@_censored_superwords) {
        my $replace = $_censor x length($word);
        $string =~ s/$word/$replace/ig;
    }

    $string = &_format($string,$links,$emoticons);

    return $string;
}

###########################################################################
#  BEGIN DECODE_STRING

sub _decode_string {
    my $string = shift;

    $string =~ s/\<\!\-\-L\-\-\>\<.*?\>(.*?)\<\/a\>/$1/g;
    $string =~ s/\<img .*? alt\=\"(.*?)\"\>/$1/g;

    $string =~ s/&lt;/</g;
    $string =~ s/&gt;/>/g;

    if ($_convertnewline != 0) {
        $string =~ s/<br>/\n/g;
    } else {
        $string =~ s/<br><br>/\n\n/g;
        $string =~ s/<p>/\n\n/g;
    }

    return $string;
}


###########################################################################
#  BEGIN TIMEDATE
#
# Turns epoch time into an understandible time.

sub _timedate
{

    my($sec,$min,$hour,$day,$month,$year,$dls,$timezone,$tod);

    ($sec,$min,$hour,$day,$month,$year,undef,undef,$dls) = localtime(shift);

    my $fuzzied;
    my @now = localtime(time);
    my @yesterday = localtime(time - 86400);

    if ($day == $now[3] && $month == $now[4] && $year == $now[5]) {
        $fuzzied = 1;
    } elsif ($day == $yesterday[3] && $month == $yesterday[4] && $year == $yesterday[5]) {
        $fuzzied = 2;
    }

    $hour += int($_zoneoffset/60);
    $min += $_zoneoffset % 60;

    $month++;
    if ($dls) {$timezone = $_timezone_DL;} else {$timezone = $_timezone;}
    if ($_month_name) {$month = $_month_names[$month - 1]};
    if ($month < 10 && $_date_zeros && !$_month_name) {$month = "0$month";}
    if ($day < 10 && $_date_zeros) {$day = "0$day";}
    if ($hour == 0 && !$_24hour) {$hour = 12; $tod = $_am;} 
    if ($hour > 12 && !$_24hour) {$hour -= 12; $tod = $_pm;} elsif (!$_24hour) {$tod = $_am;}
    if ($_2digityear) {$year = substr($year,1);} else {$year += 1900;}
    if ($hour < 10 && $_hour_zero) {$hour = "0$hour";}
    if ($min < 10) {$min = "0$min";}

    return &_formatFuzzyDateTime($sec,$min,$hour,$tod,$timezone,$_str_text{'fuzzydate_today'}) if ($_fuzzydate && $fuzzied == 1);
    return &_formatFuzzyDateTime($sec,$min,$hour,$tod,$timezone,$_str_text{'fuzzydate_yesterday'}) if ($_fuzzydate && $fuzzied == 2);
    return &_formatDateTime($sec,$min,$hour,$tod,$day,$month,$year,$timezone);

}


sub _access {

    my $board = $_[0];
    my $user = $_[1];
    my $access = $_[2];

    $sth = $dbh->prepare('SELECT Count(*) FROM BBoardAccess WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    if ($temp[0] != 0) {
        my $sql = "SELECT Count(*) FROM BBoardAccess WHERE BBoardsID = ? AND BUsersID = ?";
        if ($access eq "block_readonly") {$sql .= " AND Access != \"readonly\"";}
        $sth = $dbh->prepare($sql) or &_error($sth->errstr);
        $sth->execute($board, $user) or &_error($sth->errstr);
        @temp = $sth->fetchrow_array();
        if ($temp[0] == 0) {
            $sth = $dbh->prepare('SELECT Username FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
            $sth->execute($user) or &_error($sth->errstr);
            my @name = $sth->fetchrow_array();

            $sth = $dbh->prepare('SELECT Access FROM BBoardAccess WHERE BUsersID = ? AND BBoardsID = ?') or &_error($sth->errstr);
            $sth->execute($user, $board) or &_error($sth->errstr);
            if (@temp = $sth->fetchrow_array()) {
                &_descerror("Read Only Access", "User <B>$name[0]</B> cannot make posts to this board.");
            } else {
                &_descerror("Access Denied", "User <B>$name[0]</B> does not have access to this board.");
            }
        }
    }

}


1;