#   Binary Concepts Bulletin Board System
#   Author: Brian Kirkland

#   --- bbconfig.pm --- 
#   Configuration Module

# For yes/no values, 1 = yes, 0 = no

$_imgpath        = "../../images/bb";     # URL Path to image dir, relative to dir of PL files
$_emoticonspath  = "../../images/bb/emoticons";    # URL Path to emoticons dir, relative to dir of PL files
$_dbusername     = "username";            # Username to access MYSQL DB
$_dbpassword     = "password";            # Password to access MYSQL DB
$_dbhostname     = "";                    # Hostname to access MYSQL DB (this is optional on some implementations)
$_cookie         = "bc_bbs";              # Name of the cookie for this board system
$_cookiepath     = "/cgi-bin/bb/";        # /folder/to/bb/dir/
$_title          = "Binary Board System"; # Title shown on Main.pl
$_pathtoregister = "http://yoursite.com/cgi-bin/bb/register.pl";   # Absolute URL to register.pl
$_header         = "Binary Board System"; # Long title of bulletin board system
$_database       = "dbname"; # MYSQL DB Name
$_usernameminlen = 4;        # Minimum Username Length
$_usernamemaxlen = 16;       # Maximum Username Length
$_passwordminlen = 4;        # Minimum Password Length
$_passwordmaxlen = 16;       # Maximum Password Length
$_subjectminlen  = 2;        # Minimum Subject Length
$_subjectmaxlen  = 60;       # Maximum Subject Length
$_writerminlen   = 2;        # Minimum "From" field Length
$_writermaxlen   = 60;       # Maximum "From" field Length
$_maxsearch      = 50;       # Maximum number of records returned in a search
$_searchallboards= 1;        # Allow ability to search all boards, disabling can improve search performance
$_linkify        = 1;        # Make URLs and E-mail addresses links in articles
$_guestpost      = 1;        # Allow guests to post
$_viewremotename = 1;        # Allow registered users to see remote names of posters
$_hitcounters    = 1;        # Enable/disable hit counters on the TOC
$_favoriteslist  = 1;        # Enable/disable favorites list for registered users
$_convertnewline = 1;        # 1 = Convert every newline to <br>, 0 = Convert double newlines to <p>
$_requireoldpw   = 1;        # 1 = Require, 0 = Don't require old password in order to change password
$_usetime        = 0;        # Display execution time at the bottom of every page (requires Time::HiRes)
$_showids        = 1;        # Display board and article IDs
$_multiplespaces = 1;        # Allow more than one consecutive space to be posted in messages.
$_emoticons      = 1;        # Allow the conversion of emoticons (eg. ":-)" to an image) (see layout.pm for more options)
$_fromname       = 1;        # Default "From" field to user's name

# -- no need to edit past this point --

$currenttime = time;

if ($_dbhostname ne "") {
    $dbh = DBI->connect("dbi:mysql:$_database:$_dbhostname","$_dbusername","$_dbpassword") or print "Content-type: text/html\n\n<html><body>Failed to connect to database:<p>dbi:mysql:$_database:$_dbhostname - user: $_dbusername</body></html>";
} else {
    $dbh = DBI->connect("dbi:mysql:$_database","$_dbusername","$_dbpassword") or print "Content-type: text/html\n\n<html><body>Failed to connect to database:<p>dbi:mysql:$_database - user: $_dbusername</body></html>";
}

1;