#!/usr/bin/perl


use CGI qw(param);
use DBI;
use bbconfig;
use layout;
use bbfunc;
use session;

###########################################################################
#  BEGIN VARIABLE DECLARATION

# Parameters
$guest = param("guest");
if ($guest ne "yes") {$id = &_login; $gueststring = ""; $guestinput = "";} else {$id = 1; $gueststring = "&guest=yes"; $guestinput = "<input type=\"hidden\" name=\"guest\" value=\"yes\">";}
$action = param("action");
$board = param("board");
$article = param("article");
$flag = param("flag");







###########################################################################
#  BEGIN MAIN SCRIPT

&_access($board, $id);

# Check to make sure this post doesn't belong to a protected board
$sth = $dbh->prepare('SELECT BBoardsID FROM BPosts WHERE BPostsID = ?') or &_error($sth->errstr);
$sth->execute($article) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();
&_access($temp[0], $id);

if ($action eq "viewarticle") {&viewarticle;}
else {&display;}

#
#########################################################################



###########################################################################
#  BEGIN VIEWARTICLE

sub viewarticle
{

$replyicon = &_icon("reply");
$blankicon = qq{<img src="$_imgpath/blank.gif" width="20" height="10" border="0">};
$topicon = &_icon("topicon");

if ($flag eq "unread") {
    $sth = $dbh->prepare('DELETE FROM BHistory WHERE BUsersID = ? AND BPostsID = ?') or &_error($sth->errstr);
    $sth->execute($id, $article) or &_error($sth->errstr);
}

if ($guest ne "yes") {
    $sth = $dbh->prepare('SELECT Count(*) FROM BHistory WHERE BUsersID = ? AND BPostsID = ?') or &_error($sth->errstr);
    $sth->execute($id, $article) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();
    if (($temp[0] == 0)&&($flag ne "unread")) {
        $sth = $dbh->prepare('INSERT INTO BHistory (BUsersID, BPostsID) VALUES (?,?)') or &_error($sth->errstr);
        $sth->execute($id, $article) or &_error($sth->errstr);
    }
}

$sth = $dbh->prepare('SELECT BPostsID, Subject, Writer, Username, Time, Message, PostCount, Remote_Name FROM BPosts, BUsers WHERE BPosts.BUsersID = BUsers.BUsersID AND BPostsID = ?') or &_error($sth->errstr);
$sth->execute($article) or &_error($sth->errstr);
$basepost = $sth->fetchrow_hashref();

$basepost->{Time} = &_timedate($basepost->{Time});

$basepost->{Message} = &_format($basepost->{Message},$linkswitch,$emoticonswitch);

my @replies = ();
$sth = $dbh->prepare('SELECT BRepliesID, Writer, Username, Time, Message, InReplyTo, BPostsID, PostCount, Remote_Name FROM BReplies, BUsers WHERE BReplies.BUsersID = BUsers.BUsersID AND BPostsID = ? ORDER BY Time') or &_error($sth->errstr);
$sth->execute($article) or &_error($sth->errstr);
while ($rep = $sth->fetchrow_hashref()) {
    $rep->{IndexMessage} = &_decode_string($rep->{Message});
    if (length($rep->{IndexMessage}) > 40) {$rep->{IndexMessage} = substr($rep->{IndexMessage},0,40) . "...";}
    $rep->{IndexMessage} = &_encode_string($rep->{IndexMessage}, "nohtml");
    $rep->{Time} = &_timedate($rep->{Time});

    #if ($rep->{InReplyTo} == 0) {
    #    $sth2 = $dbh->prepare('SELECT Writer FROM BPosts WHERE BPostsID = ?') or &_error($sth2->errstr);
    #    $sth2->execute($article) or &_error($sth2->errstr);
    #    @temp2 = $sth2->fetchrow_array();
    #    $irtpostnum = "Base Post";
    #    $irtwriter = $temp2[0];
    #} else {
    #    $sth2 = $dbh->prepare('SELECT PostCount, Writer FROM BReplies WHERE PostCount = ? AND BPostsID = ?') or &_error($sth2->errstr);
    #    $sth2->execute($rep->{InReplyTo}, $article) or &_error($sth2->errstr);
    #    @temp2 = $sth2->fetchrow_array();
    #    $irtpostnum = "Post $temp2[0]";
    #    $irtwriter = $temp2[1];
    #}

    $rep->{Message} = &_format($rep->{Message},$linkswitch,$emoticonswitch);

    push @replies, $rep;
}


&_layoutArticle(
    $basepost,
    \@replies,
    $#replies+1
);

}


###########################################################################
#  BEGIN DISPLAY

sub display
{

print "Content-type: text/html\n\n";
print &_header("$_header");

#Nothing?

print &_footer;

}