#!/usr/bin/perl

use CGI qw(param);
use DBI;
use bbconfig;
use layout;
use bbfunc;
use session;

###########################################################################
#  BEGIN VARIABLE DECLARATION

$id = &_login;

# Parameters
$action = param("action");
$board = param("board");
$branchid = param("branchid");
$newbranchid = param("newbranchid");
$branchname = param("branchname");
$forumname = param("forumname");
$shortname = param("shortname");
$longname = param("longname");
$username = param("username");
$access = param("access");
$pid = param("pid");
$rid = param("rid");
$msg = param("msg");
$firstname = param("firstname");
$lastname = param("lastname");
$location = param("location");
$email = param("email");
$user = param("user");
$password = param("password");
$pwconfirm = param("pwconfirm");
$mainpage = param("mainpage");



###########################################################################
#  BEGIN MAIN SCRIPT


$sth = $dbh->prepare('SELECT Administrator, AdminRealmID FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
$sth->execute($id) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();
$admin = $temp[0];
$realm = $temp[1];

if (($admin ne "S")&&($admin ne "A")&&($admin ne "C")&&($admin ne "B")) {
    &_descerror("Error", "You are not logged in as an administrator.<br><br><a href=\"login.pl\">Login</a>");
}

if ($action eq "") {
    &display;
} elsif ($admin eq "S") {
    if ($action eq "addboard") {&addboard;}
    elsif ($action eq "delpost") {&delpost;}
    elsif ($action eq "delreply") {&delreply;}
    elsif ($action eq "moveboard") {&moveboard;}
    elsif ($action eq "delboard") {&delboard;}
    elsif ($action eq "editboard") {&editboard;}
    elsif ($action eq "editbranch") {&editbranch;}
    elsif ($action eq "delbranch") {&delbranch;}
    elsif ($action eq "addbranch") {&addbranch;}
    elsif ($action eq "addboardaccess") {&addboardaccess;}
    elsif ($action eq "delboardaccess") {&delboardaccess;}
    elsif ($action eq "adduser") {&adduser;}
    elsif ($action eq "edituser") {&edituser;}
    elsif ($action eq "disableuser") {&disableuser;}
    elsif ($action eq "enableuser") {&enableuser;}
    elsif ($action eq "promoteadmin") {&promoteadmin;}
    elsif ($action eq "demoteadmin") {&demoteadmin;}
    elsif ($action eq "promotebranchmod") {&promotebranchmod;}
    elsif ($action eq "demotebranchmod") {&demotebranchmod;}
    elsif ($action eq "promoteboardmod") {&promoteboardmod;}
    elsif ($action eq "demoteboardmod") {&demoteboardmod;}
    elsif ($action eq "editpage") {&editpage;}
    else {&_descerror("Error", "You cannot perform that function with your current administrative position.");}
} elsif ($admin eq "A") {
    if ($action eq "addboard") {&addboard;}
    elsif ($action eq "delpost") {&delpost;}
    elsif ($action eq "delreply") {&delreply;}
    elsif ($action eq "moveboard") {&moveboard;}
    elsif ($action eq "delboard") {&delboard;}
    elsif ($action eq "editboard") {&editboard;}
    elsif ($action eq "editbranch") {&editbranch;}
    elsif ($action eq "delbranch") {&delbranch;}
    elsif ($action eq "addbranch") {&addbranch;}
    elsif ($action eq "addboardaccess") {&addboardaccess;}
    elsif ($action eq "delboardaccess") {&delboardaccess;}
    elsif ($action eq "adduser") {&adduser;}
    elsif ($action eq "edituser") {&edituser;}
    elsif ($action eq "disableuser") {&disableuser;}
    elsif ($action eq "enableuser") {&enableuser;}
    elsif ($action eq "promotebranchmod") {&promotebranchmod;}
    elsif ($action eq "demotebranchmod") {&demotebranchmod;}
    elsif ($action eq "promoteboardmod") {&promoteboardmod;}
    elsif ($action eq "demoteboardmod") {&demoteboardmod;}
    elsif ($action eq "editpage") {&editpage;}
    else {&_descerror("Error", "You cannot perform that function with your current administrative position.");}
} elsif ($admin eq "C") {
    if ($action eq "addboard") {&addboard;}
    elsif ($action eq "delpost") {&delpost;}
    elsif ($action eq "delreply") {&delreply;}
    elsif ($action eq "delboard") {&delboard;}
    elsif ($action eq "editboard") {&editboard;}
    elsif ($action eq "addboardaccess") {&addboardaccess;}
    elsif ($action eq "delboardaccess") {&delboardaccess;}
    elsif ($action eq "promoteboardmod") {&promoteboardmod;}
    elsif ($action eq "demoteboardmod") {&demoteboardmod;}
    else {&_descerror("Error", "You cannot perform that function with your current administrative position.");}
} elsif ($admin eq "B") {
    if ($action eq "delpost") {&delpost;}
    elsif ($action eq "delreply") {&delreply;}
    elsif ($action eq "addboardaccess") {&addboardaccess;}
    elsif ($action eq "delboardaccess") {&delboardaccess;}
    else {&_descerror("Error", "You cannot perform that function with your current administrative position.");}
}

#
#########################################################################




###########################################################################
#  BEGIN DISPLAY

sub display
{

$BoardOptionList = "<option value=\"N/A\" selected>(select a board)</option>";
$BoardOptionListExtended = "<option value=\"N/A\" selected>(select a board)</option>";
$sth = $dbh->prepare('SELECT BBoards.BBoardsID, BBoards.Name, BBranches.Name, BBoards.Long_Name, BBranches.BBranchesID FROM BBoards, BBranches WHERE BBoards.BBranchesID = BBranches.BBranchesID ORDER BY BBranches.BBranchesID, BBoards.Name') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@temp = $sth->fetchrow_array()) {
    if ( ($admin eq "S") || ($admin eq "A") || (($admin eq "C")&&($realm == $temp[4])) || (($admin eq "B")&&($realm == $temp[0])) ) {
        $BoardOptionList .= "<option value=\"$temp[0]\">[$temp[2]] $temp[1]</option>";
        $BoardOptionListExtended .= "<option value=\"$temp[0]\">[$temp[2]] $temp[1] / $temp[3]</option>";
    }
}

$UserOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$UserDisableOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$UserEnableOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$UserPromoteAdminOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$UserDemoteAdminOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$UserPromoteBranchmodOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$UserDemoteBranchmodOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$UserPromoteBoardmodOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$UserDemoteBoardmodOptionList = "<option value=\"N/A\" selected>(select a user)</option>";
$sth = $dbh->prepare('SELECT BUsersID, Username, Enabled, Administrator, AdminRealmID FROM BUsers ORDER BY Username') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@temp = $sth->fetchrow_array()) {
    if ($temp[0] != 1) {
        if (($temp[3] ne "S")&&($temp[3] ne "A")) {
            $UserPromoteAdminOptionList .= "<option value=\"$temp[0]\">$temp[1]</option>";
        } elsif ($temp[3] eq "A") {
            $UserDemoteAdminOptionList .= "<option value=\"$temp[0]\">$temp[1]</option>";
        }

        if (($temp[3] ne "S")&&($temp[3] ne "A")&&($temp[3] ne "C")&&($temp[3] ne "B")) {
            $UserPromoteBranchmodOptionList .= "<option value=\"$temp[0]\">$temp[1]</option>";
            $UserPromoteBoardmodOptionList .= "<option value=\"$temp[0]\">$temp[1]</option>";
        } elsif ($temp[3] eq "C") {
            $sth2 = $dbh->prepare('SELECT Name FROM BBranches WHERE BBranchesID = ?') or &_error($sth2->errstr);
            $sth2->execute($temp[4]) or &_error($sth2->errstr);
            @temp2 = $sth2->fetchrow_array();
            $UserDemoteBranchmodOptionList .= "<option value=\"$temp[0]\">$temp[1] - $temp2[0]</option>";
        } elsif ($temp[3] eq "B") {
            $sth2 = $dbh->prepare('SELECT Name, BBranchesID FROM BBoards WHERE BBoardsID = ?') or &_error($sth2->errstr);
            $sth2->execute($temp[4]) or &_error($sth2->errstr);
            @temp2 = $sth2->fetchrow_array();
            if ($temp2[1] == $realm) {
                $UserDemoteBoardmodOptionList .= "<option value=\"$temp[0]\">$temp[1] - $temp2[0]</option>";
            }
        }

        $UserOptionList .= "<option value=\"$temp[0]\">$temp[1]</option>";
        if ($temp[2] eq "Y") {
            # you can't disable SuperAdmins and Admins
            if (($temp[3] ne "S")&&($temp[3] ne "A")) {
                $UserDisableOptionList .= "<option value=\"$temp[0]\">$temp[1]</option>";
            }
        } else {
            $UserEnableOptionList .= "<option value=\"$temp[0]\">$temp[1]</option>";
        }
    }
}

$BranchTable = "";
$BranchOptionList = "<option value=\"N/A\" selected>(select a branch)</option>";
$BranchOptionListDel = "<option value=\"N/A\" selected>(select a branch)</option>";
$sth = $dbh->prepare('SELECT BBranchesID, Name FROM BBranches ORDER BY BBranchesID') or &_error($sth->errstr);
$sth->execute() or &_error($sth->errstr);
while (@temp = $sth->fetchrow_array()) {
    unless ($temp[1] eq "(separator)") {
        $BranchOptionList .= "<option value=\"$temp[0]\">$temp[1]</option>";
    }

    $sth2 = $dbh->prepare('SELECT Count(*) FROM BBoards WHERE BBranchesID = ?') or &_error($sth2->errstr);
    $sth2->execute($temp[0]) or &_error($sth2->errstr);
    @tempcount = $sth2->fetchrow_array();
    if ($tempcount[0] == 0) {
        $BranchOptionListDel .= "<option value=\"$temp[0]\">[$temp[0]] $temp[1]</option>";
    }
    
    $BranchTable .= qq{
        <tr>
            <form method="POST" action="admin.pl">
            <input type="hidden" name="action" value="editbranch">
            <input type="hidden" name="branchid" value="$temp[0]">
            <td><input type="text" name="newbranchid" size="4" value="$temp[0]"></td>
            <td><input type="text" name="branchname" value="$temp[1]"></td>
            <td><input type="submit" name="submit" value="change"></td>
            </form>
        </tr>
    };

}

$AccessList = qq{
    <option selected value="admin">admin</option>
    <option value="readonly">readonly</option>
    <option value="">regular</option>
};

undef $/;
open(MAIN, "main.bbs");
$MainPage = <MAIN>;
close(MAIN);

print "Content-type: text/html\n\n";
print &_header("System Administration");

print "<br><br><center>";
print &_table("90%", qq{
    <center><font face="$_font" size="$_fonttitlesize" color="$_titlecolor"><B>System Administration</B></font>
    <font face="$_font" size="$_fontregular"><br><br><b>$msg</b></font>
});
print "</center>";

print "<br><br><center>";
print &_table("90%", qq{
    <table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td width="50%">
    <p><font face="$_font" size="$_fontregular"><b>Delete a Post</b>
    <br>Delete entire thread.
    <form method="POST" action="admin.pl">
    <p><input type="hidden" name="action" value="delpost">
    <input type="hidden" name="user" value="$user">
    <input type="hidden" name="pass" value="$pass">
    ID: <input type="text" name="pid">
    <input type="submit" name="submit" value="del post"></form></font>
   
    </td><td width="50%">

    <p><font face="$_font" size="$_fontregular"><b>Delete a Reply</b>
    <br>Delete a specific reply.
    <form method="POST" action="admin.pl">
    <p><input type="hidden" name="action" value="delreply">
    ID: <input type="text" name="rid">
    <input type="submit" name="submit" value="del reply"></form></font>

    </td></tr></table>
});
print "</center>";

if (($admin eq "S")||($admin eq "A")) {
    print "<br><br><center>";
    print &_table("90%", qq{
        <p><font face="$_font" size="$_fontregular"><b>Add User</b>
        <form method="POST" action="admin.pl">
        <p>First Name: <input type="text" name="firstname">
        <br>Last Name: <input type="text" name="lastname">
        <br>Location: <input type="text" name="location">
        <br>E-mail: <input type="text" name="email">
        <br>Username: <input type="text" name="username">
        <br>Password: <input type="password" name="password">
        <br>Confirm Password: <input type="password" name="pwconfirm">
        <input type="hidden" name="action" value="adduser">
        <input type="submit" name="submit" value="add user">
        </form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Edit User</b>
        <br>You only need to fill in the boxes of the fields you want changed.
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="edituser">
        User: <select name="user">$UserOptionList</select>
        <br>New First Name: <input type="text" name="firstname">
        <br>New Last Name: <input type="text" name="lastname">
        <br>New Location: <input type="text" name="location">
        <br>New E-mail: <input type="text" name="email">
        <br>New Password: <input type="password" name="password">
        <br>Confirm Password: <input type="password" name="pwconfirm">
        <input type="submit" name="submit" value="edit user"></form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Disable User</b>
        <br>Lock a user out of the system.
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="disableuser">
        User: <select name="user">$UserDisableOptionList</select>
        <input type="submit" name="submit" value="disable user"></form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Enable User</b>
        <br>Unlock a user.
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="enableuser">
        User: <select name="user">$UserEnableOptionList</select>
        <input type="submit" name="submit" value="enable user"></form></font>
    });
    print "</center>";
}

if ($admin eq "S") {
    print "<br><br><center>";
    print &_table("90%", qq{

        <p><font face="$_font" size="$_fontregular"><b>Promote to Administrator</b>
        <br>Administrators have the power to do everything except promote other people to administrator status.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserPromoteAdminOptionList</select>
        <input type="hidden" name="action" value="promoteadmin">
        <input type="submit" name="submit" value="promote">
        </form></font>

        </td><td bgcolor="$_tablebg" width="50%" valign="top">

        <p><font face="$_font" size="$_fontregular"><b>Demote an Administrator</b>
        <br>Remove a current administrator.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserDemoteAdminOptionList</select>
        <input type="hidden" name="action" value="demoteadmin">
        <input type="submit" name="submit" value="demote">
        </form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Promote to Branch Moderator</b>
        <br>Branch moderators can add/remove boards and delete posts within their own branch.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserPromoteBranchmodOptionList</select>
        <br>Branch: <select name="branchid">$BranchOptionList</select>
        <input type="hidden" name="action" value="promotebranchmod">
        <input type="submit" name="submit" value="promote">
        </form></font>

        </td><td bgcolor="$_tablebg" width="50%" valign="top">

        <p><font face="$_font" size="$_fontregular"><b>Demote a Branch Moderator</b>
        <br>Remove a current branch moderator.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserDemoteBranchmodOptionList</select>
        <input type="hidden" name="action" value="demotebranchmod">
        <input type="submit" name="submit" value="demote">
        </form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Promote to Board Moderator</b>
        <br>Board moderators can delete posts within their own board.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserPromoteBoardmodOptionList</select>
        <br>Board: <select name="board">$BoardOptionList</select>
        <input type="hidden" name="action" value="promoteboardmod">
        <input type="submit" name="submit" value="promote">
        </form></font>

        </td><td bgcolor="$_tablebg" width="50%" valign="top">

        <p><font face="$_font" size="$_fontregular"><b>Demote a Board Moderator</b>
        <br>Remove a current board moderator.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserDemoteBoardmodOptionList</select>
        <input type="hidden" name="action" value="demoteboardmod">
        <input type="submit" name="submit" value="demote">
        </form></font>
    });
    print "</center>";
} elsif ($admin eq "A") {
    print "<br><br><center>";
    print &_table("90%", qq{

        <p><font face="$_font" size="$_fontregular"><b>Promote to Branch Moderator</b>
        <br>Branch moderators can add/remove boards and delete posts within their own branch.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserPromoteBranchmodOptionList</select>
        <br>Branch: <select name="branchid">$BranchOptionList</select>
        <input type="hidden" name="action" value="promotebranchmod">
        <input type="submit" name="submit" value="promote">
        </form></font>

        </td><td bgcolor="$_tablebg" width="50%" valign="top">

        <p><font face="$_font" size="$_fontregular"><b>Demote a Branch Moderator</b>
        <br>Remove a current branch moderator.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserDemoteBranchmodOptionList</select>
        <input type="hidden" name="action" value="demotebranchmod">
        <input type="submit" name="submit" value="demote">
        </form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Promote to Board Moderator</b>
        <br>Board moderators can delete posts within their own board.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserPromoteBoardmodOptionList</select>
        <br>Board: <select name="board">$BoardOptionList</select>
        <input type="hidden" name="action" value="promoteboardmod">
        <input type="submit" name="submit" value="promote">
        </form></font>

        </td><td bgcolor="$_tablebg" width="50%" valign="top">

        <p><font face="$_font" size="$_fontregular"><b>Demote a Board Moderator</b>
        <br>Remove a current board moderator.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserDemoteBoardmodOptionList</select>
        <input type="hidden" name="action" value="demoteboardmod">
        <input type="submit" name="submit" value="demote">
        </form></font>
    });
    print "</center>";
} elsif ($admin eq "C") {
    print "<br><br><center>";
    print &_table("90%", qq{

        <p><font face="$_font" size="$_fontregular"><b>Promote to Board Moderator</b>
        <br>Board moderators can delete posts within their own board.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserPromoteBoardmodOptionList</select>
        <br>Board: <select name="board">$BoardOptionList</select>
        <input type="hidden" name="action" value="promoteboardmod">
        <input type="submit" name="submit" value="promote">
        </form></font>

        </td><td bgcolor="$_tablebg" width="50%" valign="top">

        <p><font face="$_font" size="$_fontregular"><b>Demote a Board Moderator</b>
        <br>Remove a current board moderator.
        <form method="POST" action="admin.pl">
        <p>User: <select name="user">$UserDemoteBoardmodOptionList</select>
        <input type="hidden" name="action" value="demoteboardmod">
        <input type="submit" name="submit" value="demote">
        </form></font>
    });
    print "</center>";
}

if (($admin eq "S")||($admin eq "A")) {
    print "<br><br><center>";
    print &_table("90%", qq{
        <p><font face="$_font" size="$_fontregular"><b>Add Bulletin Board</b>
        <form method="POST" action="admin.pl">
        <p>Branch: <select name="branchid">$BranchOptionList</select>
        <br>Sidebar Name: <input type="text" name="shortname">
        <br>TOC Name: <input type="text" name="longname">
        <input type="hidden" name="action" value="addboard">
        <input type="submit" name="submit" value="add board">
        </form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Move Bulletin Board</b>
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="moveboard">
        Board: <select name="board">$BoardOptionList</select>
        <br>New Branch: <select name="branchid">$BranchOptionList</select>
        <input type="submit" name="submit" value="move board"></form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Edit Bulletin Board</b>
        <br>You only need to fill in the boxes of the fields you want changed.
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="editboard">
        Board: <select name="board">$BoardOptionListExtended</select>
        <br>New Sidebar Name: <input type="text" name="shortname">
        <br>New TOC Name: <input type="text" name="longname">
        <input type="submit" name="submit" value="edit board"></form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Delete Bulletin Board</b>
        <br>WARNING! This will delete the bulletin board and ALL posts and replies!
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="delboard">
        Board: <select name="board">$BoardOptionList</select>
        <input type="submit" name="submit" value="del board"></form></font>
    });
    print "</center>";
} elsif ($admin eq "C") {
    print "<br><br><center>";
    print &_table("90%", qq{
        <p><font face="$_font" size="$_fontregular"><b>Add Bulletin Board</b>
        <form method="POST" action="admin.pl">
        <input type="hidden" name="branchid" value="$realm">
        <p>Sidebar Name: <input type="text" name="shortname">
        <br>TOC Name: <input type="text" name="longname">
        <input type="hidden" name="action" value="addboard">
        <input type="submit" name="submit" value="add board">
        </form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Edit Bulletin Board</b>
        <br>You only need to fill in the boxes of the fields you want changed.
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="editboard">
        Board: <select name="board">$BoardOptionListExtended</select>
        <br>New Sidebar Name: <input type="text" name="shortname">
        <br>New TOC Name: <input type="text" name="longname">
        <input type="submit" name="submit" value="edit board"></form></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Delete Bulletin Board</b>
        <br>WARNING! This will delete the bulletin board and ALL posts and replies!
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="delboard">
        Board: <select name="board">$BoardOptionList</select>
        <input type="submit" name="submit" value="del board"></form></font>
    });
    print "</center>";
}

if (($admin eq "S")||($admin eq "A")) {
    print "<br><br><center>";
    print &_table("90%", qq{
        <p><font face="$_font" size="$_fontregular"><b>Add Branch</b>
        <br>Categories are sorted by ID. Add a category with the name "(separator)" (with parenthesis, but not quotes) to have a blank line separator between categories.
        <table>
        <form method="POST" action="admin.pl">
        <input type="hidden" name="action" value="addbranch">
            <tr>
                <td><font face="$_font" size="$_fontregular"><b>ID</b></font></td>
                <td><font face="$_font" size="$_fontregular"><b>Name</b></font></td>
                <td><font face="$_font" size="$_fontregular">&nbsp;</font></td>
            </tr>
            <tr>
                <td><input type="text" name="branchid" size="4"></td>
                <td><input type="text" name="branchname"></td>
                <td><input type="submit" name="submit" value="add branch"></td>
            </tr>
        </form>
        </table></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Edit Branch</b>
        <br>Categories are sorted by ID.
        <br><table>$BranchTable</table></font>

        </td></tr><tr><td bgcolor="$_tablebg">

        <p><font face="$_font" size="$_fontregular"><b>Delete Branch</b>
        <br>You can only do this on branches that have no boards.
        <form method="POST" action="admin.pl">
        <p><input type="hidden" name="action" value="delbranch">
        Branch: <select name="branchid">$BranchOptionListDel</select>
        <input type="submit" name="submit" value="del branch"></form></font>
    });
    print "</center>";
}

print "<br><br><center>";
print &_table("90%", qq{
    <p><font face="$_font" size="$_fontregular"><b>Add Board Access Restriction</b>
    <br>Boards are restricted if there is 1 or more user on its restriction list. "Admin" access allows users to add/delete other users from the restriction list.</font>
    <table>
    <form method="POST" action="admin.pl">
    <input type="hidden" name="action" value="addboardaccess">
        <tr>
            <td><font face="$_font" size="$_fontregular"><B>Board</b></font></td>
            <td><font face="$_font" size="$_fontregular"><B>User</b></font></td>
            <td><font face="$_font" size="$_fontregular"><B>Access</b></font></td>
            <td><font face="$_font" size="$_fontregular">&nbsp;</font></td>
        </tr>
        <tr>
            <td><select name="board">$BoardOptionList</select></td>
            <td><input type="text" name="username"></td>
            <td><select name="access">$AccessList</select></td>
            <td><input type="submit" name="submit" value="add user"></td>
        </tr>
    </form>
    </table>

    </td></tr><tr><td bgcolor="$_tablebg">

    <p><font face="$_font" size="$_fontregular"><b>Remove Board Access Restriction</b>
    <br>Make sure the user even has access to begin with. This is better off handled through the interface admins get on the BB system itself.
    <table>
    <form method="POST" action="admin.pl">
    <input type="hidden" name="action" value="delboardaccess">
        <tr>
            <td><font face="$_font" size="$_fontregular"><B>Board</B></font></td>
            <td><font face="$_font" size="$_fontregular"><B>User</B></font></td>
            <td><font face="$_font" size="$_fontregular">&nbsp;</font></td>
        </tr>
        <tr>
            <td><select name="board">$BoardOptionList</select></td>
            <td><input type="text" name="username"></td>
            <td><input type="submit" name="submit" value="del user"></td>
        </tr>
    </form>
    </table></font>
});
print "</center><br><br>";

if (($admin eq "S")||($admin eq "A")) {
    print "<br><br><center>";
    print &_table("90%", qq{
        <p><font face="$_font" size="$_fontregular"><b>Edit Main Page</b>
        <br>Post news or announcements on the main page of the BBS, the first page you see when you log in.

        <form method="POST" action="admin.pl">
        <input type="hidden" name="action" value="editpage">
        
        <textarea name="mainpage" rows="35" cols="75">$MainPage</textarea>

        <br><input type="submit" name="submit" value="Modify">

        </form>
            
        </font>
    });
    print "</center>";
}

print &_footer();


}





###########################################################################
#  BEGIN ADDBOARD

sub addboard
{

if ((length($shortname) == 0)||(length($longname) == 0)) {
    &_descerror("Error","You must specify both a short and long name.");
} elsif ($branchid eq "N/A") {
    &_descerror("Error","You must specify a Branch.");
} else {
    if (($admin eq "C")&&($realm != $branchid)) {
        &_descerror("Error", "You can only add boards within your own branch.");
    }

    $sth = $dbh->prepare('INSERT INTO BBoards (BBranchesID, Name, Long_Name) VALUES (?,?,?)') or &_error($sth->errstr);
    $sth->execute($branchid, $shortname, $longname) or &_error($sth->errstr);
    $msg = "Board added successfully.";
    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN MOVEBOARD

sub moveboard
{

if ($board eq "N/A") {
    &_descerror("Error","You must select a BB.");
} elsif ($branchid eq "N/A") {
    &_descerror("Error","You must specify a Branch.");
} else {
    $sth = $dbh->prepare('UPDATE BBoards SET BBranchesID = ? WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($branchid, $board) or &_error($sth->errstr);
    $msg = "Board moved successfully.";
    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN EDITBOARD

sub editboard
{

if ($board eq "N/A") {
    &_descerror("Error","You must select a BB.");
} else {
    $sth = $dbh->prepare('SELECT BBranchesID FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    if (($admin eq "C")&&($realm != $temp[0])) {
        &_descerror("Error", "You can only edit boards within your own branch.");
    }

    if ($shortname ne "") {
        $sth = $dbh->prepare('UPDATE BBoards SET Name = ? WHERE BBoardsID = ?') or &_error($sth->errstr);
        $sth->execute($shortname, $board) or &_error($sth->errstr);
    }

    if ($longname ne "") {
        $sth = $dbh->prepare('UPDATE BBoards SET Long_Name = ? WHERE BBoardsID = ?') or &_error($sth->errstr);
        $sth->execute($longname, $board) or &_error($sth->errstr);
    }

    $msg = "Board edited successfully.";
    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN DELPOST

sub delpost
{

if (length($pid) == 0) {
    &_descerror("Error", "You must specify a Post ID");
} else {
    $sth = $dbh->prepare('SELECT BPosts.BBoardsID, BBranchesID FROM BPosts, BBoards WHERE BPostsID = ? AND BPosts.BBoardsID = BBoards.BBoardsID') or &_error($sth->errstr);
    $sth->execute($pid) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    if (($admin eq "C")&&($realm != $temp[1])) {
        &_descerror("Error", "You can only delete posts within your own branch.");
    } elsif (($admin eq "B")&&($realm != $temp[0])) {
        &_descerror("Error", "You can only delete posts within your own board.");
    }

    $sth = $dbh->prepare('DELETE FROM BPosts WHERE BPostsID = ?') or &_error($sth->errstr);
    $sth->execute($pid) or &_error($sth->errstr);
    $sth = $dbh->prepare('DELETE FROM BReplies WHERE BPostsID = ?') or &_error($sth->errstr);
    $sth->execute($pid) or &_error($sth->errstr);

    $sth = $dbh->prepare('SELECT BBoardsID, PostCount FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($temp[0]) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    $sth = $dbh->prepare('UPDATE BBoards SET PostCount = ? WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($temp[1]-1, $temp[0]) or &_error($sth->errstr);

    $msg = "Post and all its replies deleted successfully.";
    print "Location: admin.pl?msg=$msg\n\n";
}


}


###########################################################################
#  BEGIN DELREPLY

sub delreply
{

if (length($rid) == 0) {
    &_descerror("Error","You must specify a Reply ID");
} else {
    $sth = $dbh->prepare('SELECT BPostsID, PostCount FROM BReplies WHERE BRepliesID = ?') or &_error($sth->errstr);
    $sth->execute($rid) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    $sth = $dbh->prepare('SELECT BPostsID, PostCount, BPosts.BBoardsID, BBranchesID FROM BPosts, BBoards WHERE BPostsID = ? AND BPosts.BBoardsID = BBoards.BBoardsID') or &_error($sth->errstr);
    $sth->execute($temp[0]) or &_error($sth->errstr);
    @postinfo = $sth->fetchrow_array();

    if (($admin eq "C")&&($realm != $temp[3])) {
        &_descerror("Error", "You can only delete posts within your own branch.");
    } elsif (($admin eq "B")&&($realm != $temp[2])) {
        &_descerror("Error", "You can only delete posts within your own board.");
    }

    # Set replies of deleted thread to branch off of main post, by setting InReplyTo = 0
    $sth = $dbh->prepare('UPDATE BReplies SET InReplyTo = ? WHERE BPostsID = ? AND InReplyTo = ?') or &_error($sth->errstr);
    $sth->execute(0, $temp[0], $temp[1]) or &_error($sth->errstr);

    # Start with PostCount, decrement every reply above it. Reply (PostCount) of (TotalPosts).
    for ($lcv = $temp[1]; $lcv < $postinfo[1]; $lcv++) {
        $sth = $dbh->prepare('UPDATE BReplies SET PostCount = ? WHERE BPostsID = ? AND PostCount = ?') or &_error($sth->errstr);
        $sth->execute($lcv, $temp[0], $lcv+1) or &_error($sth->errstr);
        $sth = $dbh->prepare('UPDATE BReplies SET InReplyTo = ? WHERE BPostsID = ? AND InReplyTo = ?') or &_error($sth->errstr);
        $sth->execute($lcv, $temp[0], $lcv+1) or &_error($sth->errstr);
    }

    $sth = $dbh->prepare('DELETE FROM BReplies WHERE BRepliesID = ?') or &_error($sth->errstr);
    $sth->execute($rid) or &_error($sth->errstr);

    $sth = $dbh->prepare('UPDATE BPosts SET PostCount = ? WHERE BPostsID = ?') or &_error($sth->errstr);
    $sth->execute($postinfo[1]-1, $postinfo[0]) or &_error($sth->errstr);

    $msg = "Reply deleted successfully.";
    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN DELBOARD

sub delboard
{

if ($board eq "N/A") {
    &_descerror("Error","You must select a BB.");
} else {
    $sth = $dbh->prepare('SELECT BBranchesID FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    if (($admin eq "C")&&($realm != $temp[0])) {
        &_descerror("Error", "You can only delete boards within your own branch.");
    }

    $sth = $dbh->prepare('SELECT BPostsID FROM BPosts WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    while (@temp = $sth->fetchrow_array()) {
        $sth2 = $dbh->prepare('DELETE FROM BReplies WHERE BPostsID = ?') or &_error($sth2->errstr);
        $sth2->execute($temp[0]) or &_error($sth2->errstr);
        $sth2 = $dbh->prepare('DELETE FROM BHistory WHERE BPostsID = ?') or &_error($sth2->errstr);
        $sth2->execute($temp[0]) or &_error($sth2->errstr);
    }

    $sth = $dbh->prepare('DELETE FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    $sth = $dbh->prepare('DELETE FROM BPosts WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    $sth = $dbh->prepare('DELETE FROM BBoardAccess WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    $sth = $dbh->prepare('DELETE FROM BBoardHits WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    $sth = $dbh->prepare('DELETE FROM BFavBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    $sth = $dbh->prepare('DELETE FROM BBoardBold WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);

    $msg = "Board and all posts/replies/favorites/hits deleted successfully.";
    print "Location: admin.pl?msg=$msg\n\n";
}

}


###########################################################################
#  BEGIN EDITBRANCH

sub editbranch
{

if ($branchname eq "") {
    &_descerror("Error","You must supply a Branch Name.");
} elsif ($branchid eq "N/A") {
    &_descerror("Error","You must specify a Branch.");
} elsif ($newbranchid eq "N/A") {
    &_descerror("Error","You must specify a Branch.");
} else {
    $sth = $dbh->prepare('UPDATE BBranches SET Name = ?, BBranchesID = ? WHERE BBranchesID = ?') or &_error($sth->errstr);
    $sth->execute($branchname, $newbranchid, $branchid) or &_error($sth->errstr);
    $sth = $dbh->prepare('UPDATE BBoards SET BBranchesID = ? WHERE BBranchesID = ?') or &_error($sth->errstr);
    $sth->execute($newbranchid, $branchid) or &_error($sth->errstr);
    $msg = "Branch modified successfully.";
    print "Location: admin.pl?msg=$msg\n\n";
}

}


###########################################################################
#  BEGIN DELBRANCH

sub delbranch
{

if ($branchid eq "N/A") {
    &_descerror("Error","You must specify a Branch.");
} else {
    $sth = $dbh->prepare('SELECT Count(*) FROM BBoards WHERE BBranchesID = ?') or &_error($sth->errstr);
    $sth->execute($branchid) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    if ($temp[0] == 0) {
        $sth = $dbh->prepare('DELETE FROM BBranches WHERE BBranchesID = ?') or &_error($sth->errstr);
        $sth->execute($branchid) or &_error($sth->errstr);
        $msg = "Branch deleted.";
    } else {
        $msg = "Cannot delete branch - there are still boards associated with it.";
    }

    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN ADDBRANCH

sub addbranch
{

if ($branchname eq "") {
    &_descerror("Error","You must supply a Branch Name.");
} elsif ($branchid eq "N/A") {
    &_descerror("Error","You must supply a Branch ID.");
} else {
    $sth = $dbh->prepare('INSERT INTO BBranches (BBranchesID, Name) VALUES (?, ?)') or &_error($sth->errstr);
    $sth->execute($branchid, $branchname) or &_error($sth->errstr);
    $msg = "Branch added successfully.";
    print "Location: admin.pl?msg=$msg\n\n";
}

}


###########################################################################
#  BEGIN ADDBOARDACCESS

sub addboardaccess
{

if ($username eq "") {
    &_descerror("Error","You must supply a username.");
} elsif ($board eq "N/A") {
    &_descerror("Error","You must specify a BB.");
} else {
    $sth = $dbh->prepare('SELECT BUsersID FROM BUsers WHERE Username = ?') or &_error($sth->errstr);
    $sth->execute($username) or &_error($sth->errstr);
    @userinfo = $sth->fetchrow_array();
    if ($username eq "") {
        &_descerror("Error","User not found.");
    } else {
        $sth = $dbh->prepare('SELECT BBoardsID, BBranchesID FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
        $sth->execute($board) or &_error($sth->errstr);
        @temp = $sth->fetchrow_array();

        if (($admin eq "C")&&($realm != $temp[1])) {
            &_descerror("Error", "You can only manage board access within your own branch.");
        } elsif (($admin eq "B")&&($realm != $temp[0])) {
            &_descerror("Error", "You can only manage board access within your own board.");
        }

        $sth = $dbh->prepare('SELECT Count(*) FROM BBoardAccess WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth->errstr);
        $sth->execute($board, $userinfo[0]) or &_error($sth->errstr);
        @temp = $sth->fetchrow_array();
        if ($temp[0] != 0) {
            &_descerror("Error","User already has access to that board.");
        } else {
            $sth = $dbh->prepare('INSERT INTO BBoardAccess (BBoardsID, BUsersID, Access) VALUES (?,?,?)') or &_error($sth->errstr);
            $sth->execute($board, $userinfo[0], $access) or &_error($sth->errstr);
            $msg = "User access added successfully.";
        }
    }
    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN DELBOARDACCESS

sub delboardaccess
{

if ($username eq "") {
    &_descerror("Error","You must supply a username.");
} elsif ($board eq "N/A") {
    &_descerror("Error","You must specify a BB.");
} else {
    $sth = $dbh->prepare('SELECT BUsersID FROM BUsers WHERE Username = ?') or &_error($sth->errstr);
    $sth->execute($username) or &_error($sth->errstr);
    @userinfo = $sth->fetchrow_array();
    if ($username eq "") {
        &_descerror("Error","User not found.");
    } else {
        $sth = $dbh->prepare('SELECT BBoardsID, BBranchesID FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
        $sth->execute($board) or &_error($sth->errstr);
        @temp = $sth->fetchrow_array();

        if (($admin eq "C")&&($realm != $temp[1])) {
            &_descerror("Error", "You can only manage board access within your own branch.");
        } elsif (($admin eq "B")&&($realm != $temp[0])) {
            &_descerror("Error", "You can only manage board access within your own board.");
        }
        $sth = $dbh->prepare('SELECT Count(*) FROM BBoardAccess WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth->errstr);
        $sth->execute($board, $userinfo[0]) or &_error($sth->errstr);
        @temp = $sth->fetchrow_array();
        if ($temp[0] == 0) {
            &_descerror("Error","User doesn't have access to that board anyway.");
        } else {
            $sth = $dbh->prepare('DELETE FROM BBoardAccess WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth->errstr);
            $sth->execute($board, $userinfo[0]) or &_error($sth->errstr);
            $msg = "User access deleted successfully.";
        }
    }
    print "Location: admin.pl?msg=$msg\n\n";
}

}


###########################################################################
#  BEGIN ADDUSER

sub adduser
{

if ($username eq "") {
    &_descerror("Error","You must supply a username.");
} elsif (length($password) < $_passwordminlen) {
    &_descerror("Error",$_str_errors{'pass_too_short'});
} elsif (length($password) > $_passwordmaxlen) {
    &_descerror("Error",$_str_errors{'pass_too_long'});
} elsif ($password ne $pwconfirm) {
    &_descerror("Error",$_str_errors{'password_mismatch'});
} else {
    $sth = $dbh->prepare('SELECT Count(*) FROM BUsers WHERE Username = ?') or &_error($sth->errstr);
    $sth->execute($username) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    if ($temp[0] != 0) {
        &_descerror("Error","Username is already taken.");
    } else {
        $sth = $dbh->prepare('INSERT INTO BUsers (Username, Password, First_Name, Last_Name, Location, Email) VALUES (?,PASSWORD(?),?,?,?,?)') or &_error($sth->errstr);
        $sth->execute($username,$password,$firstname,$lastname,$location,$email) or &_error($sth->errstr);
        $msg = "User created successfully.";
    }
    print "Location: admin.pl?msg=$msg\n\n";
}

}


###########################################################################
#  BEGIN EDITUSER

sub edituser
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} elsif ((length($password) < $_passwordminlen)&&(length($password) != 0)) {
    &_descerror("Error",$_str_errors{'pass_too_short'});
} elsif ((length($password) > $_passwordmaxlen)&&(length($password) != 0)) {
    &_descerror("Error",$_str_errors{'pass_too_long'});
} elsif ($password ne $pwconfirm) {
    &_descerror("Error","Passwords did not match.");
} else {
    $sth = $dbh->prepare('SELECT First_Name, Last_Name, Location, Email, Password FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute($user) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    if ($firstname ne "") {$temp[0] = $firstname;}
    if ($lastname ne "") {$temp[1] = $lastname;}
    if ($location ne "") {$temp[2] = $location;}
    if ($email ne "") {$temp[3] = $email;}

    if ($password ne "") {
        $sth = $dbh->prepare('UPDATE BUsers SET First_Name = ?, Last_Name = ?, Location = ?, Email = ?, Password = PASSWORD(?) WHERE BUsersID = ?') or &_error($sth->errstr);
        $sth->execute($temp[0], $temp[1], $temp[2], $temp[3], $password, $user) or &_error($sth->errstr);
        $msg = "User modified successfully.";
    } else {
        $sth = $dbh->prepare('UPDATE BUsers SET First_Name = ?, Last_Name = ?, Location = ?, Email = ? WHERE BUsersID = ?') or &_error($sth->errstr);
        $sth->execute($temp[0], $temp[1], $temp[2], $temp[3], $user) or &_error($sth->errstr);
        $msg = "User modified successfully.";
    }
    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN DISABLEUSER

sub disableuser
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} else {
    $sth = $dbh->prepare('SELECT Administrator FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute($user) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();
    if (($temp[0] eq "S")||($temp[0] eq "A")) {
        &_descerror("Error", "You cannot disable board administrators.");
    }

    $sth = $dbh->prepare('UPDATE BUsers SET Enabled = ? WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute("N",$user) or &_error($sth->errstr);

    $msg = "User disabled.";

    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN ENABLEUSER

sub enableuser
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} else {
    $sth = $dbh->prepare('UPDATE BUsers SET Enabled = ? WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute("Y",$user) or &_error($sth->errstr);

    $msg = "User enabled.";

    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN PROMOTEADMIN

sub promoteadmin
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} else {
    $sth = $dbh->prepare('UPDATE BUsers SET Administrator = ?, AdminRealmID = ? WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute("A",0,$user) or &_error($sth->errstr);

    $msg = "User promoted to administrator.";

    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN DEMOTEADMIN

sub demoteadmin
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} else {
    $sth = $dbh->prepare('UPDATE BUsers SET Administrator = ?, AdminRealmID = ? WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute("N",0,$user) or &_error($sth->errstr);

    $msg = "User demoted from administrator.";

    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN PROMOTEBRANCHMOD

sub promotebranchmod
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} elsif ($branchid eq "N/A") {
    &_descerror("Error","You must supply a branch.");
} else {
    $sth = $dbh->prepare('UPDATE BUsers SET Administrator = ?, AdminRealmID = ? WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute("C",$branchid,$user) or &_error($sth->errstr);

    $msg = "User promoted to branch moderator.";

    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN DEMOTEBRANCHMOD

sub demotebranchmod
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} else {
    $sth = $dbh->prepare('UPDATE BUsers SET Administrator = ?, AdminRealmID = ? WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute("N",0,$user) or &_error($sth->errstr);

    $msg = "User demoted from branch moderator.";

    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN PROMOTEBOARDMOD

sub promoteboardmod
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} elsif ($board eq "N/A") {
    &_descerror("Error","You must supply a board.");
} else {
    $sth = $dbh->prepare('UPDATE BUsers SET Administrator = ?, AdminRealmID = ? WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute("B",$board,$user) or &_error($sth->errstr);

    $msg = "User promoted to board moderator.";

    print "Location: admin.pl?msg=$msg\n\n";
}

}

###########################################################################
#  BEGIN DEMOTEBOARDMOD

sub demoteboardmod
{

if ($user eq "N/A") {
    &_descerror("Error","You must supply a user.");
} else {
    $sth = $dbh->prepare('SELECT Administrator, AdminRealmID FROM BUsers WHERE BUsersID = ?') or &_error($sth->errstr);
    $sth->execute($user) or &_error($sth->errstr);
    @temp = $sth->fetchrow_array();

    $sth = $dbh->prepare('SELECT BBranchesID FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
    $sth->execute($temp[1]) or &_error($sth->errstr);
    @temp2 = $sth->fetchrow_array();

    if (($temp[0] eq "B")&&($temp2[0] == $realm)) {
        $sth = $dbh->prepare('UPDATE BUsers SET Administrator = ?, AdminRealmID = ? WHERE BUsersID = ?') or &_error($sth->errstr);
        $sth->execute("N",0,$user) or &_error($sth->errstr);

        $msg = "User demoted from board moderator.";

        print "Location: admin.pl?msg=$msg\n\n";
    } else {
        &_descerror("Error", "You can only delete board moderators within your own branch.");
    }
}

}

###########################################################################
#  BEGIN EDITPAGE

sub editpage
{

open(MAIN, ">main.bbs");
print MAIN "$mainpage";
close(MAIN);

print "Location: admin.pl?msg=Main page updated.\n\n";

}