#!/usr/bin/perl

use CGI qw(param);
use DBI;
use bbconfig;
use layout;
use bbfunc;
use session;

###########################################################################
#  BEGIN VARIABLE DECLARATION

# Parameters
$guest = param("guest");
if ($guest ne "yes") {$id = &_login; $gueststring = ""; $guestinput = "";} else {$id = 1; $gueststring = "&guest=yes"; $guestinput = "<input type=\"hidden\" name=\"guest\" value=\"yes\">";}
$action = param("action");
$board = param("board");








###########################################################################
#  BEGIN MAIN SCRIPT

&_access($board, $id);
if ($action eq "adduser") {&adduser;}
elsif ($action eq "deluser") {&deluser;}
else {&display;}

#
#########################################################################



###########################################################################
#  BEGIN DISPLAY

sub display
{

$sth = $dbh->prepare('SELECT Count(*) FROM BBoardAccess WHERE BBoardsID = ?') or &_error($sth->errstr);
$sth->execute($board) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();

if ($show == 0) {$oppshow = 1; $ShowHide = "show";} else {$oppshow = 0; $ShowHide = "hide";}
$tocstring = &_icon("post") . "<a href=\"post.pl?board=$board$gueststring\">post</a> | " . &_icon("refresh") . "<a href=\"toc.pl?board=$board&show=$show$gueststring\">refresh</a> | " . &_icon("previews") . "<a href=\"toc.pl?board=$board&show=$oppshow$gueststring\">$ShowHide previews</a>";
if ($temp[0] != 0) {$tocstring .= " | " . &_icon("access") . "<a href=\"access.pl?board=$board$gueststring\">access list</a>";}

$sth = $dbh->prepare('SELECT Name FROM BBoards WHERE BBoardsID = ?') or &_error($sth->errstr);
$sth->execute($board) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();
$boardname = $temp[0];

my $userlist = "";
$sth = $dbh->prepare('SELECT Username, Access FROM BBoardAccess, BUsers WHERE BBoardAccess.BBoardsID = ? AND BBoardAccess.BUsersID = BUsers.BUsersID ORDER BY Username') or &_error($sth->errstr);
$sth->execute($board) or &_error($sth->errstr);
while (@temp = $sth->fetchrow_array()) {
    $userlist .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$temp[0]";
    if ($temp[1] ne "") {$userlist .= " - <I>$temp[1]</I><BR>";} else {$userlist .= "<BR>";}
}

$sth = $dbh->prepare('SELECT Access FROM BBoardAccess WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth->errstr);
$sth->execute($board, $id) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();

my $adddelForm = "";
if ($temp[0] eq "admin") {
    $delUserList = "";
    $sth = $dbh->prepare('SELECT BBoardAccess.BUsersID, BUsers.Username, BBoardAccess.Access FROM BBoardAccess, BUsers WHERE BBoardAccess.BBoardsID = ? AND BBoardAccess.BUsersID = BUsers.BUsersID ORDER BY BUsers.Username') or &_error($sth->errstr);
    $sth->execute($board) or &_error($sth->errstr);
    while (@temp = $sth->fetchrow_array()) {
        if ($temp[2] ne "admin") {
            $delUserList .= "<option value=\"$temp[0]\">$temp[1]</option>";
        }
    }

    $adddelForm = qq{
        <form method="POST" action="access.pl">
        <input type="hidden" name="action" value="adduser">
        <input type="hidden" name="board" value="$board">
        <font face="$_font" size="$_fontregular">Add user: </font><input type="text" name="user">
        <select name="access"><option value="" selected>Normal</option><option value="readonly">Read Only</option></select>
        <input type="submit" name="submit" value="Add">
        </form>
    };

    if ($delUserList ne "") {
        $adddelForm .= qq{
            <form method="POST" action="access.pl">
            <input type="hidden" name="action" value="deluser">
            <input type="hidden" name="board" value="$board">
            <font face="$_font" size="$_fontregular">Delete user: </font><select name="user">$delUserList</select>
            <input type="submit" name="submit" value="Delete">
            </form>
        };
    }
}

&_layoutAccess(
    $boardname,
    $tocstring,
    $userlist,
    $adddelForm
);


}



###########################################################################
#  BEGIN ADDUSER

sub adduser {

$sth = $dbh->prepare('SELECT Access FROM BBoardAccess WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth->errstr);
$sth->execute($board, $id) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();

if ($temp[0] eq "admin") {
    $user = param("user");
    $uaccess = param("access");
    $sth = $dbh->prepare('SELECT BUsersID FROM BUsers WHERE Username = ?') or &_error($sth->errstr);
    $sth->execute($user) or &_error($sth->errstr);
    $didloop = "false";
    while (@temp = $sth->fetchrow_array()) {
        $didloop = "true";
        $sth = $dbh->prepare('INSERT INTO BBoardAccess (BBoardsID, BUsersID, Access) VALUES (?,?,?)') or &_error($sth->errstr);
        $sth->execute($board, $temp[0], $uaccess) or &_error($sth->errstr);
    }
    if ($didloop eq "false") {
        &_error("Username $user does not exist!");
    }
}

print "Location: access.pl?board=$board\n\n";

}


###########################################################################
#  BEGIN DELUSER

sub deluser {

$sth = $dbh->prepare('SELECT Access FROM BBoardAccess WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth->errstr);
$sth->execute($board, $id) or &_error($sth->errstr);
@temp = $sth->fetchrow_array();

if ($temp[0] eq "admin") {
    $user = param("user");
    $sth = $dbh->prepare('DELETE FROM BBoardAccess WHERE BBoardsID = ? AND BUsersID = ?') or &_error($sth->errstr);
    $sth->execute($board, $user) or &_error($sth->errstr);
}

print "Location: access.pl?board=$board\n\n";

}