#!/usr/bin/perl
#####################################################################
# ChatPro Script Version 2.51                                       #
#                                                                   #
# by Command-O Software                                             #
# http://www.command-o.com                                          #
#                                                                   #
# Copyright 1996-2001, All Rights Reserved                          #
#                                                                   #
# By using this script Licensee agrees to all terms of the License  #
# Agreement. Read it now, if you haven't already.                   #
#####################################################################

$conf_file = "chatpro.conf";
$default_lang_file = "chatpro.lang";

#####################################################################
# CHANGING ANYTHING BELOW THIS LINE WITHOUT THE EXPRESS PERMISSION  #
#  OF COMMAND-O SOFTWARE IS A VIOLATION OF THE LICENSE AGREEMENT    #
#####################################################################
&main;

sub main {
   $|=1;
   require($conf_file);
   if (-e "$plugin_dir/plugin.conf") {
      require("$plugin_dir/plugin.conf");
   }
   &set_values;
   
   $lang_file = $default_lang_file;
   $lock_file = "lock";
   
   $our_link = "http://www.command-o.com/";
   $our_image = "<font size=-1>ChatPro 2.5 by<br> <a target=\"_new\" href=\"$our_link\">Command-O Software</a></font>";
   
   if($profile_plugin) {
      $profiles_active = 1;
      require ("$plugin_dir/profile.pl");
   }
   
   $oshow_status = $show_status;
   
   $time = time() + ($time_zone * 3600);

   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($time);

   #Y2K Display Fix
	$year =~ s/^\d(\d\d)$/$1/;
	
   if ($sec < 10) {
      $sec = "0$sec";
   }
   if ($min < 10) {
      $min = "0$min";
   }
   if ($hour < 10) {
      $hour = "0$hour";
   }
   
   $mon++;

   if ($mon < 10) {
      $mon = "0$mon";
   }

   if ($mday < 10) {
      $mday = "0$mday";
   }

   if($include_date == 1) {
      $date = "$mon/$mday/$year $hour\:$min\:$sec";
      $archive_date = "$mon/$mday/$year $hour\:$min\:$sec";
   }
   elsif($include_date == 2) {
      $date = "$hour\:$min\:$sec";
      $archive_date = "$mon/$mday/$year $hour\:$min\:$sec";
   }   
   else {
      $date = "$hour\:$min\:$sec";
      $archive_date = "$hour\:$min\:$sec";
   }

   &lock;


   
   if ($ENV{'QUERY_STRING'} =~ /^topframe/ && !$ENV{'CONTENT_LENGTH'}) {
      require("$plugin_dir/frames.pl") || die "Couldn't find frames part";
      &topframe;
   }
   elsif ($ENV{'QUERY_STRING'} =~ /^ct--/) {
      require("$plugin_dir/advertise.pl") || die "Couldn't find ad part";
      &lock;
      &click_through;
      &unlock;
      exit;
   }
   elsif ($ENV{'PATH_INFO'} =~ /^\/bottomframe/) {
      require("$plugin_dir/frames.pl") || die "Couldn't find frames part";
      $bottomframe = 1;
      &bottomframe;
   }
   elsif ($ENV{'QUERY_STRING'} =~ /^ad_summary/) {
      &unlock;
      require("$plugin_dir/advertise.pl");
      &ad_summary;
      exit;
   }

   elsif ($ENV{'QUERY_STRING'} =~ /^register/) {
      require("$plugin_dir/register.pl");
      exit;
   }
   else {
     if($ENV{'CONTENT_LENGTH'}) {
         &parse_form;
         &get_variables;
         if ($admin_plugin && $adminyes && $message =~ /^command::/) {
            require("$plugin_dir/admin.pl");
            &admin_work;
         }
         if($admin_plugin && -s "$file_dir/commands.txt") {
            require("$plugin_dir/admin.pl");
            &apply_commands;
         }
         &read_files;
      }
      else {
         if ($ENV{'QUERY_STRING'}) {
            ($tentry,$tout_link) = split(/::/,$ENV{'QUERY_STRING'});
            if($tentry) {
               $entry = $tentry;
            }
            if($tout_link) {
               $out_link = $tout_link;
            }
         }
         $room = $entry;
         if($custom_room_plugin) {
            require("$plugin_dir/custom_room.pl");
            &custom_room;
         }
         require("$lang_file") || die "Could not find language file";
         &misc_lang;
      } 
      
      if($advertise_plugin && $ad_locations) {
         require("$plugin_dir/advertise.pl");
      }
      &check_referer;
      &prelocation;
      &location;
  }
   exit;
}
sub set_values {
   $visitors_time = $visitors_time * 60;
   $chat_time = $chat_time * 60;
}
##########
# Lock
sub lock {

   while(-e "$file_dir/$lock_file") {
      if($time + $lock_time < time()) {
         unlink("$file_dir/$lock_file");
      }
      else {
         select(undef, undef, undef, 0.25);
      }
   }

   open(LOCK,">$file_dir/$lock_file") || die "Could not create lock file";
   close(LOCK);
}

########################
# Parse Form

sub parse_form {

   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($nam, $value) = split(/=/, $pair);
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;
      if($allow_html == 0) {
         $value =~ s/</&lt;/g;
         $value =~ s/>/&gt;/g;
      }
      $FORM{$nam} = $value;
   }
}

###########
# Get variables from form

sub get_variables {

   if ($FORM{'room'}) {
      $room = "$FORM{'room'}";
      $room =~ s/ /_/g;
      $room =~ s/\//_/g;
   }
   
   if($custom_room_plugin) {
      require("$plugin_dir/custom_room.pl");
      &custom_room;
   }
   require("$lang_file") || die "Could not find language file";
   &misc_lang;
   
   if ($FORM{'where'}) {
      $where = "$FORM{'where'}";
   }   

   if($FORM{'frames'}) {
      $frames = "$FORM{'frames'}";
   }

   if ($FORM{'pubroom'}) {
      $pubroom = "$FORM{'pubroom'}";
      $pubroom =~ s/ /_/g;
      $pubroom =~ s/\//_/g;
      if($pubroom eq "$pubroom_title") {
         undef($pubroom);
      }
   }

   if ($FORM{'priroom'}) {
      $priroom = "$FORM{'priroom'}";
      $priroom =~ s/ /_/g;
      $priroom =~ s/\//_/g;
   }

   if ($FORM{'solo'}) {
      $solo = "$FORM{'solo'}";
      if($solo eq "$entire_room") {
         undef($solo);
      }
   }

   if ($FORM{'link'}) {
      $link = "$FORM{'link'}";
   }

   if ($FORM{'name'}) {
      $name = "$FORM{'name'}";
      $name =~ s/\/|"|<|>|\&|\(|\)|\$|\*|\?|\\//g;
      $name =~ s/\s+/ /g;
      $name =~ s/^\s//g;
      $name =~ s/\s$//g;
      $name =~ s/^\.+//g;
      $name =~ s/_/ /g;
      $vname = $name;
      $vname =~ s/ /_/g;

   }

   if ($FORM{'load_time'}) {
      $load_time = "$FORM{'load_time'}";
   }

   if ($FORM{'mail'} =~ /.*\@.*\..*/) {
      $mail = "$FORM{'mail'}";
      $maillink = "<a href=\"mailto:$mail\">$mail</a>";
   }

   if ($FORM{'passwd'}) {
      $passwd = "$FORM{'passwd'}";
   }

   if ($FORM{'password'}) {
      $password = "$FORM{'password'}";
   }

   if ($FORM{'passwordb'}) {
      $passwordb = "$FORM{'passwordb'}";
   }

   if ($FORM{'regno'}) {
      $regno = "$FORM{'regno'}";
   }

   if ($FORM{'nummes'}) {
      $nummes = $FORM{'nummes'};
   }

   if ($FORM{'message'}) {
      $message = $FORM{'message'};
      $message =~ s/\cM//g;
      $tempmessage = $message;
      $tempmessage =~ s/\s+//g;
      if($where ne "$reload_text") {
         if($message =~ /   /) {
            @messagelines = split(/\n/,$message);
            $count = 0;
            while($count < @messagelines) {
               if(length $messagelines[$count] > 80) {
                  $messagelines[$count] = "</pre>$messagelines[$count]<pre>";
                  $longline = 1;
               }
               $count++;
            }
            if($longline) {
               $message = join ("\n", @messagelines); 
            }
            $message = "<pre>$message</pre>";
         }
         $message =~ s/http:\/\/\S+/<a href="$&" target="new">$&<\/a>/g;
         $message =~ s/https:\/\/\S+/<a href="$&" target="new">$&<\/a>/g;
         $message =~ s/ftp:\/\/\S+/<a href="$&" target="new">$&<\/a>/g;
         $message =~ s/\S+\@\S+\.\S+/<a href="mailto:$&">$&<\/a>/g;
         $message =~ s/\n\n/ <p> /g;
         $message =~ s/\n/ <br> /g;
      }
      $message =~ s/&quot/"/g;
      if($filter_plugin) {
         require("$plugin_dir/filter.pl");
         &lang_filter;
      }
   }
   
   if ($FORM{'ignored'}) {
      @ignored = split(/\(\)/,$FORM{'ignored'});
   }

   if($profile_plugin && -e "$profile_dir/$vname") {
      $profile_link = "<a target=\"profile\" href=\"$ENV{'SCRIPT_NAME'}/profile/$vname\">$profile_link_text</a>";
      $maillink = "$maillink $profile_link";
   }
   if($FORM{'admin'}) {
      $adminyes = 1;
   }
}

###########
# Read files

sub read_files {
   if($where || $solo || $ENV{'PATH_INFO'}){
      $origroom = $room;
      
      open(MAIN,"$file_dir/chat$room");
      @main = <MAIN>;
      close(MAIN);

      @main = @main[(0 .. $max_mes)];

      open(VISITORS,"$file_dir/vis$room");
      @visitors = <VISITORS>;   
      close(VISITORS);
      
      $vname = $name;
      $vname =~ s/ /_/g;
      $vname =~ s/\//_/g;

      open(VFILE,"$vis_dir/$vname");
      @vfile = <VFILE>;
      close(VFILE);
      
      @vfile = @vfile[(0 .. $max_mes)];
            
   }
}

############
# Check Referer
sub check_referer {
   
   if ($ENV{'HTTP_REFERER'} =~ /^http:\/\/([^\/]+)/) {
      foreach$referer(@valid_referers) {
         if ($ENV{'HTTP_REFERER'} =~ /$referer/) {
            $okay_referer = 1;
         }
      }
   }
   if(!$ENV{'HTTP_REFERER'}) {
      $okay_referer = 1;
   }
   
   if(!$okay_referer) {
      &unlock;
      &login;
      exit;
   }
}

##########
# Prepare for sending them places

sub prelocation {
   if($where eq "$ignore_text" && $ignore_plugin) {
      require("$plugin_dir/ignore.pl");
      &ignore;
   }

   if($where eq "$go_there") {
      $oldroom = $room;
      if ($priroom) {
         $room = $priroom;
      }
      elsif($pubroom) {
         $room = $pubroom;
      }
      else {
         $where = $reload_text;
      }
      if ($room eq "$oldroom") {
         $where = "$reload_text";
      }
   }

   if($message_plugin) {
      require("$plugin_dir/message.pl");
      &message_prep;
   }
}
##########
# Where are they coming from?

sub location {
   if ($solo && $where eq "$post_text" && $solo ne $entire_room) {
      &verify_password;
      &main_page_lang;
      &privmsg;
      &update;
      &write;
      &unlock;
      &reload;
   }
   elsif ($where eq "register") {
      if($frames eq "yes" && !$ENV{'QUERY_STRING'}) {
         &unlock;
         &check_name;
         if($access_control_plugin) {
            require("$plugin_dir/access_control.pl");
            &admit_style;
         }
         if($admin_plugin) {
            require("$plugin_dir/admin.pl");
            &check_admin;
         }
         require("$plugin_dir/frames.pl") || die "Couldn't find frames part";
         &frames;
      }
      else {
         &main_page_lang;
         &check_name;
         if($access_control_plugin) {
            require("$plugin_dir/access_control.pl");
            &admit_style;
         }
         if($admin_plugin) {
            require("$plugin_dir/admin.pl");
            &check_admin;
         }
         &create;
         &register;
         &write;
         &unlock;
         &reload;
      }
   }
   elsif ($where eq "$post_text") {
      &verify_password;
      &main_page_lang;
      &create;
      &post;
      &update;
      &write;
      &unlock;
      &reload;
   }
   elsif ($where eq "$reload_text") {
      &verify_password;
      &main_page_lang;
      &snag;
      &create;
      &update;
      &write;
      &unlock;
      &reload;
   }
   elsif ($where eq "$go_there") {
      &verify_password;   
      if($pubroom || $priroom) {
         $lang_file = $default_lang_file;
         if($custom_room_plugin) {
            require("$plugin_dir/custom_room.pl");
            &custom_room;
            if($message_plugin) {
               require("$plugin_dir/message.pl");
               &message_prep;
            }
         }
         require("$lang_file") || die "Could not find language file";
         &misc_lang;
         &main_page_lang;
         &create;
         &change;
         &write;
         &unlock;
         &reload;
      }
      else {
         &main_page_lang;
         &snag;
         &create;
         &update;
         &write;
         &unlock;
         &reload;
      }
   }
   elsif ($where eq "$leave_text") {
      &verify_password;
      &leave;
      &write;
      &unlock;
   }
   elsif ($profile_plugin && $where eq "$edit_profile") {
      &check_name;
      if($access_control_plugin) {
         require("$plugin_dir/access_control.pl");
         &admit_style;
      }
      if($passlistok) {
         &edit_profile;
      }
      else {
         &name_taken
      }
   }
   elsif($profile_plugin && $where eq "$update_profile") {
      &check_name;
      if($access_control_plugin) {
         require("$plugin_dir/access_control.pl");
         &admit_style;
      }
      &update_profile;
   }
   elsif($profile_plugin && $where eq "$change_password") {
      &check_name;
      if($access_control_plugin) {
         require("$plugin_dir/access_control.pl");
         &admit_style;
      }
      &change_password;      
   }
   elsif($who_is_where_plugin && $where eq "$who_is_where") {
      &misc_lang;
      if($where_locations =~ /A/ && !$load_time) {
         &main_page_lang;
         &check_name;
         if($access_control_plugin) {
            require("$plugin_dir/access_control.pl");
            &admit_style;
         }
         if($admin_plugin) {
            require("$plugin_dir/admin.pl");
            &check_admin;
         }
      }
      require("$plugin_dir/who_is_where.pl");
      &who_is_where;
   }   
   else {
      &deletevfiles;
      &unlock;
      if(! -e "$file_dir/.htaccess") {
         $access_dir = $file_dir;
         &write_htaccess;
      }
      if(! -e "$vis_dir/.htaccess") {
         $access_dir = $vis_dir;
         &write_htaccess;
      }
      if(! -e "$plugin_dir/.htaccess" && -e $plugin_dir) {
         $access_dir = $plugin_dir;
         &write_htaccess;
      }
      
      &login;
   }
}
############
# Login

sub login {
   &reg_page_lang;
   opendir(VFILES,$vis_dir);
   @vfilelist =  grep(!/^\.|^_/, readdir (VFILES));
   closedir(VFILES);
   $vtotal = @vfilelist - 1;

   open(VISITORS,"$file_dir/vis$room");
   @visitors = <VISITORS>;
   close(VISITORS);

   foreach $visitors_line (@visitors) {
      ($bogus,$load,$bogus2) = split(/:/,$visitors_line);
      if ($time - $load < $visitors_time && $load) {
         push (@visitors_new,"$visitors_line");
      }
   }
   @visitors = @visitors_new;
   undef @visitors_new;
   $vnum = @visitors;

   print "Content-type: text/html\n\n";
   print "<html><head><title>$page_title $reg_page</title></head>\n";

   print "<body bgcolor=$bgcolor background=\"$background\" ";
   print "text=$text_color link=$link_color vlink=$vlink_color>\n";
   if($font_face ne "") {
      print "<font face=\"$font_face\">\n";
   }
   print "<ul><center>\n";

   if($advertise_plugin && $ad_locations =~ /a/) {
      &advertise;
   }

   if ($title_graphic eq "") {
      print "<H1>$page_title</h1>\n";
   }
   else {
      print "<h1><img src=\"$title_graphic\" alt=\"$page_title\"></h1>\n";
   }
   print "<h2>$reg_page</h2><p></center>\n";
   
   &register_body;
}

###########
# Body of Registration Page
# used on initial login, and when their chosen name is taken
# or other problem requires them to login again

sub register_body {
   print "<b><font size=4 color=$one_color><center>$you_must</font>\n";
   print "</b></center><p>$instruct<p>\n";
   if ($vnum < 1) {
      print "$no_vis_a $room $no_vis_b<p>\n";
   }
   elsif ($vnum==1) {
      print "$one_vis_a $room $one_vis_b<p>\n";
   }
   else {
      print "$mult_vis_a $vnum $mult_vis_b $room $mult_vis_c<P>\n";
   }
   if ($vtotal < 1) {
      print "$no_vis_tot<p>\n";
   }
   elsif ($vtotal==1) {
      print "$one_vis_tot<P>\n";
   }
   else {
      print "$mult_vis_tot_a $vtotal $mult_vis_tot_b<P>\n";
   }
   print "$enter_name<br>\n";
   print "<form method=POST action=\"$ENV{'SCRIPT_NAME'}\">\n";
   print "<input type=hidden name=\"where\" value=\"register\">\n";
   print "<input type=hidden name=\"link\" value=\"$out_link\">\n";
   print "<input type=hidden name=\"time\" value=\"$time\">\n";
   print "<table><tr><td>$name_blank</td>\n";
   print "<td><input type=text size=30 name=\"name\" maxlength=25>";
   print "<br></td></tr>\n";
   print "<tr><td>$passwd_blank</td>\n";
   print "<td><input type=password name=\"passwd\" size=30><br></td></tr>\n";
   print "<tr><td>$mail_blank</td>\n";
   print "<td><input type=text size=30 name=\"mail\"><br></td></tr>\n";
   if($frames_plugin  ||$lite_plugin) {
      print "<tr><td>$layout_blank</td><td>\n";
      if($lite_plugin) {
         print "$layout_lite:<input type=radio name=\"frames\" value=\"lite\">&nbsp;\n";
      }
      print "$layout_std:<input type=radio name=\"frames\" value=\"no\">&nbsp;\n";
      if($frames_plugin) {
         print "$layout_frames:<input type=radio name=\"frames\" value=\"yes\"  checked>\n";
      }
      print "</td></tr>\n";
   }
   print "</table><br><input type=hidden name=\"room\" value=\"$room\">\n";
   print "<input type=submit value=\"$enter_chat\">\n";
   if($who_is_where_plugin && $where_locations =~ /a/i) {
      print "<input type=\"submit\" name=\"where\" value=\"$who_is_where\">\n";
   }
   if ($profile_plugin) {
      print "<input type=submit name=\"where\" value=\"$edit_profile\">\n";
   }
   print "</form>\n";
   if ($schedule_file) {
      print "$sched_note_a <a href=\"$schedule_file\">";
      print "$sched_note_b</a> $sched_note_c<p>\n";
   }
   if ($help_file) {
      print "$help_a <a target=\"profile\" href=\"$help_file\"> $help_b</a> $help_c<p>\n";
   }   

   if($advertise_plugin && $ad_locations =~ /b/) {
      &advertise;
   }

   print "<center>$our_image</center>\n";
   print "</body> </html>\n";
}
###########
# Name taken
sub name_taken {
   &reg_page_lang;
   print "Content-type: text/html\n\n";
   print "<html><head><title>$page_title $reg_page</title></head>\n";
   print "<body bgcolor=$bgcolor background=\"$background\" ";
   print "text=$text_color link=$link_color vlink=$vlink_color>\n";
   if($font_face ne "") {
      print "<font face=\"$font_face\">\n";
   }
   print "<ul><center>\n";
   
   if($advertise_plugin && $ad_locations =~ /a/) {
      &advertise;
   }

   if ($title_graphic eq "") {
      print "<H1>$page_title</h1>\n";
   }
   else {
      print "<h1><img src=\"$title_graphic\" alt=\"$page_title\"></h1>\n";
   }
   
   print "<h2>$reg_page</h2><p></center>\n";
   print "$wrong_name<p>\n";
   &register_body;
   &unlock;
   exit;
}
############
# Check Name

sub check_name {
   if (!$passwd || !$name) {
      &name_taken;
   }
   elsif (-e "$vis_dir/$vname"){
      open (VSAME,"$vis_dir/$vname") || die $!;
      $vsame = <VSAME>;
      close (VSAME);
      ($bogus,$test,$bogus2) = split(/:/,$vsame);
      $password = crypt($passwd,MW);
      if ($password ne $test) {
         &name_taken;
      }
   }
   elsif($user_limit_plugin) {
      require("$plugin_dir/user_limit.pl");
      &overflow;
   }
}



########################
# Maintain files
sub create {
   open(INDEX,">$file_dir/index.html");
   print INDEX "$index_html\n";
   close(INDEX);

   open(INDEXB,">$vis_dir/index.html");
   print INDEXB "$index_html\n";
   close(INDEXB);
   
   if($message_plugin) {
      require("$plugin_dir/message.pl");
      &message_prep;
   }

   opendir(FILES,"$file_dir");
   @filelist =  grep(!/^\./, readdir (FILES));
   closedir(FILES);
   foreach $file (@filelist) {
      $tfile = $file;
      $tfile =~ s/^chat//g;
      if (-M "$file_dir/$file" > $chat_time / 86400 && ! $MESGROOMS{$tfile}) {
         if ($file =~ /^chat/ || $file =~ /^vis/) {
            unlink("$file_dir/$file");
         }
      }
   }

   &deletev;
}

sub deletev {
   if (-e "$file_dir/vis$room") {
      foreach $visitors_line (@visitors) {
         ($bogus,$load,$bogus2) = split(/:/,$visitors_line);
         if ($time - $load < $visitors_time) {
            push (@visitors_new,"$visitors_line");
         }
      }
   }

   @visitors = @visitors_new;
   undef @visitors_new;

   &deletevfiles;
}
sub deletevfiles {
   opendir(VFILES,$vis_dir);
   @vfilelist =  grep(!/^\.|^_/, readdir (VFILES));
   closedir(VFILES);
   foreach $vfilelist (@vfilelist) {
      if (-M "$vis_dir/$vfilelist" > ($visitors_time / 86400)) {
         unlink("$vis_dir/$vfilelist");
      }
   }
   if(!$where) {
      opendir(VFILES,$vis_dir);
      @ffilelist =  grep(/^_/, readdir (VFILES));
      closedir(VFILES);
      foreach $ffilelist (@ffilelist) {
         open(FFILE,"$vis_dir/$ffilelist");
         $ffile = <FFILE>;
         close(FFILE);
         $ffile =~ s/\n//g;
         $ffile =~ s/ /_/g;
         if(! -e "$vis_dir/$ffile") {
            unlink("$vis_dir/$ffilelist");
         }
      }
   }

}

###########
# Register
sub register {

   $login = $date;
   
   foreach $visitors_line (@visitors) {
      if ($visitors_line !~ /^<!--:\d+:-->$name($| \d+:\d\d:\d\d$)/) {
         push (@visitors_new,"$visitors_line");
      }
   }
   @visitors = @visitors_new;
   undef @visitors_new;
   $temp = "<!--:$time:-->$name\n";
   unshift (@visitors,$temp);

   shift(@vfile);
   if($frame_remind && $frames eq "yes") {
      if ($initial_message_plugin) {
         require("$plugin_dir/initial_message.pl");
         $temp = "<!--:$time:-->$name, $frame_remind<p>$countdown<p>$random_line<hr>";
      }
      else {
         $temp = "<!--:$time:-->$name, $frame_remind<hr>";
      }
   }
   else {
      if ($initial_message_plugin) {
         require("$plugin_dir/initial_message.pl");
         $temp = "<!--:$time:-->$name, $reload_remind<p>$countdown<p>$random_line<hr>";
      }
      else {
         $temp = "<!--:$time:-->$name, $reload_remind<hr>";
      }
   }
   unshift (@vfile,"$temp\n");
   $password = crypt($passwd,MW);
   $temp = "<!--:$password\:$room\:$mail\::0:-->\n";
   unshift(@vfile,$temp);
   $vmodified = 1;
   
   if($show_status) {
      $temp = "<!--:$time:--><b>$name</b> $maillink $joined_chat $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><hr>\n";
      unshift(@main,$temp);
      $cmodified = 1;
   }
}
##########
# Modify chat page

sub post {
   if ($tempmessage) {
      if($emoticon_plugin) {
         require("$plugin_dir/emoticon.pl");
         if ($FORM{'emoticon'} && $FORM{'emoticon'} ne $blank_emoticon) {
            &post_emoticon;
         }
         else {
            $temp = "<!--:$time:--><b>$name</b> $maillink $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br>$message<hr>\n";
         }
      }
      else {
         $temp = "<!--:$time:--><b>$name</b> $maillink $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br>$message<hr>\n";
      }
      unshift(@main,$temp);
      $cmodified = 1;
   }
}
#########
# Snag information when person hits reload

sub snag {
   $mess = $message;
}

sub verify_password {

   ($bogus,$fpassword) = split(/:/,$vfile[0]);
   if($where eq "$leave_text" && !$password) {
      $password = $fpassword;
   }
   if($password ne $fpassword) {
      &unlock;
      &login;
      exit;
   }
}
##########
# Update Visitor's log

sub update {
   foreach $visitors_line (@visitors) {
      if ($visitors_line !~ /^<!--:\d+:-->$name$/ && 
          $visitors_line !~ /^<!--:\d+:-->$name \d+:\d\d:\d\d$/ &&
          $visitors_line !~ /^<!--:\d+:-->$name \d\d\/\d\d\/\d\d \d+:\d\d:\d\d$/) {
         push (@visitors_new,"$visitors_line");
      }
   }
   
   @visitors = @visitors_new;
   undef @visitors_new;

   $temp ="<!--:$time:-->$name $date\n";
   unshift (@visitors,$temp);

   $vmodified = 1;

   if ($admonish) {
      &admonish;
   }
}


############
# Reload
sub reload {
   $public_count = @public_rooms;
   if($password_style == 2 && $access_control_plugin) {
      require("$plugin_dir/access_control.pl");
      &admit_style;
   }
   elsif($frames eq "lite") {
      require("$plugin_dir/lite.pl");
      &lite_layout;
   }
   elsif($frames eq "yes") {
      require("$plugin_dir/frames.pl");
      &topframe_reload;
   }
   elsif($bottomframe) {
      require("$plugin_dir/frames.pl");
      &bottomframe_reload;
   }
   else {
      $ignoredlist = join("()",@ignored);
      if(!$nummes) {
         $nummes = $def_mes;
      }
      if(!$refreq) {
         $refreq = $def_reload;
      }
      if($nummes =~ /\D/ && $nummes !~ /^($new_nummes||$all_nummes)$/i) {
         $nummes = $def_mes ;
      }
      if($nummes > $max_mes && $nummes !~ /^($new_nummes||$all_nummes)$/i) {
         $nummes = $max_mes;
      }
      print "Content-type: text/html\n\n";
   
      print "<html><head><title>$page_title</title>\n";
   
      print "</head><body bgcolor=$bgcolor background=\"$background\"";
      print " text=$text_color link=$link_color vlink=$vlink_color>\n";
      if($font_face ne "") {
         print "<font face=\"$font_face\">\n";
      }
      print "<form method=POST action=\"$ENV{'SCRIPT_NAME'}\">\n";
      print "<center>\n";
   
      if($advertise_plugin && $ad_locations =~ /c/) {
         &advertise;
      }

      print "<table border=$border width=100%><tr valign=top>\n";      
      if($advertise_plugin && $ad_locations =~ /d/) {
         print "<td rowspan=3>\n";
         &advertise;
         print "</td>\n";
      }
      print "<td rowspan=3><center>\n";
      if (!$title_graphic) {
         print "<H3>$page_title</h3>\n";
      }
      else {
         print "<img src=\"$title_graphic\" border=0 ";
         print "alt=\"$page_title\"><br>\n";
      }
      print "<input type=hidden name=\"password\" value=\"$password\">\n";
      print "<input type=hidden name=\"frames\" value=\"$frames\">\n";
      print "<input type=hidden name=\"load_time\" value=\"$time\">\n";
      print "<input type=hidden name=\"room\" value=\"$room\">\n";
      print "<input type=hidden name=\"mail\" value=\"$mail\">\n";
      print "<input type=hidden name=\"name\" value=\"$name\">\n";
      print "<input type=hidden name=\"link\" value=\"$link\">\n";
      print "<input type=hidden name=\"ignored\" value=\"$ignoredlist\">\n";
      if($adminyes) {
         print "<input type=\"hidden\" name=\"admin\" value=\"1\">\n";
      }
   
      print "Place message to post below:<br><textarea COLS=$textarea_cols ROWS=$textarea_rows name=\"message\" wrap>\n";
      print "$mess</textarea><br>\n";
      
      $vname = $name;
      $vname =~ s/ /_/g;
      if($emoticon_plugin) {
         print "<table cellpadding=0><tr><td>\n";
      }
      if($allow_one_on_one) {
         print "$send_to <select name=\"solo\">\n";
         print "<option>$entire_room\n";
         opendir(VFILES,$vis_dir);
         @vfilelist =  grep(!/^\.|^_/, readdir (VFILES));
         closedir(VFILES);
         @vfilelist = sort(@vfilelist);
         foreach $vfilelist (@vfilelist) {
            if ($vfilelist ne "index.html" && $vfilelist ne "$vname") {
               $vfilelist =~ s/_/ /g;
               undef($vfilelistb);
               if(@ignored) {
                  foreach$ignoree(@ignored) {
                     if($vfilelist eq "$ignoree") {
                        $vfilelistb = "$vfilelist$ignoremark";
                     }
                  }
                  if($solo eq "$vfilelist" && $vfilelistb) {
                     print "<option selected value=\"$vfilelist\">$vfilelistb\n";
                  }
                  elsif($solo eq "$vfilelist") {
                     print "<option selected>$vfilelist\n";
                  }
                  elsif($vfilelistb) {
                     print "<option value=\"$vfilelist\">$vfilelistb\n";
                  }
                  else {
                     print "<option>$vfilelist\n";
                  }
               }
               else {
                  if($solo eq "$vfilelist") {
                     print "<option selected>$vfilelist\n";
                  }
                  else {
                     print "<option>$vfilelist\n";
                  }
               }
            }
         }
         print "</select>\n";
      }
      if($emoticon_plugin) {
         print "</td><td rowspan=2>\n";
      }
   
      if($ignore_plugin) {
         print "<input type=submit name=\"where\" value=\"$ignore_text\">\n";
      }
         
      if(($password_style == 2 && $passpost) || $password_style != 2) {
         print "<input type=submit name=\"where\" value=\"$post_text\">\n";
      }
      if($frames ne "yes") {
         print "<input type=submit name=\"where\" value=\"$reload_text\">\n";
      }
      if($frames ne "yes") {
         print "<input type=submit name=\"where\" value=\"$leave_text\">\n";
      }   
   
      if($emoticon_plugin) {
         print "</td></tr><td>\n";
         require("$plugin_dir/emoticon.pl");
         &emoticon_list;
         print "</td></tr></table>\n";
      }
   
      print "</td><td>\n";
      if($public_count == 1 || $allow_private) {
         $curroom = $room;
         $curroom=~ s/_/ /g;
         print "$currently_in <b>$curroom</b><br>\n";
      }
      print "<select>\n";
      print "<option>$whos_here\n";
      foreach$visline(@visitors) {
         $vislinet = $visline;
         $vislinet =~ s/<!--(.|\n)*-->//g;
         print "<option>$vislinet\n";
      }
      print "</select>\n";
      if($who_is_where_plugin && $where_locations =~ /b/) {
         print "<input type=\"submit\" name=\"where\" value=\"$who_is_where\"><br>\n";
      }
      print "</td></tr><tr><td>\n";
   
      print "$nummes_a <input type=text name=\"nummes\" ";
      print "value=\"$nummes\" size=3 maxlength=3> $nummes_b\n";
      print "</td></tr><tr><td>\n";
      if($public_count > 1) {
         print "<select name=\"pubroom\">\n";    
         print "<option value=\"\">$pub_room_title\n";
         foreach$public_room(@public_rooms) {
            print "<option>$public_room\n";
         }
         print "</select><br>\n";
      }
      if($allow_private) {
         print "$pri_room_title<br>\n";
         print "<input type=text size=15 name=\"priroom\"><br>\n";
      }
      if($public_count > 1 || $allow_private) {
         print "<input type=submit name=\"where\" value=\"$go_there\">\n";
      }
      print "<a href=\"$help_file\" target=\"profile\">$help_b</a>\n";
      
      print "</td></tr></table></center></form>\n";
   
      if($advertise_plugin && $ad_locations =~ /e/) {
         &advertise;
         print "<hr>";
      }
      
      print "<a name=\"messages\">\n";
      if($bottomframe) {
         print "<hr>\n";
      }
   
      &nummes;
   
      if($advertise_plugin && $ad_locations =~ /f/) {
         &advertise;
      }
   
      print "<center>$our_image</center>\n";
      print "</body> </html>\n";
   }
}
sub nummes {

   if($nummes =~ /^$all_nummes$/i) {
      $clinecount = 0;
      $vlinecount = 1;
      while($clinecount < @main || $vlinecount < @vfile) {
         &print_chat;
      }
   }
   elsif($nummes =~ /^$new_nummes$/i) {
      $clinecount = 0;
      $vlinecount = 1;
      $clinetime = $time;
      while(($vlinetime > $load_time - $new_time || $clinetime > $load_time - $new_time) && ($clinecount < @main || $vlinecount < @vfile)) {
         &print_chat;
      }      
   }
   else {
      $clinecount = 0;
      $vlinecount = 1;
      while($mlinecount < $nummes && ($clinecount < @main || $vlinecount < @vfile)) {
         &print_chat;
      }
   }

}
sub print_chat {
   foreach$ignoree(@ignored) {
      while($main[$clinecount] =~ /<b>$ignoree<\/b>/) {
         $clinecount++;
         undef($clinetime);
      }
      while($vfile[$vlinecount] =~ /<b>$ignoree<\/b>/) {
         $vlinecount++;
         undef($vlinetime);
      }
   }
   if(!$clinetime || $nummes =~ /$new_nummes/i) {
      ($bogus,$clinetime) = split(/:/,$main[$clinecount]);
   }
   if(!$vlinetime || $nummes =~ /$new_nummes/i) {
      ($bogus,$vlinetime) = split(/:/,$vfile[$vlinecount]);
   }
   if(!$clinetime && !$vlinetime) {
      $clinecount++;
      $vlinecount++;
   }
   elsif($clinetime > $vlinetime) {
      $tcline = $main[$clinecount];
      $tcline =~ s/^<!--:\d\d\d+:-->//g;
      if($adminyes && $show_ip == 1) {
         $messtime = substr($clinetime, -5, 5);
         $tcline =~ s/<!--/&nbsp;/g;
         $tcline =~ s/-->/&nbsp; &nbsp; $messtime/g;
      }
      else {
         $tcline =~ s/<!--\d+\.\d+\.\d+\.\d+-->//g;
      }
      if($clinetime > $load_time) {
         if($tcline =~ /$joined_chat/ && $alert_sound_plugin) {
            require("$plugin_dir/alert_sound.pl");
            &alert_sound;
         }
         print "$new_message $tcline";
      }
      elsif(!$old_timer) {
         $old_timer = 1;
         print "<font color=$oldcolor>\n";
         print $tcline;
      }
      else {
         print $tcline;
      }
      $clinecount++;
      if($nummes !~ /$new_nummes/i) {
         undef($clinetime);
      }
   }
   
   else {
      $tvline = $vfile[$vlinecount];
      $tvline =~ s/<font>/<font color=$one_color>/g;
      $tvline =~ s/^<!--:\d\d\d+:-->//g;
      if($adminyes && $show_ip == 1) {
         $tvline =~ s/<!--/&nbsp;/g;
         $tvline =~ s/-->//g;
      }
      else {
         $tvline =~ s/<!--\d+\.\d+\.\d+\.\d+-->//g;
      }
      if($vlinetime > $load_time) {
         print "$new_message $tvline";
      }
      else {
         print $tvline;
      }
      $vlinecount++;
      if($nummes ne "$new_nummes") {
         undef($vlinetime);
      }
   }

   $mlinecount++;

}

##############
# Change rooms
sub change {
   $load_time = 0;

   if($oshow_status) {
      open(OLDMAIN,"$file_dir/chat$oldroom");
      @oldmain = <OLDMAIN>;
      close(OLDMAIN);
   
      $temp = "<!--:$time:--><b>$name</b> $maillink $left_room $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br><hr>\n";
      unshift(@oldmain,$temp);
      
      open(OLDMAIN,">$file_dir/tempc$oldroom");
      foreach$oldmainline(@oldmain){
         print OLDMAIN "$oldmainline";
      }
      close(OLDMAIN);
      rename("$file_dir/tempc$oldroom","$file_dir/chat$oldroom");
      
      open(OLDVIS,"$file_dir/vis$oldroom");
      @oldvis = <OLDVIS>;
      close(OLDVIS);
   }
   foreach $visitors_line (@oldvis) {
      if ($visitors_line !~ /^<!--:\d+:-->$name($| \d+:\d\d:\d\d$)/) {
         push (@visitors_old,"$visitors_line");
      }
   }
   @oldvis = @visitors_old;
   undef @visitors_old;
   
   
   open(OLDVIS,">$file_dir/tempv$oldroom");
   foreach$oldvisline(@oldvis) {
      print OLDVIS "$oldvisline";
   }
   close(OLDVIS);
   rename("$file_dir/tempv$oldroom","$file_dir/vis$oldroom");
   
   undef(@oldmain);
   undef(@oldvis);

   open(MAIN,"$file_dir/chat$room");
   @main = <MAIN>;
   close(MAIN);
   @main = @main[(0 .. $max_mes)];
   
   if($show_status) {
      $temp = "<!--:$time:--><b>$name</b> $maillink $joined_chat $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br><hr>\n";
      unshift(@main,$temp);
      $cmodified = 1;
   }
   
   open(VISITORS,"$file_dir/vis$room");
   @visitors = <VISITORS>;   
   close(VISITORS);

   $login = "$date";
   
   foreach $visitors_line (@visitors) {
      if ($visitors_line !~ /^<!--:\d+:-->$name($| \d+:\d\d:\d\d$)/) {
         push (@visitors_new,"$visitors_line");
      }
   }
      
   @visitors = @visitors_new;
   undef @visitors_new;

   $temp = "<!--:$time:-->$name\n";
   unshift (@visitors,$temp);
   
   $vmodified = 1;
}

##############
# Send the private message
sub privmsg {

   if ($tempmessage) {
      $solo =~ s/ /_/g;
      if(-e "$vis_dir/$solo"){
         open (VFILES,"$vis_dir/$solo") || die $!;
         @vfiles = <VFILES>;
         close (VFILES);
         
         $vfilestemp = $vfiles[0];
         shift(@vfiles);
         
         if($emoticon_plugin) {
            require("$plugin_dir/emoticon.pl");
            if ($FORM{'emoticon'} && $FORM{'emoticon'} ne $blank_emoticon) {
               &one_on_one_emoticon;
            }
            else {
               $tempa ="<!--:$time:--><font>$one_on_one_text:";
               $tempb = " <b>$name</b> $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br>$message</font><hr>\n";
               $temp = "$tempa$tempb";
            }   
         }
         else {
            $tempa ="<!--:$time:--><font>$one_on_one_text:";
            $tempb = " <b>$name</b> $maillink $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br> $message</font><hr>\n";
            $temp = "$tempa$tempb";
         }
         unshift(@vfiles,$temp);

         unshift(@vfiles,"$vfilestemp");

         open(VFILES,">$vis_dir/$solo") || die $!;
         foreach $vfiles_line(@vfiles) {
            print VFILES "$vfiles_line";
         }

         close(VFILES);

         $primessage = $message;
      }
      else {
          $primessage = "<b>$person_gone</b><br>$message";
      }

      $solo =~ s/_/ /g;
      $vfiletemp = $vfile[0];
      shift(@vfile);
      if($emoticon_plugin) {
         require("$plugin_dir/emoticon.pl");
         if ($FORM{'emoticon'} && $FORM{'emoticon'} ne $blank_emoticon) {
            &send_one_on_one_emoticon;
         }
         else {
            $tempa ="<!--:$time:--><font>$one_on_one_text:";
            $tempb = " <b>To: $solo</b> $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br>$primessage</font><hr>\n";
            $temp = "$tempa$tempb";
         }   
      }
      else {
         $tempa ="<!--:$time:--><font>$one_on_one_text:";
         $tempb = " <b>To: $solo</b> $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br>$primessage</font><hr>\n";
         $temp = "$tempa$tempb";
      }   
      unshift (@vfile,$temp);
      unshift (@vfile,"$vfiletemp");
   }
}
###############
# Leave
sub leave {

   unlink("$vis_dir/$vname");
   
   if($emoticon_plugin) {
      require("$plugin_dir/emoticon.pl");
      if ($FORM{'emoticon'} && $FORM{'emoticon'} ne $blank_emoticon) {
         &leave_emoticon;
      }
      else {
         $temp = "<!--:$time:--><b>$name</b> $maillink $left_chat $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br><hr>\n";
      }
   }
   else {
      $temp = "<!--:$time:--><b>$name</b> $maillink $left_chat $date &nbsp; <!--$ENV{'REMOTE_ADDR'}--><br><hr>\n";
   }
   if($show_status) {
      unshift(@main,$temp);
      $cmodified = 1;
   }
   
   foreach $visitors_line (@visitors) {
      if ($visitors_line !~ /^<!--:\d+:-->$name($| \d+:\d\d:\d\d$)/) {
         push (@visitors_new,"$visitors_line");
      }
   }
   @visitors = @visitors_new;
   undef @visitors_new;

   print "Location: $link\n\n";
   $vmodified = 1;
}

###########
# Write Files
sub write {
   if($cmodified) {
      open(MAIN,">$file_dir/tempc$room");
      print MAIN @main;
      close(MAIN);
      rename("$file_dir/tempc$room","$file_dir/chat$room")
   }
   
   if($vmodified) {
      open(VISITORS,">$file_dir/tempv$room");
      print VISITORS @visitors;
      close(VISITORS);
      rename("$file_dir/tempv$room","$file_dir/vis$room")
   }
   
   $vfile[0] = "<!--:$password\:$room\:$mail\:$ignoredlist\:$time:-->\n";
   if(!$vname) {
      $vname = $name;
      $vname =~ s/ /_/g;
   }
   if($where ne "$leave_text" && $vname){
      open(VFILE,">$vis_dir/temp$vname");
      print VFILE @vfile;
      close(VFILE);
      rename("$vis_dir/temp$vname","$vis_dir/$vname");
   }
}
#############
# Write .htaccess file for security
sub write_htaccess {
   open(HTACCESS,">$access_dir/.htaccess");
   print HTACCESS "AuthUserFile /etc/.htpasswd\nAuthGroupFile /dev/null\n";
   print HTACCESS "AuthName ChatPro Restricted Area\nAuthType Basic\n\n";
   print HTACCESS "<Limit GET>require user ChatPro\n</Limit>\n";
   close(HTACCESS);
}
#############
# Unlock
sub unlock {

   unlink("$file_dir/$lock_file");

}

