#!/usr/local/bin/perl

# Modificao do sistema por: Vinicius Martins <webmaster@brasildesigner.com>

# Bibliotecas Requeridas
# --------------------------------------------------------
eval {
    ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");    # Pega o local do script: UNIX /
    ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");    # Pega o local do script: Windows \

    require "/somline.hypermart.net/cgi-bin/busca/admin/links.cfg";
    require "$db_lib_path/db_utils.pl";
    require "$db_lib_path/links.def";
    require "$db_lib_path/site_html.pl";
};
if ($@) {
    print "Content-type: text/plain\n\n";
    print "Erro incluindo bibliotecas: $@\n";
    print "Tenha certeza de que elas existem, permisses esto corretas e caminhos esto definidos corretamente.";
    exit;
}

# ========================================================

eval { &main; };
if ($@) { &cgierr("fatal error: $@"); } 
exit;

sub main {
# --------------------------------------------------------
    local (%in) = &parse_form;

# Estamos processando o formulrio..  
    if (keys %in != 0) {
        &process_form;
    }
# Ou ento, ns estamos exibindo o formulrio (em site_html.pl).
    else {
        &site_html_senha_form;
    }
}


sub process_form {

# Tenha certeza de que temos um link a ser procurado
    !$in{'URL'} and &site_html_senha_failure ("No especificou o Endereo a ser procurado") and return;

# Vamos verificar se o link que ns queremos encontrar a senha est atualmente no 
# banco de dados.
    open (DB, "<$db_file_name") or &cgierr("erro em process_form em senha.cgi. impossvel abrir arquivos db: $db_file_name. Motivo: $!");
    $found = 0;
    LINE: while (<DB>) {
        (/^#/)      and next LINE;
        (/^\s*$/)   and next LINE;
        chomp;      
        @data = &split_decode($_);
        if ($data[$db_url] eq $in{'URL'}) {
            $in{$db_key} = $data[0];
            $found = 1; 
            %link = &array_to_hash (0, @data);
            last LINE;
        }
    }
    close DB;
    !$found and &site_html_senha_failure ("O link no foi encontrado em nossos arquivos") and return;

# Agora envia a mensagem original ao usurio
&envia_senha_email (%link);

# Envia o usurio para uma pgina dizendo que a senha foi corretamente encontrada.
&site_html_senha_success (%link);
}


sub envia_senha_email {
# --------------------------------------------------------
# Todas as informaes do link so guradadas em %link.
    my (%link) = @_;

# Define Para, De, Assunto e Mensagem a ser enviada.
    my $to      = $link{'Contact Email'};
    my $from    = $db_admin_email;
    my $subject = "Sua senha foi encontrada!";
    my $msg     = &load_template ('email-add.txt', \%link);
    
# Agora a envia de qualquer jeito!
    require "$db_lib_path/Mailer.pm";
    my $mailer = new Mailer ( { smtp => $db_smtp_server, 
                                sendmail => $db_mail_path, 
                                from => $from, 
                                subject => $subject,
                                to => $to,
                                msg => $msg,
                                log => $db_mailer_log 
                            } ) or 
        &cgierr("Unable to init mailer! Reason: $Mailer::error");
    $mailer->send or &cgierr ("Unable to send addition message. Reason: $Mailer::error");   
}

