#!/usr/local/bin/perl

# Bibliotecas Requeridas
# --------------------------------------------------------
eval {
    ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");    # Pega o local do script: UNIX /
    ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");    # Pega o local do script: Windows \

    require "/somline.hypermart.net/cgi-bin/busca/admin/links.cfg";
    require "$db_lib_path/db_utils.pl";
    require "$db_lib_path/links.def";       
    require "$db_lib_path/site_html.pl";
};
if ($@) {
    print "Content-type: text/plain\n\n";
    print "Erro incluindo bibliotecas: $@\n";
    print "Tenha certeza de que elas existem, permisses esto corretas e caminhos esto definidos corretamente.";
    exit;
}

# ========================================================

eval { &main; };
if ($@) { &cgierr("fatal error: $@"); } 
exit;

sub main {
# --------------------------------------------------------  
    $|++;
    my %in     = &parse_form;
    my $action = $in{'action'};
    
    CASE: {
            ($action eq "subscribe")    and do { &subscribe  (%in); last CASE; };
            ($action eq "unsubscribe")  and do { &unsubscribe(%in); last CASE; };
            
            &site_html_mailing();           
    };
}

sub subscribe {
# -----------------------------------------------------------
# Adds a user into a mailing list.
#
    my %in = @_;    
    my $list = $db_email_name;
    
# Make sure the email address at least looks like an email address.
    my $email      = $in{'email'};
    my $name       = $in{'name'};   
    ($email =~ /.+@.+\..+/) or &site_html_mailing_error ("Endereo de Email: '$email' no parece um endereo de email real.") and return;
    ($name  =~ /[A-Za-z]+/) or &site_html_mailing_error ("Por Favor entre um nome, assim como um endereo de email.") and return;

# Check that the user is not already subscribed.    
    my $users_r    = &get_users ($list);
    ${$users_r}{$email}    and &site_html_mailing_error ("Endereo de Email: $email j est inscrito nessa lista.") and return;

# Made it this far, so let's add the user in.
    ${$users_r}{$email} = $name;
    
    open  (LIST, ">$list") or &cgierr ("Unable to open list: $list. Reason: $!");
    if ($db_use_flock) { flock (LIST, 2) or &cgierr ("Unable to get exlusive lock! Reason: $!"); }
    foreach (sort keys %{$users_r}) {
        print LIST "$_$db_delim${$users_r}{$_}\n";
    }
    close LIST;

# Go to the success page.
    &site_html_mailing ('subscribe');
}

sub unsubscribe {
# -----------------------------------------------------------
# Removes a user from a mailing list.
#
    my %in = @_;    
    my $list = $db_email_name;
    
# Check that the user is already subscribed.    
    my $email      = $in{'email'};
    my $name       = $in{'name'};   
    my $users_r    = &get_users ($list);    
    ${$users_r}{$email} or &site_html_mailing_error ("Endereo de Email: $email mo est inscrito nesta lista.") and return;

# Made it this far, so let's remove the user.
    delete ${$users_r}{$email};
    
    open  (LIST, ">$list") or &cgierr ("Unable to open list: $list. Reason: $!");
    if ($db_use_flock) { flock (LIST, 2) or &cgierr ("Unable to get exlusive lock! Reason: $!"); }
    foreach (sort keys %{$users_r}) {
        print LIST "$_$db_delim${$users_r}{$_}\n";
    }
    close LIST;

# Go to the success page.
    &site_html_mailing ('unsubscribe');
}

sub get_users {
# -----------------------------------------------------------
# Returns a hash ref of a list of all users in a list.
#
    my ($list) = shift;
    my $users_r;
    my $delim  = quotemeta ($db_delim);
    open (LIST, "<$list") or &cgierr ("Unable to open list: $config{'list_dir'}/$list. Reason: $!");
    if ($db_use_flock) { flock (LIST, 1); }
    while (<LIST>) {
        chomp;
        (/(.*)$delim(.*)/o) and (${$users_r}{$1} = $2);
    }
    close LIST;
    return $users_r;
}