 
$date = &get_date;
$time = &get_time;

$font_title     = 'font face="Arial, Verdana" size="4"';
$font_menu      = 'font face="Arial, Verdana" size="1"';
$font_results   = 'font face="Arial, Verdana" size="3"';
$font           = 'font face="Arial, Verdana" size="2"';
$font_hits      = 'font face="Arial, Verdana" size="2" color="#666666"';
$font_erro      = 'font face="Arial, Verdana" size="2" color="red"';

$dtd    = '!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN" "http://www.w3.org/TR/REC-html40/strict.dtd"';

$site_body = 'body';

$site_title = $build_site_title;

$site_menu = qq~
<p><$font><small>|
    <a href="$build_root_url">Principal</a> |
    <a href="$build_add_url">Adicionar</a> |
    <a href="$build_modify_url">Modificar</a> |
    <a href="$build_new_url">Novos Sites</a> |
    <a href="$build_cool_url">Top</a> |
    <a href="$build_ratings_url">Avaliaes</a> |
    <a href="$build_email_url">Atualizaes por Email</a> | 
    <a href="$build_jump_url?ID=random">Link Qualquer</a> |
    <a href="$build_search_url">Busca</a> |
</small></p>
~;

$site_search = qq~<$font>
    <form action="$build_search_url" method="GET">
        <p><big><b>Busca</b></big></p>
                <table border="0" cellspacing="0" cellpadding="0">
                <tr><td><font size="2"><strong>Procurando algo?</strong></td></tr>
                <tr><td><input type="text" size=15 name="query"> <input type=submit value="Busca!"></td></tr>
                <tr><td><font size="2"><a href="$build_search_url">Opes</a></td></tr>
                </table>
    </form>
~;

$site_footer = qq~
<hr><$font>
     <b>Atualizado em: $date s $time<br>
        Copyright  1999 <a href="http://www.brasildesigner.com">Brasil Designer</a></b>
~;

$new_1_graphic = qq~img src="$build_root_url/novo1.gif" BORDER="0" WIDTH="xx" HEIGHT="xx"~;
$new_3_graphic = qq~img src="$build_root_url/novo2.gif" BORDER="0" WIDTH="xx" HEIGHT="xx"~;
$new_7_graphic = qq~img src="$build_root_url/novo3.gif" BORDER="0" WIDTH="xx" HEIGHT="xx"~;
$pop_graphic   = qq~img src="$build_root_url/pop.gif" border="0" width="xx" height="xx"~;


##########################################################
##                    A Link                          ##
##########################################################

sub site_html_link {

my (%rec) = @_;
my $days_old = &days_old($rec{'Date'}); 

$build_detailed ?
    ($output = qq~<ul><li><$font><a href="$build_detail_url/$rec{$db_key}$build_extension">$rec{'Title'}</a></font>~) :
    ($output = qq~<ul><li><$font><a href="$build_jump_url?$db_key=$rec{$db_key}">$rec{'Title'}</a> ~);

if ($rec{'isNew'} eq "Yes") {
	if ($days_old <= 0)    { $output .= qq|- <$new_1_graphic>|; } 
	elsif ($days_old <= 2) { $output .= qq|- <$new_3_graphic>|; } 
	elsif ($days_old <= 6) { $output .= qq|- <$new_7_graphic>|; } 
	else { } 
}

if ($rec{'isPopular'} eq "Yes") { $output .= qq~ <$pop_graphic>~; }

if ($rec{'Description'})        { $output .= qq~ - $rec{'Description'}</font>\n~; }
$output .= qq~<br><$font_hits>(Adicionado: $rec{'Date'} Hits: $rec{'Hits'} Nota: $rec{'Rating'} Votos: $rec{'Votes'}) <a href="$build_rate_url?ID=$rec{'ID'}">Avaliar</a></font></ul>~;

return $output;
}

##########################################################
##                   Pgina Principal                   ##
##########################################################

sub site_html_home {
# --------------------------------------------------------
# Essa rotina ir construir a pgina principal. No  programada para ter nenhum link
# nela, somente as categorias.
#
#   $category       : A lista de subcategories.
#   $time           : A hora atual.
#   $date           : A data atual.
#   $grand_total    : O nmero total de links.
#

my ($output);

$output = qq~ 
<$dtd>
<html>

<head>
<title>$site_title</title>
<meta name="description" content="">
<meta name="keywords" content="">
</head>

<$site_body>

<h1>$site_title</h1>

    $site_menu

    <p>Site description</p>

        <h2>Categorias:</h2>
        
        $category
        
        <p class="grandtotal">H <strong>$grand_total</strong> links para voc escolher!</p>

    $site_search
    $site_footer

</body>
</html>
~;

return $output;
}

##########################################################
##                 Pgina de Novos Sites                ##
##########################################################

sub site_html_new {
# --------------------------------------------------------
# Essa rotina ir construir a pgina de Novos Sites. Voc pode usar as seguintes variveis
#
#   $time           : A hora atual.
#   $date           : A data atual.
#   $total          : O nmero total de novos links.
#   $grand_total    : O nmero total de links.
#   $link_results   : A lista de novos links.
#   $title_linked
#

$output = qq~ 
<$dtd>
<html>

<head>
<title>$site_title: Novos Sites</title>
</head>

<$site_body>

   <p><$font_title>$title_linked</strong></p>

<h1>$site_title: Novos Sites</h1>

        $site_menu

        <h2>$total Novos Links:</h2>

            $link_results

        $site_search
        $site_footer

</body>
</html>
~;

return $output;
}

##########################################################
##                 Pginas Legais                       ##
##########################################################

sub site_html_cool {
# --------------------------------------------------------
# Essa rotina ir construir uma pgina dos links mais visitados. Voc pode usar as seguintes
# variveis.
#
#   $time           : A hora atual.
#   $date           : A data atual.
#   $total          : O nmero total de links Legais (mais visitados).
#   $grand_total    : O nmero total de links.
#   $percent        : A porcentagem de links legais (top 3%, etc).
#   $link_results   : A lista de links legais.
#

$output = qq~ 
<$dtd>
<html>

<head>
<title>$site_title: Top $percent</title>
</head>
<$site_body>

  <h1><$font_title>$site_title: Top $percent!</font></h1>

    $site_menu

    <h2>$total Links Legais:</h2>

    $link_results

    $site_search
    $site_footer

</body>
</html>
~;

return $output;
}

##########################################################
##                 Viso Detalhada                      ##
##########################################################

sub site_html_detailed {

    my %rec = @_;

$output = qq~ 
<$dtd>
<html>

<head>
<title>$site_title: $rec{'Title'}</title>
</head>

<$site_body>

<p><$font><b>$title_linked</b></p>

<h1><$font_title>$site_title: Descrio Detalhada!</font></h1>

    $site_menu

    <h2>$rec{'Title'}</h2>
    <p>$rec{'Description'}</p>
    <p><small>Enviado por: $rec{'Contact Name'} -- <a href="mailto:$rec{'Contact Email'}">$rec{'Contact Email'}</a><br>Hits: $rec{'Hits'}</small></p>
    <p><a class="link" href="$build_jump_url?$db_key=$rec{$db_key}">Visitar este site</a>.
    $site_search
    $site_footer

</body>
</html>
~;

    return $output;
}

##########################################################
##              Pginas das Categorias                  ##
##########################################################

sub site_html_category {
# --------------------------------------------------------
#   $category       : A lista das subcategorias.
#   $links          : A lista dos links nessa categoria.
#   $time           : A hora atual.
#   $date           : A data atual.
#   $total          : O nmero total dos links nessa categoria.
#   $grand_total    : O nmero total de links.
#   $title_linked   : Uma verso linkada da barra de ttulo.
#   $title          : Uma verso no linkada da barra de ttulo.
#   $category_name  : O nome da categoria.
#   $category_name2  : O nome da categoria. (Original)
#   $category_name_escaped  : A URL do nome da categoria escapada (usada para a funo Adicionar)
#   $category_clean : O nome da categoria com _ e / removido.
#

my ($output);

$output = qq~
<$dtd>
<html>

<head>
<title>$site_title: $category_clean</title>
<meta name="description" content="$meta_name">
<meta name="keywords" content="$meta_keywords">
</head>

<$site_body>

<p><$font_title>$site_title: $category_clean</font></p>

  <p><$font><br><b>$title_linked</b></p>

$site_menu

~;
if ($header) { $output .= qq~<p><$font><b>$header</b></font><br>
~; }
if ($category) { $output .= qq~
                    <p><$font_results><b>Categorias:</b></font><br><br>
                    <table border="0" width="90%" align="center">
                      <tr><td>$category</td></tr></table></p>
~; } 
if ($links) {$output .= qq~          
                    <p><$font_results><b>Links:</b></font>
                    $links</p>
~; }

else { $output .= qq~
                    <p align="center"><br><$font><b>No h links nessa pgina!</b></font><br><br></p>
~; }

if ($related) {
$output .= qq~
                    <$font_results><b>Categorias Relacionadas:</b></font>
                    <ul><$font>$related</ul>
~; }

if ($prev or $next) { $output .= qq~<p>~; }
if ($prev)   { $output .= qq~<b><a href="$prev">ltimos $build_links_per_page</a></b> ~; }
if ($next)   { $output .= qq~<b><a href="$next">Prximos $build_links_per_page</a></b> ~; }
if ($prev or $next) { $output .= qq~</p>~; }

if ($footer) { $output .= qq~<p>$footer</p>~; }

$output .= qq~

        $site_search
        $site_footer

</body>
</html>
~;

$output =~ s/    <\/form>/
       <input type=\"checkbox\" name=\"where\" value=\"$category_name2\">Somente na categoria $category_name<br>
       <input type=\"checkbox\" name=\"subcategories\" value=\"$category_name2\">Busca em subcategorias tambm<\/b>
    <\/form>/;

return $output;

}

##########################################################
##                    Category Listings               ##
##########################################################

sub site_html_print_cat {
# --------------------------------------------------------

    my (@subcat) = @_; 

    my ($url, $numlinks, $mod, $subcat, $category_name, $description, $output, $i, $nonenglish);

    my ($half) = int (($#subcat+2) / 2);
    
    # Print Header.
     $output = qq~<table border="0" cellspacing="0" cellpadding="0"><tr><td valign="top" align="right"><$font>\n~;
    
    foreach $subcat (sort @subcat) { 
        ($description) = @{$category{$subcat}}[2];
        ($nonenglish) = @{$category{$subcat}}[8];

# First let's get the name, number of links, and last modified date...  
        $url = "$build_root_url/" . &urlencode($subcat) . "/";
        if ($nonenglish eq "") {
            if ($subcat =~ m,.*/([^/]+)$,) { $category_name = &build_clean($1); } else { $category_name = &build_clean($subcat); }
        }
        else {
            $category_name = &build_last_title_mb($nonenglish);
        }		
        $numlinks = $stats{"$subcat"}[0]; 
        $mod = $stats{"$subcat"}[1];

# We check to see if we are half way through, if so we stop this table cell
# and begin a new one (this lets us have category names in two columns).        
        if ($i == $half) {
            $output .= qq~</td><td width="25">&nbsp;</td><td valign="top"><$font>\n~;
        }
        $i++;
        
        
# Then we print out the name linked, new if it's new, and popular if its popular.
        if ($output =~ "<\/td><td width=\"25\">") {
	        $output .= qq~<dl><dt><b><$font><a href="$url">$category_name</a></b> ~;
      	          my $days_old = &days_old($mod); 
            	    if ($days_old <= 0) { $output .= qq|<$new_1_graphic>|; } 
	                elsif ($days_old <= 2) { $output .= qq|<$new_3_graphic>|; } 
      	          elsif ($days_old <= 6) { $output .= qq|<$new_7_graphic>|; } 
            	    else { } 
	        $oytput .= qq~</dt>~;
        }
        else {
	        $output .= qq~<dl><dt>~;
      	          my $days_old = &days_old($mod); 
            	    if ($days_old <= 0) { $output .= qq|<$new_1_graphic>|; } 
	                elsif ($days_old <= 2) { $output .= qq|<$new_3_graphic>|; } 
      	          elsif ($days_old <= 6) { $output .= qq|<$new_7_graphic>|; } 
            	    else { } 
	        $output .= qq~ <b><$font><a href="$url">$category_name</a></b></dt>~;
 	  }
        $output .= qq~<dd><font color="#333333">$description </font></dd>~ if (!($description =~ /^[\s\n]*$/));
        $output .= qq~</dl>~;
        
    }

# Don't forget to end the unordered list..
    $output .= "</td></tr></table>\n";
    return $output;
}

##########################################################
##                    Add Resources                     ##
##########################################################

sub site_html_add_form {
# --------------------------------------------------------
#
    my $category = shift;
    my ($kategorie) = &kategorie_title_mb ($category);
    $category ?
        ($category = qq~$kategorie <input type=hidden name="Category" value="$category">~) :
        ($category = &build_select_field ("Category", "$in{'Category'}"));


    &html_print_headers;    
    print qq~   
<$dtd>
<html>

<head>
<title>$site_title: Incluir Site</title>
</head>

<$site_body>
  
<p><$font_title>$site_title: Incluir Site</font></p>
$site_menu
<p><br>
      <form action="$build_add_url" method="POST">
        <p><$font>Por favor, preencha o formulrio por completo, e ns iremos incluir o seu site em at 48 horas.</p>
            <table border ="0" cellspacing="0" cellpadding="0">
                <tr><td align="right" valign="top"><font size="2">Ttulo:</td>
                    <td><input name="Title" value="$in{'Title'}" size="50"></td></tr>
                <tr><td align="right" valign="top"><font size="2">URL:</td>
                    <td><input name="URL" value="$in{'URL'}" size="50"></td></tr>
                <tr><td align="right" valign="top"><font size="2">Categoria:</td>
                    <td>$category</td></tr>
                <tr><td align="right" valign="top"><font size="2">Descrio:</td>
                    <td><textarea wrap="virtual" name="Description" value="$in{'Description'}" rows="5" cols="46">$in{'Description'}</textarea></td></tr>
                <tr><td align="right" valign="top"><font size="2">Nome para Contato:</td>
                    <td><input name="Contact Name" value="$in{'Contact Name'}" size="40"></td></tr>
                <tr><td align="right" valign="top"><font size="2">Email para Contato:</td>
                    <td><input name="Contact Email" value="$in{'Contact Email'}" size="40"></td></tr>
                <tr><td align="right" valign="top"><font size="2">Senha:</td>
                    <td><input name="Senha" value="$in{'Senha'}" size="40"><br><font size="1">
                        Escolha uma senha para alterar o seu site posteriormente</td></tr>
	        <tr><td></td><td align="center"><br><input type="SUBMIT" value="Incluir Site">$espaco$espaco</td></tr>
            </table>
        </font>
     </form>

    $site_search
    $site_footer

</body>
</html>
~;
}

sub site_html_add_success {

	my ($kategorie) = &kategorie_title_mb ($in{'Category'});

    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Site Adicionado</title>
</head>

<$site_body>

<p><$font_title>$site_title: Site Adicionado</font></p>

$site_menu

<p><br><$font>Ns recebemos o seguinte link:</p>
      <table border="0" cellpading="0" cellspacing="0">
       <tr>
        <td align="right" width="135"><font size=2><b>Ttulo:</b></td><td><font size=2>$in{'Title'}</td></tr>
        <td align="right" width="135"><font size=2><b>URL:</b></td><td><font size=2>$in{'URL'}</td></tr>
        <td align="right" width="135" valign="top"><font size=2><b>Descrio:</b></td><td><font size=2>$in{'Description'}</td></tr>
        <td align="right" width="135"><font size=2><b>Nome para Contato:</b></td><td><font size=2>$in{'Contact Name'}</td></tr>
        <td align="right" width="135"><font size=2><b>Email para Contato:</b></td><td><font size=2>$in{'Contact Email'}</td></tr>
        <td align="right" width="135"><font size=2><b>Categoria:</b></td><td><font size=2>$kategorie</td></tr>
        <td align="right" width="135"><font size=2><b>Senha:</b></td><td><font size=2>$in{'Senha'}<td></tr>
       </tr>
      </table>
    <p>Obrigado! Ns lhe enviaremos um e-mail assim que o seu link for aceito.</font><br></p>

    $site_search
    $site_footer

</body>
</html>
~;
}

sub site_html_add_failure {
# --------------------------------------------------------
# Essa rotina define como a pgina de erro adicionando ser. Voc tem 
# accesso as seguintes variveis:
#
#   $errormsg       : A lista dos problemas.
#   %in             : variveis usadas no formulrio de adio. til para recriar o formulrio
#

    my ($errormsg) = $_[0];

    $errormsg =~ s/Contact Name/Nome para Contato/;
    $errormsg =~ s/Title/Ttulo/;
    $errormsg =~ s/Category/Categoria/;
    $errormsg =~ s/Contact Email/Email para Contato/;

    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Erro Adicionando Site</title>
</head>

<$site_body>

<p><$font_title>$site_title: Erro Adicionando Site</font></p>

$site_menu

<p><br>
    <form action="$build_add_url" method="POST">                        
        <p><$font>Houve os seguintes erros tentando incluir o seu site:</p>
        <p><$font_erro><b>
            $errormsg
        </b></font></p>
        <p>Faa as correes necessrias e tente de novo!</p>

        <table border="0" cellspacing="0" cellpadding="0">
            <tr><td align="right" valign="top"><$font>Ttulo:</td>
                <td><input name="Title" value="$in{'Title'}" size="50"></td></tr>
            <tr><td align="right" valign="top"><$font>URL:</td>
                <td><input name="URL" value="$in{'URL'}" size="50"></td></tr>
            <tr><td align="right" valign="top"><$font>Categoria:</td>
                <td>~; $db_select_fields{'Category'} = join (",", &category_list); print &build_select_field ("Category", "$in{'Category'}"); print qq~</td></tr>
            <tr><td align="right" valign="top"><$font>Descrio:</td>
                <td><textarea wrap="virtual" name="Description" value="$in{'Description'}" rows="5" cols="46">$in{'Description'}</textarea></td></tr>
            <tr><td align="right" valign="top"><$font>Nome para Contato:</td>
                <td><input name="Contact Name" value="$in{'Contact Name'}" size="40"></td></tr>                            
            <tr><td align="right" valign="top"><$font>Email para Contato:</td>
                <td><input name="Contact Email" value="$in{'Contact Email'}" size="40"></td></tr>                              
            <tr><td align="right" valign="top"><font size="2">Senha:</td>
                <td><input name="Senha" value="$in{'Senha'}" size="40"><br><font size="1">
                    Escolha uma senha para alterar o seu site posteriormente</td></tr>
            <tr><td></td><td><input type="SUBMIT" value="Incluir Site"></td></tr>
        </table>
    </form>

    $site_search
    $site_footer

</body>
</html>
~;

}

##########################################################
##                    Modify Resources                 ##
##########################################################

sub site_html_modify_first {
# --------------------------------------------------------
    my %rec = @_;

    &html_print_headers;
    
    print qq~   
<$dtd>
<html>

<head>
<title>$site_title: Modificar um Site</title>
</head>

<$site_body>

<p><$font_title>$site_title: Modificar um Site</font></p>

<p><$font><br><form action="$build_modify_url" method="POST">
      <p>&nbsp; &nbsp; &nbsp; Antes de mais nada, voc precisa informar o ID e a senha do seu Link. Eles foram 
         enviados para voc por email na hora em que voc se cadastrou.</p>

        <table border="0" cellspacing="0" cellpadding="0" width="300">
          <tr><td align="right" valign="top" width="150"><font size="2">ID: </td>
              <td width="150"><input type="text" name="ID" size="5"></td></tr>
          <tr><td align="right" valign="top" width="150"><font size="2">Senha: </td>
              <td width="150"><input type="password" name="senha" size="20"></td></tr>
          <tr><td width="150"></td><td width="150"><input type="submit" value="Modificar Site"></td></tr>
        </table>
      <p>&nbsp; &nbsp; &nbsp; Esqueceu a sua senha? <b><a href="$build_senha_url">Procurar</a></b></p>
      </form>

$site_search
$site_footer

</body>
</html>
~;
}

sub site_html_modify_form {
# --------------------------------------------------------
    my %rec = @_;

   &html_print_headers;
    
    print qq~   
<$dtd>
<html>

<head>
<title>$site_title: Modificar um Site</title>
</head>

<$site_body>

<p><$font_title>$site_title: Modificar um Site</font></p>

$site_menu

<p><$font><br><form action="$build_modify_url" method="POST">
      <input type="hidden" name="Current URL" value="$rec{'URL'}">
      <$font>Agora que voc j se identificou, basta modificar o que for preciso:<br></p>

        <table border="0" cellspacing="0" cellpadding="0">
          <tr><td align="right" valign="top"><font size="2">Ttulo:</td>
              <td><input name="Title" value="$rec{'Title'}" size="50"></td></tr>
          <tr><td align="right" valign="top"><font size="2">URL:</td>
              <td><input name="URL" value="$rec{'URL'}" size="50"></td></tr>
          <tr><td align="right" valign="top"><font size="2">Categoria:</td>
              <td>~; $db_select_fields{'Category'} = join (",", &category_list); print &build_select_field ("Category", "$rec{'Category'}"); print qq~</td></tr>
          <tr><td align="right" valign="top"><font size="2">Descrio:</td>
              <td><textarea wrap="virtual" name="Description" value="$rec{'Description'}" rows="5" cols="46">$rec{'Description'}</textarea></td></tr>
          <tr><td align="right" valign="top"><font size="2">Nome para Contato:</td>
              <td><input name="Contact Name" value="$rec{'Contact Name'}" size="40"></td></tr>                            
          <tr><td align="right" valign="top"><font size="2">Email para Contato:</td>
              <td><input name="Contact Email" value="$rec{'Contact Email'}" size="40"></td></tr>
          <tr><td align="right" valign="top"><font size="2">Senha:</td>
              <td><input name="Senha" value="$rec{'Senha'}" size="20"></td></tr>
          <tr><td></td><td><input type="SUBMIT" name="Submit" value="Modificar Site"></td></tr>
        </table></font>
      </form>

    $site_search
    $site_footer

</body>
</html>
~;
}

sub site_html_modify_success {
# --------------------------------------------------------
	my ($kategorie) = &kategorie_title_mb ($in{'Category'});

    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Site Modificado</title>
</head>

<$site_body>

<p><$font_title>$site_title: Site Modificado</font></td>

$site_menu

<p><br><$font>Ns recebemos o seguinte link:</font></p>

      <table border="0">
       <tr>
        <td align="right" width="30%"><$font><strong>
            Ttulo:<br>
            URL:<br>
            Descrio:<br>
            Nome para Contato:<br>
            Email para Contato:<br>
            Categoria:<br>
            Senha:</font></strong>
        </td>
        <td align="left" width="70%"><$font>
           $in{'Title'}<br>
           $in{'URL'}<br>
           $in{'Description'}<br>
           $in{'Contact Name'}<br>
           $in{'Contact Email'}<br>
           $kategorie<br>
           $in{'Senha'}</font>
        </td>
       </tr>
      </table>
    <p><$font>Obrigado! Ns iremos lhe enviar um email quando o seu site for validado.<br></font></p>

    $site_search
    $site_footer

</body>
</html>
~;
}

sub site_html_modify_failure {

    my ($errormsg) = $_[0];

    $errormsg =~ s/Contact Name/Nome para Contato/;
    $errormsg =~ s/Title/Ttulo/;
    $errormsg =~ s/Category/Categoria/;
    $errormsg =~ s/Contact Email/Email para Contato/;

    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Erro Modificando Site</title>
</head>

<$site_body>

<p><$font_title>$site_title: Erro Modificando Site</font></p>

<form action="$build_modify_url" method="POST">
        <p><br><$font>$esp Houve os seguintes erros tentando modificar o seu site:</font><br>
            $esp <$font_erro><b>
                $errormsg
            </b></font></p>

      <input type="hidden" name="Current URL" value="$rec{'URL'}">
      <$font>$esp Agora que voc j se identificou, basta modificar o que for preciso:<br></p>

            <table border="0" cellspacing="0" cellpadding="0">
                <tr><td align="right" valign="top"><font size="2">Ttulo:</td>
                    <td><input name="Title" value="$in{'Title'}" size="50"></td></tr>
                <tr><td align="right" valign="top"><font size="2">URL:</td>
                    <td><input name="URL" value="$in{'URL'}" size="50"></td></tr>
                <tr><td align="right" valign="top"><font size="2">Categoria:</td>
                    <td>~; $db_select_fields{'Category'} = join (",", &category_list); print &build_select_field ("Category", "$in{'Category'}"); print qq~</td></tr>
                <tr><td align="right" valign="top"><font size="2">Descrio:</td>
                    <td><textarea wrap="virtual" name="Description" value="$in{'Description'}" rows="5" cols="46">$in{'Description'}</textarea></td></tr>
                <tr><td align="right" valign="top"><font size="2">Nome para Contato:</td>
                    <td><input name="Contact Name" value="$in{'Contact Name'}" size="40"></td></tr>                            
                <tr><td align="right" valign="top"><font size="2">Email para Contato:</td>
                    <td><input name="Contact Email" value="$in{'Contact Email'}" size="40"></td></tr>                          
               <tr><td align="right" valign="top"><font size="2">Senha:</td>
                   <td><input name="Senha" value="$in{'Senha'}" size="20"></td></tr>
               <tr><td></td><td><input type="SUBMIT" value="Modificar Site"></td></tr>
            </table>
    </form>

    $site_search
    $site_footer

</body>
</html>
~;

}

##########################################################
##                  Resultado da Busca                  ##
##########################################################

sub site_html_search_results {
# --------------------------------------------------------
# Essa rotina determinar como ser o resultado de uma busca.
# 


    my (@hits) = @_;
    my $term    = &urlencode ($in{'query'});
    $termo = $in{'query'};
    $termo =~ s/\+/ /;

	if ($cat_hits == 1) { $mostra_cat = 'categoria'; }
	else { $mostra_cat = 'categorias'; }
	if ($link_hits == 1) { $mostra_link = 'link'; }
	else { $mostra_link = 'links'; }


    &html_print_headers;    
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Resultados da Busca</title>
</head>

<$site_body>

<p><$font_title>$site_title: Resultados da Busca</font></p>

$site_menu

 <p><br><$font>A sua busca retornou <strong>$cat_hits</strong> $mostra_cat e <strong>$link_hits</strong> $mostra_link.</font></p>

~;
if ($next) {    
    print qq~<p><$font>Pginas: $next</font></p>
~;
}
if ($category_results) {
    print qq~
        <p><$font_results><b>Categorias:</b></font></p>
        <ul><$font>$category_results</font></ul>
~;
}
if ($link_results) {
    print qq~   
        <p><$font_results><b>Links</b></font>
        $link_results
~;
}
if ($next) {
    print qq~
        <p><$font>Pginas: $next</font></p>
~;
    }   

    print qq~
    $site_search
    $site_footer

</body>
</html>
~;
}

sub site_html_search_failure {

    my ($error) = shift;
    my $term    = &urlencode ($in{'query'});
    $termo = $in{'query'};
    $termo =~ s/\+/ /;
    &html_print_headers;
    
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Busca Falhou</title>
</head>

<$site_body>

<p><$font_title>$site_title: Busca Falhou</font></p>
$site_menu
<p><br><$font>Erro: <$font_erro><b>$error</b></font></p>
     <form action="$build_search_url" method="GET">
        <$font>
            <table border="0" cellpadding="0" cellspacing="0">
                <tr><td><font size="2">Procurar por: <input type="TEXT" name="query" size="30"> <input type="Submit" value="Busca!"></font></td></tr>
                <tr><td><font size="2">Nmero de Resultados: <SELECT name="mh"><OPTION>10<OPTION SELECTED>25<OPTION>50<OPTION>100</SELECT></font></td></tr>
                <tr><td><font size="2">Como palavra-chave: <input type="RADIO" name="type" value="keyword" CHECKED> Como Frase: <input type="RADIO" name="type" value="phrase"></font></td></tr>
                <tr><td><font size="2">Conector:  E: <input type="RADIO" name="bool" value="and" CHECKED> OU: <input type="RADIO" name="bool" value="or"></font></td></tr>
            </table>
        </font>
    </form>

    $site_search
    $site_footer

</body>
</html>
~;
}
    

sub site_html_search_form {

    my $action = shift;

    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Opes de Busca</title>
</head>

<$site_body>

<p><$font_title>$site_title: Opes de Busca</font></p>
$site_menu
<p><br>
     <form action="$build_search_url" method="GET">
        <$font>
            <table border="0" cellpadding="0" cellspacing="0">
                <tr><td><font size="2">Procurar por: <input type="TEXT" name="query" size="30"> <input type="Submit" value="Busca!"></font></td></tr>
                <tr><td><font size="2">Nmero de Resultados: <SELECT name="mh"><OPTION>10<OPTION SELECTED>25<OPTION>50<OPTION>100</SELECT></font></td></tr>
                <tr><td><font size="2">Como palavra-chave: <input type="RADIO" name="type" value="keyword" CHECKED> Como Frase: <input type="RADIO" name="type" value="phrase"></font></td></tr>
                <tr><td><font size="2">Conector:  E: <input type="RADIO" name="bool" value="and" CHECKED> OU: <input type="RADIO" name="bool" value="or"></font></td></tr>
            </table>
        </font>
    </form>
   </td>
</p>

    $site_search
    $site_footer

</body>
</html>
~;

}

##########################################################
##                    Email Updates                   ##
##########################################################

sub site_html_mailing {
# --------------------------------------------------------
# Essa rotina exibe o formulrio de assinatura/remoo da sua mailing list.
#
    my $action = shift;
    my $message;
    ($action eq 'subscribe')   and ($message = qq~Voc foi inscrito com sucesso ao nosso mailing list!~);
    ($action eq 'unsubscribe') and ($message = qq~Voc foi removido com sucesso do nosso mailing list!~);
    
    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Atualizaes por Email</title>
</head>

<$site_body>

<p><$font_title>$site_title: Atualizaes por E-mail</font></p>

$site_menu

      <form action="$build_email_url" method="POST">
       <p><br><$font_erro><b>$message</b></font></p>
       <p><$font>Mantenha-se informado de novas adices ao $site_title, inscrevendo-se ao nossso boletim
          que ir enviar os novos links direto ao seu email!<br><br>        
          <select name="action"><option value="subscribe">Inscrever-se<option value="unsubscribe">Remover-se</select>  lista<br>
          Nome: <input name="name" size=15> Email: <input name="email" size=15> <input type="submit" value="Enviar!">
       </p>
      </form>
</p>
    $site_search
    $site_footer
</body>
</html>
    ~;  
}

sub site_html_mailing_error {
    my $error = shift;
    
    &html_print_headers();
    print qq~
<$dtd>
<html>
<head>
<title>$site_title: Problemas!!!</title>
</head>
<$site_body>

<p><$font_title>Oops, houve um problema!</font></p>

$site_menu

     <p><br><$font>Erro: <$font_erro><b>$error</b></font></p>
     <p>Por favor <a href="javascript:history.go(-1)">volte</a> e corrija o problema.</font></p>

    $site_search
    $site_footer

</body>
</html>     
    ~;
}

##########################################################
##                        Avaliaes                    ##
##########################################################

sub site_html_ratings {
# --------------------------------------------------------
# Essa rotina determina como a pgina de mais votados ser.
# Voc pode usar:
#       $top_rated : tabela de trs colunas sem as tags <table> e </table>.
#       $top_votes : tabela de trs colunas sem as tags <table> e </table>.
#
#
    my %rec = @_;
    
    &html_print_headers;    
    my $output = qq~   
<$dtd>
<html>

<head>
<title>$site_title: Avaliaes</title>
</head>

<$site_body>

<p><$font_title>$site_title: Avaliaes</font></td>
$site_menu

     <p><br><$font><b>10 Sites mais bem Avaliados (por Nota)</b><br>
       <table border=0>
         <tr><th><font size="2"><b>Nota</b></th><th><font size="2"><b># Votos</b></th><th><font size="2"><b>Site</b></th></tr>
         $top_rated
       </table>
     </p>
     <p><b>10 Sites mais bem Avaliados (por Quantidade de Votos)</b><br>
       <table border=0>
         <tr><th><font size="2"><b>Nota</b></th><th><font size="2"><b># Votos</b></th><th><font size="2"><b>Site</b></th></tr>
         $top_votes
       </table>
     </p>

    $site_search
    $site_footer

</body>
</html>
~;
    return $output;

}

sub site_html_rate_form {
# --------------------------------------------------------
# Essa rotina determina como o formulrio de avaliao ser exibido. 
#
    my %rec = @_;
    
    &html_print_headers;    
    print qq~   
<$dtd>
<html>

<head>
<title>$site_title: Avaliar um Site</title>
</head>

<$site_body>

<p><$font_title>$site_title: Avaliar um Site</font></td>
$site_menu
     <form action="$build_rate_url" method="POST">   
        <input type=hidden name="$db_key" value="$in{$db_key}">
        <p><br><$font>Por favor, avalie o link <b><a href="$rec{'URL'}">$rec{'Title'}</a></b> entre 1(um) e 10(dez), sendo 10 o mximo.</p>
            <p><select name=rate>
                <option>---
                <option>1
                <option>2
                <option>3
                <option>4
                <option>5
                <option>6
                <option>7
                <option>8
                <option>9
                <option>10
               </select>
               <input type=submit value="Avaliar Esse Link">
            </p>
    </form>

    $site_search
    $site_footer

</body>
</html>
~;

}

sub site_html_rate_success {
# --------------------------------------------------------
#
#   %in     : a varivel usada para avaliar o link, til na confirmao do que foi adicionado.
#

    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Site Avaliado</title>
</head>

<$site_body>

$site_menu
  
  <$font_title>$site_title: Site Avaliado</font></td>
     <p><br><$font>Obrigado pelo seu voto.<br></p>

    $site_search
    $site_footer

</body>
</html>
~;
}

sub site_html_rate_failure {
# ---------------------------------------
#
#   $errormsg       : A lista dos problemas encontrados.
#

    my $errormsg = shift;

    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Erro Avaliando Site</title>
</head>

<$site_body>

<p><$font_title>$site_title: Erro Avaliando Site</font></td>
$site_menu
      <p><br><$font>Desculpe, no foi possvel avaliar o site pelo seguinte motivo:
      <p><$font_erro><b>
          $errormsg
      </b></font></p>
      <p>Por favor, contate o administrador do site se voc tiver qualquer dvida.</font><br></p>

    $site_search
    $site_footer

</body>
</html>
~;

}

##########################################################
##                    Procurar Senha                    ##
##########################################################


sub site_html_senha_form {
# --------------------------------------------------------
# Essa rotina mostra o formulrio para procurar a senha.
#
    
    &html_print_headers;    
    print qq~   
<$dtd>
<html>

<head>
<title>$site_title: Esqueceu a senha?</title>
</head>

<$site_body>

<p><$font_title>$site_title: Procurar Senha</font></p>

$site_menu

     <p><br>
<form action="$build_senha_url" method="POST">
  <table border="0" width="100%" bgcolor="#F7F7F7">
   <tr>
    <td><$font>&nbsp; &nbsp; &nbsp; 
       Se voc esqueceu a sua senha e/ou seu ID, basta voc digitar o endereo de
       sua pgina abaixo e a carta de boas vindas que voc recebeu quando incluiu o seu site,
       ser reenviada a voc no e-mail cadastrado.</p>
       <p>Endereo: <input type="text" name="URL" value="http://" size="40">
    </td>
   </tr>
   <tr><td align=center><input type=submit value="Procurar Dados"></td></tr>
  </table>
</form>

    $site_search
    $site_footer

</body>
</html>
~;

}

sub site_html_senha_failure {
# --------------------------------------------------------

    my $errormsg = shift;
    
    &html_print_headers;    
    print qq~   
<$dtd>
<html>

<head>
<title>$site_title: Procura por Dados Falhou.</title>
</head>

<$site_body>

<p><$font_title>$site_title: Procura por Senha Falhou</font></p>

$site_menu

<p><br>
<form action="$build_senha_url" method="POST">
  <table border="0" width="100%">
   <tr>
    <td><$font>Desculpe, no foi possvel encontrar os seus dados pelo seguinte motivo:<br>
      <$font_erro><b>$errormsg</b></font></p>
      <p><br><$font>&nbsp; &nbsp; &nbsp; 
       Se voc esqueceu a sua senha e/ou seu ID, basta voc digitar o endereo de
       sua pgina abaixo e a carta de boas vindas que voc recebeu quando incluiu o seu site,
       ser reenviada a voc no e-mail cadastrado.</p>
      <p>Endereo: <input type="text" name="URL" value="http://" size="45">
    </td>
   </tr>
   <tr><td align=center><input type=submit value="Procurar Dados"></td></tr>
  </table>
</form>

    $site_search
    $site_footer

</body>
</html>
~;

}

sub site_html_senha_success {
# --------------------------------------------------------

    my %rec = @_;

    &html_print_headers;
    print qq~
<$dtd>
<html>

<head>
<title>$site_title: Dados Enviados</title>
</head>

<$site_body>

<p><$font_title>$site_title: Dados Enviados</font></p>

$site_menu

     <p><br><$font>&nbsp; &nbsp; &nbsp; &nbsp; O endereo <b>$rec{'URL'}</b> foi encontrado nos nossos arquivos.<br>
     &nbsp; &nbsp; &nbsp; &nbsp; Sua mensagem de boas vindas original foi enviada para o email <b>$rec{'Contact Email'}</b>.</p>
     <p>&nbsp; &nbsp; &nbsp; &nbsp; Se voc quiser modicar o seu link agora, 
       v at <a href="$build_modify_url">$build_modify_url</a></p>

    $site_search
    $site_footer

</body>
</html>
~;
}

# ***************************************** nonenglish modification - begin ****************
sub kategorie_title_mb {
# --------------------------------------------------------
	open (DB, "<$db_category_name") or &cgierr("unable to open $db_file_name. Reason: $!");
		@kategorien = <DB>;
	close DB;

	my ($input, $output, $title, $kategorie, @fields);

	$input = $_[0];
	$title = "";

	KATEGORIE: foreach $kategorie (@kategorien) {
		if ($kategorie =~ /^#/) { next KATEGORIE; }       # Skip comment lines.   
		chomp ($kategorie);                                        
		@fields = &split_decode ($kategorie);
		if (@fields[1] eq $input) {
			$title = @fields[8];
			$title =~ s,\\, : ,g;
			last KATEGORIE;
		}
	}
	if ($title eq "") {
		$output = &build_clean ($input);
	}
	else {
		$output = $title;
	}

	return $output;
}
# ***************************************** nonenglish modification - end ******************

1;