#!/usr/bin/perl
##########################################################################
# Aardvark Topsites 3.02 to Aardvark Topsites 3.2.0 Converter            #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Script Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Last Modified: 2002-07-03                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
use strict;
package AT;
use CGI::Carp qw(fatalsToBrowser);
use Fcntl qw(:DEFAULT :flock);

BEGIN {
  require "./config.cgi";
  use lib "$AT::config{dir}/Modules";
}

require "$AT::config{dir}/Modules/Scripts/Subs.pm";

use CGI qw/:standard/;
$AT::cgi = new CGI;
%AT::form = map { $_ => &subs::strip($AT::cgi->param($_)) } $AT::cgi->param;

sysopen(NUM, "$AT::config{dir}/Data/num.txt", AT::O_RDONLY) || die "$!, stopped";
flock(NUM, 2);
my($id, $totalranks) = split(/\|/, <NUM>);
close(NUM);

my $num = 1;

while ($id >= $num) {
  sysopen(REVIEWS, "$AT::config{dir}/Data/Members/${num}reviews.txt", O_WRONLY|O_CREAT) || die "$!, stopped";
  chmod(0666, "$AT::config{dir}/Data/Members/${num}reviews.txt") || die "$!, stopped";
  close(REVIEWS);
  $num++;
}

$num--;

print "Content-type: text/html\n\nAll $num members have been successfully converted.... hopefully.  Go to topsites.cgi and see if your members are listed.  If not, don't panic.  The list doesn't refresh constantly.  Just wait a little while and see if they show up.";