#!/usr/bin/perl
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Script Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Last Modified: 2002-06-29                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
use strict;
package AT;
use CGI::Carp qw(fatalsToBrowser);
use Fcntl qw(:DEFAULT :flock);

BEGIN {
  require "./config.cgi";
  use lib "$AT::config{dir}/Modules";
}

require "$AT::config{dir}/Modules/Scripts/Subs.pm";

use CGI qw/:standard/;
$AT::cgi = new CGI;
%AT::form = map { $_ => &subs::strip($AT::cgi->param($_)) } $AT::cgi->param;

use Benchmark;
$AT::t1 = new Benchmark;

$tmpl::var{language} = $AT::config{deflanguage};
require "$AT::config{dir}/Modules/Languages/$tmpl::var{language}.pm";

my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = (localtime(time + (3600 * $AT::config{timeoffset})));
$Scripts::Date::dcheck = $mday;
sysopen(DATE, "$AT::config{dir}/Data/date.txt", AT::O_RDONLY) || die "$!, stopped";
flock(DATE, 2);
$Scripts::Date::date = <DATE>;
close(DATE);
if ($Scripts::Date::dcheck != $Scripts::Date::date) { require "$AT::config{dir}/Modules/Scripts/Date.pm"; }

# Rerank the members?
sysopen(OLDTIME, "$AT::config{dir}/Data/oldtime.txt", AT::O_RDONLY) || die "$!, stopped";
flock(OLDTIME, 2);
my $oldtime = <OLDTIME>;
close(OLDTIME);
$Scripts::Date::newtime = time;
$Scripts::Date::check = $Scripts::Date::newtime - $oldtime;
if ($Scripts::Date::check >= $AT::config{refresh}) { require "$AT::config{dir}/Modules/Scripts/Rank.pm"; }

# What does the user want to see?
if ($AT::form{action} eq "admin") { require "$AT::config{dir}/Modules/Scripts/Admin.pm"; }
elsif ($AT::form{action} eq "button") { require "$AT::config{dir}/Modules/Scripts/Button.pm"; }
elsif ($AT::form{action} eq "display") { require "$AT::config{dir}/Modules/Scripts/Display.pm"; }
elsif ($AT::form{action} eq "edit") { require "$AT::config{dir}/Modules/Scripts/Edit.pm"; }
elsif ($AT::form{action} eq "email") { require "$AT::config{dir}/Modules/Scripts/Email.pm"; }
elsif ($AT::form{action} eq "graph") { require "$AT::config{dir}/Modules/Scripts/Graph.pm"; }
elsif ($AT::form{action} eq "in") { require "$AT::config{dir}/Modules/Scripts/In.pm"; }
elsif ($AT::form{action} eq "in2") { require "$AT::config{dir}/Modules/Scripts/In2.pm"; }
elsif ($AT::form{action} eq "info") { require "$AT::config{dir}/Modules/Scripts/Info.pm"; }
elsif ($AT::form{action} eq "join") { require "$AT::config{dir}/Modules/Scripts/Join.pm"; }
elsif ($AT::form{action} eq "lostcode") { require "$AT::config{dir}/Modules/Scripts/LostCode.pm"; }
elsif ($AT::form{action} eq "lostpw") { require "$AT::config{dir}/Modules/Scripts/LostPW.pm"; }
elsif ($AT::form{action} eq "out") { require "$AT::config{dir}/Modules/Scripts/Out.pm"; }
elsif ($AT::form{action} eq "random") { require "$AT::config{dir}/Modules/Scripts/Random.pm"; }
elsif ($AT::form{action} eq "rate") { require "$AT::config{dir}/Modules/Scripts/Rate.pm"; }
elsif ($AT::form{action} eq "search") { require "$AT::config{dir}/Modules/Scripts/Search.pm"; }
elsif ($AT::form{action} eq "stats") { require "$AT::config{dir}/Modules/Scripts/Stats.pm"; }
elsif ($AT::form{action} eq "top") { require "$AT::config{dir}/Modules/Scripts/Top.pm"; }
else { require "$AT::config{dir}/Modules/Scripts/Display.pm"; }