package subs;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Subroutines                                               #
# Module Desc: Various subroutines for the script.                       #
# Module Group: Required                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
sub subs::email {
  if ($AT::config{mail}) {
    open(MAIL,"|$AT::config{mail} -t") || die "$!, stopped";
    print MAIL "To: $_[0]\n";
    print MAIL "From: $_[1]\n";
    print MAIL "Subject: $_[2]\n\n";
    print MAIL "$_[3]\n\n";
    close(MAIL);
  }
  elsif ($AT::config{smtpserver}) {
    require "$AT::config{dir}/Modules/Mail/Sendmail.pm";
    unshift @{$Mail::Sendmail::mailcfg{'smtp'}} , '$smtpserver';
    %mail = ( To      => "$_[0]",
              From    => "$_[1]",
              Subject => "$_[2]",
              Message => "$_[3]"
    );
    sendmail(%mail) || die $Mail::Sendmail::error;
  }
}
sub subs::regexvars {
  $_[0] =~ s/<\$lng\{\'(.+?)\'\}>/$tmpl::lng{$1}/ig;
  $_[0] =~ s/<\$(.+?)>/$tmpl::var{$1}/ig;
  return $_[0];
}
sub subs::strip {
  $_[0] =~ s/\|/\&\#124\;/g;
  $_[0] =~ s/\"/\&quot\;/g;
  $_[0] =~ s/\'/\&rsquo\;/g;
  if ($AT::form{action} ne "admin") {
    $_[0] =~ s/</\&lt\;/g;
    $_[0] =~ s/>/\&gt\;/g;
    $_[0] =~ s/\n//g;
    $_[0] =~ s/\cM//g;
  }
  return $_[0];
}
sub subs::template {
  if ($AT::form{action} eq "admin" && !$Scripts::Rank::refresh) {
    sysopen(TEMPLATE, "$AT::config{templates_dir}/admin.html", AT::O_RDONLY) || die "$!, stopped";
    flock(TEMPLATE, 2);
  }
  else {
    sysopen(TEMPLATE, "$AT::config{templates_dir}/template.html", AT::O_RDONLY) || die "$!, stopped";
    flock(TEMPLATE, 2);
  }
  my @template = <TEMPLATE>;
  close(TEMPLATE);
  sysopen(NUM,"$AT::config{dir}/Data/num.txt", AT::O_RDONLY) || die "$!, stopped";
  flock(NUM, 2);
  ($Scripts::Subs::bignum,$tmpl::var{nummem}) = split(/\|/,<NUM>);
  close(NUM);
  my $meth_lng = "g_$AT::config{uniquetotal}";
  $tmpl::var{meth} = $tmpl::lng{$meth_lng};
  my $done = 1;
  my $listnum = $tmpl::var{nummem} / $AT::config{numlist};
  $listnum2 = int($listnum);
  unless ($listnum == $listnum2) { $listnum2++; }
  $listnum2++;
  my $menulist = $AT::config{numlist};
  $tmpl::var{menu} = "<select name=\"page\" class=\"form\">\n";
  while ($listnum2 > $done) {
    if ($done == 1) { $tmpl::var{menu} .= "<option value=\"\">1 - $menulist\n"; }
    else {
      my $menulist1 = $menulist + 1;
      if ($done eq $AT::form{page}) { $tmpl::var{menu} .= "<option value=\"$done\" selected=\"selected\">$menulist1"; }
      else { $tmpl::var{menu} .= "<option value=\"$done\">$menulist1"; }
      $menulist = $menulist + $AT::config{numlist};
      $tmpl::var{menu} .= " - $menulist\n";
    }
    $done++;
  }
  $tmpl::var{menu} .= "</select>\n<input type=\"submit\" value=\"$tmpl::lng{'g_form_submit_short'}\" class=\"form\" />\n";
  if ($done <= 2) { $tmpl::var{menu} = ""; }
  my $templates;
  foreach my $thing(@template) {
    if ($thing =~ /<include=\"(.+?)\">/) {
      my $file;
      sysopen(SSI, "$1", AT::O_RDONLY) || die "$!, stopped";
      flock(SSI, 2);
      @ssi = <SSI>;
      close(SSI);
      foreach my $line(@ssi) { $file .= $line; }
      $thing =~ s/<include=\".+\">/$file/i;
    }
    elsif ($thing =~ /<include2=\"(.+?)\">/) {
      my $file;
      use LWP::Simple qw(get);
      $file = get "$1";
      $thing =~ s/<include2=\".+\">/$file/i;
    }
    $templates .= $thing;
  }
  $tmpl::var{time} = time;
  $AT::t2 = new Benchmark;
  my $td = AT::timediff($AT::t2,$AT::t1);
  $tmpl::var{td} = AT::timestr($td);
  $templates = &subs::regexvars($templates);
  if (!$_[0]) { print "Content-type: text/html\n\n" . $templates; }
  else { return $templates; }
}
1;