package Scripts::Stats;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Stats                                                     #
# Module Desc: Displays the stats for the given member.                  #
# Module Group: Standard                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
$tmpl::var{header} = $tmpl::lng{'stats_header'};
sysopen(HITS, "$AT::config{dir}/Data/Members/$AT::form{id}.txt", AT::O_RDONLY) || die "$!, stopped";
flock(HITS, 2);
my @hits = <HITS>;
close(HITS);
($tmpl::var{tod_unq_pv}, $tmpl::var{'1_unq_pv'}, $tmpl::var{'2_unq_pv'}, $tmpl::var{'3_unq_pv'}) = split(/\|/, $hits[0]);
$tmpl::var{avg_unq_pv} = ($tmpl::var{tod_unq_pv} + $tmpl::var{'1_unq_pv'} + $tmpl::var{'2_unq_pv'} + $tmpl::var{'3_unq_pv'}) / 4;
($tmpl::var{tod_tot_pv}, $tmpl::var{'1_tot_pv'}, $tmpl::var{'2_tot_pv'}, $tmpl::var{'3_tot_pv'}) = split(/\|/, $hits[1]);
$tmpl::var{avg_tot_pv} = ($tmpl::var{tod_tot_pv} + $tmpl::var{'1_tot_pv'} + $tmpl::var{'2_tot_pv'} + $tmpl::var{'3_tot_pv'}) / 4;
($tmpl::var{tod_unq_in}, $tmpl::var{'1_unq_in'}, $tmpl::var{'2_unq_in'}, $tmpl::var{'3_unq_in'}) = split(/\|/, $hits[2]);
$tmpl::var{avg_unq_in} = ($tmpl::var{tod_unq_in} + $tmpl::var{'1_unq_in'} + $tmpl::var{'2_unq_in'} + $tmpl::var{'3_unq_in'}) / 4;
($tmpl::var{tod_tot_in}, $tmpl::var{'1_tot_in'}, $tmpl::var{'2_tot_in'}, $tmpl::var{'3_tot_in'}) = split(/\|/, $hits[3]);
$tmpl::var{avg_tot_in} = ($tmpl::var{tod_tot_in} + $tmpl::var{'1_tot_in'} + $tmpl::var{'2_tot_in'} + $tmpl::var{'3_tot_in'}) / 4;
($tmpl::var{tod_unq_out}, $tmpl::var{'1_unq_out'}, $tmpl::var{'2_unq_out'}, $tmpl::var{'3_unq_out'}) = split(/\|/, $hits[4]);
$tmpl::var{avg_unq_out} = ($tmpl::var{tod_unq_out} + $tmpl::var{'1_unq_out'} + $tmpl::var{'2_unq_out'} + $tmpl::var{'3_unq_out'}) / 4;
($tmpl::var{tod_tot_out}, $tmpl::var{'1_tot_out'}, $tmpl::var{'2_tot_out'}, $tmpl::var{'3_tot_out'}) = split(/\|/, $hits[5]);
$tmpl::var{avg_tot_out} = ($tmpl::var{tod_tot_out} + $tmpl::var{'1_tot_out'} + $tmpl::var{'2_tot_out'} + $tmpl::var{'3_tot_out'}) / 4;
my $avg = "avg_$AT::config{uniquetotal}";
my $tod = "tod_$AT::config{uniquetotal}";
$tmpl::var{avg} = $tmpl::var{$avg};
$tmpl::var{tod} = $tmpl::var{$tod};
($tmpl::var{ratetot}, $tmpl::var{ratenum}) = split(/\|/, $hits[6]);
sysopen(REVIEWS, "$AT::config{dir}/Data/Members/$AT::form{id}reviews.txt", AT::O_RDONLY) || die "$!, stopped";
flock(REVIEWS, 2);
$tmpl::var{review} = join('', <REVIEWS>);
close(REVIEWS);
sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
flock(INFO, 2);
my @info = <INFO>;
close(INFO);
foreach (@info) {
  ($tmpl::var{id}, $tmpl::var{url}, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $Scripts::Stats::password, $tmpl::var{urlbanner}) = split(/\|/);
  if ($tmpl::var{id} eq $AT::form{id}) { last; }
}
if ($tmpl::var{ratenum} == 0) { $tmpl::var{avg_rate} = 0; }
else {
  $tmpl::var{avg_rate} = $tmpl::var{ratetot} / $tmpl::var{ratenum};
  unless (int($tmpl::var{avg_rate}) == $tmpl::var{avg_rate}) {
    $tmpl::var{avg_rate} =~ /(.+)\.(.+)/;
    my $avg_rate2 = substr($2, 0, 2);
    $tmpl::var{avg_rate} = "$1.$avg_rate2";
  }
}
sysopen(STATS,"$AT::config{templates_dir}/stats.html", AT::O_RDONLY) || die "$!, stopped";
flock(STATS, 2);
print "Content-type: text/html\n\n" . &subs::regexvars(join('', <STATS>));
close(STATS);
1;