package Scripts::Search;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Search                                                    #
# Module Desc: Lets visitors search for members.                         #
# Module Group: Standard                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
$tmpl::var{header} = $tmpl::lng{'search_header'};
if (!$AT::config{search}) { $tmpl::var{content} .= "$tmpl::lng{'search_off'}<br /><br />"; }
elsif ($AT::form{kw}) {
  my @keywords;
  if ($AT::form{string}) { $keywords[0] = $AT::form{kw}; $tmpl::var{checked} = "checked=\"checked\""; }
  else { @keywords = split(/ /, $AT::form{kw}); $tmpl::var{checked} = ""; }
  $tmpl::var{keywords} = $AT::form{kw};
  my $results = 1;
  sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
  flock(INFO, 2);
  my @info = <INFO>;
  close(INFO);
  foreach my $line(@info) {
    chomp($line);
    ($tmpl::var{id}, $tmpl::var{url}, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $Scripts::Search::password, $tmpl::var{urlbanner}) = split(/\|/, $line);
    foreach my $keyword(@keywords) {
      if ($tmpl::var{description} =~ /$keyword/i || $tmpl::var{title} =~ /$keyword/i) {
        $tmpl::var{description} =~ s/($keyword)/<b>$1<\/b>/ig;
        my $url = "topsites.cgi?action=out\&amp\;id=$tmpl::var{id}";
        $tmpl::var{results} .= "$results. <a href=\"$url\" target=\"_blank\"><b>$tmpl::var{title}</b></a><br />$tmpl::var{description}</a><br /><font color=\"\#737373\">$tmpl::lng{'g_id'}: $tmpl::var{id} | $tmpl::var{url}</font><br /><br />\n";
        $results++;
      }
    }
  }
  if ($results == 1) { $tmpl::var{results} .= "$tmpl::lng{'search_nosites'}<br /><br />"; }
  sysopen(SEARCH_RESULTS, "$AT::config{templates_dir}/search_results.html", AT::O_RDONLY) || die "$!, stopped";
  flock(SEARCH_RESULTS, 2);
  $tmpl::var{content} .= &subs::regexvars(join('', <SEARCH_RESULTS>));
  close(SEARCH_RESULTS);
}
else {
  sysopen(SEARCH_FORM, "$AT::config{templates_dir}/search_form.html", AT::O_RDONLY) || die "$!, stopped";
  flock(SEARCH_FORM, 2);
  $tmpl::var{content} .= &subs::regexvars(join('', <SEARCH_FORM>));
  close(SEARCH_FORM);
}
&subs::template;
1;