package Scripts::Rate;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Rate and Review                                           #
# Module Desc: Allows visitors to rate and review members.               #
# Module Group: Standard                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
$tmpl::var{header} = $tmpl::lng{'rate_header'};
unless ($AT::form{id}) {
  sysopen(RATE_FORM, "$AT::config{templates_dir}/rate_form.html", AT::O_RDONLY) || die "$!, stopped";
  flock(RATE_FORM, 2);
  $tmpl::var{content} .= &subs::regexvars(join('', <RATE_FORM>));
  close(RATE_FORM);
}
elsif ($AT::form{do} eq "form" && $AT::form{id}) {
  sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
  flock(INFO, 2);
  my @info = <INFO>;
  close(INFO);
  foreach (@info) {
    ($tmpl::var{id}, $Scripts::Rate::url, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $Scripts::Rate::password, $tmpl::var{urlbanner}) = split(/\|/);
    if ($tmpl::var{id} == $AT::form{id}) { last; }
  }
  $tmpl::var{url} = "topsites.cgi?action=out\&amp\;id=$AT::form{id}";
  sysopen(RATE_FORM2, "$AT::config{templates_dir}/rate_form2.html", AT::O_RDONLY) || die "$!, stopped";
  flock(RATE_FORM2, 2);
  $tmpl::var{content} .= &subs::regexvars(join('', <RATE_FORM2>));
  close(RATE_FORM2);
}
elsif ($AT::form{do} eq "submit" && $AT::form{id}) {
  my $cookiename = "aardvark_rate_$AT::form{id}_$AT::config{list_url}";
  if (!$AT::cgi->cookie($cookiename)) {
    my $cookie = $AT::cgi->cookie(	-name=>$cookiename,
			     		-value=>'1',
			     		-expires=>'+72h');
    print "Set-Cookie: $cookie\n";
    sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
    flock(INFO, 2);
    my @info = <INFO>;
    close(INFO);
    foreach (@info) {
      ($tmpl::var{id}, $Scripts::Rate::url, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $Scripts::Rate::password, $tmpl::var{urlbanner}) = split(/\|/);
      if ($tmpl::var{id} == $AT::form{id}) { last; }
    }
    $tmpl::var{url} = "topsites.cgi?action=out\&amp\;id=$AT::form{id}";
    if ($AT::form{review}) {
      $AT::form{review} .= "<br /><hr /><br />";
      $tmpl::var{review} = $AT::form{review};
      sysopen(REVIEW, "$AT::config{dir}/Data/Members/$tmpl::var{id}reviews.txt", AT::O_WRONLY|AT::O_APPEND) || die "$!, stopped";
      flock(REVIEW, 2);
      print REVIEW "$tmpl::var{review}\n";
      close(REVIEW);
    }
    if ($AT::form{rating}) {
      $tmpl::var{rating} = &subs::strip($AT::form{rating});
      sysopen(HITS, "$AT::config{dir}/Data/Members/$AT::form{id}.txt", AT::O_RDWR) || die "$!, stopped";
      flock(HITS, 2);
      my @hits = <HITS>;
      truncate(HITS, 0);
      seek(HITS, 0, 0);
      my($ratetot, $ratenum) = split(/\|/, $hits[6]);
      $ratetot = $ratetot + $tmpl::var{rating};
      $ratenum++;
      $hits[6] = join('|', $ratetot, $ratenum);
      print HITS @hits;
      close(HITS);
    }
    $tmpl::var{content} .= "$tmpl::lng{'rate_thanks'}<br /><br />";
  }
  else { $tmpl::var{content} .= "$tmpl::lng{'rate_error'}<br /><br />"; }
  $tmpl::var{content} .= "<a href=\"$AT::config{list_url}/topsites.cgi?action=stats\&amp\;id=$AT::form{id}\">$tmpl::lng{'rate_back'}</a><br /><br />";
}
print "Content-type: text/html\n\n";
sysopen(RATE, "$AT::config{templates_dir}/rate.html", AT::O_RDONLY) || die "$!, stopped";
flock(RATE, 2);
print &subs::regexvars(join('', <RATE>));
close(RATE);
1;