package Scripts::Rank;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Rank                                                      #
# Module Desc: Reranks members.                                          #
# Module Group: Required                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
if ($Scripts::Date::check >= $AT::config{refresh}) {
  $Scripts::Rank::refresh = 1;
  sysopen(OLDTIME, "$AT::config{dir}/Data/oldtime.txt", AT::O_WRONLY|AT::O_TRUNC) || die "$!, stopped";
  flock(OLDTIME, 2);
  print OLDTIME $Scripts::Date::newtime;
  close(OLDTIME);
  sysopen(TABLEHEADER, "$AT::config{templates_dir}/tableheader.html", AT::O_RDONLY) || die "$!, stopped";
  flock(TABLEHEADER, 2);
  my $tableheader = &subs::regexvars(join('', <TABLEHEADER>));
  close(TABLEHEADER);
  sysopen(TABLE, "$AT::config{templates_dir}/table.html", AT::O_RDONLY) || die "$!, stopped";
  flock(TABLE, 2);
  my $table = join('', <TABLE>);
  close(TABLE);
  sysopen(TABLECLOSER, "$AT::config{templates_dir}/tablecloser.html", AT::O_RDONLY) || die "$!, stopped";
  flock(TABLECLOSER, 2);
  my $tablecloser = &subs::regexvars(join('', <TABLECLOSER>));
  close(TABLECLOSER);
  my($tableheader_top, $table_top, $tablecloser_top);
  if ($AT::config{top}) {
    sysopen(TABLEHEADER, "$AT::config{templates_dir}/tableheader_top.html", AT::O_RDONLY) || die "$!, stopped";
    flock(TABLEHEADER, 2);
    $tableheader_top = &subs::regexvars(join('', <TABLEHEADER>));
    close(TABLEHEADER);
    sysopen(TABLE, "$AT::config{templates_dir}/table_top.html", AT::O_RDONLY) || die "$!, stopped";
    flock(TABLE, 2);
    $table_top = join('', <TABLE>);
    close(TABLE);
    sysopen(TABLECLOSER, "$AT::config{templates_dir}/tablecloser_top.html", AT::O_RDONLY) || die "$!, stopped";
    flock(TABLECLOSER, 2);
    $tablecloser_top = &subs::regexvars(join('', <TABLECLOSER>));
    close(TABLECLOSER);
  }
  sysopen(NUM, "$AT::config{dir}/Data/num.txt", AT::O_RDONLY) || die "$!, stopped";
  flock(NUM, 2);
  my($num, $totalranks) = split(/\|/, <NUM>);
  close(NUM);
  sysopen(RANKS, "$AT::config{dir}/Data/ranks.txt", AT::O_RDONLY) || die "$!, stopped";
  flock(RANKS, 2);
  my @ranks = <RANKS>;
  close(RANKS);
  sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
  flock(INFO, 2);
  my @info = <INFO>;
  close(INFO);
  my %avg;
  my $listnum = int($totalranks / $AT::config{numlist}) + 1;
  my $done;
  my @oldranks;
  while ($listnum >= $done) {
    if ($AT::config{top}) { $tmpl::var{content} = "$tableheader_top\n"; }
    else { $tmpl::var{content} = "$tableheader\n"; }
    my $fuck = 1;
    my $minlist = $AT::config{numlist} * $done;
    my $maxlist = $AT::config{numlist} * ($done + 1) + 1;
    foreach my $line(@ranks) {
      chomp($line);
      ($tmpl::var{rank}, $Scripts::Rank::rankid, $tmpl::var{oldrank}) = split(/\|/, $line);
      foreach (@info) {
        chomp;
        ($tmpl::var{id}, $Scripts::Rank::url, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $Scripts::Rank::password, $tmpl::var{urlbanner}) = split(/\|/);
        $tmpl::var{url} = "$tmpl::var{list_url}/topsites.cgi?action=out\&amp\;id=$tmpl::var{id}";
        if ($Scripts::Rank::rankid eq $tmpl::var{id}) {
          sysopen(HITS,"$AT::config{dir}/Data/Members/$tmpl::var{id}.txt", AT::O_RDONLY) || die "$!, stopped";
          flock(HITS, 2);
          my @hits = <HITS>;
          close(HITS);
          my @unq_pv = split(/\|/, $hits[0]);
          $tmpl::var{avg_unq_pv} = ($unq_pv[0] + $unq_pv[1] + $unq_pv[2] + $unq_pv[3]) / 4;
          $tmpl::var{tod_unq_pv} = $unq_pv[0];
          my @tot_pv = split(/\|/, $hits[1]);
          $tmpl::var{avg_tot_pv} = ($tot_pv[0] + $tot_pv[1] + $tot_pv[2] + $tot_pv[3]) / 4;
          $tmpl::var{tod_tot_pv} = $tot_pv[0];
          my @unq_in = split(/\|/, $hits[2]);
          $tmpl::var{avg_unq_in} = ($unq_in[0] + $unq_in[1] + $unq_in[2] + $unq_in[3]) / 4;
          $tmpl::var{tod_unq_in} = $unq_in[0];
          my @tot_in = split(/\|/, $hits[3]);
          $tmpl::var{avg_tot_in} = ($tot_in[0] + $tot_in[1] + $tot_in[2] + $tot_in[3]) / 4;
          $tmpl::var{tod_tot_in} = $tot_in[0];
          my @unq_out = split(/\|/, $hits[4]);
          $tmpl::var{avg_unq_out} = ($unq_out[0] + $unq_out[1] + $unq_out[2] + $unq_out[3]) / 4;
          $tmpl::var{tod_unq_out} = $unq_out[0];
          my @tot_out = split(/\|/, $hits[5]);
          $tmpl::var{avg_tot_out} = ($tot_out[0] + $tot_out[1] + $tot_out[2] + $tot_out[3]) / 4;
          $tmpl::var{tod_tot_out} = $tot_out[0];
          my $avg = "avg_$AT::config{uniquetotal}";
          my $tod = "tod_$AT::config{uniquetotal}";
          $tmpl::var{avg} = $tmpl::var{$avg};
          $tmpl::var{tod} = $tmpl::var{$tod};
          if ($tmpl::var{rank} > $minlist && $tmpl::var{rank} < $maxlist) {
            ($tmpl::var{ratetot}, $tmpl::var{ratenum}) = split(/\|/, $hits[6]);
            if (!$tmpl::var{ratenum}) { $tmpl::var{avg_rate} = 0; }
            else {
              $tmpl::var{avg_rate} = $tmpl::var{ratetot} / $tmpl::var{ratenum};
              $tmpl::var{avg_rate} = int($tmpl::var{avg_rate} + .5);
            }
            if ($tmpl::var{oldrank} > $tmpl::var{rank}) { $tmpl::var{movement} = "$tmpl::var{templates_url}/up.png"; }
            elsif ($tmpl::var{oldrank} < $tmpl::var{rank}) { $tmpl::var{movement} = "$tmpl::var{templates_url}/down.png"; }
            else { $tmpl::var{movement} = "$tmpl::var{templates_url}/neutral.png"; }
            my $newtable;
            if ($fuck <= $AT::config{top}) { $newtable = $table_top; }
            else {$newtable = $table; }
            $newtable = &subs::regexvars($newtable);
            $tmpl::var{content} .= "$newtable\n";
            if ($fuck == $AT::config{top}) { $tmpl::var{content} .= "$tablecloser_top\n$tableheader\n"; }
            foreach my $ad(@AT::adbreak) {
              if ($fuck == $ad) {
                sysopen(ADBREAK, "$AT::config{templates_dir}/adbreak.html", AT::O_RDONLY) || die "$!, stopped";
                flock(ADBREAK, 2);
                $tmpl::var{content} .= join('', <ADBREAK>);
                close(ADBREAK);
                last;
              }
            }
            $fuck++;
          }
          my $alreadyinoldranks;
          foreach (@oldranks) {
            my($avg_avg, $avg_id) = split(/\|/);
            if ($avg_id == $tmpl::var{id}) { $alreadyinoldranks = 1; last; }
          }
          if (!$alreadyinoldranks) { push(@oldranks, join('|', $tmpl::var{avg}, $tmpl::var{id})); }
        }
      }
    }
    $done++;
    if ($done == 1) { $done = ""; }
    $tmpl::var{content} .= "$tablecloser\n";
    open(FILE, ">$AT::config{rankings_dir}/$AT::config{rankings_filename}$done.$AT::config{rankings_ext}") || die "$!, stopped";
    flock(FILE, 2);
    chmod(0666, "$AT::config{rankings_dir}/$AT::config{rankings_filename}$done.$AT::config{rankings_ext}");
    print FILE &subs::template("NOPRINT");
    close(FILE);
    if (!$done) { $done = 1; }
  }
  my $num = 1;
  my @newranks;
  foreach (sort {$b <=> $a} @oldranks) {
    my($avg_avg, $avg_id) = split(/\|/);
    foreach my $line(@ranks) {
      my($rank, $rank_id, $oldrank) = split(/\|/, $line);
      if ($avg_id == $rank_id) {
        $new_line = join('|', $num, $avg_id, $oldrank) . "\n";
        push(@newranks, $new_line);
      }
    }
    $num++;
  }  
  open(RANKS,">$AT::config{dir}/Data/ranks.txt");
  flock(RANKS, 2);
  print RANKS @newranks;
  close(RANKS);
  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = (localtime(time + (3600*$timeoffset)));
  if (length($sec) <= 1) { $second = 0; $second .= $sec; }
  else { $second = "$sec"; }
  if (length($min) <= 1) { $minute = 0; $minute .= $min; }
  else { $minute = "$min"; }
  $last = "$hour:$minute:$second";
  open(LAST,">$AT::config{dir}/Data/last.txt") || die "$!, stopped";
  flock(LAST, 2);
  print LAST $last;
  close(LAST);
  undef $Scripts::Rank::refresh;
}
1;