package Scripts::Join;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Join                                                      #
# Module Desc: Lets visitors to your list join.                          #
# Module Group: Standard                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
$tmpl::var{header} = $tmpl::lng{'join_header'};
if (!$AT::form{url}) {
  sysopen(JOIN_FORM, "$AT::config{templates_dir}/join_form.html", AT::O_RDONLY) || die "$!, stopped";
  flock(JOIN_FORM, 2);
  $tmpl::var{content} .= &subs::regexvars(join('', <JOIN_FORM>));
  close(JOIN_FORM);
}
else {
  my($error_url, $error_email, $error_title, $error_password);
  unless ($AT::form{url} =~ /http/) { $error_url = 1; }
  unless ($AT::form{email} =~ /.+\@.+\.\w+/) { $error_email = 1; }
  unless ($AT::form{title}) { $error_title = 1; }
  unless ($AT::form{password}) { $error_password = 1; }
  if ($error_url || $error_email || $error_title || $error_password) {
    $tmpl::var{content} .= "$tmpl::lng{'join_error'}<br /><br />\n";
    $tmpl::var{content} .= "$tmpl::lng{'join_error_forgot'}<br />\n";
    if ($error_url) { $tmpl::var{content} .= "$tmpl::lng{'join_error_url'}<br />"; }
    if ($error_email) { $tmpl::var{content} .= "$tmpl::lng{'join_error_email'}<br />"; }
    if ($error_title) { $tmpl::var{content} .= "$tmpl::lng{'join_error_title'}<br />"; }
    if ($error_password) { $tmpl::var{content} .= "$tmpl::lng{'join_error_password'}<br />"; }
    $tmpl::var{content} .= "<br />$tmpl::lng{'join_error_back'}<br /><br />\n";
  }
  else {
    sysopen(NUM, "$AT::config{dir}/Data/num.txt", AT::O_RDONLY) || die "$!, stopped";
    flock(NUM, 2);
    ($tmpl::var{id}, $Scripts::Join::totalranks) = split(/\|/, <NUM>);
    close(NUM);
    $tmpl::var{id}++;
    $Scripts::Join::totalranks++;
    sysopen(NUM, "$AT::config{dir}/Data/num.txt", AT::O_WRONLY|AT::O_TRUNC) || die "$!, stopped";
    flock(NUM, 2);
    print NUM join('|', $tmpl::var{id}, $Scripts::Join::totalranks);
    close(NUM);
    $tmpl::var{url} = $AT::form{url};
    $tmpl::var{title} = $AT::form{title};
    $tmpl::var{description} = $AT::form{description};
    $tmpl::var{email} = $AT::form{email};
    $tmpl::var{password} = $AT::form{password};
    $tmpl::var{urlbanner} = $AT::form{urlbanner};
    if (!$tmpl::var{urlbanner} || $tmpl::var{urlbanner} eq "http://") { $tmpl::var{urlbanner} = $AT::config{defbanner}; }
    sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_WRONLY|AT::O_APPEND) || die "$!, stopped";
    flock(INFO, 2);
    print INFO join('|', $tmpl::var{id}, $tmpl::var{url}, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $tmpl::var{password}, $tmpl::var{urlbanner}) . "\n";
    close(INFO);
    sysopen(RANKS, "$AT::config{dir}/Data/ranks.txt", AT::O_WRONLY|AT::O_APPEND) || die "$!, stopped";
    flock(RANKS, 2);
    print RANKS join('|', $Scripts::Join::totalranks, $tmpl::var{id}, $Scripts::Join::totalranks) . "\n";
    close(RANKS);
    sysopen(HITS, "$AT::config{dir}/Data/Members/$tmpl::var{id}.txt", AT::O_WRONLY|AT::O_CREAT) || die "$!, stopped";
    chmod(0666, "$AT::config{dir}/Data/Members/$tmpl::var{id}.txt") || die "$!, stopped";
    flock(HITS, 2);
    print HITS join('|', 0, 0, 0, 0) . "\n";
    print HITS join('|', 0, 0, 0, 0) . "\n";
    print HITS join('|', 0, 0, 0, 0) . "\n";
    print HITS join('|', 0, 0, 0, 0) . "\n";
    print HITS join('|', 0, 0, 0, 0) . "\n";
    print HITS join('|', 0, 0, 0, 0) . "\n";
    print HITS join('|', 0, 0);
    close(HITS);
    sysopen(REVIEWS, "$AT::config{dir}/Data/Members/$tmpl::var{id}reviews.txt", AT::O_WRONLY|AT::O_CREAT) || die "$!, stopped";
    chmod(0666, "$AT::config{dir}/Data/Members/$tmpl::var{id}reviews.txt") || die "$!, stopped";
    close(HITS);
    open(WELCOME, "$AT::config{templates_dir}/welcome.html") || die "$!, stopped";
    my @welcomes = <WELCOME>;
    close(WELCOME);
    my $subject = shift(@welcomes);
    $subject =~ s/Subject\: //i;
    my $welcome = join('', @welcomes);
    $subject = &subs::regexvars($subject);
    $welcome = &subs::regexvars($welcome);
    &subs::email($tmpl::var{email}, $AT::config{youremail}, $subject, $welcome);
    sysopen(JOIN_FINISH, "$AT::config{templates_dir}/join_finish.html", AT::O_RDONLY) || die "$!, stopped";
    flock(JOIN_FINISH, 2);
    $tmpl::var{content} .= &subs::regexvars(join('', <JOIN_FINISH>));
    close(JOIN_FINISH);
  }
}
&subs::template;
1;