package Scripts::Graph;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Graph                                                     #
# Module Desc: Makes the bar graph for the member's given stat.          #
# Module Group: Standard                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
$tmpl::var{header} = $tmpl::lng{'graph_header'};
sysopen(HITS, "$AT::config{dir}/Data/Members/$AT::form{id}.txt", AT::O_RDONLY) || die "$!, stopped";
flock(HITS, 2);
my @hits = <HITS>;
close(HITS);
($tmpl::var{tod_unq_pv}, $tmpl::var{'1_unq_pv'}, $tmpl::var{'2_unq_pv'}, $tmpl::var{'3_unq_pv'}) = split(/\|/, $hits[0]);
$tmpl::var{avg_unq_pv} = ($tmpl::var{tod_unq_pv} + $tmpl::var{'1_unq_pv'} + $tmpl::var{'2_unq_pv'} + $tmpl::var{'3_unq_pv'}) / 4;
($tmpl::var{tod_tot_pv}, $tmpl::var{'1_tot_pv'}, $tmpl::var{'2_tot_pv'}, $tmpl::var{'3_tot_pv'}) = split(/\|/, $hits[1]);
$tmpl::var{avg_tot_pv} = ($tmpl::var{tod_tot_pv} + $tmpl::var{'1_tot_pv'} + $tmpl::var{'2_tot_pv'} + $tmpl::var{'3_tot_pv'}) / 4;
($tmpl::var{tod_unq_in}, $tmpl::var{'1_unq_in'}, $tmpl::var{'2_unq_in'}, $tmpl::var{'3_unq_in'}) = split(/\|/, $hits[2]);
$tmpl::var{avg_unq_in} = ($tmpl::var{tod_unq_in} + $tmpl::var{'1_unq_in'} + $tmpl::var{'2_unq_in'} + $tmpl::var{'3_unq_in'}) / 4;
($tmpl::var{tod_tot_in}, $tmpl::var{'1_tot_in'}, $tmpl::var{'2_tot_in'}, $tmpl::var{'3_tot_in'}) = split(/\|/, $hits[3]);
$tmpl::var{avg_tot_in} = ($tmpl::var{tod_tot_in} + $tmpl::var{'1_tot_in'} + $tmpl::var{'2_tot_in'} + $tmpl::var{'3_tot_in'}) / 4;
($tmpl::var{tod_unq_out}, $tmpl::var{'1_unq_out'}, $tmpl::var{'2_unq_out'}, $tmpl::var{'3_unq_out'}) = split(/\|/, $hits[4]);
$tmpl::var{avg_unq_out} = ($tmpl::var{tod_unq_out} + $tmpl::var{'1_unq_out'} + $tmpl::var{'2_unq_out'} + $tmpl::var{'3_unq_out'}) / 4;
($tmpl::var{tod_tot_out}, $tmpl::var{'1_tot_out'}, $tmpl::var{'2_tot_out'}, $tmpl::var{'3_tot_out'}) = split(/\|/, $hits[5]);
$tmpl::var{avg_tot_out} = ($tmpl::var{tod_tot_out} + $tmpl::var{'1_tot_out'} + $tmpl::var{'2_tot_out'} + $tmpl::var{'3_tot_out'}) / 4;
sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
flock(INFO, 2);
my @info = <INFO>;
close(INFO);
foreach (@info) {
  ($tmpl::var{id}, $tmpl::var{url}, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $Scripts::Stats::password, $tmpl::var{urlbanner}) = split(/\|/);
  if ($tmpl::var{id} eq $AT::form{id}) { last; }
}
my $avg_graph = "avg_$AT::form{type}";
my $tod_graph = "tod_$AT::form{type}";
my $graph1 = "1_$AT::form{type}";
my $graph2 = "2_$AT::form{type}";
my $graph3 = "3_$AT::form{type}";
my $g_graph = "g_$AT::form{type}";
$tmpl::var{avg_graph} = $tmpl::var{$avg_graph};
$tmpl::var{tod_graph} = $tmpl::var{$tod_graph};
$tmpl::var{'1_graph'} = $tmpl::var{$graph1};
$tmpl::var{'2_graph'} = $tmpl::var{$graph2};
$tmpl::var{'3_graph'} = $tmpl::var{$graph3};
$tmpl::var{graph} = $tmpl::lng{$g_graph};
my($numnum, $numnum2, $number);
if ($tmpl::var{tod_graph} > $tmpl::var{avg_graph}) { $numnum = $tmpl::var{tod_graph}; }
else { $number = $tmpl::var{avg_graph}; }
if ($tmpl::var{'2_graph'} > $tmpl::var{'3_graph'}) { $numnum2 = $tmpl::var{'2_graph'}; }
else { $numnum2 = $tmpl::var{'3_graph'}; }
if ($numnum > $numnum2) { $number = $numnum; }
else { $number = $numnum2; }
if ($number) { $number = 275 / $number; }
$tmpl::var{avg_num} = $tmpl::var{avg_graph} * $number;
$tmpl::var{tod_num} = $tmpl::var{tod_graph} * $number;
$tmpl::var{'1_num'} = $tmpl::var{'1_graph'} * $number;
$tmpl::var{'2_num'} = $tmpl::var{'2_graph'} * $number;
$tmpl::var{'3_num'} = $tmpl::var{'3_graph'} * $number;
sysopen(GRAPH,"$AT::config{templates_dir}/graph.html", AT::O_RDONLY) || die "$!, stopped";
flock(GRAPH, 2);
print "Content-type: text/html\n\n" . &subs::regexvars(join('', <GRAPH>));
close(GRAPH);
1;