package Scripts::Edit;
##########################################################################
# Aardvark Topsites  3.2.0                                               #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Edit Member Info                                          #
# Module Desc: Lets members log in and edit their info.                  #
# Module Group: Standard                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
$tmpl::var{header} = $tmpl::lng{'edit_header'};
if (!$AT::form{do}) {
  sysopen(EDIT_FORM, "$AT::config{templates_dir}/edit_form.html", AT::O_RDONLY) || die "$!, stopped";
  flock(EDIT_FORM, 2);
  $tmpl::var{content} .= &subs::regexvars(join('', <EDIT_FORM>));
  close(EDIT_FORM);
}
elsif ($AT::form{do} eq "form") {
  sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
  flock(INFO, 2);
  my @info = <INFO>;
  close(INFO);
  foreach (@info) {
    chomp;
    ($tmpl::var{id}, $tmpl::var{url}, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $Scripts::Edit::password, $tmpl::var{urlbanner}) = split(/\|/);
    if ($tmpl::var{id} eq $AT::form{id}) {
      if ($AT::form{pw} eq $Scripts::Edit::password) {
        sysopen(EDIT_FORM2, "$AT::config{templates_dir}/edit_form2.html", AT::O_RDONLY) || die "$!, stopped";
        flock(EDIT_FORM2, 2);
        $tmpl::var{content} .= &subs::regexvars(join('', <EDIT_FORM2>));
        close(EDIT_FORM2);
      }
      else { $tmpl::var{content} .= "$tmpl::lng{'edit_error'}<br /><br />\n$tmpl::lng{'edit_error_id_password'}<br /><br />\n"; }
      last;
    }
  }
}
elsif ($AT::form{do} eq "submit") {
  my($error_url, $error_email, $error_title, $error_password);
  unless ($AT::form{url} =~ /http/) { $error_url = 1; }
  unless ($AT::form{email} =~ /.+\@.+\.\w+/) { $error_email = 1; }
  unless ($AT::form{title}) { $error_title = 1; }
  unless ($AT::form{password}) { $error_password = 1; }
  if ($error_url || $error_email || $error_title || $error_password) {
    $tmpl::var{content} .= "$tmpl::lng{'edit_error'}<br /><br />\n";
    $tmpl::var{content} .= "$tmpl::lng{'edit_error_forgot'}<br />\n";
    if ($error_url) { $tmpl::var{content} .= "$tmpl::lng{'edit_error_url'}<br />"; }
    if ($error_email) { $tmpl::var{content} .= "$tmpl::lng{'edit_error_email'}<br />"; }
    if ($error_title) { $tmpl::var{content} .= "$tmpl::lng{'edit_error_title'}<br />"; }
    if ($error_password) { $tmpl::var{content} .= "$tmpl::lng{'edit_error_password'}<br />"; }
    $tmpl::var{content} .= "<br />$tmpl::lng{'edit_error_back'}<br /><br />\n";
  }
  else {
    sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
    flock(INFO, 2);
    my @info = <INFO>;
    close(INFO);
    $tmpl::var{url} = $AT::form{url};
    $tmpl::var{title} = $AT::form{title};
    $tmpl::var{description} = $AT::form{description};
    $tmpl::var{email} = $AT::form{email};
    $tmpl::var{password} = $AT::form{password};
    $tmpl::var{urlbanner} = $AT::form{urlbanner};
    my $done = 0;
    foreach (@info) {
      ($tmpl::var{id}, $tmpl::var{url2}, $tmpl::var{title2}, $tmpl::var{description2}, $tmpl::var{email2}, $Scripts::Edit::password, $tmpl::var{urlbanner2}) = split(/\|/);
      if ($tmpl::var{id} eq $AT::form{id}) {
        if ($tmpl::var{password} eq $Scripts::Edit::password) {
          if ($AT::form{urlbanner} eq "" || $AT::form{urlbanner} eq "http://") { $AT::form{urlbanner} = $AT::config{defbanner}; }
          sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_WRONLY|AT::O_TRUNC) || die "$!, stopped";
          flock(INFO, 2);
          foreach my $line(@info) {
            chomp($line);
            my($id, $url, $title, $description, $email, $password, $urlbanner) = split(/\|/, $line);
            if ($id eq $tmpl::var{id}) {
              my $newinfo = join('|', $tmpl::var{id}, $tmpl::var{url}, $tmpl::var{title}, $tmpl::var{description}, $tmpl::var{email}, $tmpl::var{password}, $tmpl::var{urlbanner});
              print INFO "$newinfo\n";
              $tmpl::var{content} .= "$tmpl::lng{'edit_success'}<br /><br />\n";
              $tmpl::var{content} .= "$tmpl::lng{'edit_info_edited'}<br /><br />\n";
              $done = 1;
            }
            else { print INFO "$line\n"; }
          }
          close(INFO);
        }
        last;
      }
    }
    if (!$done) { $tmpl::var{content} .= "$tmpl::lng{'edit_error'}<br /><br />\n$tmpl::lng{'edit_error_id_password'}<br /><br />\n"; }
  }
}
&subs::template;
1;