package Scripts::Date;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Date                                                      #
# Module Desc: Automaticly run daily to reset the daily stats.           #
# Module Group: Required                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
if ($Scripts::Date::date != $Scripts::Date::dcheck) {
  sysopen(DATE, "$AT::config{dir}/Data/date.txt", AT::O_WRONLY|AT::O_TRUNC) || die "$AT::config{dir}/Data/date.txt\n\n$!, stopped";
  flock(DATE, 2);
  print DATE $Scripts::Date::dcheck;
  close(DATE);
  sysopen(NUM, "$AT::config{dir}/Data/num.txt", AT::O_RDONLY) || die "$!, stopped";
  flock(NUM, 2);
  my($bignum, $totalranks) = split(/\|/, <NUM>);
  close(NUM);
  my $num = 1;
  while ($bignum >= $num) {
    sysopen(HITS, "$AT::config{dir}/Data/Members/$num.txt", AT::O_RDWR) || die "$!, stopped";
    flock(HITS, 2);
    my @date_num = <HITS>;
    truncate(HITS, 0);
    seek(HITS, 0, 0);
    my $datenumnum = 0;
    while ($datenumnum <= 5) {
      chomp;
      @dateline = split(/\|/, $date_num[$datenumnum]);
      unshift(@dateline, 0);
      pop(@dateline);
      $date_num[$datenumnum] = join('|', @dateline) . "\n";
      $datenumnum++;
    }
    print HITS @date_num;
    close(HITS);
    $num++;
  }
  sysopen(RANKS, "$AT::config{dir}/Data/ranks.txt", AT::O_RDWR) || die "$AT::config{dir}/Data/date.txt\n\n$!, stopped";
  flock(RANKS, 2);
  my @ranks = <RANKS>;
  truncate(RANKS, 0);
  seek(RANKS, 0, 0);
  foreach (@ranks) {
    my($rank, $rank_id, $oldrank) = split(/\|/);
    print RANKS join('|', $rank, $rank_id, $rank) . "\n";
  }
  close(RANKS);
}
1;