package Scripts::Button;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Button                                                    #
# Module Desc: Counts pageviews and displays the topsites button.        #
# Module Group: Standard                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
my $button_num = "blank";
if ($AT::form{id}) {
  sysopen(HITS, "$AT::config{dir}/Data/Members/$AT::form{id}.txt", AT::O_RDWR) || die "$!, stopped";
  flock(HITS, 2);
  my @hits = <HITS>;
  truncate(HITS, 0);
  seek(HITS, 0, 0);
  my($hits_today_r1, $hits_1_r1, $hits_2_r1, $hits_3_r1) = split(/\|/, $hits[1]);
  $hits_today_r1++;
  $hits[1] = join('|', $hits_today_r1, $hits_1_r1, $hits_2_r1, $hits_3_r1);
  my $cookiename = "aardvark_pv_$AT::form{id}_$AT::config{list_url}";
  if (!$AT::cgi->cookie($cookiename)) {
    my $cookie = $AT::cgi->cookie(	-name=>$cookiename,
			     		-value=>'1',
			     		-expires=>'+10h');
    print "Set-Cookie: $cookie\n";
    my($hits_today_r0, $hits_1_r0, $hits_2_r0, $hits_3_r0) = split(/\|/, $hits[0]);
    $hits_today_r0++;
    $hits[0] = join('|', $hits_today_r0, $hits_1_r0, $hits_2_r0, $hits_3_r0);
  }
  print HITS @hits;
  close(HITS);
  sysopen(RANKS, "$AT::config{dir}/Data/ranks.txt", AT::O_RDONLY) || die "$!, stopped";
  flock(RANKS, 2);
  foreach (<RANKS>) {
    chomp;
    my($rank, $rank_id, $oldrank) = split(/\|/);
    if ($AT::form{id} == $rank_id && $rank <= $AT::config{button_num}) { $button_num = $rank; last; }
  }
  close(RANKS);
}
print "Location: $AT::config{button_url}/$button_num.$AT::config{button_ext}\n\n";
1;