package Scripts::Admin;
##########################################################################
# Aardvark Topsites 3.2.0                                                #
# Copyright (c) 2000-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# Module Name: Admin                                                     #
# Module Desc: Admin area for your list.                                 #
# Module Group: Standard                                                 #
# Module Author: Jeremy Scheff - webmaster@aardvarkind.com               #
# Module Version: 3.2.0                                                  #
# Last Modified: 2002-06-30                                              #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
my $cookiepw = $AT::cgi->cookie('atapw');
if ($cookiepw eq $AT::config{password}) {
  if ($AT::form{page} eq "delete") { &delete; }
  elsif ($AT::form{page} eq "edit") { &edit; }
  elsif ($AT::form{page} eq "email") { &email; }
  elsif ($AT::form{page} eq "find") { &find; }
  elsif ($AT::form{page} eq "logout") { &logout; }
  elsif ($AT::form{page} eq "settings") { &settings; }
  elsif ($AT::form{page} eq "version") { &version; }
  else { &main; }
}
else { &login; }
&subs::template;

###############
# SUBROUTINES #
###############

sub countrows {
  my $totalranks = 0;
  sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
  flock(INFO, 2);
  while (sysread(INFO, $buffer, 4096)) {
      $totalranks += ($buffer =~ tr/\n//);
  }
  close(INFO);
  sysopen(NUM, "$AT::config{dir}/Data/num.txt", AT::O_RDONLY) || die "$!, stopped";
  flock(NUM, 2);
  my($num, $totalranks2) = split(/\|/, <NUM>);
  close(NUM);
  sysopen(NUM, "$AT::config{dir}/Data/num.txt", AT::O_WRONLY|AT::O_TRUNC) || die "$!, stopped";
  flock(NUM, 2);
  print NUM "$num\|$totalranks";
  close(NUM);
}
sub delete {
  if ($AT::form{id}) {
    sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
    flock(INFO, 2);
    my @info = <INFO>;
    close(INFO);
    sysopen(RANKS, "$AT::config{dir}/Data/ranks.txt", AT::O_RDONLY) || die "$!, stopped";
    flock(INFO, 2);
    my @ranks = <RANKS>;
    close(RANKS);
    sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_WRONLY|AT::O_TRUNC) || die "$!, stopped";
    flock(INFO, 2);
    foreach (@info) {
      my($id, $url, $title, $description, $email, $password, $urlbanner) = split(/\|/);
      if ($id != $AT::form{id}) { print INFO $_; }
    }
    close(INFO);
    sysopen(RANKS, "$AT::config{dir}/Data/ranks.txt", AT::O_WRONLY|AT::O_TRUNC) || die "$!, stopped";
    flock(RANKS, 2);
    foreach (@ranks) {
      my($rank, $id, $oldrank) = split(/\|/);
      if ($id != $AT::form{id}) { print RANKS $_; }
    }
    close(RANKS);
    $tmpl::var{content} .= "$tmpl::lng{'a_del_mems'}<br /><br />";
    &countrows;
  }
  else {
    $tmpl::var{content} = <<EndHTML;
<form action="topsites.cgi" method="post">
<input name="action" type="hidden" value="admin" />
<input name="page" type="hidden" value="delete" />
<b>$tmpl::lng{'a_del_mem'}</b><br />
$tmpl::lng{'g_id'}: <input name="id" type="text" size="7" class="form" /><br />
<input type="submit" value="$tmpl::lng{'g_form_submit_long'}" class="form" />
</form>
EndHTML
  }
}
sub edit {
  if (!$AT::form{do}) {
    $tmpl::var{content} = <<EndHTML;
<form action="topsites.cgi" method="get">
<input name="action" type="hidden" value="admin" />
<input name="page" type="hidden" value="edit" />
<input name="do" type="hidden" value="form" />
$tmpl::lng{'g_id'}: <input name="id" type="text" size="7" class="form" /><br />
<input type="submit" value="$tmpl::lng{'g_form_submit_long'}" class="form" />
</form>
EndHTML
  }
  elsif ($AT::form{do} eq "form") {
    my $yes;
    sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
    flock(INFO, 2);
    my @info = <INFO>;
    close(INFO);
    foreach (@info) {
      chomp;
      my($id, $url, $title, $description, $email, $password, $urlbanner) = split(/\|/);
      if ($id eq $AT::form{id}) {
        $tmpl::var{content} .= <<EndHTML;
<form action="topsites.cgi" method="post">
<input name="action" type="hidden" value="admin" />
<input name="page" type="hidden" value="edit" />
<input name="do" type="hidden" value="submit" />
<input name="id" type="hidden" value="$id" />
<table><tr><td>
$tmpl::lng{'g_id'}
</td><td>
$id
</td></tr><tr><td>
$tmpl::lng{'g_url'}
</td><td>
<input name="url" type="text" size="50" value="$url" class="form" />
</td></tr><tr><td>
$tmpl::lng{'g_title'}
</td><td>
<input name="title" type="text" size="50" value="$title" class="form" />
</td></tr><tr><td>
$tmpl::lng{'g_description'}
</td><td>
<input name="description" type="text" size="50" value="$description" class="form" />
</td></tr><tr><td>
$tmpl::lng{'g_email'}
</td><td>
<input name="email" type="text" size="50" value="$email" class="form" />
</td></tr><tr><td>
$tmpl::lng{'g_bannerurl'}
</td><td>
<input name="urlbanner" type="text" size="50" value="$urlbanner" class="form" />
</td></tr><tr><td>
$tmpl::lng{'g_password'}
</td><td>
<input name="password" type="text" size="50" value="$password" class="form" />
</td></tr><tr><td colspan="2" align="center">
<input type="submit" value="$tmpl::lng{'g_form_submit_long'}" class="form" />
</td></tr></table>
</form>
EndHTML
        $yes = 1;
        last;
      }
    }
    if (!$yes) { $tmpl::var{content} .= "$yes<br />$tmpl::lng{'a_edit_error_id'}<br /><br />"; }
  }
  elsif ($AT::form{do} eq "submit") {
    my($error_url, $error_email, $error_title, $error_password);
    unless ($AT::form{url} =~ /http/) { $error_url = 1; }
    unless ($AT::form{email} =~ /.+\@.+\.\w+/) { $error_email = 1; }
    unless ($AT::form{title}) { $error_title = 1; }
    unless ($AT::form{password}) { $error_password = 1; }
    if ($error_url || $error_email || $error_title || $error_password) {
      $tmpl::var{content} .= "$tmpl::lng{'a_edit_error'}<br /><br />\n";
      $tmpl::var{content} .= "$tmpl::lng{'a_edit_error_forgot'}<br />\n";
      if ($error_url) { $tmpl::var{content} .= "$tmpl::lng{'a_edit_error_url'}<br />"; }
      if ($error_email) { $tmpl::var{content} .= "$tmpl::lng{'a_edit_error_email'}<br />"; }
      if ($error_title) { $tmpl::var{content} .= "$tmpl::lng{'a_edit_error_title'}<br />"; }
      if ($error_password) { $tmpl::var{content} .= "$tmpl::lng{'a_edit_error_password'}<br />"; }
      $tmpl::var{content} .= "<br />$tmpl::lng{'a_edit_error_back'}<br /><br />\n";
    }
    else {
      sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
      flock(INFO, 2);
      my @info = <INFO>;
      close(INFO);
      my $id = $AT::form{id};
      my $url = $AT::form{url};
      my $title = $AT::form{title};
      my $description = $AT::form{description};
      my $email = $AT::form{email};
      my $password = $AT::form{password};
      my $urlbanner = $AT::form{urlbanner};
      my $done = 0;
      foreach (@info) {
        my($id2, $url2, $title2, $description2, $email2, $password2, $urlbanner2) = split(/\|/);
        if ($id2 == $id) {
          if ($urlbanner eq "" || $urlbanner eq "http://") { $urlbanner = $AT::config{defbanner}; }
          sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_WRONLY|AT::O_TRUNC) || die "$!, stopped";
          flock(INFO, 2);
          foreach my $line(@info) {
            chomp($line);
            my($id3, $url3, $title3, $description3, $email3, $password3, $urlbanner3) = split(/\|/, $line);
            if ($id3 == $id) {
              print INFO join('|', $id, $url, $title, $description, $email, $password, $urlbanner) . "\n";
              $tmpl::var{content} .= "$tmpl::lng{'a_edit_success'}<br /><br />\n";
              $tmpl::var{content} .= "$tmpl::lng{'a_edit_info_edited'}<br /><br />\n";
              $done = 1;
            }
            else { print INFO "$line\n"; }
          }
          close(INFO);
        }
      }
      if (!$done) { $tmpl::var{content} .= "$tmpl::lng{'a_edit_error'}<br /><br />\n$tmpl::lng{'a_edit_error_id'}<br /><br />\n"; }
    }
  }
}
sub email {
  sysopen(INFO, "$AT::config{dir}/Data/info.cgi", AT::O_RDONLY) || die "$!, stopped";
  flock(INFO, 2);
  my @info = <INFO>;
  close(INFO);
  my $emails;
  foreach (@info) {
    my($id, $url, $title, $description, $email, $password, $urlbanner) = split(/\|/);
    unless ($emails) { $emails = $email; }
    else { $emails .= ", $email"; }
  }
  $tmpl::var{content} .= "$tmpl::lng{'a_email_addresses'}<br /><br />\n$emails<br /><br />";
}
sub find {
  $tmpl::var{content} .= "$tmpl::lng{'a_find_find'}<br /><br />";
}
sub login {
  if ($AT::form{pass} eq $AT::config{password}) {
    print "Set-Cookie: atapw=$AT::form{pass}\;\n";
    $tmpl::var{content} = "$tmpl::lng{'a_login'}<br /><br />\n";
    $tmpl::var{content} .= "<a href=\"topsites.cgi?action=admin\&amp\;page=main\"><b>$tmpl::lng{'a_login_enter'}</b></a><br /><br />";
  }
  elsif ($AT::form{pass}) { $tmpl::var{content} = "$tmpl::lng{'a_login_invalidpw'}<br /><br />"; }
  else {
    $tmpl::var{content} = <<EndHTML;
$tmpl::lng{'a_login_when'}<br /><br />
<form action="topsites.cgi" method="post">
<input name="action" type="hidden" value="admin" />
<input name="language" type="hidden" value="$tmpl::var{language}" />
$tmpl::lng{'g_password'}: <input name="pass" type="password" size="20" class="form" /><br />
<input type="submit" value="$tmpl::lng{'g_form_submit_long'}" class="form" />
</form>
EndHTML
  }
}
sub logout {
  print "Set-Cookie: atapw=delete\; expires=Thu, 01-Jan-1970 00:00:00 GMT\;\n";
  $tmpl::var{content} = "$tmpl::lng{'a_logout'}<br /><br />";
}
sub main {
  $tmpl::var{content} = "$tmpl::lng{'a_main'}";
}
sub settings {
  unless ($AT::form{deflanguage}) {
    my($languages, $uniquetotals, $gateways, $searchs);
    opendir(LANGUAGES, "$AT::config{dir}/Modules/Languages");
    my @languagesa = grep(!/^\./, readdir(LANGUAGES));
    closedir(LANGUAGES);
    foreach my $line(@languagesa) {
      my @whatever = split(/\./, $line);
      if ($whatever[0] eq $tmpl::var{language}) { $languages .= "<option value=\"$whatever[0]\" selected=\"selected\">$whatever[0]\n"; }
      else { $languages .= "<option value=\"$whatever[0]\">$whatever[0]\n"; }
    }
    my @uniquetotala = ('unq_pv','tot_pv','unq_in','tot_in');
    foreach (@uniquetotala) {
      my $lng = "g_$_";
      if ($_ eq $AT::config{uniquetotal}) { $uniquetotals .= "<option value=\"$_\" selected=\"selected\">$tmpl::lng{$lng}\n"; }
      else { $uniquetotals .= "<option value=\"$_\">$tmpl::lng{$lng}\n"; }
    }
    if ($AT::config{gateway}) { $gateways = "<option value=\"1\" selected=\"selected\">$tmpl::lng{'a_s_on'}\n<option value=\"0\">$tmpl::lng{'a_s_off'}"; }
    else { $gateways = "<option value=\"1\">$tmpl::lng{'a_s_on'}\n<option value=\"0\" selected=\"selected\">$tmpl::lng{'a_s_off'}"; }
    if ($AT::config{search}) { $searchs = "<option value=\"1\" selected=\"selected\">$tmpl::lng{'a_s_on'}\n<option value=\"0\">$tmpl::lng{'a_s_off'}"; }
    else { $searchs = "<option value=\"1\">$tmpl::lng{'a_s_on'}\n<option value=\"0\" selected=\"selected\">$tmpl::lng{'a_s_off'}"; }
    my $adbreak = join(',', @AT::adbreak);
    $tmpl::var{content} = <<EndHTML;
<table cellspacing="0" cellpadding="0"><tr><td>
<form action="topsites.cgi" method="post">
<input name="action" type="hidden" value="admin" />
<input name="page" type="hidden" value="settings" />
<b>$tmpl::lng{'a_s_general'}</b><br /><br />
$tmpl::lng{'a_s_list_name'}<br />
<input name="list_name" type="text" size="50" class="form" value="$tmpl::var{list_name}" /><br /><br />
$tmpl::lng{'a_s_deflanguage'}<br />
<select name="deflanguage" class="form">
$languages</select><br /><br />
$tmpl::lng{'a_s_dir'}<br />
<input name="dir" type="text" size="50" class="form" value="$AT::config{dir}" /><br /><br />
$tmpl::lng{'a_s_list_url'}<br />
<input name="list_url" type="text" size="50" class="form" value="$AT::config{list_url}" /><br /><br />
$tmpl::lng{'a_s_templates_dir'}<br />
$tmpl::lng{'a_s_rankings_dir_warning'}<br />
<input name="templates_dir" type="text" size="50" class="form" value="$AT::config{templates_dir}" /><br /><br />
$tmpl::lng{'a_s_templates_url'}<br />
$tmpl::lng{'a_s_rankings_dir_warning'}<br />
<input name="templates_url" type="text" size="50" class="form" value="$AT::config{templates_url}" /><br /><br />
$tmpl::lng{'a_s_youremail'}<br />
<input name="youremail" type="text" size="50" class="form" value="$AT::config{youremail}" /><br /><br /><br /><br />

<b>$tmpl::lng{'a_s_ranking'}</b><br /><br />
$tmpl::lng{'a_s_numlist'}<br />
<input name="numlist" type="text" size="7" class="form" value="$AT::config{numlist}" /><br /><br />
$tmpl::lng{'a_s_rankings_dir'}<br />
$tmpl::lng{'a_s_rankings_dir_warning'}<br />
$tmpl::lng{'a_s_rankings_dir_chmod'}<br />
<input name="rankings_dir" type="text" size="50" class="form" value="$AT::config{rankings_dir}" /><br /><br />
$tmpl::lng{'a_s_rankings_url'}<br />
$tmpl::lng{'a_s_rankings_dir_warning'}<br />
$tmpl::lng{'a_s_rankings_dir_chmod'}<br />
<input name="rankings_url" type="text" size="50" class="form" value="$AT::config{rankings_url}" /><br /><br />
$tmpl::lng{'a_s_rankings_filename'}<br />
<input name="rankings_filename" type="text" size="20" class="form" value="$AT::config{rankings_filename}" /><br /><br />
$tmpl::lng{'a_s_rankings_ext'}<br />
<input name="rankings_ext" type="text" size="10" class="form" value="$AT::config{rankings_ext}" /><br /><br />
$tmpl::lng{'a_s_refresh'}<br />
<input name="refresh" type="text" size="10" class="form" value="$AT::config{refresh}" /><br /><br />
$tmpl::lng{'a_s_defbanner'}<br />
<input name="defbanner" type="text" size="50" class="form" value="$AT::config{defbanner}" /><br /><br />
$tmpl::lng{'a_s_uniquetotal'}<br />
<select name="uniquetotal" class="form">
$uniquetotals</select><br /><br />
$tmpl::lng{'a_s_top'}<br />
<input name="top" type="text" size="7" class="form" value="$AT::config{top}" /><br /><br />
$tmpl::lng{'a_s_adbreak'}<br />
<input name="adbreak" type="text" size="20" class="form" value="$adbreak" /><br /><br /><br /><br />

<b>$tmpl::lng{'a_s_button'}</b><br /><br />
$tmpl::lng{'a_s_button_url'}<br />
<input name="button_url" type="text" size="50" class="form" value="$AT::config{button_url}" /><br /><br />
$tmpl::lng{'a_s_button_ext'}<br />
<input name="button_ext" type="text" size="10" class="form" value="$AT::config{button_ext}" /><br /><br />
$tmpl::lng{'a_s_button_num'}<br />
<input name="button_num" type="text" size="7" class="form" value="$AT::config{button_num}" /><br /><br /><br /><br />

<b>$tmpl::lng{'a_s_other'}</b><br /><br />
$tmpl::lng{'a_s_mail'}<br />
<input name="mail" type="text" size="20" class="form" value="$AT::config{mail}" /><br /><br />
$tmpl::lng{'a_s_smtpserver'}<br />
<input name="smtpserver" type="text" size="20" class="form" value="$AT::config{smtpserver}" /><br /><br />
$tmpl::lng{'a_s_timeoffset'}<br />
<input name="timeoffset" type="text" size="20" class="form" value="$AT::config{timeoffset}" /><br /><br />
$tmpl::lng{'a_s_gateway'}<br />
<select name="gateway" class="form">
$gateways</select><br /><br />
$tmpl::lng{'a_s_search'}<br />
<select name="search" class="form">
$searchs</select><br /><br />
<input type="submit" value="$tmpl::lng{'g_form_submit_long'}" class="form" />
</form>
</td></tr></table>
EndHTML
  }
  else {
    my $config = <<EndHTML;
package AT;
\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#
\# Aardvark Topsites 3.2.0                                                \#
\# Copyright (c) 2000-2002 Aardvark Industries                            \#
\#                         http://www.aardvarkind.com/                    \#
\#                                                                        \#
\# Module Name: Config                                                    \#
\# Module Desc: Settings for the script.                                  \#
\# Module Group: Required                                                 \#
\# Module Author: Jeremy Scheff - webmaster\@aardvarkind.com               \#
\# Module Version: 3.2.0                                                  \#
\# Last Modified: 2002-06-10                                              \#
\#                                                                        \#
\# This program is free software; you can redistribute it and/or modify   \#
\# it under the terms of the GNU General Public License as published by   \#
\# the Free Software Foundation; either version 2 of the License, or (at  \#
\# your option) any later version.                                        \#
\#                                                                        \#
\# This program is distributed in the hope that it will be useful, but    \#
\# WITHOUT ANY WARRANTY; without even the implied warranty of             \#
\# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      \#
\# General Public License for more details.                               \#
\#                                                                        \#
\# You should have received a copy of the GNU General Public License      \#
\# with this program; if not, write to the Free Software Foundation,      \#
\# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.        \#
\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#
\$AT::config{password} = '$AT::config{password}';

\$tmpl::var{list_name} = '$AT::form{list_name}';
\$AT::config{deflanguage} = '$AT::form{deflanguage}';
\$AT::config{dir} = '$AT::form{dir}';
\$AT::config{list_url} = '$AT::form{list_url}';
\$tmpl::var{list_url} = \$AT::config{list_url};
\$AT::config{templates_dir} = '$AT::form{templates_dir}';
\$AT::config{templates_url} = '$AT::form{templates_url}';
\$tmpl::var{templates_url} = \$AT::config{templates_url};
\$AT::config{youremail} = '$AT::form{youremail}';

\$AT::config{numlist} = '$AT::form{numlist}';
\$AT::config{rankings_dir} = '$AT::form{rankings_dir}';
\$AT::config{rankings_url} = '$AT::form{rankings_url}';
\$AT::config{rankings_filename} = '$AT::form{rankings_filename}';
\$AT::config{rankings_ext} = '$AT::form{rankings_ext}';
\$AT::config{refresh} = '$AT::form{refresh}';
\$AT::config{defbanner} = '$AT::form{defbanner}';
\$AT::config{uniquetotal} = '$AT::form{uniquetotal}';
\$AT::config{top} = '$AT::form{top}';
\@AT::adbreak = ($AT::form{adbreak});

\$AT::config{button_url} = '$AT::form{button_url}';
\$tmpl::var{button_url} = \$AT::config{button_url};
\$AT::config{button_ext} = '$AT::form{button_ext}';
\$AT::config{button_num} = '$AT::form{button_num}';

\$AT::config{mail} = '$AT::form{mail}';
\$AT::config{smtpserver} = '$AT::form{smtpserver}';
\$AT::config{timeoffset} = '$AT::form{timeoffset}';
\$AT::config{gateway} = '$AT::form{gateway}';
\$AT::config{search} = '$AT::form{search}';

\$AT::config{version} = '$AT::config{version}';
\$tmpl::var{version} = \$AT::config{version};
1;
EndHTML
    open(CONFIG, ">$AT::config{dir}/config.cgi") || die "$!, stopped";
    flock(CONFIG, 2);
    print CONFIG $config;
    close(CONFIG);
    $tmpl::var{content} .= "$tmpl::lng{'a_s_updated'}<br /><br />\n";
  }
}
sub version {
  use LWP::Simple;
  my $lwpfile = get "http://www.aardvarkind.com/cgi/topsites/version.txt";
  my($version, $message) = split(/\n/,$lwpfile);
  if ($AT::config{version} == $version) { $tmpl::var{content} .= "$tmpl::lng{'a_version_using'}<br /><br />"; }
  else { $tmpl::var{content} .= "$tmpl::lng{'a_version_your'}: $AT::config{version}<br />$tmpl::lng{'a_version_latest'}: $version\n<br /><br />$tmpl::lng{'a_version_new'}<br /><br />\n$message\n"; }
}
1;