#!/usr/bin/perl
#############################################################################
#                                                                           #
# This copyright data applies to all source files                           #
#                                                                           #
# Rapid WebShell, Copyright (c) 2002 Steven Wishart, All Rights Reserved.   #
#                                                                           #
#      Module  : manage.cgi                                                 #
#        Type  : Perl Source file                                           #
# Description  : WebShell File Manager                                      #
#                                                                           #
# This software is provided `AS IS' and without any express or implied      #
# warranties, including, without limitation, the implied waranties of       #
# merchantabulity and fitness for a particular purpose.                     #
#                                                                           #
# Redistribution and use of source are permitted provided that:             #
#                                                                           #
# (1) source distributions may not be sold for profit on physical media     #
# such as disks, tapes, and CD-ROMS, without expressed written permission   #
# from the author.                                                          #
#                                                                           #
#############################################################################
require "cgi-lib.pl";
require "global.pl";

print &PrintHeader;

# Load Config
&LoadConfig;

&ReadParse(*input); 
	
	local(@Date) = &CDate3;

# Remove Spaces from Options
$input{Options} =~ s/\ //g;

# Don't print the BODY tag when previewing files
if("$input{'Preview'}" ne "Preview")
	{
print <<"ENDOFTEXT";
<body bgcolor="#0088BB" text="#000000" link="#0033CC" vlink="#0033CC" alink="#0088BB" topmargin="0" leftmargin="0" marginheight="0" marginwidth="0">
ENDOFTEXT
	}
@Files = split(/\0/, $input{'files'});
@htPasswd = split(/\0/, $input{'htpasswd'});

# Some browsers pass the whole path to the file, instead of just the filename, so it's a good idea to strip off
# everything that includes backslashes (Windows browsers) and forward slashes (Unix browsers) and which
# might appear before the filename:
#$input{Options} =~ s/.*[\/\\]/;

	# Delete Selected Files from List
	if("$input{'Function'}" eq "delete")
		{
		# Only delete if file has been selected
		if("$Files[0]" ne "")
			{
			for($i = 0; $i <= $#Files; $i++)
				{
				# Remove file(s)
				unlink("$RootDir/$input{currentDir}/$Files[$i]");
				}
			$Message = "File has been deleted @Files";
			}
		else
			{
			$Message = "Please select file to delete";
			}
		$Status = $TRUE;
		}
	# Create Directory
	elsif("$input{'Function'}" eq "createdir")
		{
		# Only if a Optional Parameter is given
		if("$input{Options}" ne "")
			{
		        # Remove '.' and '/' from Directory name	
			$input{DIR} =~ s/\.//g;
			$input{DIR} =~ s/^\///g;

		        # Make Directory with mode from config.pl
			mkdir("$RootDir/$input{'currentDir'}/$input{Options}", 0777);
			$Message = "$input{'currentDir'}/$input{Options}, $CHDIR_MODE";
			#$Message = "Directory ($input{Options}) has been created.";
			}
		else
			{
			$Message = "Please enter Directory name in Options Box";
			}
		$Status = $TRUE;
		}
	# Delete Selected Files from List
	elsif("$input{'Function'}" eq "deldir")
		{
		# Only delete if file has been selected
		if("$Files[0]" ne "")
			{
			for($i = 0; $i <= $#Files; $i++)
				{
				# Remove file(s)
				rmdir("$RootDir/$input{currentDir}/$Files[$i]");
				}
			$Message = "Directory has been deleted @Files";
			}
		else
			{
			$Message = "Please select file to delete";
			}
		$Status = $TRUE;
		}
	# Create Basic File
	elsif("$input{'Function'}" eq "createfile")
		{
		if("$input{Options}" ne "")
			{
			if("$input{Options}" !~ /\./g) 
				{
				$input{Options} = "$input{Options}.html";
				}
	        	open(File, ">$RootDir/$input{currentDir}/$input{Options}");	
			select(File);
			print "<html>\n";
			print "<head>\n";
			print "<title>Under construction</title>\n";
			print "<center><font color=blue size=4><b>Under construction</center></b>\n";
			print "</head>\n";
			print "<body bgcolor=white\n>";
			print "</body></html>\n";
			close(File);
			select(stdout);
			$Message = "File Created ($input{Options})";
			$Status = $TRUE;
                        }			
		}
	# Save File from Editing
	elsif(("$input{'Function'}" eq "savefile") && ("$input{Cancel}" ne "Cancel") && ("$input{Preview}" ne "Preview"))
		{
	       	open(File, ">$RootDir/$input{currentDir}/$input{saveFile}");	
		select(File);
		print "$input{fileedit}\n";
		close(File);
		select(stdout);
		$Message = "File Saved ($input{saveFile})";
		$Status = $TRUE;
		}
	# Edit File
	elsif("$input{'Function'}" eq "edit")
		{
		print "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=$Site/$BinDir/edit.cgi?currentDir=$input{currentDir}&File=$Files[0]&uid=$input{uid}&uidp=$input{uidp}\">";
		}
	# Preview WebPage from Editor
	elsif(("$input{'Preview'}" eq "Preview") && ("$input{Cancel}" ne "Cancel"))
		{
		print "$input{fileedit}";
		$Status = $FALSE;
		}
	# Page Save Cancelled
	elsif(("$input{Cancel}" eq "Cancel") || ("$input{Cancel}" eq "File Manager"))
		{
		$Status = $TRUE;
		$Message = "Action Cancelled";
		}
	# Rename File/Directory
	elsif("$input{'Function'}" eq "rename")
		{
		if("$input{Options}" ne "")
			{
				
			-e "$RootDir/$input{currentDir}/$input{Options}" || rename ("$RootDir/$input{currentDir}/$Files[0]", "$RootDir/$input{currentDir}/$input{Options}");
			&Syslog("$RootDir/$input{currentDir}/$Files[0], $RootDir/$input{currentDir}/$input{Options}");

			$Message = "Renamed $Files[0] to $input{Options}";
			$Status = $TRUE;
                        }			
		}
	# Locking Directory
	elsif("$input{'Function'}" eq "lockdir")
		{
		$Message =~ s/\ /\+/g;
		print "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=$Site/$BinDir/lockdir.cgi?currentDir=$input{currentDir}&Message=$Message&File=$Files[0]&uid=$input{uid}&uidp=$input{uidp}\">";
		}
	# Create Lock in Directory
	elsif(("$input{addlock}" eq "Add") && ("$input{lockname}" ne "") && ("$input{lockpassword}" ne "") && ("$input{Cancel}" ne "Cancel"))
		{
		# Call htpasswd to set password, create file if one does not exist
		if(! -r "$RootDir/$input{currentDir}/.htpasswd")
			{
			# Create new file if one does not exist
			system("htpasswd -cb $RootDir$input{currentDir}/.htpasswd $input{lockname} $input{lockpassword}");
			}	
		else
			{
			# Don't overwrite file if already exists, just append	
			system("htpasswd -b $RootDir$input{currentDir}/.htpasswd $input{lockname} $input{lockpassword}");
			}	

		if(! -r "$RootDir/$input{currentDir}/.htaccess")
			{
		       	open(File, ">$RootDir$input{currentDir}/.htaccess");	
			select(File);
			print "#\n";
			print "# .htaccess created by Rapid WebSHELL (http://www.myrapid.com) - @Date\n";
			print "#\n";
			print "Options All\n";
			print "AuthType \"Basic\"\n";
			print "AuthName \"Protected Access\"\n";
			print "AuthUserFile $RootDir$input{currentDir}/.htpasswd\n";
			print "<Limit GET>\n";
			print "require valid-user\n";
			print "</Limit>\n";
			close(File);		
			select(stdout);
			}

		$Message = "<font color=Red>User (<b><font color=green>$input{lockname}</font></b>) added to Password Sub System. Folder: (<font color=green>$input{currentDir}</font>)</font>";
		$Message =~ s/\ /\+/g;

		print "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=$Site/$BinDir/lockdir.cgi?currentDir=$input{currentDir}&Message=$Message&File=$Files[0]&uid=$input{uid}&uidp=$input{uidp}\">";
		}
	# Delete Users from htpasswd (lock) file
	elsif("$input{'deletelock'}" eq "Delete User(s)")
		{
		# Only delete if file has been selected
		if("$htPasswd[0]" ne "")
			{
			$x=0;	
			for($i = 0; $i <= $#htPasswd; $i++)
				{
				local(@Remember);
				# Copy all users into array which are NOT on the delete list
				if(open(File, "$RootDir$input{currentDir}/.htpasswd"))
					{
					while (($line = <File>) ne "")
		                        	{
						# if line not equal to users in userslist, remember them in array
	                                        if($line !~ /^$htPasswd[$i]:/i)
							{
							# Save to Remember Array
							@Remember[$x] = $line;
							$x++;
							}
						}
					close(File);
					#&Syslog("@Remember");
					# Once users are in array, write file back to disk
					if(open(File, ">$RootDir$input{currentDir}/.htpasswd"))
						{
						select(File);
						for($j = 0; $j < $x; $j++)
							{
							print "$Remember[$j]";
							}
						select(stdout);
						close(File);
						$j=0;
						}
					}
				}
			}
		select(stdout);
		if("$htPasswd[0]" ne "")
			{
			$Message = "User(s) (<font color=green>@htPasswd</font>) have been deleted from Password Sub System";
			}
		else
			{
			$Message = "<b><font color=green>No</font></b> users have been deleted";
			}
		$Message =~ s/\ /\+/g;
		print "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=$Site/$BinDir/lockdir.cgi?currentDir=$input{currentDir}&Message=$Message&File=$Files[0]&uid=$input{uid}&uidp=$input{uidp}\">";
		}
	else
		{
# Add + sign instead of space
$Message =~ s/\ /\+/g;
print "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=manager.cgi?DIR=$input{currentDir}&Message=$Message&uid=$input{uid}&uidp=$input{uidp}\">";
		}	

if($Status)
	{
	$Message =~ s/\ /\+/g;
	print "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=manager.cgi?DIR=$input{currentDir}&Message=$Message&uid=$input{uid}&uidp=$input{uidp}\">";
	}	

# Close the document cleanly.
  print &HtmlBot;
