#!/usr/bin/perl
#############################################################################
#                                                                           #
# This copyright data applies to all source files                           #
#                                                                           #
# Rapid WebShell, Copyright (c) 2002 Steven Wishart, All Rights Reserved.   #
#                                                                           #
#      Module  : manage.cgi                                                 #
#        Type  : Perl Source file                                           #
# Description  : WebShell File Manager                                      #
#                                                                           #
# This software is provided `AS IS' and without any express or implied      #
# warranties, including, without limitation, the implied waranties of       #
# merchantabulity and fitness for a particular purpose.                     #
#                                                                           #
# Redistribution and use of source are permitted provided that:             #
#                                                                           #
# (1) source distributions may not be sold for profit on physical media     #
# such as disks, tapes, and CD-ROMS, without expressed written permission   #
# from the author.                                                          #
#                                                                           #
#############################################################################
require "cgi-lib.pl";
require "global.pl";

print &PrintHeader;

#use strict; 
use File::stat; 	# Used for stat'ing a file
use POSIX qw(strftime); # Used for setting time and date
use Cwd;		# Get Working Directory Library

# Load Config into Memory
&LoadConfig;

&ReadParse(*input); 

# Do Parameter Check, make sure uid and uidp are passed else time out
	if(("$input{uid}" eq "") || ("$input{uidp}" eq ""))
		{
		&Syslog("Security Alert: UID or UIDP is blank, timing user out");
		print "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=$Site/$BinDir/timeout.cgi\">";
		break;
		}
	else
		{

	local (@User) = &Getpwinfouid("$input{uid}");

	# Check Password and UID match
	if("$input{uidp}" ne "$User[7]") 
		{
		&Syslog("Security Alert: Password does not match UID in File Manager - Possible Violation from User $User[3]");
		print "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=$Site/$BinDir/timeout.cgi\">";
		}
	else
		{

	chdir("$RootDir/$User[17]");

# To protect yourself

chroot("$RootDir/$User[17]");

# Set Directory, if Blank, set to current dir
if("$input{DIR}" eq "")
	{
	$input{DIR} = ".";
	}
else
	{
	# Remove '.' and '/' from DIR
	$input{DIR} =~ s/^\.//;
	#$input{DIR} =~ s/^\///;
	# Change Directory, make sure you put the rootdir in front, to avoid
	# any mischievious hacking
	$cwdtmp = cwd;
	#&Syslog("$RootDir/$User[17]/$input{DIR}");
	if("$input{DIR}" eq "/")
		{
		chdir("$RootDir/$User[17]");
		}
	else
		{
		chdir("$RootDir/$input{DIR}");
		}

        $Message = "Change Directory to $input{DIR}";
	}

# Set Message
if ("$input{'Message'}" eq "")
	{
	$input{'Message'} = "Welcome to Rapid Webshell v$Version";
	}

print <<"ENDOFTEXT";
<body bgcolor="#0088BB" text="#0088BB" link="#0033CC" vlink="#0033CC" alink="#0088BB" topmargin="0" leftmargin="0" marginheight="0" marginwidth="0">
<form action=$Site/$BinDir/webshell.cgi method=post>
ENDOFTEXT

# Open Curent Directory
opendir (HOMEDIR, ".");

# List files in directory which are READABLE ONLY, all file should be readable
# Ignore files starting it a period (.)
@files = grep (!/^\./, grep(-r, readdir(HOMEDIR)));

# Close Directory when finsihed reading
closedir(HOMEDIR);

print "<br><center><a href=http://www.wisharts.com target=_blank><img src=$Site/$ImageDir/webshelllogo.gif border=0></a></center>";
print "<br>";
print "<table border=0 cellpadding=3 cellspacing=0 width=100%><tr>";
print "<td bgcolor=#0066FF><font size=4 color=#ffffff face=\"arial,verdana,sans-serif\"><B>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;RAPID WEBSHELL</B></font></td><td align=right bgcolor=#0066FF><a href=$Site/$BinDir/login.cgi><img src=$Site/$ImageDir/logout.jpg border=0></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</tr><tr>";

print "<td bgcolor=#99ccff><font size=1 face=\"verdana, helvetica, arial\" color=#444444 face=\"arial,verdana,sans-serif\">&nbsp;&nbsp;&nbsp;Your homepage url is: <a href=$RootDirSite/$User[17]>$RootDirSite/$User[17]</a></font></td><td align=right bgcolor=#99ccff>&nbsp;</td>";
print "</tr></table></font>";

if("$input{showonce}" ne "1")
	{
	print "<table border=0 width=98%><tr>";
	print "<td><font color=white>You are logged in as <b>$User[1] $User[2]</b> (Login ID: <b>$User[3]</b> Logins: <b>$User[13])</b></td>";
	if("$User[8]" >= "$AdminLevel")
		{
		print "<td align=right><a href=$Site/$BinDir/Administration.cgi?uid=$input{uid}&uidp=$input{uidp}>Administration</a></td>";
		}
	print "<td align=right width=10% nowrap=\"\"><a href=$Site/$BinDir/ChangePasswordScreen.cgi?uid=$input{uid}&uidp=$input{uidp}>Change Password</a></td>";
	print "</tr></table>";
	}

print "<br><center>";

if(("$input{showonce}" eq "1") && ("$FortuneDisable" eq "N"))
	{
	print "<table border=0 width=80%><tr><td><font color=white><center><b><div align=left>Hello $User[1], Your Fortune for Today is:</div></b><br>";
	
	system("$Fortune");

	print "</center></tr></td></table></center>";
	}

print "<br><br><br>";
# Folder Directory Listing
# Get Current Working Directory
$cwdtmp = cwd;
# Split directory path in an array for removal of RootDir
@cwd = split(/\//, $cwdtmp);
# Put RootDir in Array for counting for below for statement
# You want to loop After main root dir, in order not to disclose your official path
@root = split(/\//, $RootDir);
print <<"ENDOFTEXT";
<center><table border=0 bgcolor=#ffffff cellpadding=5 cellspacing=0 width=90%><tr><td nowrap="">\n
<a href=$Site/$BinDir/manager.cgi?DIR=/&uid=$input{uid}&uidp=$input{uidp}><img src="$Site/$ImageDir/folderopen.gif" border=0>/</a>\n
<font color=blue>\n
ENDOFTEXT

# For loop to get rid of official Directory, so users will think
# / is there main directory, even though you might have it down several directory trees

for($i = $#root+1; $i <= $#cwd; $i++)
	{
	# Print Working Directory for Users
	# Add total path to $newtmp, this will keep the current Path where user is
	$newtmp = sprintf("$newtmp/%s", $cwd[$i]);

	# Add path in a href, so user can click on path to go back
	print "<a href=$Site/$BinDir/manager.cgi?DIR=$newtmp&uid=$input{uid}&uidp=$input{uidp}>$cwd[$i]</a> / \n";
	}

	# Put current path in hidden tag, to pass to webshell.cgi, so webshell
	# can use it to create directories etc in the correct path
	print "<INPUT type=\"hidden\" name=\"currentDir\" value=\"$newtmp\">\n";

	# If Directory has a password file, display Lock	
	if( -r "$RootDir$newtmp/.htpasswd")
		{
		print "<a href=$Site/$BinDir/webshell.cgi?currentDir=$newtmp&uid=$input{uid}&uidp=$input{uidp}&files=$file&Function=lockdir><img src=$Site/$ImageDir/lock.gif height=30 border=0 alt=\"$newtmp is Password Protected\"></a>";
		}

print <<"ENDOFTEXT";
</td><Td><table border="0" cellspacing="3" cellpadding="2" align=right>\n
<tr><td>&nbsp;</td><td bgcolor="#99ccff">\n
<table border="0" bgcolor=#99ccff cellpadding="3" cellspacing="0">\n
<tr>\n
<td bgcolor="#ffffff" ><font size="2" color=#CC0000 face="arial, helvetica, verdana">\n
$input{'Message'}\n
</font></td>\n
</tr>\n
</table>\n
</td></tr></table>&nbsp;&nbsp;&nbsp;&nbsp;</center>\n

</td></tr></table></center>\n
<br>
ENDOFTEXT

print "<center><table border=1 bgcolor=#FFFFCC cellpadding=0 cellspacing=0 width=90%><tr><td>\n";
print <<"ENDOFTEXT";
<br>
<table border=0>
<td nowrap="">
<font color=blue>
<select name=Function><option>Choose Option
<option value=edit>Edit File
<option value=createfile>Create File
<option value=delete>Delete File(s)
<option value=rename>Rename File/Directory
<option value=copy>Make copy of file
<option value=createdir>Create Directory
<option value=deldir>Delete Directory
<option value=lockdir>Lock Directory with Password
</select>
<INPUT TYPE="text" name="Options" size="25" maxlength="100">
<input TYPE="image" name="Submit" SRC="$Site/$ImageDir/go.gif" BORDER=0 height=35> 
</td></table>
ENDOFTEXT
print "<table border=0 bgcolor=#ffffff cellpadding=2 cellspacing=3><tr>";

foreach $file (sort @files)
	{
        my $s = stat($file) || die "Can't stat($file) $!\n"; 
        my $modtime = strftime('%d/%m/%Y', localtime($s->mtime)); 
	my $size = -s _; 
	$cwdtmp = cwd;
	if ("$size" >= "1000" )
		{ 
		$size = $size / 1000;
		if (-d "$file")
			{
			# Print Image before File Name
			print "<td bgcolor=\"ffffff\"><img src=$Site/$ImageDir/folder.gif border=0></td>\n";
			# Print File name and Link, add $newtmp/ + new file name to link
			printf("<td bgcolor=\"#ffffff\"><font color=#CC0000><a href=$Site/$BinDir/manager.cgi?DIR=$newtmp/$file&uid=$input{uid}&uidp=$input{uidp}>$file</a></td>\n<td bgcolor=\"#ffffff\"><font color=#CC0000>$modtime</td>\n<td bgcolor=\"#ffffff\"><font color=#CC0000>&nbsp;</td>\n");
			}
		else
			{
			print "<td bgcolor=\"ffffff\"><img src=$Site/$ImageDir/html.gif border=0></td>\n";
			printf("<td bgcolor=\"#ffffff\"><font color=#CC0000><a href=$RootDirSite$newtmp/$file>$file</a></td>\n<td bgcolor=\"#ffffff\"><font color=#CC0000>$modtime</td>\n<td bgcolor=\"#ffffff\"><font color=#CC0000>(%-2dk)</td>\n", $size);
			}

		print "<td bgcolor=\"#ffffff\"><input type=\"checkbox\" name=\"files\" value=\"$file\"></td>\n";
		# If not a directory Place edit tag next to file
		if (! -d "$file")
			{
			print "<td bgcolor=#ffffff><a href=$Site/$BinDir/webshell.cgi?currentDir=$newtmp&uid=$input{uid}&uidp=$input{uidp}&files=$file&Function=edit><img src=$Site/$ImageDir/edit.gif border=0 alt=\"Edit $file\"></a></td>\n";
			}		
		else
			{
			print "<td></td>\n";
			}
		print "</tr>";
		}
	else
		{
		$size = $size / 1000;
		if (-d "$file")
			{
			print "<td bgcolor=\"ffffff\"><img src=$Site/$ImageDir/folder.gif border=0></td>\n";
			printf("<td bgcolor=\"#ffffff\"><font color=#CC0000><a href=$Site/$BinDir/manager.cgi?DIR=$newtmp/$file&uid=$input{uid}&uidp=$input{uidp}>$file</a></td>\n<td bgcolor=\"#ffffff\"><font color=#CC0000>$modtime</td>\n<td bgcolor=\"#ffffff\"><font color=#CC0000>&nbsp;</td>\n");
			}
		else
			{
			print "<td bgcolor=\"ffffff\"><img src=$Site/$ImageDir/html.gif border=0></td>\n";
		printf("<td bgcolor=\"#ffffff\"><font color=#CC0000><a href=$RootDirSite$newtmp/$file>$file</a></td>\n<td bgcolor=\"#ffffff\"><font color=#CC0000>$modtime</td>\n<td bgcolor=\"#ffffff\"><font color=#CC0000>%.2fk</td>\n",  $size);
			}		

		print "<td bgcolor=\"#ffffff\"><input type=\"checkbox\" name=\"files\" value=\"$file\"></td>\n";

		# If not a directory Place edit tag next to file
		if (! -d "$file")
			{
			print "<td bgcolor=#ffffff><a href=$Site/$BinDir/webshell.cgi?currentDir=$newtmp&uid=$input{uid}&uidp=$input{uidp}&files=$file&Function=edit><img src=$Site/$ImageDir/edit.gif border=0 alt=\"Edit $file\"></a></td>\n";
			}
		else
			{
			print "<td></td>\n";
			}
			
		print "</tr>\n";
		}
	}
print "</table>\n";

print <<"ENDOFTEXT";
<br>
</td>
ENDOFTEXT
print <<"ENDOFTEXT";
<input type=hidden name=uid value=$input{uid}>
<input type=hidden name=uidp value=$input{uidp}>
ENDOFTEXT
print "</tr></table></center>";
print "</form>";
print <<"ENDOFTEXT";
<FORM enctype="multipart/form-data" method="post" action="upload.cgi">
<input type=hidden name=uid value=$input{uid}>
<input type=hidden name=uidp value=$input{uidp}>
<input type=hidden name=currentDir value=$newtmp>
<table border="0" cellspacing="0" cellpadding="2" width="90%" align="center">
		<td><font size="2" face="arial, helvetica, verdana"><b>FILE UPLOAD</b></font></td>
	</tr><tr>
		<td nowrap><font color=yellow size="2" face="arial, helvetica, verdana">Select a file to upload:
		<INPUT TYPE="submit" NAME="Submit" VALUE="UPLOAD"></td></tr></font>
		<tr><td nowrap><INPUT type="file" name="upload" size="25"><font size="2">&nbsp;</font></td>
		<td nowrap><INPUT type="file" name="upload1" size="25"><font size="2">&nbsp;</font></td></tr>
		<tr><td nowrap><INPUT type="file" name="upload2" size="25"><font size="2">&nbsp;</font></td>
		<td nowrap><INPUT type="file" name="upload3" size="25"><font size="2">&nbsp;</font></td></tr>
		<tr><td nowrap><INPUT type="file" name="upload4" size="25"><font size="2">&nbsp;</font></td>
		<td nowrap><INPUT type="file" name="upload5" size="25"><font size="2">&nbsp;</font></td></tr>
	</tr><tr>
	</tr><tr>
		<td colspan="2"><hr align="center" size="1" noshade></td>
	</tr></FORM>
</tr></table>
<font color=yellow><center>Copyright &copy Wisharts Data Center, www.wisharts.com 2002, All Rights Reserved</center>
<br>


ENDOFTEXT
		} # End of Timeout Check
	}

# Close the document cleanly.
  print &HtmlBot;
