#!/usr/bin/perl
#############################################################################
#                                                                           #
# This copyright data applies to all source files                           #
#                                                                           #
# WebShell, Copyright (c) 2002 Steven Wishart, All Rights Reserved.         #
#                                                                           #
#      Module  : logincheck.cgi                                             #
#        Type  : Perl Source file                                           #
# Description  : Script to verify logins to WebShell                        #
#                                                                           #
# This software is provided `AS IS' and without any express or implied      #
# warranties, including, without limitation, the implied waranties of       #
# merchantabulity and fitness for a particular purpose.                     #
#                                                                           #
# Redistribution and use of source are permitted provided that:             #
#                                                                           #
# (1) source distributions may not be sold for profit on physical media     #
# such as disks, tapes, and CD-ROMS, without expressed written permission   #
# from the author.                                                          #
#                                                                           #
#############################################################################
# require the DBI module and the DBD::mysql driver
use DBI;
use CGI;
require "cgi-lib.pl";
require "global.pl";


# LoadConfig
&LoadConfig;

$table = "users";
$database = "webshell";
$data_source = "dbi:mysql";
$user = "webshell";
$passwd = "webshell";

&ReadParse(*input);

	local(@Date) = &CDate4;

$pass = $input{'password'};
$remember = $input{'rememberpw'};

if("$input{'rememberpw'}" ne "1")
	{
	$remember = "";
	$pass = "";
	}

# ----- Start Cookie Set for next time
my $query = new CGI;

my $cookie_out = $query->cookie(-name=>"WEBSHELL_LOGIN",
                 -value=>"$input{login}|$remember|$pass",
                 -expires=>'+7d');

print $query->header(-cookie=>$cookie_out);   

# ----- End of Cookie Set


# connect to our database
$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	# a normal select/execute/fetch sequence
	$statement = "select * from $table";

$sth = $dbh->prepare($statement) or &error('database_prepare');
$sth->execute or &error('database_execute');
$rows_returned = $sth->rows;

# print the header
print "<html>\n";
print "<head>\n";
print "</head>\n";
print "<body bgcolor=white>\n";


# Set count = 0
$count=0;

# Set Status = FALSE
$Status = $FALSE;

# print the results
print "<table border=0 width=600 cellpadding=5>\n";


while( @row = $sth->fetchrow_array )
{
  #if($count++ % 2 == 0) { print "<tr bgcolor=white> "; }
  #else                  { print "<tr bgcolor=white> "; }

  $Encrypt = (crypt(($input{'password'}),SW));

  if (("$input{login}" eq "@row[3]") && ("$Encrypt" eq "@row[7]"))
        {
	if(! -r "$RootDir/$row[17]")
		{
        	$Status = "$FALSE";
		$Status1 = "Dir";
		}
	else
		{
        	$Status = $TRUE;

        &Syslog("$input{login} Connected \($ENV{REMOTE_HOST}\)");

	# close the open statement
	$sth->finish;

	# disconnect from the database
	$dbh->disconnect;

	# Update Users number of Logins
	&UpdateUsers("$row[0]", "logins", ++$row[13]);
	# Update Users IP Address
	&UpdateUsers("$row[0]", "ipaddress", "$ENV{REMOTE_ADDR} $ENV{REMOTE_HOST}");
	if("$row[11]" eq "0000-00-00")
		{
		# Update Users First Login
		&UpdateUsers("$row[0]", "firstlogin", "$Date[0]-$Date[1]-$Date[2]");
		}	
	# Update Users Last Login Date
	&UpdateUsers("$row[0]", "lastlogin", "$Date[0]-$Date[1]-$Date[2]");

	# Update Users HomeDir if Blank
	&UpdateUsers("$row[0]", "homedir", "$row[3]");

        print <<"ENDOFTEXT";
        <META HTTP-EQUIV="refresh" CONTENT="0; URL=$Site/$BinDir/manager.cgi?uid=@row[0]&uidp=$Encrypt&showonce=1">
ENDOFTEXT
        exit
		}
        }
   else
        {
        $Status = $FALSE;
        }
}
# --> Check if login was successful else print error
        if(!$Status)
                {

		&Syslog("$Status1  s");
		if("$Status1" ne "Dir")
			{
                	print "<font color=blue><b> - Incorrect login</b> - Please Try again";
                	&Syslog("Login or Password Incorrect for $input{login}");
                	&Syslog("Failed Login IP: \($ENV{REMOTE_HOST}\)");
			}
		else
			{
                	print "<font color=blue><b>Login Directory not available</b> - Please contact Site Admins";
                	&Syslog("Login directory not available - $input{login}");
                	&Syslog("Bad Directory: \($ENV{REMOTE_HOST}\)");
			}
                }

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;
print "</table>";

print "</body></html>\n";
exit;


# handle errors
sub error { 
  # Localize variables and assign subroutine input.
  local($error,@error_fields) = @_;

  print "
  <html>
  <head>
  <title>Error: $error</title>
  </head>
  <body bgcolor=white>
  <table border=0 width=600 cellpadding=5 bgcolor=#999999>
  <tr><th><font size=+2>Error: $error</font></th></tr>
  </table>
  <table border=0 width=600 cellpadding=5>
  <tr><td>
  <br>
  ";

  if ($error eq 'missing_data')
  {
    print "All of the data that is neccessary to complete your " .
          "request was not given. Please go back and fill out all " .
          "neccessary feilds.<br>";
  }
  elsif ($error eq 'database_connect')
  {
    print STDERR "$0: error connecting to the " .
                 "WebShell Database\n";
    print "Error connecting to the WebShell Database. " .
          "Please try again later <br>\n";


	open(MAIL, "| mail swishart") || die "Error Can't start mail program";
    select(MAIL);

      print MAIL "Subject: WebShell Database Down\n\n";
      print MAIL "Database is down, Someone attempted to try access at " . `date`;
      print MAIL "\r\n";
    close(MAIL);
    select(STDOUT);  

  }
  elsif ($error eq 'database_prepare')
  {
    print STDERR "$0: error preparing SQL statement $statement\n";
    print "error preparing SQL statement $statement. " .
          "Please contact the servers system administrator.<br>\n";
  }
  elsif ($error eq 'database_execute')
  {
    $error_string = $sth->errstr;
    print STDERR "$0: error executing SQL query: $error_string\n";
    print "error executing SQL query: $error_string. " .
          "Please contact the servers system administrator.<br>\n";
  }
  else
  {
    print "There was an error proccessing you request<br>\n";
  }

  print "
  <br>
  </td></tr>
  <tr><td>
  <font size=-1>
  </td></tr>
  </table>
  </body>
  </html>
  ";

  exit;
}



