#!/usr/bin/perl
############################################################################
#                                                                           #
# This copyright data applies to all source files                           #
#                                                                           #
# Rapid WebShell, Copyright (c) 2002 Steven Wishart, All Rights Reserved.   #
#                                                                           #
#      Module  : global.pl                                                  #
#        Type  : Perl Source file                                           #
# Description  : Global function file. Contains all the functions           #
#                for the WebShell system.                                   #
#                                                                           #
# This software is provided `AS IS' and without any express or implied      #
# warranties, including, without limitation, the implied waranties of       #
# merchantabulity and fitness for a particular purpose.                     #
#                                                                           #
# Redistribution and use of source are permitted provided that:             #
#                                                                           #
# (1) source distributions may not be sold for profit on physical media     #
# such as disks, tapes, and CD-ROMS, without expressed written permission   #
# from the author.                                                          #
#                                                                           #
#############################################################################
push(@INC, ".");
# require the DBI module and the DBD::mysql driver
use DBI;
require "cgi-lib.pl";   # Include Standard Library

sub Syslog;		# Log messages to System 
sub CDate2;		# Returns Date and Time -> DD-Mon HH:MM:SS
sub CDate3;		# Returns Date -> DD MM YYYY
sub CDate4;		# Returns Date -> YYYY MM DD
sub Getpwinfo;		# Get user file information and return using ID NUMBER
sub error;		# DB Error Connecting Function
sub CTime;		# Returns Time HH:MM
sub SyntaxError;	# Display Errors if fields are blank
sub ChangePassword;	# Allow User to Change Password
sub EmailTicket;	# Email Ticket to Group
sub ForgotPassword;	# Send user lost password
sub ListUsers;		# List Users
sub Getpwinfoe;		# Get user file information and return using email address
sub Getpwinfouid;	# Get user file information and return using UID column
sub GetTicket;		# Get Ticket Info, using Ticket #
sub GetDepartment;	# Get Department Names of People using users ID
sub Getpwinfouser;	# Get user information and return using firstname,lastname 
sub PhoneStatus;        # Update Phone Status on User
sub ListAllUsers;	# List Users
sub LoadConfig;		# Load config into memory
sub UpdateUsers;	# Update Users
sub Getpwinfouserid;	# Get user file information and return using userid column
sub WriteError;		# Write errors to log file
#sub Encrypt_Password;	# Encrypt Users password with Random Seed

# Load Config into Memory
#&LoadConfig;

# Default Database Settings
$table = "users";
$database = "webshell";
$data_source = "dbi:mysql";
$user = "webshell";
$passwd = "webshell";

#
# Function will log messages to system logfile
# Usage: &Syslog("Text or $Var");
#
sub Syslog
{
      local ($Text) = @_;
	local($Header);
	local(@Date) = &CDate2;

	if(!( -e "$Syslog_File"))
		{
		$Header = "System Log Started for WebShell at @Date\n\n";
		}

        # Open syslog file. It is important that the log
        # directory is writable so it can log messages.
        open(LogFile, ">>$Syslog_File");

        # Send all output to error file
        select(LogFile);

	# If newlog file print header, at top
	print "$Header";

        # Print to syslog file, variable that was passed via the @_ varible
        print "> @Date $Text\n";
        close(LogFile);

	  chown($CHOWN_MODE, $CHGRP_MODE, "$Syslog_File");
        chmod(00662, $Syslog_File);

        # Select STDOUT to all output will go to screen
        select(STDOUT);
}

#
# Function will print date in following format
# DD-Mon HH:MM:SS
# Usage: $var = &CDate2;
#
sub CDate2
{
	local(@Date);

        ($second,$minute,$hour,$day,$month,$year,$weekday,$day_of_year,$daylight) = localtime(time);

        if(($month > 0) && ($month < 10))
                {
                $month = "0$month";
                }

        if(($day > 0) && ($day < 10))
                {
                $day = "0$day";
                }

	if($day == 0)
		{
		$day = "00";
		}

        if(($hour > 0) && ($hour < 10))
                {
                $hour = "0$hour";
                }

	 if($hour == 0)
                {
                $hour = "00";
                }

	 if($second == 0)
                {
                $second = "00";
                }

	 if($minute == 0)
                {
                $minute = "00";
                }

        if(($minute > 0) && ($minute < 10))
                {
                $minute = "0$minute";
                }

	if(($second > 0) && ($second < 10))
                {
                $second = "0$second";
                }

        @Date = "$day-$Month[$month] $hour:$minute:$second";

        @Date;
}

#
# Function will print date in following format
# Returns DD MM YYYY 
# Usage: $var = &CDate3;
#
sub CDate3
{
	local(@Date);

        ($second,$minute,$hour,$day,$month,$year,$weekday,$day_of_year,$daylight) = localtime(time);

        if(($month > 0) && ($month < 10))
                {
                $month = "0$month";
                }

        if(($day > 0) && ($day < 10))
                {
                $day = "0$day";
                }

	if($day == 0)
		{
		$day = "00";
		}

        if(($hour > 0) && ($hour < 10))
                {
                $hour = "0$hour";
                }

	 if($hour == 0)
                {
                $hour = "00";
                }

	 if($second == 0)
                {
                $second = "00";
                }

	 if($minute == 0)
                {
                $minute = "00";
                }

        if(($minute > 0) && ($minute < 10))
                {
                $minute = "0$minute";
                }

	if(($second > 0) && ($second < 10))
                {
                $second = "0$second";
                }

        #@Date = "$day-$Month[$month] $hour:$minute:$second";

	$Date[0] = "$day";
	$Date[1] = $month + 1;
	$Date[2] = $year + 1900;

        @Date;
}

#
# Function will print date in following format
# Returns YYYY-MM-DD
# Usage: @var = &CDate4;
#
sub CDate4
{
	local(@Date);

        ($second,$minute,$hour,$day,$month,$year,$weekday,$day_of_year,$daylight) = localtime(time);

        if(($month > 0) && ($month < 10))
                {
                $month = "0$month";
                }

        if(($day > 0) && ($day < 10))
                {
                $day = "0$day";
                }

	if($day == 0)
		{
		$day = "00";
		}

        if(($hour > 0) && ($hour < 10))
                {
                $hour = "0$hour";
                }

	 if($hour == 0)
                {
                $hour = "00";
                }

	 if($second == 0)
                {
                $second = "00";
                }

	 if($minute == 0)
                {
                $minute = "00";
                }

        if(($minute > 0) && ($minute < 10))
                {
                $minute = "0$minute";
                }

	if(($second > 0) && ($second < 10))
                {
                $second = "0$second";
                }

        #@Date = "$day-$Month[$month] $hour:$minute:$second";

	$Date[0] = $year + 1900;
	$Date[1] = $month + 1;
	$Date[2] = "$day";

        @Date;
}

#
# Function will return user information from users.dat file
# Return users information from USER ID
# Usage: @PWInfo = Getpwinfo($userID);
#
sub Getpwinfo
{
	local($userid) = @_;			# Return users info
      	local($line) = "";			# Set $line to blank
	local(@Userpw);				# Declare local varibles
	local($table) = "users";		# User user table instead

	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

        if ("$userid" ne "")
                {
                # a normal select/execute/fetch sequence
                $statement = "select * from $table " .
                " where uid = $userid";
                }

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	while( @row = $sth->fetchrow_array )
		{
		@Userpw = @row;
		}

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;

      # Return User information
      @Userpw;
}

#
# Function will return error with database connectivity
# Usage: error(errorcall)
#
sub error {
  # Localize variables and assign subroutine input.
  local($error,@error_fields) = @_;

  print "
  <html>
  <head>
  <title>Error: $error</title>
  </head>
  <body bgcolor=white>
  <center>
  <table border=0 width=600 cellpadding=5 bgcolor=#999999>
  <tr><th><font size=+2>Error: $error</font></th></tr>
  </table>
  <table border=0 width=600 cellpadding=5>
  <tr><td>
  <br>
  ";

  if ($error eq 'missing_data')
  {
    print "All of the data that is neccessary to complete your " .
          "request was not given. Please go back and fill out all " .
          "neccessary feilds.<br>";
  }
  elsif ($error eq 'database_connect')
  {
print STDERR "$0: error connecting to the " .
                 "WebShell Database\n";
    print "Error connecting to the WebShell Database. " .
          "Please try again later <br>\n";


        open(MAIL, "| mail swishart") || die "Error Can't start mail program";
    select(MAIL);

      print MAIL "Subject: WebShell Database Down\n\n";
      print MAIL "Database is down, Someone attempted to try access at " . `date`;
      print MAIL "\r\n";
    close(MAIL);
    select(STDOUT);

  }
  elsif ($error eq 'database_prepare')
  {
    print STDERR "$0: error preparing SQL statement $statement\n";
    print "error preparing SQL statement $statement. " .
          "Please contact the servers system administrator.<br>\n";
  }
  elsif ($error eq 'database_execute')
  {
    $error_string = $sth->errstr;
    print STDERR "$0: error executing SQL query: $error_string\n";
    print "error executing SQL query: $error_string. " .
          "Please contact the servers system administrator.<br>|$statement\n";
 }
  else
  {
    print "There was an error proccessing you request<br>\n";
  }
 print "
  <br>
  </td></tr>
  <tr><td>
  <center><font size=-1>
  </td></tr>
  </table>
  </center>
  </body>
  </html>
  ";

  exit;
}

# 
# Function will print time in following format
# Returns HH:MM 
# Usage: $var = &CTime;
#
sub CTime
{
	local(@Date);

	($second,$minute,$hour,$day,$month,$year,$weekday,$day_of_year,$daylight) = localtime(time);

        if(($hour > 0) && ($hour < 10))
                {
                $hour = "0$hour";
                }

        if(($minute > 0) && ($minute < 10))
                {
                $minute = "0$minute";
                }

	if(($day > 0) && ($day < 10))
                {
                $day = "0$day";
                }

        if($day == 0)
                {
                $day = "00";
                }

	if($hour == 0)
                {
                $hour = "00";
                }

         if($minute == 0)
                {
                $minute = "00";
                }

        # @Date = sprintf("%s %s, %s:%s", $Month2[$month], $day, $hour, $minute);
        @Date = sprintf("%s:%s", $hour, $minute);
		
	@Date;
}

#
# Function to Print Errors to the user
# Usage: &SyntaxError($Message);
#
sub SyntaxError
{
        local($Message) = @_;
        print <<"ENDOFTEXT";

<HTML>
<HEAD>
   <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
   <TITLE>Form Error</TITLE>
</HEAD>
<BODY>
 <BODY TEXT="#000000" BGCOLOR="#FFFFFF" LINK="#0000EE" VLINK="#551A8B"
ALINK="#FF0000">

<b>You must fill out the form correctly!</b><br><br>

The following fields were filled out incorrectly:-<br><br>

ENDOFTEXT

print "<b><font
color=red>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$Message</font
color><br><br>";

print "Use your Browser's Back Button to Return and re-submit your
Request</b><br><br>";

}

#
# Function will change users password and compare old one
# Usage: &ChangePassword($userid, $password);
#
sub ChangePassword
{
	local($userid, $password) = @_;		# Return users info
	local($table) = "users";		# User user table instead

	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	# Encrypt Password
	$Encrypt = crypt($password,SW); 

        if ("$userid" ne "")
                {
	     $statement = " UPDATE $table " .
             " SET password = \'$Encrypt\' " .
             " WHERE uid = $userid";
             " ";

                }

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	while( @row = $sth->fetchrow_array )
		{
		@Userpw = @row;
		}

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;

}

#
# Function will send mail to the provided users mail address with a password
# Usage: &EmailTicket($Data, $Subject, $FromEmail, $FromName, $Email);
#
sub EmailTicket
{
	local($Data, $Subject, $FROMemail, $FROMname, $Email) = @_;

	open(MAIL, "| /usr/lib/sendmail -f\"$FROMemail\" -F\"$FROMname\" -O NoRecipientAction=add-to $Email") || die "Error Can't start mail program";
	select(MAIL);

	#&Syslog("$Data, $Subject, $FROMemail, $FROMname, $Email");

	print MAIL ("Subject: $Subject\n\n");

	print MAIL "$Data\n\n";

	print MAIL "\r\n";

	close(MAIL);
	select(STDOUT);
}                   

#
# Function will change users password and compare old one
# Usage: &ChangePassword($email);
#
sub ForgotPassword
{
	local($email) = @_;			# Return users info
	local($table) = "users";		# User user table instead
	local(@EUser);

	# Put a \ in front of the @
	$email1 = $email;
	$email1 =~ s/\@/\\@/g;

	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	# Give user password than has been set
	$Ord1 = (ord($email1)*1024);
	$Ord = (ord($Ord1)*1024);

	# Encrypt Password
	$Encrypt = (crypt($Ord1,SW)); 

        if ("$email" ne "")
                {
	     $statement = " UPDATE $table " .
             " SET password = \'$Encrypt\' " .
             " WHERE email='$email'";
             " ";
                }

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	while( @row = $sth->fetchrow_array )
		{
		@Userpw = @row;
		}

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;


 	@EUser = &Getpwinfoe("$email");

	# Send user lost password information
	open(MAIL, "| /usr/lib/sendmail -f\"$AdminEmail\" -F\"$SiteName\" -O NoRecipientAction=add-to $email") || die "Error Can't start mail program";
	select(MAIL);

	print MAIL ("Subject: $SiteName WebShell Requested Password\n\n");

	if("$EUser[5]" eq "$email")
		{
		print MAIL "\nYour WebShell Login and Password are:\n";
		print MAIL "\nLogin    : $EUser[3]";
		print MAIL "\nPassword : $Ord1\n\n";
		print MAIL "\n\nThank you for using WebShell\n\n";
		}
	else
		{
		print MAIL "\nYou do not currently have a WebShell Account\n";
		print MAIL "\nPlease contact $SiteName for a new account\n\n";
		print MAIL "\n\nThank you for using WebShell\n\n";
		}

	print MAIL "\r\n";
	print MAIL "$Site";
	print MAIL "\r\n";

	close(MAIL);
	select(STDOUT);

}

#
# Function will return user information from users.dat file
# Return users information from USER ID
# Usage: ListUsers();
#
sub ListUsers
{
	local($userid) = @_;			# Return users info
      	local($line) = "";			# Set $line to blank
	local(@Userpw);				# Declare local varibles
	local($table) = "users";		# User user table instead

	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	# a normal select/execute/fetch sequence
        $statement = "select * from $table";

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	print "<TABLE BGCOLOR=#CCCCCC BORDER=0 CELLPADDING=2 CELLSPACINg=2>";

	print "<img src=$Company_Logo border=0><br>";
        print "<tr bgcolor=#003399><td colspan=11 align=center>\n";
        print "<font face=Arial,Helvetica,sans-serif color=#FFFFFF size=2>\n";
        print "<b>User Listing</font></td></tr>\n";
        print "<TR bgcolor=#6699CC><TD><font color=black><b>#</TD>\n";
        print "<TD><font color=black><b>User Name</TD>\n";
        print "<TD><font color=black><b>UserID</TD>\n";
        print "<TD><font color=black><b>Phone</TD>\n";
        print "<TD><font color=black><b>Email</TD>\n";
        print "<TD><font color=black><b>Department</TD>\n";
        print "<TD><font color=black><b>Created</TD>\n";
        print "<TD><font color=black><b>Last Login</TD>\n";
        print "<TD><font color=black><b>Password</TD>\n";
        print "<TD><font color=black><b>Level</TD>\n";
        print "<TD><font color=black><b>Delete</TD>\n";
        print "</tr><tr bgcolor=CCCCCC>\n";

	while( @row = $sth->fetchrow_array )
		{
		print "<TD>$row[0]</TD>";
		print "<TD nowrap=\"\">$row[1]</TD>";
		print "<TD>$row[2]</TD>";
		print "<TD>$row[3]</TD>";
		print "<TD>$row[4]</TD>";
		print "<TD>$row[5]</TD>";
		print "<TD>$row[6]</TD>";
		print "<TD>$row[7]</TD>";
		print "<TD>*Encrypted*</TD>";
		print "<TD>$row[10]</TD>";
		print "<TD><img src=$Site/$ImageDir/delete.gif border=0></TD>";
		print "</TR>";
		}

	print "</TABLE>";

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;

}

#
# Function will return user information from users.dat file
# Return users information from email address
# Usage: @PWInfo = Getpwinfoe($email);
#
sub Getpwinfoe
{
	local($email) = @_;			# Return users info
      	local($line) = "";			# Set $line to blank
	local(@Userpw);				# Declare local varibles
	local($table) = "users";		# User user table instead

        if ("$email" ne "")
                {
	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

                # a normal select/execute/fetch sequence
                $statement = "select * from $table " .
                " where email = '$email'";

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	while( @row = $sth->fetchrow_array )
		{
		@Userpw = @row;
		}

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;

	return @Userpw;
	}
}

#
# Function will return user information from users.dat file
# Return users information from UID column
# Usage: @PWInfo = Getpwinfouid(uid);
#
sub Getpwinfouid
{
	local($uid) = @_;			# Return users info
      	local($line) = "";			# Set $line to blank
	local(@Userpw);				# Declare local varibles
	local($table) = "users";		# User user table instead

        if ("$uid" ne "")
                {
	# connect to our database
	$dbh1 = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

                # a normal select/execute/fetch sequence
                $statement = "select * from $table " .
                " where uid = '$uid'";

	$sth1 = $dbh1->prepare($statement) or &error('database_prepare');
	$sth1->execute or &error('database_execute');
	$rows1_returned = $sth1->rows;

	while( @row1 = $sth1->fetchrow_array )
		{
		@Userpw = @row1;
		}

# close the open statement
$sth1->finish;

# disconnect from the database
$dbh1->disconnect;

	return @Userpw;
	}
}

#
# Function will return Ticket Info using ticket #
# Usage: @PWInfo = GetTicket($table, Ticket#);
#
sub GetTicket
{
	local($table, $ticket) = @_;		# Return users info
      	local($line) = "";			# Set $line to blank
	local(@Userpw);				# Declare local varibles

        if ("$ticket" ne "")
                {
	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

                # a normal select/execute/fetch sequence
                $statement = "select * from $table " .
                " where id = '$ticket'";

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	while( @row = $sth->fetchrow_array )
		{
		@Userpw = @row;
		}

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;

	return @Userpw;
	}
}

#
# Function will return user information from users.dat file
# Return users belonging to the same user group as current user
# Usage: @PWInfo = GetDepartment($Department);
#
sub GetDepartment
{
	local($depart) = @_;			# Return users info
      	local($line) = "";			# Set $line to blank
	local(@departm);			# Declare local varibles
	local($table) = "users";		# User user table instead
	local($count) = 0;

	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	# Search by Department
        if ("$depart" ne "")
                {
                # a normal select/execute/fetch sequence
                $statement = "select * from $table " .
                " where department='$depart' ";
                }

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	while( @row = $sth->fetchrow_array )
		{
		# Set 1st array to userid
		$departm[$count] = "$row[3]";
		$count++;
		# Set second Array to firstname lastname
		$departm[$count] = "$row[1] $row[2]";
		$count++;
		# End Result = $array[0] = swishart, $array[1] = Steven Wishart
		}

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;

      # Return User information
      @departm;
}

#
# Function will return user information from users.dat file
# Return users information from email address
# Usage: @PWInfo = Getpwinfouser($firstname,lastname);
#
sub Getpwinfouser
{
	local($firstname, $lastname) = @_;	# Return users info
      	local($line) = "";			# Set $line to blank
	local(@Userpw);				# Declare local varibles
	local($table) = "users";		# User user table instead

        if (("$firstname" ne "") && ("$lastname" ne ""))
                {
	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

                # a normal select/execute/fetch sequence
                $statement = "select * from $table " .
                " where firstname = '$firstname' and lastname = '$lastname'";

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	while( @row = $sth->fetchrow_array )
		{
		@Userpw = @row;
		}

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;

	return @Userpw;
	}
}

#
# Function will change users password and compare old one
# Usage: &PhoneStatus($userid, $PhoneStatus, $ReturnStatus, $Comments);
#
sub PhoneStatus
{
	local($userid, $phonestatus, $returnstatus, $comments) = @_;			# Return users info
	local($table) = "users";	# User user table instead

        if ("$userid" ne "")
                {
	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	     $statement = " UPDATE $table " .
             " SET userstatus = \'$phonestatus\', " .
             " returnstatus = \'$returnstatus\', " .
             " phonecomments = \'$comments\' " .
             " WHERE userid ='$userid'";
             " ";

	&Syslog("$statement");

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	 while( @row = $sth->fetchrow_array )
                {
                @Userpw = @row;
                }

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;
	}

}

#
# Function will return user information from users.dat file
# Return users information from USER ID
# Usage: ListALLUsers();
#
sub ListAllUsers
{
	local($userid) = @_;			# Return users info
      	local($line) = "";			# Set $line to blank
	local(@Userpw);				# Declare local varibles
	local($table) = "users";		# User user table instead
	local(@UsersList);			# Local Var

	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	# a normal select/execute/fetch sequence
        $statement = "select * from $table GROUP By lastname,firstname";

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	# Set counter to Zeri
	$x = 0;

	while( @row = $sth->fetchrow_array )
		{
		if(("@row[19]" ne "N") && ("@row[19]" ne "B"))
			{
		@UsersList[$x++] = "$row[1]|$row[2]";
			}
		}

	print "</TABLE>";

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;
	@UsersList;
}

#
# Function will Load the Config when the script runs
# Usage: LoadConfig();
#
sub LoadConfig
{
	local($table) = "config";		# User user table instead

$database = "webshell";
$data_source = "dbi:mysql";
$user = "webshell";
$passwd = "webshell";

	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	# a normal select/execute/fetch sequence
        $statement = "select * from $table";

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

	while( @row = $sth->fetchrow_array )
		{
		$Author 		= "$row[1]";
		$Site 			= "$row[2]";
		$SiteName 		= "$row[3]";
		$ProgramDir 		= "$row[4]";
		$BinDir 		= "$row[5]";
		$DataDir 		= "$row[6]";
		$ImageDir 		= "$row[7]";
		$HelpDir 		= "$row[8]";
		$LogDir 		= "$row[9]";
		$RootDir 		= "$row[10]";
		$ErrorLog 		= "$ProgramDir/$LogDir/$row[11]";
		$Syslog_File 		= "$ProgramDir/$LogDir/$row[12]";
		$AdminEmail 		= "$row[13]";
		$AdminLevel 		= "$row[14]";
		$EmailDomain 		= "$row[15]";
		$DomainName 		= "$row[16]";
		$TRUE 			= "$row[17]";
		$FALSE 			= "$row[18]";
		@Month 			= split(/\,/, "$row[19]");
		@Month2 		= split(/\,/, "$row[20]");
		$CHDIR_MODE 		= "$row[21]";
		$CHMOD_MODE 		= "$row[22]";
		$CHOWN_MODE 		= "$row[23]";
		$CHGRP_MODE 		= "$row[24]";
		$RootDirSite		= "$row[25]";
		$Version		= "$row[26]";
		$Fortune		= "$row[27]";
		$FortuneDisable		= "$row[28]";
		$PrivateSystem		= "$row[29]";
		$PrivateSystemMsg	= "$row[30]";
		$PrivateSystemPasswd	= "$row[31]";
		}

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;

}

#
# Function will Load the Config when the script runs
# Usage: UpdateUsers();
#
sub UpdateUsers
{
	local($table) = "users";		# User user table instead
	local($uid, $field, $data) = @_;	# Return users info

$database = "webshell";
$data_source = "dbi:mysql";
$user = "webshell";
$passwd = "webshell";

	# connect to our database
	$dbh = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

	# a normal select/execute/fetch sequence
	$statement = " UPDATE $table " .
	             " SET $field = \'$data\' " .
                     " WHERE uid = \'$uid\' " .
                     " ";

	$sth = $dbh->prepare($statement) or &error('database_prepare');
	$sth->execute or &error('database_execute');
	$rows_returned = $sth->rows;

# close the open statement
$sth->finish;

# disconnect from the database
$dbh->disconnect;
}

#
# Function will return user information from users.dat file
# Return users information from UID column
# Usage: @PWInfo = Getpwinfouserid(userid);
#
sub Getpwinfouserid
{
	local($userid) = @_;			# Return users info
      	local($line) = "";			# Set $line to blank
	local(@Userpw);				# Declare local varibles
	local($table) = "users";		# User user table instead

        if ("$userid" ne "")
                {
	# connect to our database
	$dbh1 = DBI->connect("$data_source:$database", $user, $passwd) or &error('database_connect');

                # a normal select/execute/fetch sequence
                $statement = "select * from $table " .
                " where userid = '$userid'";

	$sth1 = $dbh1->prepare($statement) or &error('database_prepare');
	$sth1->execute or &error('database_execute');
	$rows1_returned = $sth1->rows;

	while( @row1 = $sth1->fetchrow_array )
		{
		@Userpw = @row1;
		}

# close the open statement
$sth1->finish;

# disconnect from the database
$dbh1->disconnect;

	return @Userpw;
	}
}

#
# Function will log errors to logfile, instead of echoing
# the error to the screen
# Usage: &WriteError("Text or $Var", $login);
#
sub WriteError
{
	local($error, $uid) = @_;				# Get Args been passed
	local(@User) = &Getpwinfouid("$uid");			# Get user info
	local(@Date) = &CDate3;					# Get current Date

	# Open error log file. It is important that the log
	# directory is writable so it can log errors.
	open(Errorlog, ">>$ErrorLog") ||
                die "FATAL: Can't open $ErrorLog file";

	# Send all output to error file
	select(Errorlog);

	# Print to errorlog file, variable that was passwd via the @_ varible
	printf("@Date $User[0] %s\n", $error);
	close(Errorlog);

	chmod($CHMOD_MODE, "$ErrorLog");
	chown($CHOWN_MODE, $CHGRP_MODE, "$Error_Log");

	# Select STDOUT to all output will go to screen
	select(STDOUT);

	print &PrintHeader;
	# printf("<B><**System error**></B>\n");
	print &HtmlBot;

	#die($error);
}

#
# Function will encrypt Password
# Usage: &Encrypt_Password($unencrypted_password);
#
#sub  Encrypt_Password
#     {
#        my $unencrypted_string = shift @_;
#        my @salt_chars         = ('a'..'z','A'..'Z','0'..'9');
#        my $salt               = $salt_chars[rand(63)] . $salt_chars[rand(63)];
#        return crypt($unencrypted_string, $salt);
#     }
#
1;		# Set True for Library


