#!/usr/bin/perl
use CGI::Carp 'fatalsToBrowser'; CGI::Carp -> VERSION(1.06);
use lib 'lib';

##########################> Ringlink 2.0 <##########################
#                                                                  #
#  Ringlink is a CGI Perl program that provides the tools          #
#  necessary to run and administrate rings of websites.            #
#                                                                  #
#  Copyright (C) 2000, 2001 Gunnar Hjalmarsson,                    #
#  gunnar@ringlink.org; Version 2.0 released August 22, 2001       #
#  Ringlink homepage: http://www.ringlink.org/                     #
#                                                                  #
#  Ringlink is free software; you can redistribute it and/or       #
#  modify it under the terms of the GNU General Public License as  #
#  published by the Free Software Foundation; either version 2 of  #
#  the License, or (at your option) any later version.             #
#                                                                  #
#  Ringlink is distributed in the hope that it will be useful,     #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of  #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the    #
#  GNU General Public License for more details.                    #
#                                                                  #
#  You should have received a copy of the GNU General Public       #
#  License along with this program; if not, write to the Free      #
#  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,  #
#  MA  02111-1307  USA                                             #
#                                                                  #
####################################################################

use strict;

use rlmain 2.0;
use site 2.0;
use Locale::PGetText 2.0;

rlmain::execstart;
rlmain::ringlist;
if (!@rlmain::rings)	{
  $rlmain::result = rlmain::noring;
} elsif (!$rlmain::data)	{
  &selectform;
} elsif (!$rlmain::data{'ringid'})	{
  push (@rlmain::error, '<p class="error">' . gettext("Select ring ID!") . '</p>');
  &selectform;
} else	{
  rlmain::getringvalues;
  rlmain::htmlize ($rlmain::data{'ringtitle'} = $rlmain::ringtitle);
  my $ring = gettext("Ring:");

  $rlmain::ring_site = qq~<table cellspacing="8"><tr><td><span>$ring</span></td>
<td><span><a href="$rlmain::ringURL" target="Ringlink">
$rlmain::data{'ringtitle'}</a></span></td></tr></table>~;

  if (!$rlmain::allowsiteadd)	{
    my $nonew = sprintf (
      gettext("%s is configured so that the &quot;Add new site&quot; feature\nis not publicly available. You may want to contact\nthe ringmaster to ask for a new site to be created."),
      $rlmain::data{'ringtitle'});
    my $ringmastername = gettext("Ringmaster name:");
    my $email = gettext("Email:");

    $rlmain::result = qq~<p class="error">
$nonew
</p>
<table>
<tr>
<td><span>$ringmastername&nbsp;&nbsp;&nbsp;</span></td>
<td><span>$rlmain::rmname</span></td>
</tr>
<tr>
<td><span>$email</span></td>
<td><span><a href="mailto:$rlmain::rmemail">$rlmain::rmemail</a></span></td>
</tr>
</table>~;

  } elsif ($rlmain::data{'submit'})	{
    site::validation;
    if (!@rlmain::error)	{
      site::create;
      $rlmain::result = $rlmain::addpage;
    } else	{
      $rlmain::result = site::form;
    }
  } else	{
    $rlmain::data{'entryURL'} = 'http://';
    $rlmain::data{'codeURL'} = 'http://';
    $rlmain::data{'routine'} = 'New site';
    $rlmain::result = site::form;
  }
}

$rlmain::pagetitle = gettext("Add new site");
rlmain::adminhtml;


sub selectform	{
  my $ringid = gettext("Ring ID");
  my $getform = gettext("Get form");
  rlmain::ringselect;

  $rlmain::result = qq~@rlmain::error
<form method="POST" action="$rlmain::cgiURL/$rlmain::action">
<p>$ringid<br />
$rlmain::ringselect</p>
<p><input type="submit" value="$getform" /></p>
</form>~;

}

