#!/usr/bin/perl
use CGI::Carp 'fatalsToBrowser'; CGI::Carp -> VERSION(1.06);
use lib 'lib';

##########################> Ringlink 2.0 <##########################
#                                                                  #
#  Ringlink is a CGI Perl program that provides the tools          #
#  necessary to run and administrate rings of websites.            #
#                                                                  #
#  Copyright (C) 2000, 2001 Gunnar Hjalmarsson,                    #
#  gunnar@ringlink.org; Version 2.0 released August 22, 2001       #
#  Ringlink homepage: http://www.ringlink.org/                     #
#                                                                  #
#  Ringlink is free software; you can redistribute it and/or       #
#  modify it under the terms of the GNU General Public License as  #
#  published by the Free Software Foundation; either version 2 of  #
#  the License, or (at your option) any later version.             #
#                                                                  #
#  Ringlink is distributed in the hope that it will be useful,     #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of  #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the    #
#  GNU General Public License for more details.                    #
#                                                                  #
#  You should have received a copy of the GNU General Public       #
#  License along with this program; if not, write to the Free      #
#  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,  #
#  MA  02111-1307  USA                                             #
#                                                                  #
####################################################################

use strict;

use rlmain 2.0;
use ring 2.0;
use Locale::PGetText 2.0;

rlmain::execstart;
if (!$rlmain::allowringadd)	{
  my $nonew = sprintf (
    gettext("%s is configured so that the &quot;Add new ring&quot; feature\nis not publicly available. You may want to contact\nthe administrator to ask for a new ring to be created."),
    $rlmain::title);
  my $admname = gettext("Administrator name:");
  my $email = gettext("Email:");

  $rlmain::result = qq~<p class="error">
$nonew
</p>
<table>
<tr>
<td><span>$admname&nbsp;&nbsp;&nbsp;</span></td>
<td><span>$rlmain::adminname</span></td>
</tr>
<tr>
<td><span>$email</span></td>
<td><span><a href="mailto:$rlmain::adminemail">$rlmain::adminemail</a></span></td>
</tr>
</table>~;

} elsif ($rlmain::data{'submit'})	{
  ring::validation;
  if (!@rlmain::error)	{
    ring::create;
    rlmain::htmlize ($rlmain::data{'ringtitle'});
    my $newtitle = "</p><p style=\"font-weight: bold\">$rlmain::data{'ringtitle'}</p><p class=\"success\">";
    $rlmain::result = '<p class="success">' . sprintf (
      gettext("The ring %s was successfully created."), $newtitle) . '</p>';
  } else	{
    $rlmain::result = ring::form;
  }
} else	{
  { no strict 'refs';
    for (keys %rlmain::colors)	{
      $rlmain::data{$_} = ${'rlmain::' . $_};
    }
  }
  $rlmain::data{'ringURL'} = 'http://';
  $rlmain::data{'logoURL'} = 'http://';
  $rlmain::data{'allowsiteadd'} = 'on';
  $rlmain::data{'ringlang'} = $rlmain::lang;
  $rlmain::data{'sitesperlistpage'} = 25;
  $rlmain::data{'routine'} = 'New ring';
  $rlmain::result = ring::form;
}

$rlmain::pagetitle = gettext("Add new ring");
rlmain::adminhtml;

