##########################> Ringlink 2.0 <##########################
#                                                                  #
#  Ringlink is a CGI Perl program that provides the tools          #
#  necessary to run and administrate rings of websites.            #
#                                                                  #
#  Copyright (C) 2000, 2001 Gunnar Hjalmarsson,                    #
#  gunnar@ringlink.org; Version 2.0 released August 22, 2001       #
#  Ringlink homepage: http://www.ringlink.org/                     #
#                                                                  #
#  Ringlink is free software; you can redistribute it and/or       #
#  modify it under the terms of the GNU General Public License as  #
#  published by the Free Software Foundation; either version 2 of  #
#  the License, or (at your option) any later version.             #
#                                                                  #
#  Ringlink is distributed in the hope that it will be useful,     #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of  #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the    #
#  GNU General Public License for more details.                    #
#                                                                  #
#  You should have received a copy of the GNU General Public       #
#  License along with this program; if not, write to the Free      #
#  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,  #
#  MA  02111-1307  USA                                             #
#                                                                  #
####################################################################

package site;
$VERSION = '2.0';

use strict;
use Locale::PGetText;

sub LOCK_EX { 2 }
sub LOCK_UN { 8 }

sub form	{
  my ($siteid, $siteURLtext, $secondURL, $passvalues, $error);
  my $status = '';
  my $updated = '';
  my $siteidtext = '';
  my $blank = '';
  my $active_checked = '';
  my $inactive_checked = '';
  my $statustext = gettext("Status");
  my $activetext = gettext("Active");
  my $inactivetext = gettext("Inactive");
  my $updatedtext = gettext("Last updated");
  my $codeURL = gettext("HTML code URL");
  my $title = gettext("Site title");
  my $desc = gettext("Description");
  my $desc_maxchar = sprintf (gettext("max %d characters"), $rlmain::numcharsitedesc);
  my $keyw = gettext("Keywords");
  my $keyw_maxchar = gettext("optional; max 150 characters");
  my $idtext = gettext("Site ID");
  my $pw = gettext("Password");
  my $name = gettext("Name");
  my $name_expl = gettext("name of the site's webmaster");
  my $email = gettext("Email");
  my $email_expl = gettext("email address of the site's webmaster");
  my $submit = gettext("Submit");
  my $reset = gettext("Reset");
  foreach (@rlmain::sitenames)	{
    if ($rlmain::data{$_})	{
      rlmain::htmlize ($rlmain::data{$_});
    } else	{
      $rlmain::data{$_} = '';
    }
  }
  if ($rlmain::data{'routine'} ne 'New site')	{
    $siteid = "<span style=\"font-family: 'courier new', monospace\">$rlmain::data{'siteid'}</span>\n"
    . "<input type=\"hidden\" name=\"siteid\" value=\"$rlmain::data{'siteid'}\" />";
    if ($rlmain::action =~ /siteadmin/i && $rlmain::status eq 'inactive')	{
      $status = "<tr>\n<td><p>$statustext<br />"
      . "<span style=\"font-family: 'courier new', monospace\">$inactivetext</span></p>\n"
      . "<input type=\"hidden\" name=\"status\" value=\"$rlmain::data{'status'}\" /></td>";
    } else	{
      $active_checked = 'checked="checked"' if $rlmain::data{'status'} eq 'active';
      $inactive_checked = 'checked="checked"' if $rlmain::data{'status'} eq 'inactive';

      $status = qq~<tr>
<td><span>$statustext</span><br />
<input type="radio" $active_checked name="status" value="active">&nbsp;<span>$activetext</span>&nbsp;&nbsp;&nbsp;
<input type="radio" $inactive_checked name="status" value="inactive">&nbsp;<span>$inactivetext</span>&nbsp;&nbsp;&nbsp;</td>~;

    }
    $updated = "<td><p>$updatedtext<br />"
    . "<span style=\"font-family: 'courier new', monospace\">$rlmain::data{'updated'}</span></p>\n"
    . "<input type=\"hidden\" name=\"updated\" value=\"$rlmain::data{'updated'}\" /></td>\n</tr>";
  } else	{
    $siteidtext = '<span class="small">(' . gettext("letters and/or digits") . ')</span>';
    $siteid = "<input class=\"text\" type=\"text\" size=\"15\" maxlength=\"15\" "
    . "name=\"siteid\" value=\"$rlmain::data{'siteid'}\" />";
    $blank = '<span class="small">(' . gettext("leave blank if same as entry URL") . ')</span>';
  }
  if ($rlmain::hide2ndURL eq 'on' && ($rlmain::action =~ /siteadmin/i || $rlmain::action =~ /newsite/i))	{
    $siteURLtext = gettext("Site URL");
    $secondURL = "<input type=\"hidden\" name=\"codeURL\" value=\"$rlmain::data{'codeURL'}\" />";
  } else	{
    $siteURLtext = gettext("Site entry URL");

    $secondURL = qq~<tr>
<td colspan="2"><span>$codeURL </span>$blank<br />
<input class="text" type="text" size="45" name="codeURL" value="$rlmain::data{'codeURL'}" /></td>
</tr>~;

  }
  if ($rlmain::data{'pass'})	{

    $passvalues = qq~<input type="hidden" name="pass" value="$rlmain::data{'pass'}" />
<input type="hidden" name="completeinfo" value="$rlmain::data{'completeinfo'}" />
<input type="hidden" name="sitesperpage" value="$rlmain::data{'sitesperpage'}" />~;

  } else	{
    $passvalues = '';
  }
  $error = join ("\n", @rlmain::error);

  return qq~$error
<form method="POST" action="$rlmain::cgiURL/$rlmain::action">
<table>
<tr>
<td colspan="2"><span>$title</span><br />
<input class="text" type="text" size="45" maxlength="45" name="sitetitle" value="$rlmain::data{'sitetitle'}" /></td>
</tr>
<tr>
<td colspan="2"><span>$desc </span><span class="small">($desc_maxchar)</span><br />
<input class="text" type="text" size="45" maxlength="$rlmain::numcharsitedesc" name="sitedesc" value="$rlmain::data{'sitedesc'}" /></td>
</tr>
<tr>
<td colspan="2"><span>$keyw </span><span class="small">($keyw_maxchar)</span><br />
<input class="text" type="text" size="45" maxlength="150" name="keywords" value="$rlmain::data{'keywords'}" /></td>
</tr>
<tr>
<td colspan="2"><span>$siteURLtext</span><br />
<input class="text" type="text" size="45" name="entryURL" value="$rlmain::data{'entryURL'}" /></td>
</tr>
$secondURL
<tr>
<td><span>$idtext </span>$siteidtext<br />
$siteid</td>
<td><span>$pw</span><br />
<input class="text" type="text" size="15" maxlength="15" name="sitepw" value="$rlmain::data{'sitepw'}" /></td>
</tr>
<tr>
<td colspan="2"><span>$name </span><span class="small">($name_expl)</span><br />
<input class="text" type="text" size="45" maxlength="45" name="wmname" value="$rlmain::data{'wmname'}" /></td>
</tr>
<tr>
<td colspan="2"><span>$email </span><span class="small">($email_expl)</span><br />
<input class="text" type="text" size="45" name="wmemail" value="$rlmain::data{'wmemail'}" /></td>
</tr>
$status
$updated
</table>
<input type="hidden" name="ringid" value="$rlmain::data{'ringid'}" />
<input type="hidden" name="pw" value="$rlmain::data{'pw'}" />
<input type="hidden" name="routine" value="$rlmain::data{'routine'}" />
$passvalues
<p><div class="center">
<input type="submit" name="submit" value="$submit" />&nbsp;&nbsp;&nbsp;<input type="reset" value="$reset" />
</div></p>
</form>~;

}


sub validation	{
  foreach (@rlmain::sitenames)	{
    rlmain::trim ($rlmain::data{$_}) if $rlmain::data{$_};
  }
  if (!$rlmain::data{'sitetitle'})	{
    push (@rlmain::error, '<p class="error">' . gettext("You must enter Site title.") . '</p>');
  }
  if (!$rlmain::data{'sitedesc'})	{
    push (@rlmain::error, '<p class="error">' . gettext("You must enter Description.") . '</p>');
  }
  $rlmain::data{'keywords'} =~ s/[ ,;]+/ /g;
  $rlmain::data{'entryURL'} =~ s/\s+//g;
  if (!$rlmain::data{'entryURL'} || 'http://' =~ /$rlmain::data{'entryURL'}/)	{
    push (@rlmain::error, '<p class="error">' . gettext("You must enter Site entry URL.") . '</p>');
  } elsif ($rlmain::data{'entryURL'} !~ /^http\S*:\/\/\S+\.\S+/ || $rlmain::data{'entryURL'} =~ /["<>{}]/)	{
    push (@rlmain::error, '<p class="error">' . gettext("Site entry URL is not correctly filled.") . '</p>');
  }
  $rlmain::data{'codeURL'} =~ s/\s+//g;
  unless (!$rlmain::data{'codeURL'} || 'http://' =~ /$rlmain::data{'codeURL'}/)	{
    if ($rlmain::data{'codeURL'} !~ /^http\S*:\/\/\S+\.\S+/ || $rlmain::data{'codeURL'} =~ /["<>{}]/)	{
      push (@rlmain::error, '<p class="error">' . gettext("HTML code URL is not correctly filled.") . '</p>');
    }
  }
  unless ($rlmain::data{'routine'} ne 'New site')	{
    if (!$rlmain::data{'siteid'})	{
      push (@rlmain::error, '<p class="error">' . gettext("You must enter Site ID.") . '</p>');
    } elsif ($rlmain::data{'siteid'} =~ /\W/)	{
      push (@rlmain::error, '<p class="error">'
      . gettext("Site ID shall consist of letters and digits only.") . '</p>');
    } else	{ 
      rlmain::sitelist;
      foreach (@rlmain::sites)	{
        if ("\L$_" eq "\L$rlmain::data{'siteid'}")	{
          push (@rlmain::error, '<p class="error">' . sprintf (
            gettext("Site ID %s exists already. Choose another site ID."),
            "&quot;$rlmain::data{'siteid'}&quot;") . '</p>');
          last;
        }
      }
    }
  }
  if (!$rlmain::data{'sitepw'})	{
    push (@rlmain::error, '<p class="error">' . gettext("You must enter Password.") . '</p>');
  } elsif ($rlmain::data{'sitepw'} =~ / /)	{
    push (@rlmain::error, '<p class="error">' . gettext("Password must not contain spaces.") . '</p>');
  } elsif ($rlmain::data{'sitepw'} =~ /["<>{}]/)	{
    push (@rlmain::error, '<p class="error">' . gettext("Password contains forbidden characters.") . '</p>');
  }
  if (!$rlmain::data{'wmname'})	{
    push (@rlmain::error, '<p class="error">' . gettext("You must enter webmaster name.") . '</p>');
  }
  if (!$rlmain::data{'wmemail'})	{
    push (@rlmain::error, '<p class="error">' . gettext("You must enter webmaster email.") . '</p>');
  } elsif ($rlmain::data{'wmemail'} =~ / /)	{
    push (@rlmain::error, '<p class="error">' . gettext("Webmaster email must not contain spaces.") . '</p>');
  } elsif ($rlmain::data{'wmemail'} !~ /\S+\@\S+\.\S+/ || $rlmain::data{'wmemail'} =~ /["<>{}]/)	{
    push (@rlmain::error, '<p class="error">' . gettext("Webmaster email is not correctly filled.") . '</p>');
  } elsif ($rlmain::data{'wmemail'} =~ /\@[\S\s]*\@/)	{
    push (@rlmain::error, '<p class="error">' . gettext("You may enter one webmaster email only.") . '</p>');
  }
}


sub create	{
  my ($site, $mailcopy, $ringtitle, $body, @execfiles, $siteadmin);
  $rlmain::data{'codeURL'} = $rlmain::data{'entryURL'} if 'http://' =~ /$rlmain::data{'codeURL'}/
   || !$rlmain::data{'codeURL'};
  $rlmain::data{'status'} = 'inactive';
  $rlmain::data{'updated'} = rlmain::timestamp;
  { no strict 'refs';
    foreach (@rlmain::sitenames)	{
      $site .= "$rlmain::data{$_}\t";
      ${'rlmain::' . $_} = $rlmain::data{$_};
    }
  }
  $site =~ s/\t$/\n/;
  open (SITES, ">>$rlmain::datapath/$rlmain::ringid/sites.db")
   || rlmain::exit print gettext("Can't create") . " '$rlmain::ringid/sites.db'<br />\n$!";
  flock (SITES, LOCK_EX);
  print SITES $site;
  flock (SITES, LOCK_UN);
  close (SITES);
  chmod 0666, "$rlmain::datapath/$rlmain::ringid/sites.db";
  mkdir "$rlmain::datapath/$rlmain::ringid/$rlmain::data{'siteid'}", 0777
   || rlmain::exit print gettext("Can't create") . " '$rlmain::ringid/$rlmain::data{'siteid'}'<br />\n$!";
  chmod 0777, "$rlmain::datapath/$rlmain::ringid/$rlmain::data{'siteid'}";
  open (STATS, ">$rlmain::datapath/$rlmain::ringid/$rlmain::data{'siteid'}/rechits.db")
   || rlmain::exit print gettext("Can't create") . " '$rlmain::ringid/$rlmain::data{'siteid'}/rechits.db'<br />\n$!";
  flock (STATS, LOCK_EX);
  flock (STATS, LOCK_UN);
  close (STATS);
  chmod 0666, "$rlmain::datapath/$rlmain::ringid/$rlmain::data{'siteid'}/rechits.db";
  open (STATS, ">$rlmain::datapath/$rlmain::ringid/$rlmain::data{'siteid'}/genhits.db")
   || rlmain::exit print gettext("Can't create") . " '$rlmain::ringid/$rlmain::data{'siteid'}/genhits.db'<br />\n$!";
  flock (STATS, LOCK_EX);
  flock (STATS, LOCK_UN);
  close (STATS);
  chmod 0666, "$rlmain::datapath/$rlmain::ringid/$rlmain::data{'siteid'}/genhits.db";

  # Mail to webmaster
  $mailcopy = $rlmain::rmemail if $rlmain::action =~ /newsite/i;
  $ringtitle = rlmain::nameclean($rlmain::ringtitle);
  &substitute ($rlmain::htmlcode = rlmain::htmlcode);
  &substitute ($body = rlmain::addmail);
  $body =~ s/[\t ]*Keywords:\s*\n// if !$rlmain::keywords;
  rlmain::email (
    $rlmain::wmemail,
    $mailcopy,
    "$ringtitle <$rlmain::rmemail>",
    gettext("New site registered"),
    $body
  );

  # Prepare resulting page
  opendir(DIR, $rlmain::cgipath) || rlmain::exit print gettext("Can't open") . " $rlmain::cgipath<br />\n$!";
  @execfiles = grep { !/^\./ && (/\.pl$/i || /\.cgi$/i) } readdir(DIR);
  closedir DIR;
  for (@execfiles)	{
    $siteadmin = $_ if $_ =~ /^siteadmin\./i;
  }
  { no strict 'refs';
    for (@rlmain::sitenames)	{
      rlmain::htmlize (${'rlmain::' . $_}) if ${'rlmain::' . $_};
    }
    for (@rlmain::ringnames)	{
      rlmain::htmlize (${'rlmain::' . $_}) if ${'rlmain::' . $_};
    }
  }
  $rlmain::siteadmin = "<a href=\"$rlmain::cgiURL/$siteadmin?ringid=$rlmain::ringid;siteid=$rlmain::siteid;"
  . "pw=$rlmain::sitepw\"\ntarget=\"Ringlink\">" . gettext("Site admin") . '</a>';
  &substitute ($rlmain::addpage = rlmain::addpage);
}


sub update	{
  my ($site, @sites);
  my @newsites = ();
  if ('http://' =~ /$rlmain::data{'codeURL'}/ || !$rlmain::data{'codeURL'} || ($rlmain::hide2ndURL eq 'on'
  && ($rlmain::action =~ /siteadmin/i || $rlmain::action =~ /newsite/i) && $rlmain::entryURL eq $rlmain::codeURL))	{
    $rlmain::data{'codeURL'} = $rlmain::data{'entryURL'};
  }
  $rlmain::data{'updated'} = rlmain::timestamp;
  for (@rlmain::sitenames)	{
    $site .= "$rlmain::data{$_}\t";
  }
  $site =~ s/\t$/\n/;
  open (SITES, "$rlmain::datapath/$rlmain::ringid/sites.db")
   || rlmain::exit print gettext("Can't open") . " '$rlmain::ringid/sites.db'<br />\n$!";
  @sites = <SITES>;
  close (SITES);
  for (@sites)	{
    if ($_ =~ /^$rlmain::siteid\t/)	{
      push (@newsites, $site);
    } else	{
      push (@newsites, $_);
    }
  }
  open (SITES, ">$rlmain::datapath/$rlmain::ringid/sites.db")
   || rlmain::exit print gettext("Can't open") . " '$rlmain::ringid/sites.db'<br />\n$!";
  flock (SITES, LOCK_EX);
  print SITES @newsites;
  flock (SITES, LOCK_UN);
  close (SITES);
}


sub statuschangemail	{
  my ($ringtitle, $subject, $text, $body);
  my $passvalues = '';
  my $notify = gettext("Notify the webmaster of the status change:");
  my $send = gettext("Send");
  my $cancel = gettext("Cancel");
  if ($rlmain::data{'submit'} eq gettext("Send"))	{
    $ringtitle = rlmain::nameclean($rlmain::ringtitle);
    rlmain::email (
      $rlmain::wmemail,
      $rlmain::rmemail,
      "$ringtitle <$rlmain::rmemail>",
      $rlmain::data{'subject'},
      $rlmain::data{'body'}
    );
    if ($rlmain::data{'pass'})	{
      push (@rlmain::error, '<p class="success">' . gettext("Message sent") . '</p>');
      rlmain::getringvalues if $rlmain::action =~ /^admin\./i;
      if ($rlmain::data{'pass'} eq 'active')	{
        $rlmain::data{'routine'} = 'Active sites';
        $rlmain::data{'siteid'} = '';
        $rlmain::nolist = 1;
        ring::Active_sites();
      } elsif ($rlmain::data{'pass'} eq 'inactive')	{
        $rlmain::data{'routine'} = 'Inactive sites';
        $rlmain::data{'siteid'} = '';
        ring::Inactive_sites();
      } elsif ($rlmain::data{'pass'} eq 'check')	{
        $rlmain::data{'routine'} = 'Check sites';
        ring::Check_sites();
      }
    } else	{
      $rlmain::result = '<p class="success">' . gettext("Message sent") . '</p>';
    }
  } elsif ($rlmain::data{'submit'} eq gettext("Cancel"))	{
    if ($rlmain::data{'pass'})	{
      push (@rlmain::error, '<p class="success">' . gettext("No message was sent.") . '</p>');
      rlmain::getringvalues if $rlmain::action =~ /^admin\./i;
      if ($rlmain::data{'pass'} eq 'active')	{
        $rlmain::data{'routine'} = 'Active sites';
        $rlmain::data{'siteid'} = '';
        $rlmain::nolist = 1;
        ring::Active_sites();
      } elsif ($rlmain::data{'pass'} eq 'inactive')	{
        $rlmain::data{'routine'} = 'Inactive sites';
        $rlmain::data{'siteid'} = '';
        ring::Inactive_sites();
      } elsif ($rlmain::data{'pass'} eq 'check')	{
        $rlmain::data{'routine'} = 'Check sites';
        ring::Check_sites();
      }
    } else	{
      $rlmain::result = '<p class="success">' . gettext("No message was sent.") . '</p>';
    }
  } else	{
    if ($rlmain::data{'pass'})	{
      $rlmain::pagemenu = ring::menu();

      $passvalues = qq~<input type="hidden" name="pass" value="$rlmain::data{'pass'}" />
<input type="hidden" name="completeinfo" value="$rlmain::data{'completeinfo'}" />
<input type="hidden" name="sitesperpage" value="$rlmain::data{'sitesperpage'}" />~;

    }
    if ($rlmain::data{'status'} eq 'active')	{
      $subject = sprintf (gettext("Site ID %s activated"), "\'$rlmain::siteid\'");
      $text = sprintf (gettext("Your site %s has been approved and is now\nan active site in the webring %s."),
        "&quot;$rlmain::sitetitle&quot;", "&quot;$rlmain::ringtitle&quot;");
    } else	{
      $subject = sprintf (gettext("Site ID %s deactivated"), "\'$rlmain::siteid\'");
      $text = sprintf (
        gettext("Your site %s at %s has been assigned the status\n&quot;Inactive&quot; in the webring %s. Please let\nme know if you don't understand the reason for it."),
        "&quot;$rlmain::sitetitle&quot;", $rlmain::entryURL, "&quot;$rlmain::ringtitle&quot;");
    }
    $body = "$text\n\n$rlmain::ringtitle\n$rlmain::rmname\n$rlmain::ringURL\n";

    return qq~<p>$notify</p>
<form method="POST" action="$rlmain::cgiURL/$rlmain::action">
<textarea name="body" rows="15" cols="65" wrap="hard">
$body</textarea>
<input type="hidden" name="pw" value="$rlmain::data{'pw'}" />
<input type="hidden" name="siteid" value="$rlmain::data{'siteid'}" />
<input type="hidden" name="ringid" value="$rlmain::data{'ringid'}" />
<input type="hidden" name="routine" value="statuschangemail" />
<input type="hidden" name="subject" value="$subject" />
$passvalues
<p><input type="submit" name="submit" value="$send" />
&nbsp;&nbsp;&nbsp;<input type="submit" name="submit" value="$cancel" /></p>
</form>~;

  }
}


sub menu	{
  my $masteradmin = '';
  my $ringadmin = '';
  my $viewstats = '';
  my $ring = gettext("Ring:");
  my $site = gettext("Site:");
  my $master = gettext("Master admin");
  my $ringadm = gettext("Ring admin");
  my $getcode = gettext("Get code");
  my $edit = gettext("Edit site");
  my $view = gettext("View stats");
  my $remove = gettext("Remove site");
  $rlmain::pagetitle = gettext("Site admin");
  rlmain::htmlize ($rlmain::ringtitle);
  rlmain::htmlize ($rlmain::sitetitle);
  rlmain::htmlize ($rlmain::wmname);

  $rlmain::ring_site = qq~<table cellspacing="8">
<tr>
<td><span>$ring</span></td>
<td><span><a href="$rlmain::ringURL" target="Ringlink">$rlmain::ringtitle</a></span></td>
</tr><tr>
<td><span>$site</span></td>
<td><span><a href="$rlmain::entryURL" target="Ringlink">$rlmain::sitetitle</a></span></td>
</tr>
</table>~;

  if ($rlmain::action =~ /^admin/i)	{
    $masteradmin = "<input class=\"button\" width=\"130\" type=\"submit\" value=\"$master\" />";
    $ringadmin = "<input class=\"button\" width=\"130\" type=\"submit\" name=\"routine\" value=\"$ringadm\" />";
  } elsif ($rlmain::action =~ /ringadmin/i)	{
    $ringadmin = "<input class=\"button\" width=\"130\" type=\"submit\" value=\"$ringadm\" />";
  }
  if ($rlmain::stats)	{
    $viewstats = "<input class=\"button\" width=\"130\" type=\"submit\" name=\"routine\" value=\"$view\" />";
  }

  return qq~$masteradmin
$ringadmin
<hr /><br /><input type="hidden" name="pw" value="$rlmain::data{'pw'}" />
<input type="hidden" name="siteid" value="$rlmain::data{'siteid'}" />
<input type="hidden" name="ringid" value="$rlmain::data{'ringid'}" />
<input class="button" width="130" type="submit" name="routine" value="$getcode" />
<input class="button" width="130" type="submit" name="routine" value="$edit" />
$viewstats
<input class="button" width="130" type="submit" name="routine" value="$remove" />~;

}


sub substitute	{
  no strict 'refs';
  for my $subst (@rlmain::ringsubstitutes, @rlmain::sitesubstitutes)	{
    $_[0] =~ s/\[$subst\]/${'rlmain::' . $subst}/g;
  }
}


sub htmlcode	{
  my ($introduction, $htmlcode, $codeformat);
  my $normalintro = gettext("To have the normal format back, click here:");
  my $normal = gettext("Normal");
  my $onelineintro = gettext("If you prefer to get the code as one single line, click here:");
  my $oneline = gettext("One line");
  my $header = gettext("Get code");
  &substitute ($introduction = rlmain::codepage);
  &substitute ($rlmain::htmlcode);
  my $appear = gettext("The code appears like this:");
  $htmlcode = $rlmain::htmlcode;
  if ($rlmain::data{'submit'} eq gettext("One line"))	{
    for ($rlmain::htmlcode)	{
      s/>\s*\n\s*</></g;
      s/\s*\n\s*/ /g;
      s/^\s+//;
      s/\s+$//;
    }

    $codeformat = qq~<p>$normalintro<br />
<input type="submit" value="$normal" /></p>~;

  } else	{

    $codeformat = qq~<p>$onelineintro<br />
<input type="submit" name="submit" value="$oneline" /></p>~;

  }
  rlmain::htmlize ($rlmain::htmlcode);

  return qq~<h4>$header</h4>
$introduction
<form method="POST" action="$rlmain::cgiURL/$rlmain::action">
$codeformat
<textarea name="code" rows="10" cols="45" wrap="off">
$rlmain::htmlcode</textarea>
<input type="hidden" name="siteid" value="$rlmain::data{'siteid'}" />
<input type="hidden" name="ringid" value="$rlmain::data{'ringid'}" />
<input type="hidden" name="pw" value="$rlmain::data{'pw'}" />
<input type="hidden" name="routine" value="$rlmain::data{'routine'}" />
<br /><br />
<span>$appear<br />
</span>

$htmlcode
</form>~;

}


sub getstats	{
  my @sitestats = rlmain::getstats ("$rlmain::datapath/$rlmain::ringid/$rlmain::siteid");
  my $gen = &calcstats ($sitestats[0], $sitestats[1]);
  my $rec = &calcstats ($sitestats[2], $sitestats[3]);
  my $header = gettext("View stats");
  my $contribute = gettext("contributed");
  my $receive = gettext("received");
  return '<h4>' . gettext("View stats") . "</h4>\n<p>" . sprintf (
    gettext("This site has %s to the ring traffic with %s when visitors\nhave clicked the links on the navigation panel for %s, and\nit has %s as a result of its membership in the ring."),
    "</p>\n<p><span style=\"font-weight: bold\">$contribute</span>", "<br />\n$gen</p>\n<p>",
    "<br />\n<span style=\"font-weight: bold\">$rlmain::ringtitle</span>",
    "</p>\n<p><span style=\"font-weight: bold\">$receive</span><br />\n$rec</p>\n<p>") . '</p>';
}


sub calcstats	{
  my ($numdays, $count) = @_;
  my @months = (gettext("January"), gettext("February"), gettext("March"), gettext("April"),
               gettext("May"), gettext("June"), gettext("July"), gettext("August"),
               gettext("September"), gettext("October"), gettext("November"), gettext("December"));
  my @timelist = gmtime (time - ($numdays > 1 ? ($numdays - 2)*60*60*24 : 0));
  my $average;
  if ($numdays >= 3)	{
    my ($sec, $min, $hour) = gmtime;
    my $adjnumdays = $numdays - 2 + ($hour*60*60 + $min*60 + $sec) / (24*60*60);
    $average = sprintf ("%.0f", $count / $adjnumdays);
  }
  if ($numdays < 3)	{
    return '<span style="font-weight: bold">' .
      sprintf (gettext("%s hits since %s"), "$count</span>", "$timelist[3] $months[$timelist[4]]");
  } elsif ($numdays < 32)	{
    return '<span style="font-weight: bold">' .
      sprintf (gettext("%s hits, or %s hits per day,\nsince %s"), "$count</span>",
      "<span style=\"font-weight: bold\">$average</span>", "$timelist[3] $months[$timelist[4]]");
  } else	{
    return '<span style="font-weight: bold">' .
      sprintf (gettext("%s hits, or %s hits per day,\nduring the last 30 days"),
      "$count</span>", "<span style=\"font-weight: bold\">$average</span>");
  }
}


sub removeform	{
  my $cancelbutton;
  my $emailnote = '';
  my $emailnote_yes = '';
  my $emailnote_no = '';
  my $passvalues = '';
  my $notify = gettext("Notify the webmaster?");
  my $yes = gettext("Yes");
  my $no = gettext("No");
  my $remove = gettext("Remove");
  my $cancel = gettext("Cancel");
  my $header = gettext("Remove site");
  my $surequery = gettext("Are you sure you want to remove this site?");
  my $sure = gettext("I am sure.");
  $rlmain::pagemenu = &menu;
  if ($rlmain::action =~ /^admin/i || $rlmain::action =~ /ringadmin/i)	{
    if (!$rlmain::data{'submit'})	{
      $emailnote_yes = 'checked="checked"';
      my $text = sprintf (gettext("Your site %s has been removed from the webring %s."),
        "&quot;$rlmain::sitetitle&quot;", "&quot;$rlmain::ringtitle&quot;");
      $rlmain::data{'body'} = "$text\n\n$rlmain::ringtitle\n$rlmain::rmname\n$rlmain::ringURL\n";
    } else	{
      $emailnote_yes = 'checked="checked"' if $rlmain::data{'emailnote'} eq 'yes';
      $emailnote_no = 'checked="checked"' if $rlmain::data{'emailnote'} eq 'no';
      rlmain::htmlize ($rlmain::data{'body'}) if $rlmain::data{'body'};
    }

    $emailnote = qq~<span>$notify</span>&nbsp;&nbsp;&nbsp;
<input type="radio" $emailnote_yes name="emailnote" value="yes">
<span>$yes</span>&nbsp;&nbsp;&nbsp;
<input type="radio" $emailnote_no name="emailnote" value="no">
<span>$no</span><br />
<textarea name="body" rows="10" cols="65" wrap="hard">
$rlmain::data{'body'}</textarea>~;

    if ($rlmain::data{'pass'})	{

      $passvalues = qq~<input type="hidden" name="pass" value="$rlmain::data{'pass'}" />
<input type="hidden" name="completeinfo" value="$rlmain::data{'completeinfo'}" />
<input type="hidden" name="sitesperpage" value="$rlmain::data{'sitesperpage'}" />~;

    }
  }
  $cancelbutton = ($rlmain::data{'pass'} eq 'check' ?
   "<input type=\"button\" value=\"$cancel\" onClick=\"window.close()\" />" :
   "<input type=\"submit\" name=\"submit\" value=\"$cancel\" />");

  $rlmain::result = qq~<h4>$header</h4>
@rlmain::error
<form method="POST" action="$rlmain::cgiURL/$rlmain::action">
<p>$surequery<br />
<input type="checkbox" name="removesure" />&nbsp;<span>$sure</span></p>
$emailnote
<input type="hidden" name="pw" value="$rlmain::data{'pw'}" />
<input type="hidden" name="siteid" value="$rlmain::data{'siteid'}" />
<input type="hidden" name="ringid" value="$rlmain::data{'ringid'}" />
<input type="hidden" name="routine" value="Remove site" />
$passvalues
<p><input type="submit" name="submit" value="$remove" />
&nbsp;&nbsp;&nbsp;$cancelbutton</p>
</form>~;

}


sub remove	{
  open (SITES, "$rlmain::datapath/$rlmain::ringid/sites.db")
   || rlmain::exit print gettext("Can't open") . " '$rlmain::ringid/sites.db'<br />\n$!";
  my @sites = <SITES>;
  close (SITES);
  my $i = 0;
  for (@sites)	{
    if ($_ =~ /^$rlmain::siteid\t/)	{
      splice (@sites, $i, 1);
      last;
    }
    $i++;
  }
  open (SITES, ">$rlmain::datapath/$rlmain::ringid/sites.db")
   || rlmain::exit print gettext("Can't open") . " '$rlmain::ringid/sites.db'<br />\n$!";
  flock (SITES, LOCK_EX);
  print SITES @sites;
  flock (SITES, LOCK_UN);
  close (SITES);
  my $dir = "$rlmain::datapath/$rlmain::ringid/$rlmain::siteid";
  for ('genhits.db', 'rechits.db')	{
    unlink ("$dir/$_") || rlmain::exit print gettext("Can't remove") . " '$rlmain::ringid/$rlmain::siteid/$_'<br />\n$!";
  }
  rmdir $dir || rlmain::exit print gettext("Can't remove") . " '$rlmain::ringid/$rlmain::siteid'<br />\n$!";
}


sub removemail	{ # to the webmaster
  if ($rlmain::data{'emailnote'} eq 'yes')	{
    my $title=rlmain::nameclean($site::ringtitle);
    rlmain::email (
      $rlmain::wmemail,
      $rlmain::rmemail,
      "$title <$rlmain::rmemail>",
      sprintf (gettext("Site ID %s removed"), "\'$rlmain::siteid\'"),
      $rlmain::data{'body'}
    );
  }
}


sub removemail2	{ # to the ringmaster
  my $body = sprintf (gettext("The site %s, site ID %s, has been\nremoved from the webring %s."),
    "&quot;$rlmain::sitetitle&quot;", $rlmain::siteid, "&quot;$rlmain::ringtitle&quot;");
  my $title=rlmain::nameclean($site::ringtitle);
  rlmain::email (
    $rlmain::rmemail,
    '',
    "$title <$rlmain::rmemail>",
    gettext("Site removed"),
    $body
  );
}


1;

