##########################> Ringlink 2.0 <##########################
#                                                                  #
#  Ringlink is a CGI Perl program that provides the tools          #
#  necessary to run and administrate rings of websites.            #
#                                                                  #
#  Copyright (C) 2000, 2001 Gunnar Hjalmarsson,                    #
#  gunnar@ringlink.org; Version 2.0 released August 22, 2001       #
#  Ringlink homepage: http://www.ringlink.org/                     #
#                                                                  #
#  Ringlink is free software; you can redistribute it and/or       #
#  modify it under the terms of the GNU General Public License as  #
#  published by the Free Software Foundation; either version 2 of  #
#  the License, or (at your option) any later version.             #
#                                                                  #
#  Ringlink is distributed in the hope that it will be useful,     #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of  #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the    #
#  GNU General Public License for more details.                    #
#                                                                  #
#  You should have received a copy of the GNU General Public       #
#  License along with this program; if not, write to the Free      #
#  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,  #
#  MA  02111-1307  USA                                             #
#                                                                  #
####################################################################

package rlmain;
$VERSION = '2.0';
$rlmain::version = $VERSION;

use strict;

use rlconfig;
use mainhtml;
use admhtml;
use mailhtml;
use Locale::PGetText;

BEGIN	{
# To facilitate debugging, the preceding # characters at the five
# lines below can be removed:

 # set_message(\&handle_errors);
 # use CGI::Carp qw(carpout set_message);
 # open(LOG, ">>ERRORMSG.TXT") || die "Can't write to ERRORMSG.TXT; $!\n";
 # carpout(\*LOG);
 # $^W = 1;

# Ensure, though, that those lines are commented out in production
# installations.

  sub handle_errors	{
    my $msg = shift;
    print "<h1>Error!</h1>\n";
    print $msg;
    print "<p>You might find more details in ERRORMSG.TXT in the directory with the *.pl or *.cgi files.";
  }

  sub exit {
    if ($ENV{MOD_PERL}) {
      require Apache;
      Apache::exit();
    }

    exit;
  }
}

sub execstart	{
  # initialize certain global variables to ensure that they are empty
  # and/or can be used without warnings
  $rlmain::data = '';
  $rlmain::pagetitle = '';
  $rlmain::ring_site = '';
  $rlmain::pagemenu = '';
  $rlmain::result = '';
  $rlmain::htmlprint = '';
  $rlmain::sendmail = '';
  $rlmain::smtpserver = '';
  $rlmain::allowringadd = 0;
  $rlmain::stats = 0;
  $rlmain::nolist = 0;
  $rlmain::logoURL = '';
  $rlmain::allowsiteadd = '';
  $rlmain::hide2ndURL = '';
  $rlmain::sitetitle = '';
  $rlmain::siteid = '';
  $rlmain::sitedesc = '';
  $rlmain::entryURL = '';
  $rlmain::codeURL = '';
  $rlmain::ringlang = '';
  $rlmain::browserlang = 0;
  @rlmain::inactivesites = ();
  @rlmain::error = ();
  %rlmain::lang = ();
  %rlmain::routines = ();
  %rlmain::data = ();
  my @datakeys = qw/pw submit pass removesure routine allowsiteadd hide2ndURL completeinfo sitesperpage result
                    ordnumb startsite method next prev list rand next5 prev5 home limit status separator ringid
                    offset siteid entryURL codeURL/;
  for (@datakeys)	{
    $rlmain::data{$_} = '';
  }
  $rlmain::data{'timeout'} = 0;
  $rlmain::data{'maxsites'} = 0;


  # Set name of the executable
  ($rlmain::action = $ENV{'SCRIPT_FILENAME'} ? $ENV{'SCRIPT_FILENAME'} : $0) =~ s/\\/\//g;
  $rlmain::action =~ s/(.*)\///;
  $rlmain::cgipath = $1;

  # Get system variables from rlconfig.pm
  rlconfig::systemvar;

  # Check whether path to the executables is set
  unless ($rlmain::cgipath)	{
    print "Content-type: text/plain\n\n" . 'The $rlmain::cgipath variable is empty.'
    . ' Set it explicitly in the rlconfig.pm file.';
    rlmain::exit;
  }

  # Remove possible trailing slashes
  for ($rlmain::cgiURL, $rlmain::cgipath, $rlmain::datapath)	{
    $_ =~ s/\/$//;
  }

  # Set constants
  my @ringcolornames = qw/colbg coltablebg coltxt colemph colerr collink colvlink/;

  @rlmain::ringnames = ('ringid', 'ringtitle', 'ringdesc', 'ringURL', 'ringpw', 'rmname', 'rmemail',
                       'allowsiteadd', 'sitesperlistpage', 'logoURL', 'logowidth', 'logoheight',
                       @ringcolornames, 'hide2ndURL', 'ringlang');

  @rlmain::sitenames = qw/siteid status sitetitle sitedesc keywords entryURL codeURL
                          sitepw wmname wmemail updated/;

  @rlmain::ringsubstitutes = qw/ringtitle ringURL rmname rmemail/;
  @rlmain::sitesubstitutes = qw/siteid sitetitle sitedesc keywords entryURL codeURL
                                sitepw wmname wmemail siteadmin htmlcode/;

  my @routinebuttonvalues = ('New ring', 'Ring admin', 'Reset stats', 'Active sites', 'Inactive sites',
                            'Check sites', 'Reorder sites', 'Send email', 'Edit ring', 'Customize',
                            'Remove ring', 'New site', 'Site admin', 'Appearance', 'HTML code', 'Add page',
                            'Add mail', 'Code page', 'Get code', 'Edit site', 'View stats', 'Remove site');

  # Set colors to default
  { no strict 'refs';
    for (keys %rlmain::colors)	{
      ${'rlmain::' . $_} = $rlmain::colors{$_};
    }
  }

  # Language fix
  Locale::PGetText::dbmselect;
  Locale::PGetText::setLocaleDir ("$rlmain::cgipath/lang/mo");
  opendir(DIR, "$rlmain::cgipath/lang/mo")
   || rlmain::exit print "Content-type: text/html\n\n" . "Can't open $rlmain::cgipath/lang/mo<br />\n$!";
  my @pofiles = grep { /^\w{2}(\.\w+)?/ } readdir(DIR);
  closedir DIR;
  for my $po (@pofiles)	{
    $po =~ s/^(\w{2}).*/$1/;
    $rlmain::lang{$po} = $po;
  }
  if ($rlmain::action =~ /admin\./i)	{
    my $localstring;
    for (keys %rlmain::lang)	{
      Locale::PGetText::setLanguage ($_);
      for (@routinebuttonvalues)	{
        $localstring = gettext($_);
        for ($localstring)	{
          s/&quot;/"/g;
          s/&#34;/"/g;
        }
        $rlmain::routines{$localstring} = $_;
      }
    }
    for ('Activate','Deactivate','Active_sites','Inactive_sites','Edit_site','Remove_site','statuschangemail')	{
      $rlmain::routines{$_} = $_;
    }
  }
  if ($ENV{'HTTP_ACCEPT_LANGUAGE'})	{
    for ('next', 'list', 'goto', 'home', 'rand', 'prev', 'skip')	{
      if ($rlmain::action =~ /^$_/i)	{
        my @browserlang = split (/,/, $ENV{'HTTP_ACCEPT_LANGUAGE'});
        for (@browserlang)	{
          my $browserlang = substr ($_, 0, 2);
          if ($rlmain::lang{$browserlang})	{
            Locale::PGetText::setLanguage ($browserlang);
            $rlmain::browserlang = 1;
            last;
          }
        }
        last;
      }
    }
  }
  Locale::PGetText::setLanguage ($rlmain::lang) unless $rlmain::browserlang;

  # This line was used in a SSL experiment where the admin procedures were run
  # through a secure server. However, I haven't figured out yet how to make the
  # use of SSL to interact with images (ring logo and/or images in the HTML code).
  #$rlmain::cgiURL = 'https://rbro4.securesites.com/gunnar/cgi-bin/ringlink' if $rlmain::action =~ /admin\./i;

  # Read indata
  if ($ENV{'REQUEST_METHOD'} eq 'POST')	{
    read (STDIN, $rlmain::data, $ENV{'CONTENT_LENGTH'});
  } else	{
    $rlmain::data = $ENV{'QUERY_STRING'};
  }
  $rlmain::data =~ s/\+/ /g;
  my @data = split(/[&;]/, $rlmain::data);
  foreach (@data)	{
    my ($name, $value) = split(/=/);
    $name = 'ringid' if $name =~ /^ringid$/i;
    $name = 'siteid' if $name =~ /^siteid$/i;
    $name = 'offset' if $name =~ /^offset$/i;
    $value =~ s/%(..)/pack("c",hex($1))/ge;
    $rlmain::data{$name} = $value;
  }

  # HTTP header
  for ('next', 'prev', 'rand', 'home', 'goto', 'skipnext', 'skipprev')	{
    if ($rlmain::action =~ /^$_\./i)	{
      $rlmain::htmlprint = "Content-type: text/html\n\n";
      last;
    }
  }
  for ('list', 'next5', 'prev5', 'admin', 'ringadmin', 'siteadmin', 'newring', 'newsite')	{
    if ($rlmain::action =~ /^$_\./i)	{
      print "Content-type: text/html\n\n" unless $rlmain::data{'details'};
      last;
    }
  }
}


sub LOCK_EX { 2 }
sub LOCK_UN { 8 }

sub trim	{
  $_[0] =~ s/^\s+//;
  $_[0] =~ s/\s+$//;
  $_[0] =~ s/\s+/ /g;
  return $_[0];
}

sub htmlize	{
  $_[0] =~ s/&/&amp;/g;
  $_[0] =~ s/\"/&quot;/g;
  $_[0] =~ s/</&lt;/g;
  $_[0] =~ s/>/&gt;/g;
  return $_[0];
}

sub nameclean {
  my $name=shift;
  if ($name =~ m/[^ \w]/) {
    $name=~tr/\"/\'/;
    $name=qq{"$name"};
  }
  $name
}

sub ringlist	{
  opendir(DIR, $rlmain::datapath) || rlmain::exit print $rlmain::htmlprint
  . gettext("Can't open data directory");
  @rlmain::rings = grep { !/^\./ && -d "$rlmain::datapath/$_" } readdir(DIR);
  closedir DIR;
  if ($rlmain::data{'ringid'})	{
    for (@rlmain::rings)	{
      $rlmain::data{'ringid'} = $_ if $rlmain::data{'ringid'} =~ /^$_$/i;
    }
  }
}

sub ringselect	{
  my $selectid = gettext("Select ring ID");
  my $startselect = '';
  $startselect = "\n<option selected=\"selected\" value=\"\">- $selectid -</option>" if !$rlmain::data{'ringid'};
  $rlmain::ringselect = "<select name=\"ringid\" size=\"1\">$startselect\n";
  foreach (@rlmain::rings)	{
    if ($_ eq $rlmain::data{'ringid'})	{
      $rlmain::ringselect .= "<option selected=\"selected\" value=\"$_\">$_</option>\n";
    } else	{
      $rlmain::ringselect .= "<option value=\"$_\">$_</option>\n";
    }
  }
  $rlmain::ringselect .= '</select>';
}

sub noring	{
  my $noring = gettext("No ring has been registered yet.");
  return "<p class=\"error\">$noring</p>";
}

sub getringvalues	{
  open (RING, "$rlmain::datapath/$rlmain::data{'ringid'}/ring.db") || rlmain::exit print $rlmain::htmlprint
  . gettext("Can't open") . " '$rlmain::data{'ringid'}/ring.db'<br />\n$!";
  my @ringvalues = <RING>;
  close (RING);
  chomp @ringvalues;
  { no strict 'refs';
    for (@rlmain::ringnames)	{
      ${'rlmain::' . $_} = shift (@ringvalues);
    }
  }
  if ($rlmain::ringlang && $rlmain::lang{$rlmain::ringlang} && !$rlmain::browserlang)	{
    Locale::PGetText::setLanguage ($rlmain::ringlang);
  }
}

sub sitelist	{
  opendir(DIR, "$rlmain::datapath/$rlmain::data{'ringid'}") || rlmain::exit print $rlmain::htmlprint
  . gettext("Can't open") . " '$rlmain::data{'ringid'}'<br />\n$!";
  @rlmain::sites = grep { !/^\./ && -d "$rlmain::datapath/$rlmain::data{'ringid'}/$_" } readdir(DIR);
  closedir DIR;
  if ($rlmain::data{'siteid'})	{
    for (@rlmain::sites)	{
      $rlmain::data{'siteid'} = $_ if $rlmain::data{'siteid'} =~ /^$_$/i;
    }
  }
}

sub getsitevalues	{
  open (SITES, "$rlmain::datapath/$rlmain::data{'ringid'}/sites.db") || rlmain::exit print $rlmain::htmlprint
  . gettext("Can't open") . " '$rlmain::data{'ringid'}/sites.db'<br />\n$!";
  my @sites = <SITES>;
  close (SITES);
  no strict 'refs';
  for (@sites)	{
    if ($_ =~ /^$rlmain::data{'siteid'}\t/)	{
      chomp $_;
      my @sitevalues = split (/\t/, $_);
      for (@rlmain::sitenames)	{
        ${'rlmain::' . $_} = shift (@sitevalues);
      }
      last;
    }
  }
}

sub timestamp	{
  my ($sec,$min,$hour,$mday,$mon,$year) = gmtime(time);
  my @months = qw/Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec/;
  $year += 1900;
  $hour = sprintf("%02d", $hour);
  $min = sprintf("%02d", $min);
  $sec = sprintf("%02d", $sec);
  return "$mday $months[$mon] $year $hour:$min:$sec GMT";
}

sub mainhtml	{
  if ('http://' !~ /$rlmain::logoURL/)	{
    $rlmain::ringlogo = "<img src=\"$rlmain::logoURL\" style=\"float: right\" "
    . "width=\"$rlmain::logowidth\" height=\"$rlmain::logoheight\" alt=\"$rlmain::ringtitle\" />";
  } else	{
    $rlmain::ringlogo = '';
  }
  print $rlmain::htmlprint if $rlmain::htmlprint;
  mainhtml::listpage;
}

sub adminhtml	{
  if ($rlmain::pagetitle)	{
    $rlmain::titlesep = '&nbsp;&nbsp;-&nbsp;&nbsp;';
  } else	{
    $rlmain::titlesep = '';
  }
  if ($rlmain::colbg eq $rlmain::colors{'colbg'} && $rlmain::coltablebg eq $rlmain::colors{'coltablebg'})	{
    $rlmain::margcoltablebg = $rlmain::leftpanecolors{'tablebg'};
    $rlmain::margcoltxt = $rlmain::leftpanecolors{'txt'};
    $rlmain::margcollink = $rlmain::leftpanecolors{'link'};
    $rlmain::margcolvlink = $rlmain::leftpanecolors{'vlink'};
  } else	{
    $rlmain::margcoltablebg = $rlmain::coltablebg;
    $rlmain::margcoltxt = $rlmain::coltxt;
    $rlmain::margcollink = $rlmain::collink;
    $rlmain::margcolvlink = $rlmain::colvlink;
  }
  print $rlmain::htmlprint if $rlmain::htmlprint;
  admhtml::adminpage;
}

sub emailhtml	{
  if ($rlmain::pagetitle)	{
    $rlmain::titlesep = '&nbsp;&nbsp;-&nbsp;&nbsp;';
  } else	{
    $rlmain::titlesep = '';
  }
  if ($rlmain::colbg eq $rlmain::colors{'colbg'} && $rlmain::coltablebg eq $rlmain::colors{'coltablebg'})	{
    $rlmain::margcolor = $rlmain::leftpanecolors{'tablebg'};
  } else	{
    $rlmain::margcolor = '$rlmain::coltablebg';
  }
  mailhtml::emailpage;
}

sub email	{
  my ($to, $bcc, $subject, $msg);
  my $extras = '';
  ($to, $bcc, $rlmain::from, $subject, $msg) = @_;
  unless ($rlmain::from =~ /$rlmain::adminemail/)	{
    $rlmain::mailtitle = rlmain::nameclean($rlmain::title);
    $extras = "Sender: $rlmain::mailtitle <$rlmain::adminemail>";
  }
  my $CRLF = $rlmain::sendmail ? "\n" : "\r\n";
  $extras .= ($extras ? $CRLF : '') . "X-Originating-IP: [$ENV{'REMOTE_ADDR'}]" if $ENV{'REMOTE_ADDR'};
  if ($rlmain::sendmail)	{
    open (MAIL, "| $rlmain::sendmail -oi -t -odb")
     || rlmain::exit print sprintf (gettext("Can't open pipe to %s"), $rlmain::sendmail) . "<br />\n$!";
    print MAIL "To: $to\n";
    print MAIL "From: $rlmain::from\n";
    print MAIL "bcc: $bcc\n" if $bcc;
    print MAIL "$extras\n" if $extras;
#    print MAIL "Errors-To: $from\n";
    print MAIL "Subject: $subject\n\n";
    print MAIL "$msg\n";
    close (MAIL);
  } else	{
    require Mail::Sender;
    undef $Mail::Sender::SITE_HEADERS;
    $Mail::Sender::SITE_HEADERS = $extras if $extras;
    $Mail::Sender::NO_X_MAILER = 1;
    my $ms = new Mail::Sender ({smtp => $rlmain::smtpserver, from => $rlmain::from})
     || rlmain::exit print "new Error: $Mail::Sender::Error<br />\n$!";
    $ms -> MailMsg ({to => $to, ($bcc ? 'bcc' : '') => $bcc, subject => $subject, msg => $msg})
     || rlmain::exit print "send Error: $Mail::Sender::Error<br />\n$!";
  }
}

sub htmlcode	{
  open (CODE, "$rlmain::datapath/$rlmain::data{'ringid'}/htmlcode.txt")
   || rlmain::exit print gettext("Can't open") . " '$rlmain::data{'ringid'}/htmlcode.txt'<br />\n$!";
  my @code = <CODE>;
  close (CODE);
  return &varconvert (join ('', @code));
}

sub addpage	{
  open (MSG, "$rlmain::datapath/$rlmain::data{'ringid'}/addpage.txt")
   || rlmain::exit print gettext("Can't open") . " '$rlmain::data{'ringid'}/addpage.txt'<br />\n$!";
  my @msg = <MSG>;
  close (MSG);
  return &varconvert (join ('', @msg));
}

sub addmail	{
  open (MSG, "$rlmain::datapath/$rlmain::data{'ringid'}/addmail.txt")
   || rlmain::exit print gettext("Can't open") . " '$rlmain::data{'ringid'}/addmail.txt'<br />\n$!";
  my @msg = <MSG>;
  close (MSG);
  return &varconvert (join ('', @msg));
}

sub codepage	{
  open (MSG, "$rlmain::datapath/$rlmain::data{'ringid'}/codepage.txt")
   || rlmain::exit print gettext("Can't open") . " '$rlmain::data{'ringid'}/codepage.txt'<br />\n$!";
  my @msg = <MSG>;
  close (MSG);
  return &varconvert (join ('', @msg));
}

sub varconvert	{
  for my $subst (@rlmain::ringsubstitutes, @rlmain::sitesubstitutes)	{
    $_[0] =~ s/\$::$subst/\[$subst\]/g;
  }
  return $_[0];
}

sub inittests	{
  ## Used in next, prev, rand, list, next5, prev5, goto and home (and also in skipnext and skipprev)

  my $ringexists;
  &ringlist;
  if (!$rlmain::data{'ringid'})	{
    $rlmain::result = '<p class="error">' . gettext("Error! You must provide a ring ID.") . '</p>';
    &adminhtml;
    rlmain::exit;
  } else	{
    for (@rlmain::rings)	{
      if ($rlmain::data{'ringid'} eq $_)	{
        $ringexists = 1;
        last;
      }
    }
  }
  if (!$ringexists)	{
    $rlmain::result = '<p class="error">' . sprintf (gettext("Error! Ring ID %s does not exist in %s."),
      "&quot;$rlmain::data{'ringid'}&quot;", $rlmain::title) . '</p>';
    &adminhtml;
    rlmain::exit;
  } else	{
    &getringvalues;
    { no strict 'refs';
      for (@rlmain::ringnames)	{
        &htmlize (${'rlmain::' . $_}) if ${'rlmain::' . $_};
      }
    }
    &sitelist;
    if (!@rlmain::sites)	{
      $rlmain::result = '<p class="error">' . gettext("There are no sites in this ring.") . '</p>';
      &mainhtml;
      rlmain::exit;
    }
  }
  &statussplit;
  if (!@rlmain::activesites)	{
    $rlmain::result = '<p class="error">' . gettext("There are no active sites in this ring.") . '</p>';
    &mainhtml;
    rlmain::exit;
  }
}

sub statussplit	{
  open (SITES, "$rlmain::datapath/$rlmain::data{'ringid'}/sites.db") || rlmain::exit print $rlmain::htmlprint
  . gettext("Can't open") . " '$rlmain::data{'ringid'}/sites.db'<br />\n$!";
  my @sites = <SITES>;
  close (SITES);
  @rlmain::activesites = @sites;
  my $i = 0;
  for (@sites)	{
    my @tmp = split (/\t/, $_);
    if ($tmp[1] eq 'inactive')	{
      push (@rlmain::inactivesites, splice (@rlmain::activesites, $i, 1));
    } else	{
      $i ++;
    }
  }
  splice (@sites);
}

sub list	{
  my $activesite = 0;
  my $inactivesite = 0;
  if ($rlmain::data{'offset'} || $rlmain::data{'offset'} eq '0')	{
    if ($rlmain::data{'offset'} =~ /\D/)	{
      push (@rlmain::error, '<p class="error">'
      . gettext("The &quot;offset&quot; argument shall consist of digits only.\nThe list below starts with a randomly chosen site.")
      . '</p>');
      $rlmain::data{'offset'} = int (rand (scalar @rlmain::activesites));
    } elsif ($rlmain::data{'offset'} > scalar @rlmain::activesites - 1 || $rlmain::data{'offset'} < 0)	{
      push (@rlmain::error, '<p class="error">' . sprintf (
        gettext("Incorrect &quot;offset&quot; value. (Should have been a number between\n0 and %d.) The list below starts with a randomly chosen site."),
        scalar @rlmain::activesites - 1) . '</p>');
      $rlmain::data{'offset'} = int (rand (scalar @rlmain::activesites));
    }
    &createlist;
  }
  $rlmain::data{'offset'} = 0;
  for (@rlmain::activesites)	{
    if ($_ =~ /^$rlmain::data{'siteid'}\t/)	{
      $activesite = 1;
      last;
    } else	{
      $rlmain::data{'offset'} ++;
    }
  }
  if (!$rlmain::data{'siteid'})	{
    if ($rlmain::action =~ /^list\./i)	{
      $rlmain::data{'offset'} = int (rand (scalar @rlmain::activesites));
      &createlist;
    } else	{
      $rlmain::result = '<p class="error">' . gettext("Error! You must provide a site ID.") . '</p>';
      &mainhtml;
      rlmain::exit;
    }
  } elsif (!$activesite && $rlmain::action !~ /^list\./i)	{
    &naverror;
  } elsif (!$activesite)	{
    for (@rlmain::inactivesites)	{
      if ($_ =~ /^$rlmain::data{'siteid'}\t/)	{
        $inactivesite = 1;
        push (@rlmain::error, '<p class="error">' . sprintf (
          gettext("Site ID %s is not active. The list below\nstarts with another, randomly chosen, site."),
          "&quot;$rlmain::data{'siteid'}&quot;") . '</p>');
        $rlmain::data{'offset'} = int (rand (scalar @rlmain::activesites));
        &createlist;
        last;
      }
    }
    if (!$inactivesite)	{
      push (@rlmain::error, '<p class="error">' . sprintf (
        gettext("Site ID %s does not exist in this ring.\nThe list below starts with a randomly chosen site."),
        "&quot;$rlmain::data{'siteid'}&quot;") . '</p>');
      $rlmain::data{'offset'} = int (rand (scalar @rlmain::activesites));
      &createlist;
    }
  } else	{
    rlmain::addgenhits ($rlmain::data{'siteid'});
    &createlist;
  }
}

sub createlist	{
  my $links = '';
  my ($prevoffset, $nextoffset, @execfiles, $goto, @sitevalues);
  $rlmain::sitesperlistpage = 5 unless $rlmain::action =~ /^list\./i;
  my $prevtxt = sprintf (gettext("Previous %d sites"), $rlmain::sitesperlistpage);
  my $nexttxt = sprintf (gettext("Next %d sites"), $rlmain::sitesperlistpage);
  if (scalar @rlmain::activesites > $rlmain::sitesperlistpage)	{
    $rlmain::result = '<h4>' . sprintf (
      gettext("%d sites out of %d"), $rlmain::sitesperlistpage, scalar @rlmain::activesites) . "</h4>\n";
    $prevoffset = $rlmain::data{'offset'} - $rlmain::sitesperlistpage
    + ($rlmain::sitesperlistpage > $rlmain::data{'offset'} ? scalar @rlmain::activesites : 0);
    $nextoffset = $rlmain::data{'offset'} + $rlmain::sitesperlistpage
    - ($rlmain::data{'offset'} + $rlmain::sitesperlistpage > scalar @rlmain::activesites - 1 ? scalar @rlmain::activesites : 0);
    if ($rlmain::action =~ /^next5\./i)	{
      $rlmain::data{'offset'} = $rlmain::data{'offset'} + 1 - ($rlmain::data{'offset'}
      + 1 > scalar @rlmain::activesites - 1 ? scalar @rlmain::activesites : 0);
    } elsif ($rlmain::action =~ /^prev5\./i)	{
      $rlmain::data{'offset'} = $prevoffset;
    }

    $links = qq~
<p style="text-align: center">
[ <a href="$rlmain::cgiURL/$rlmain::action?ringid=$rlmain::ringid;offset=$prevoffset">
$prevtxt</a> |
<a href="$rlmain::cgiURL/$rlmain::action?ringid=$rlmain::ringid;offset=$nextoffset">
$nexttxt</a> ]
</p>~;

  } else	{
    $rlmain::result = '<h4>';
    if (scalar @rlmain::activesites == 1)	{
      $rlmain::result .= gettext("1 site");
    } elsif (scalar @rlmain::activesites == 2)	{
      $rlmain::result .= gettext("2 sites");
    } else	{
      $rlmain::result .= sprintf (gettext("%d sites"), scalar @rlmain::activesites);
    }
    $rlmain::result .= "</h4>\n";
  }
  $rlmain::result .= "@rlmain::error\n<dl>\n";
  unshift (@rlmain::activesites, splice (@rlmain::activesites, $rlmain::data{'offset'}));
  splice (@rlmain::activesites, $rlmain::sitesperlistpage);
  opendir(DIR, $rlmain::cgipath) || rlmain::exit print gettext("Can't open") . " $rlmain::cgipath<br />\n$!";
  @execfiles = grep { !/^\./ && (/\.pl$/i || /\.cgi$/i) } readdir(DIR);
  closedir DIR;
  for (@execfiles)	{
    $goto = $_ if $_ =~ /^goto\./i;
  }
  for (@rlmain::activesites)	{
    @sitevalues = split (/\t/, $_);
    { no strict 'refs';
      for (@rlmain::sitenames)	{
        ${'rlmain::' . $_} = shift (@sitevalues);
        rlmain::htmlize (${'rlmain::' . $_});
      }
    }

    $rlmain::result .= qq~
<dt><a href="$rlmain::cgiURL/$goto?ringid=$rlmain::ringid;siteid=$rlmain::siteid" target="_top">
$rlmain::sitetitle</a></dt>
<dd>$rlmain::sitedesc</dd>
~;

  }
  $rlmain::result .= "\n</dl>";
  $rlmain::result .= $links;
  &mainhtml;
  rlmain::exit;
}

sub naverror	{
  my (@execfiles, $list);
  my $inactivesite = 0;
  opendir(DIR, $rlmain::cgipath) || rlmain::exit print gettext("Can't open") . " $rlmain::cgipath<br />\n$!";
  @execfiles = grep { !/^\./ && (/\.pl$/i || /\.cgi$/i) } readdir(DIR);
  closedir DIR;
  for (@execfiles)	{
    $list = $_ if $_ =~ /^list\./i;
  }
  for (@rlmain::inactivesites)	{
    if ($_ =~ /^$rlmain::data{'siteid'}\t/)	{
      $inactivesite = 1;
      $rlmain::result = '<p class="error">'
      . sprintf (gettext("Site ID %s is not active."), "&quot;$rlmain::data{'siteid'}&quot;")
      . "</p>\n<p><a href=\"$rlmain::cgiURL/$list?ringid=$rlmain::ringid\">"
      . sprintf (gettext("List active sites in %s"), $rlmain::ringtitle) . '</a></p>';
      last;
    }
  }
  if (!$inactivesite)	{
    $rlmain::result = '<p class="error">'
    . sprintf (gettext("Site ID %s does not exist in this ring."), "&quot;$rlmain::data{'siteid'}&quot;")
    . "</p>\n<p><a href=\"$rlmain::cgiURL/$list?ringid=$rlmain::ringid\">"
    . sprintf (gettext("List sites in %s"), $rlmain::ringtitle) . '</a></p>';
  }
  &mainhtml;
  rlmain::exit;
}

sub removedirectory	{
  my $dir = $_[0];
  opendir(DIR, $dir) || rlmain::exit print gettext("Can't open") . " $dir<br />\n$!";
  my @files = grep { !/^\./ } readdir(DIR);
  closedir DIR;
  for (@files)	{
    unlink ("$dir/$_") || rlmain::exit print gettext("Can't remove") . " $dir/$_<br />\n$!";
  }
  rmdir $dir || rlmain::exit print gettext("Can't remove") . " $dir<br />\n$!";
}

sub addgenhits	{
  &addhits ("$rlmain::datapath/$rlmain::ringid/$_[0]/genhits.db") if $rlmain::stats;
}

sub addrechits	{
  &addhits ("$rlmain::datapath/$rlmain::ringid/$_[0]/rechits.db") if $rlmain::stats;
}

sub addhits	{
  my ($startdate, $checksum, $count, @hits, $i, @timelist, $year, $month, $day, $numdays, $hits);
  my @dates = my %hits = ();
  (my $dbname = $_[0]) =~ s/.*\/(\S*)/$1/;

  # Get saved stats
  open (STATS, "$_[0]") || rlmain::exit print $rlmain::htmlprint . gettext("Can't open") . " '$dbname'<br />\n$!";
  @hits = <STATS>;
  close (STATS);
  chomp @hits;
  if (scalar @hits >= 2)	{
    %hits = (@hits);
    $startdate = splice (@hits, -2, 1);
  }

  # Create list of dates
  for ($i = 0; $i < 32; $i++) {
    @timelist = gmtime (time - $i * 60 * 60 * 24);
    $year = sprintf("%02d", $timelist[5] % 100);
    $month = sprintf("%02d", $timelist[4] + 1);
    $day = sprintf("%02d", $timelist[3]);
    push (@dates, "$year-$month-$day");
    last if (!$startdate || "$year-$month-$day" eq $startdate);
  }
  $numdays = scalar @dates;

  # Checksum for process control
  if (scalar @hits > 1)	{
    splice (@hits, -3, 2) unless $startdate eq $dates[$#dates];
    for ($i = 1; $i < scalar @hits - 1; $i += 2)	{
      $checksum += $hits[$i];
    }
  } elsif (@hits && $numdays == 1)	{
    $checksum = $hits[0];
  } else	{
    $checksum = 0;
  }

  # Increase today's hits by 1
  $hits{$dates[0]} ++;

  # Save updated stats
  @hits = ();
  for (@dates)	{
    $hits = ($hits{$_} ? $hits{$_} : 0);
    push (@hits, $_, "\n", $hits, "\n");
    $count += $hits unless ($_ eq $dates[$#dates] && $numdays > 1);
  }
  if ($count == $checksum + 1)	{
    open (STATS, ">$_[0]") || rlmain::exit print $rlmain::htmlprint . gettext("Can't open") . " '$dbname'<br />\n$!";
    flock (STATS, LOCK_EX);
    print STATS @hits;
    flock (STATS, LOCK_UN);
    close (STATS);
  }
}

sub getstats	{
  my @sitestats = ();
  for ("$_[0]/genhits.db", "$_[0]/rechits.db")	{
    my ($startdate, $count);
    my (@hits, $i, @timelist, $year, $month, $day, $numdays);
    (my $dbname = $_) =~ s/.*\/(\S*)/$1/;

    # Get saved stats
    open (STATS, "$_") || rlmain::exit print gettext("Can't open") . " '$dbname'<br />\n$!";
    @hits = <STATS>;
    close (STATS);
    chomp @hits;
    if (scalar @hits >= 2)	{
      $startdate = splice (@hits, -2, 1);
    }

    # Get number of days
    for ($i = 0; $i < 32; $i++) {
      @timelist = gmtime (time - $i * 60 * 60 * 24);
      $year = sprintf("%02d", $timelist[5] % 100);
      $month = sprintf("%02d", $timelist[4] + 1);
      $day = sprintf("%02d", $timelist[3]);
      last if (!$startdate || "$year-$month-$day" eq $startdate);
    }
    $numdays = $i + 1;

    # Get hits total
    if (scalar @hits > 1)	{
      splice (@hits, -3, 2) unless "$year-$month-$day" eq $startdate;
      for ($i = 1; $i < scalar @hits - 1; $i += 2)	{
        $count += $hits[$i];
      }
    } elsif (@hits && $numdays == 1)	{
      $count = $hits[0];
    } else	{
      $count = 0;
    }

    push (@sitestats, $numdays, $count);
  }
  return @sitestats;
}

sub langlist	{
  my %langlist = ();

  # ISO 639 language codes
  %langlist = (
    de => gettext("German"),
    en => gettext("English"),
    es => gettext("Spanish"),
    fr => gettext("French"),
    it => gettext("Italian"),
    ja => gettext("Japanese"),
    nl => gettext("Dutch"),
    ru => gettext("Russian"),
    sv => gettext("Swedish"),
    tr => gettext("Turkish"),
    zh => gettext("Chinese"),
  );

  for (keys %rlmain::lang)	{
    $rlmain::lang{$_} = $langlist{$_} if $langlist{$_};
  }
}


1;

