####################################################################
#                                                                  #
# The code below controls the HTML output for the list page.       #
# Feel free to make those modifications you find suitable.         #
#                                                                  #
# Please keep the link to the Ringlink homepage, though. Ringlink  #
# is provided as an open source, free program, and the link        #
# encourages a larger user base, which in turn encourages future   #
# development. You may well use a logo for the link; see           #
# http://www.ringlink.org/faq/logos/                               #
#                                                                  #
####################################################################

package mainhtml;

use strict;
use Locale::PGetText;

sub listpage	{
my $homepage = gettext("Ring homepage");
my $pow = gettext("Powered by");

print qq~<!-- Page generated by Ringlink $rlmain::version -->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML//EN">
<html>
<head>
<title>$rlmain::ringtitle</title>
<style type="text/css">
<!--
  body { background: $rlmain::colbg }
  p, span, dl { font-family: arial, helvetica, sans-serif; font-size: 10pt; color: $rlmain::coltxt }
  p.error { font-weight: bold; color: $rlmain::colerr }
  p.success { font-weight: bold; color: $rlmain::colemph }
  span.small { font-size: 8pt }
  h3 { font-family: arial, helvetica, sans-serif; color: $rlmain::colemph }
  h4, h5 { font-family: arial, helvetica, sans-serif; color: $rlmain::coltxt }
  td { background: $rlmain::coltablebg; vertical-align: top }
  div.center { text-align: center }
  input.text { font-family: "courier new", monospace; color: black }
  a:link { color: $rlmain::collink }
  a:visited { color: $rlmain::colvlink }
  a:active { color: red }
-->
</style>
</head>
<body>
<center>
<div class="center">
<table border="0" height="100%" width="590" cellpadding="40">
<tr>
<td>
$rlmain::ringlogo
<h3>$rlmain::ringtitle</h3>
<span><a href="$rlmain::ringURL" target="_top">$homepage</a></span>
<hr style="clear: right" />
$rlmain::result
</td>
</tr>
<tr>
<td style="vertical-align: bottom">
<table width="100%">
<tr>
<td><p><a href="$rlmain::ringURL" target="_top">$rlmain::ringtitle homepage</a><br />&nbsp;</p></td>
<td />
</tr>
<tr>
<td style="vertical-align: bottom">
<span class="small"><a href="$rlmain::ringlinkURL" target="_top">$rlmain::title</a></span></td>
<td style="text-align: right"><span class="small" style="text-align: right">
$pow <a class="margcell" href="http://www.ringlink.org/" target="_top">Ringlink</a>
</span></td>
</tr>
</table>
</td>
</tr>
</table>
</div>
</center>
</body>
</html>
<!-- Page generated by Ringlink $rlmain::version -->

~

}

1;

