#!/usr/bin/perl
use CGI::Carp 'fatalsToBrowser'; CGI::Carp -> VERSION(1.06);
use lib 'lib';

##########################> Ringlink 2.0 <##########################
#                                                                  #
#  Ringlink is a CGI Perl program that provides the tools          #
#  necessary to run and administrate rings of websites.            #
#                                                                  #
#  Copyright (C) 2000, 2001 Gunnar Hjalmarsson,                    #
#  gunnar@ringlink.org; Version 2.0 released August 22, 2001       #
#  Ringlink homepage: http://www.ringlink.org/                     #
#                                                                  #
#  Ringlink is free software; you can redistribute it and/or       #
#  modify it under the terms of the GNU General Public License as  #
#  published by the Free Software Foundation; either version 2 of  #
#  the License, or (at your option) any later version.             #
#                                                                  #
#  Ringlink is distributed in the hope that it will be useful,     #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of  #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the    #
#  GNU General Public License for more details.                    #
#                                                                  #
#  You should have received a copy of the GNU General Public       #
#  License along with this program; if not, write to the Free      #
#  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,  #
#  MA  02111-1307  USA                                             #
#                                                                  #
####################################################################

use strict;

use rlconfig;
rlconfig::systemvar;

use Locale::PGetText 2.0;
Locale::PGetText::dbmselect;

# Path to the language directory
(my $tmp = $ENV{'SCRIPT_FILENAME'} ? $ENV{'SCRIPT_FILENAME'} : $0) =~ s/\\/\//g;
$tmp =~ s/(.*\/)\S*//;
my $langdir = $1 . 'lang';

# Check that the 'mo' directory exists and is writable
MOTEST:	{
  last MOTEST if -w "$langdir/mo";
  if (-e "$langdir/mo")	{
    die "You need to chmod the $langdir/mo directory 777";
  } elsif (-e $langdir)	{
    if (eval mkdir "$langdir/mo", 0777)	{
      chmod 0777, "$langdir/mo";
      last MOTEST;
    } else	{
      die "You need to create the $langdir/mo directory";
    }
  } else	{
    die "$langdir does not exist";
  }
}

# Create list of PO files
opendir (DIR, $langdir) || die "Can't open $langdir\n$!";
my @files = grep { /^\w{2}\.po$/ } readdir(DIR);
closedir DIR;

# Remove old databases
opendir (DIR, "$langdir/mo") || die "Can't open $langdir/mo\n$!";
my @mofiles = grep { -f "$langdir/mo/$_" } readdir(DIR);
closedir DIR;
for (@mofiles)	{
  unlink "$langdir/mo/$_" || die "Can't remove $langdir/mo/$_\n$!";
}

# Create new databases
my $path;
my @error = ();
for (@files)	{
  (my $lang = $_) =~ s/\.po$//;
  $path = "$langdir/mo/$lang";
  open (POFILE, "$langdir/$_") || die "Can't open $langdir/$_\n$!";
  &MsgFormat;
  close POFILE;
}

# Print result
print "Content-type: text/plain\n\n";
if (@error)	{
  print join ("\n", @error) . "\n";
} elsif (@files)	{
  print "Language databases were created from:\n" . join ("\n", @files) . "\n";
} else	{
  print "Can't find any ??.po files in $langdir\n";
}


sub MsgFormat	{
  # This subroutine is an extract from the file MsgFormat, included
  # in the CPAN module Locale::PGetText, (C) 1998 Mike Shoyher

  my $s = my $msgid = '';
  dbmopen(my %msg,$path,0644) || push (@error, "Cannot create database $path");

  for (<POFILE>){
    if (/^msgid\s+\"(.*)\"\s*$/){
        if ($msgid) {
            $msgid=~s/\\n/\n/g;
            $s=~s/\\n/\n/g;
            $s=~s/\\"/"/g;
            $msg{$msgid}=$s;
        }
        $s=$1
    }
    if (/^\"(.+)\"\s*$/){
        $s.=$1
    }
    if (/^msgstr\s+\"(.*)\"\s*$/){
        $msgid=$s;
        $s=$1
    }
  }

  $msgid=~s/\\n/\n/g;
  $s=~s/\\n/\n/g;
  $s=~s/\\"/"/g;
  $msg{$msgid}=$s;

  dbmclose(%msg);
}

