#!/usr/bin/perl
use CGI::Carp 'fatalsToBrowser'; CGI::Carp -> VERSION(1.06);
use lib 'lib';

##########################> Ringlink 2.0 <##########################
#                                                                  #
#  Ringlink is a CGI Perl program that provides the tools          #
#  necessary to run and administrate rings of websites.            #
#                                                                  #
#  Copyright (C) 2000, 2001 Gunnar Hjalmarsson,                    #
#  gunnar@ringlink.org; Version 2.0 released August 22, 2001       #
#  Ringlink homepage: http://www.ringlink.org/                     #
#                                                                  #
#  Ringlink is free software; you can redistribute it and/or       #
#  modify it under the terms of the GNU General Public License as  #
#  published by the Free Software Foundation; either version 2 of  #
#  the License, or (at your option) any later version.             #
#                                                                  #
#  Ringlink is distributed in the hope that it will be useful,     #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of  #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the    #
#  GNU General Public License for more details.                    #
#                                                                  #
#  You should have received a copy of the GNU General Public       #
#  License along with this program; if not, write to the Free      #
#  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,  #
#  MA  02111-1307  USA                                             #
#                                                                  #
####################################################################

use strict;

use rlmain 2.0;
use ring 2.0;
use site 2.0;
use Locale::PGetText 2.0;

sub LOCK_EX { 2 }
sub LOCK_UN { 8 }

rlmain::execstart;
if (!$rlmain::data{'pw'} || $rlmain::data{'pw'} ne $rlmain::adminpw)	{
  my $enterpw = gettext("Enter password!");
  my $wrongpw = gettext("Incorrect password, please try again.");
  my $login = gettext("Login");
  my $admpw = gettext("Admin password");
  my $loginsuccess = gettext("Login succeeded");
  my $loginbutton = gettext("Log in");
  if ($rlmain::data && !$rlmain::data{'pw'})	{
    push (@rlmain::error, "<p class=\"error\">$enterpw</p>");
  } elsif ($rlmain::data{'pw'})	{
    push (@rlmain::error, "<p class=\"error\">$wrongpw</p>");
  }
  $rlmain::pagetitle = gettext("Master admin");

  $rlmain::result = qq~<h4>$login</h4>
@rlmain::error
<form method="POST" action="$rlmain::cgiURL/$rlmain::action">
<span>$admpw</span><br />
<input class="text" type="password" size="15" name="pw" />
<input type="hidden" name="result" value="$loginsuccess" />
<p><input type="submit" value="$loginbutton" /></p>
</form>~;

} elsif (!$rlmain::data{'routine'})	{
  $rlmain::pagemenu = &menu;
  $rlmain::result = "<p class=\"success\">$rlmain::data{'result'}</p>";
} else	{
  $rlmain::data{'routine'} = $rlmain::routines{$rlmain::data{'routine'}};
  my $routine;
  ($routine = $rlmain::data{'routine'}) =~ s/ /_/g;
  no strict 'refs';
  &$routine;
}

rlmain::adminhtml;


sub menu	{
  my $resetstats;
  my $reset = gettext("Reset stats");
  my $new = gettext("New ring");
  my $ringadm = gettext("Ring admin");
  $rlmain::pagetitle = gettext("Master admin");
  if ($rlmain::stats)	{
    $resetstats = "<input class=\"button\" width=\"130\" type=\"submit\" name=\"routine\" value=\"$reset\" />";
  }

  return qq~<hr /><br /><input type="hidden" name="pw" value="$rlmain::data{'pw'}" />
<input class="button" width="130" type="submit" name="routine" value="$new" />
<input class="button" width="130" type="submit" name="routine" value="$ringadm" />
$resetstats~;

}

sub Reset_stats	{
  my (@rings, $ringdir, @files, @sites, $sitedir);
  chmod 0777, $rlmain::datapath;
  opendir(DIR, $rlmain::datapath) || rlmain::exit print gettext("Can't open") . " $rlmain::datapath<br />\n$!";
  @rings = grep { !/^\./ && -d "$rlmain::datapath/$_" } readdir(DIR);
  closedir DIR;
  for (@rings)	{
    $ringdir = "$rlmain::datapath/$_";
    chmod 0777, $ringdir;
    opendir(DIR, $ringdir) || rlmain::exit print gettext("Can't open") . " $ringdir<br />\n$!";
    @files = grep { !/^\./ && -f "$ringdir/$_" } readdir(DIR);
    closedir DIR;
    for (@files)	{
      chmod 0666, "$ringdir/$_";
    }
    opendir(DIR, $ringdir) || rlmain::exit print gettext("Can't open") . " $ringdir<br />\n$!";
    @sites = grep { !/^\./ && -d "$ringdir/$_" } readdir(DIR);
    closedir DIR;
    for (@sites)	{
      $sitedir = "$ringdir/$_";
      chmod 0777, $sitedir;
      for ('genhits.db', 'rechits.db')	{
        unlink ("$sitedir/$_") if -e "$sitedir/$_";
        open (STATS, ">$sitedir/$_") || rlmain::exit print gettext("Can't create") . " $sitedir/$_<br />\n$!";
        flock (STATS, LOCK_EX);
        flock (STATS, LOCK_UN);
        close (STATS);
        chmod 0666, "$sitedir/$_";
      }
    }
  }
  $rlmain::pagemenu = &menu;
  $rlmain::result = '<p class="success">' . gettext("Stats reset.") . "</p>\n"
  . '<p>' . gettext("File permissions for the data directory was updated, as well.") . '</p>';
}

sub New_ring	{
  $rlmain::pagemenu = &menu;
  if ($rlmain::data{'submit'})	{
    ring::validation;
    if (!@rlmain::error)	{
      ring::create;
      rlmain::htmlize ($rlmain::data{'ringtitle'});
      my $ringtitle = '</p><p style="font-weight: bold">' . $rlmain::data{'ringtitle'}
      . '</p><p class="success">';
      $rlmain::result = '<p class="success">'
      . sprintf (gettext("The ring %s was successfully created."), $ringtitle) . '</p>';
    } else	{
      $rlmain::result = '<h4>' . gettext("Add new ring") . "</h4>\n";
      $rlmain::result .= ring::form;
    }
  } else	{
    { no strict 'refs';
      for (keys %rlmain::colors)	{
        $rlmain::data{$_} = ${'rlmain::' . $_};
      }
    }
    $rlmain::data{'ringURL'} = 'http://';
    $rlmain::data{'logoURL'} = 'http://';
    $rlmain::data{'allowsiteadd'} = 'on';
    $rlmain::data{'ringlang'} = $rlmain::lang;
    $rlmain::data{'sitesperlistpage'} = 25;
    $rlmain::result = '<h4>' . gettext("Add new ring") . "</h4>\n";
    $rlmain::result .= ring::form;
  }
}

sub Ring_admin	{
  my $switchheader = gettext("Switch to the ring admin menu");
  my $ringid = gettext("Ring ID");
  my $switchbutton = gettext("Switch");
  rlmain::ringlist;
  if (!@rlmain::rings)	{
    $rlmain::pagemenu = &menu;
    $rlmain::result = rlmain::noring;
  } elsif ($rlmain::data{'ringid'})	{
    rlmain::getringvalues;
    $rlmain::pagemenu = ring::menu;
  } else	{
    if ($rlmain::data{'submit'})	{
      push (@rlmain::error, '<p class="error">' . gettext("Select ring ID!") . '</p>');
    }
    $rlmain::pagemenu = &menu;
    rlmain::ringselect;

    $rlmain::result = qq~<h4>$switchheader</h4>
@rlmain::error
<form method="POST" action="$rlmain::cgiURL/$rlmain::action">
<p>$ringid<br />
$rlmain::ringselect</p>
<input type="hidden" name="pw" value="$rlmain::data{'pw'}" />
<input type="hidden" name="routine" value="Ring admin" />
<p><input type="submit" name="submit" value="$switchbutton" /></p>
</form>~;

  }
}

sub Edit_ring	{
  rlmain::getringvalues;
  ring::Edit_ring;
}

sub Customize	{
  rlmain::getringvalues;
  $rlmain::pagemenu = ring::customizemenu;
  $rlmain::result = "<p class=\"success\">$rlmain::data{'result'}</p>";
}

sub Appearance	{
  rlmain::getringvalues;
  ring::Appearance;
}

sub HTML_code	{
  rlmain::getringvalues;
  ring::HTML_code;
}

sub Add_page	{
  rlmain::getringvalues;
  ring::Add_page;
}

sub Add_mail	{
  rlmain::getringvalues;
  ring::Add_mail;
}

sub Code_page	{
  rlmain::getringvalues;
  ring::Code_page;
}

sub New_site	{
  rlmain::getringvalues;
  ring::New_site;
}

sub Site_admin	{
  rlmain::getringvalues;
  ring::Site_admin;
}

sub Edit_site	{
  rlmain::getringvalues;
  ring::Edit_site;
}

sub statuschangemail	{
  rlmain::getringvalues;
  rlmain::getsitevalues;
  site::statuschangemail;
  $rlmain::pagemenu = site::menu;
}

sub Remove_site	{
  rlmain::getringvalues;
  ring::Remove_site;
}

sub Get_code	{
  rlmain::getringvalues;
  rlmain::getsitevalues;
  $rlmain::htmlcode = rlmain::htmlcode;
  $rlmain::pagemenu = site::menu;
  $rlmain::result = site::htmlcode;
}

sub View_stats	{
  rlmain::getringvalues;
  rlmain::getsitevalues;
  $rlmain::pagemenu = site::menu;
  $rlmain::result = site::getstats;
}

sub Active_sites	{
  use ring;
  rlmain::getringvalues;
  ring::Active_sites;
}

sub Inactive_sites	{
  use ring;
  rlmain::getringvalues;
  ring::Inactive_sites;
}

sub Activate	{
  rlmain::getringvalues;
  ring::Activate;
}

sub Deactivate	{
  rlmain::getringvalues;
  ring::Deactivate;
}

sub Remove_ring	{
  rlmain::getringvalues;
  if ($rlmain::data{'submit'} eq gettext("Remove"))	{
    if ($rlmain::data{'removesure'} eq 'on')	{
      my $ring = gettext("Ring:");
      ring::remove;
      $ring::title = $rlmain::title;
      ring::removemail;
      $rlmain::pagetitle = gettext("Ring admin");
      rlmain::htmlize ($rlmain::ringtitle);
      $rlmain::pagemenu = &menu;

      $rlmain::ring_site = qq~<table cellspacing="8">
<tr>
<td><span>$ring</span></td>
<td><span><a href="$rlmain::ringURL" target="Ringlink">$rlmain::ringtitle</a></span></td>
</tr>
</table>~;

      $rlmain::result = '<p class="success">' . gettext("Ring removed") . '</p>';
    } else	{
      push (@rlmain::error, '<p class="error">'
      . gettext("The ring was not removed,\nsince the checkbox below wasn't checked.") . '</p>');
      $rlmain::result = ring::removeform;
      rlmain::emailhtml;
      rlmain::exit;
    }
  } elsif ($rlmain::data{'submit'} eq gettext("Cancel"))	{
      $rlmain::pagemenu = ring::menu;
  } else	{
      $rlmain::result = ring::removeform;
      rlmain::emailhtml;
      rlmain::exit;
  }
}

sub Check_sites	{
  rlmain::getringvalues;
  ring::Check_sites;
}

sub Reorder_sites	{
  rlmain::getringvalues;
  ring::Reorder_sites;
}

sub Send_email	{
  rlmain::getringvalues;
  ring::Send_email;
}

